/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.modelApi.templateLoaders;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.model.modelApi.templateLoaders.DjangoAppTemplateLoader;
import com.jetbrains.django.model.modelApi.templateLoaders.DjangoFileSystemTemplateLoader;
import com.jetbrains.django.model.modelApi.templateLoaders.DjangoTemplateLoader;
import com.jetbrains.django.model.modelApi.templates.PyTemplateEngineSettings;
import com.jetbrains.django.util.DjangoCoreUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class DjangoTemplateLoaderStrategy {
    private static final DjangoTemplateLoader[] LOADERS = new DjangoTemplateLoader[]{DjangoFileSystemTemplateLoader.INSTANCE, DjangoAppTemplateLoader.INSTANCE};
    private static final DjangoTemplateLoader[] DEFAULT_LOADERS = LOADERS;

    private DjangoTemplateLoaderStrategy() {
    }

    @NotNull
    public static List<DjangoTemplateLoader> getLoaders(@NotNull DjangoModelApi djangoModelApi) {
        if (djangoModelApi == null) {
            DjangoTemplateLoaderStrategy.$$$reportNull$$$0(0);
        }
        Pair<Boolean, List<DjangoTemplateLoader>> oldPre18Style = DjangoTemplateLoaderStrategy.getLoadersOldPre18Style(djangoModelApi);
        List oldStyleLoaders = (List)oldPre18Style.second;
        if (!djangoModelApi.isDjangoPackageMatches(DjangoCoreUtil.createRequirementAtLeast(1, 8), true)) {
            List list = oldStyleLoaders;
            if (list == null) {
                DjangoTemplateLoaderStrategy.$$$reportNull$$$0(1);
            }
            return list;
        }
        HashSet<DjangoTemplateLoader> result = new HashSet<DjangoTemplateLoader>();
        boolean oldLoadersReturnedByDefault = (Boolean)oldPre18Style.first;
        if (!oldLoadersReturnedByDefault) {
            result.addAll(oldStyleLoaders);
        }
        result.addAll(DjangoTemplateLoaderStrategy.getLoadersNewStyle(djangoModelApi));
        return new ArrayList<DjangoTemplateLoader>(result);
    }

    @NotNull
    private static List<DjangoTemplateLoader> getLoadersNewStyle(@NotNull DjangoModelApi djangoModelApi) {
        if (djangoModelApi == null) {
            DjangoTemplateLoaderStrategy.$$$reportNull$$$0(2);
        }
        List<PyTemplateEngineSettings> dicts = PyTemplateEngineSettings.getSettings(djangoModelApi.getDjangoModule());
        boolean hasAppDirs = dicts.stream().anyMatch(o -> o.isAppDirs());
        HashSet dirs2 = Sets.newHashSet((Iterable)Iterables.concat((Iterable)dicts.stream().map(o -> o.getDirs()).collect(Collectors.toSet())));
        ArrayList<DjangoTemplateLoader> result = new ArrayList<DjangoTemplateLoader>();
        if (hasAppDirs) {
            result.add(DjangoAppTemplateLoader.INSTANCE);
        }
        if (!dirs2.isEmpty()) {
            result.add(new DjangoFileSystemTemplateLoader(dirs2));
        }
        ArrayList<DjangoTemplateLoader> arrayList = result;
        if (arrayList == null) {
            DjangoTemplateLoaderStrategy.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private static Pair<Boolean, List<DjangoTemplateLoader>> getLoadersOldPre18Style(@NotNull DjangoModelApi djangoModelApi) {
        List<String> loaderNames;
        if (djangoModelApi == null) {
            DjangoTemplateLoaderStrategy.$$$reportNull$$$0(4);
        }
        if ((loaderNames = DjangoSettingsPy.getTemplateLoaders(djangoModelApi.getDjangoModule())).isEmpty()) {
            Pair pair = Pair.create((Object)true, Arrays.asList(DEFAULT_LOADERS));
            if (pair == null) {
                DjangoTemplateLoaderStrategy.$$$reportNull$$$0(5);
            }
            return pair;
        }
        ArrayList<DjangoTemplateLoader> result = new ArrayList<DjangoTemplateLoader>();
        for (String loaderName : loaderNames) {
            for (DjangoTemplateLoader loader : LOADERS) {
                if (!loader.getOldPre18LoaderNames().contains(loaderName)) continue;
                result.add(loader);
            }
        }
        Pair pair = Pair.create((Object)false, result);
        if (pair == null) {
            DjangoTemplateLoaderStrategy.$$$reportNull$$$0(6);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoModelApi";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/modelApi/templateLoaders/DjangoTemplateLoaderStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/modelApi/templateLoaders/DjangoTemplateLoaderStrategy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoaders";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadersNewStyle";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadersOldPre18Style";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLoaders";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLoadersNewStyle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLoadersOldPre18Style";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

