/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal.completion.validation;

import com.intellij.ml.llm.terminal.completion.ParsedCommand;
import com.intellij.ml.llm.terminal.completion.validation.PackageCorruptionValidatorKt;
import com.intellij.ml.llm.terminal.completion.validation.RiskCategory;
import com.intellij.ml.llm.terminal.completion.validation.Validator;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/terminal/completion/validation/PackageCorruptionValidator;", "Lcom/intellij/ml/llm/terminal/completion/validation/Validator;", "<init>", "()V", "validate", "Lkotlin/Pair;", "Lcom/intellij/ml/llm/terminal/completion/validation/RiskCategory;", "", "command", "Lcom/intellij/ml/llm/terminal/completion/ParsedCommand;", "intellij.ml.llm.terminal.completion"})
@SourceDebugExtension(value={"SMAP\nPackageCorruptionValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageCorruptionValidator.kt\ncom/intellij/ml/llm/terminal/completion/validation/PackageCorruptionValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1761#2,3:66\n1761#2,3:69\n1761#2,3:72\n*S KotlinDebug\n*F\n+ 1 PackageCorruptionValidator.kt\ncom/intellij/ml/llm/terminal/completion/validation/PackageCorruptionValidator\n*L\n33#1:66,3\n43#1:69,3\n48#1:72,3\n*E\n"})
public final class PackageCorruptionValidator
implements Validator {
    @Override
    @Nullable
    public Pair<RiskCategory, String> validate(@NotNull ParsedCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (PackageCorruptionValidatorKt.access$getPackageCommands$p().contains(command.getBaseCommand())) {
            boolean isRemoving;
            block18: {
                Object[] objectArray = new String[]{"remove", "uninstall", "purge", "erase", "rm", "autoremove", "-R"};
                Set removeOps = SetsKt.setOf((Object[])objectArray);
                Iterable $this$any$iv = command.getArgs();
                boolean $i$f$any2 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        if (!removeOps.contains(it)) continue;
                        v0 = true;
                        break block18;
                    }
                    v0 = isRemoving = false;
                }
            }
            if (isRemoving) {
                boolean bl;
                block21: {
                    boolean bl2;
                    boolean $i$f$any;
                    Iterable $this$any$iv;
                    block20: {
                        Object[] $i$f$any2 = new String[]{"kernel", "linux-image", "systemd", "init", "libc", "glibc", "bash", "sh", "coreutils", command.getBaseCommand()};
                        Set criticalPackages = SetsKt.setOf((Object[])$i$f$any2);
                        $this$any$iv = command.getArgs();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                boolean bl3;
                                block19: {
                                    String arg = (String)element$iv;
                                    boolean bl4 = false;
                                    Iterable $this$any$iv2 = criticalPackages;
                                    boolean $i$f$any3 = false;
                                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                        bl3 = false;
                                    } else {
                                        for (Object element$iv2 : $this$any$iv2) {
                                            String pkg = (String)element$iv2;
                                            boolean bl5 = false;
                                            if (!StringsKt.contains$default((CharSequence)arg, (CharSequence)pkg, (boolean)false, (int)2, null)) continue;
                                            bl3 = true;
                                            break block19;
                                        }
                                        bl3 = false;
                                    }
                                }
                                if (!bl3) continue;
                                bl2 = true;
                                break block20;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        return TuplesKt.to((Object)((Object)RiskCategory.PACKAGE_CORRUPTION), (Object)"removing critical system package");
                    }
                    $this$any$iv = command.getArgs();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl6 = false;
                            if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"*", (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block21;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return TuplesKt.to((Object)((Object)RiskCategory.PACKAGE_CORRUPTION), (Object)"mass package removal with wildcards");
                }
                Object[] objectArray = new String[]{"pip", "pip3"};
                if (SetsKt.setOf((Object[])objectArray).contains(command.getBaseCommand()) && StringsKt.contains$default((CharSequence)command.getFullCommand(), (CharSequence)"freeze", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)command.getFullCommand(), (CharSequence)"uninstall", (boolean)false, (int)2, null)) {
                    return TuplesKt.to((Object)((Object)RiskCategory.PACKAGE_CORRUPTION), (Object)"attempting to uninstall all pip packages");
                }
                if (Intrinsics.areEqual((Object)command.getBaseCommand(), (Object)"npm") && StringsKt.contains$default((CharSequence)command.getFullCommand(), (CharSequence)"ls", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)command.getFullCommand(), (CharSequence)"uninstall", (boolean)false, (int)2, null)) {
                    return TuplesKt.to((Object)((Object)RiskCategory.PACKAGE_CORRUPTION), (Object)"attempting to uninstall all global npm packages");
                }
            }
        }
        return null;
    }
}

