/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionUnit;
import org.jetbrains.letsPlot.core.plot.base.geom.util.BoxLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectanglesHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0010JT\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00102\u001e\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00040\u001bJX\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&\u00a8\u0006("}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/BoxHelper;", "", "()V", "buildBoxes", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "rectFactory", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "buildMidlines", "fatten", "", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "lineFactory", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "handler", "Lkotlin/Function3;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "xAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "middleAes", "sizeAes", "widthUnit", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "legendFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "whiskers", "", "showMidline", "plot-base"})
@SourceDebugExtension(value={"SMAP\nBoxHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/BoxHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1855#2,2:139\n1855#2,2:141\n*S KotlinDebug\n*F\n+ 1 BoxHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/BoxHelper\n*L\n30#1:139,2\n69#1:141,2\n*E\n"})
public final class BoxHelper {
    @NotNull
    public static final BoxHelper INSTANCE = new BoxHelper();

    private BoxHelper() {
    }

    public final void buildBoxes(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2, @NotNull Function1<? super DataPointAesthetics, DoubleRectangle> rectFactory) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Intrinsics.checkNotNullParameter(rectFactory, (String)"rectFactory");
        RectanglesHelper helper2 = new RectanglesHelper(aesthetics2, pos, coord, ctx2, rectFactory);
        List<SvgNode> rectangles = helper2.createRectangles();
        Iterable $this$forEach$iv = rectangles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgNode it = (SvgNode)element$iv;
            boolean bl = false;
            root.add(it);
        }
    }

    public final void buildMidlines(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull Aes<Double> xAes, @NotNull Aes<Double> middleAes, @NotNull Aes<Double> sizeAes2, @NotNull DimensionUnit widthUnit, @NotNull GeomHelper geomHelper, double fatten) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter(xAes, (String)"xAes");
        Intrinsics.checkNotNullParameter(middleAes, (String)"middleAes");
        Intrinsics.checkNotNullParameter(sizeAes2, (String)"sizeAes");
        Intrinsics.checkNotNullParameter((Object)((Object)widthUnit), (String)"widthUnit");
        Intrinsics.checkNotNullParameter((Object)geomHelper, (String)"geomHelper");
        GeomHelper.SvgElementHelper elementHelper = geomHelper.createSvgElementHelper();
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            Double d = p.finiteOrNull(xAes);
            if (d == null) {
                continue;
            }
            double x2 = d;
            Double d2 = p.finiteOrNull(middleAes);
            if (d2 == null) {
                continue;
            }
            double middle = d2;
            Double d3 = p.finiteOrNull(sizeAes2);
            if (d3 == null) {
                continue;
            }
            double w = d3;
            double width2 = w * geomHelper.getUnitResolution(widthUnit, xAes);
            Pair<SvgNode, List<DoubleVector>> pair2 = elementHelper.createLine(new DoubleVector(x2 - width2 / (double)2, middle), new DoubleVector(x2 + width2 / (double)2, middle), p, (Function1<? super DataPointAesthetics, Double>)((Function1)new Function1<DataPointAesthetics, Double>(fatten){
                final /* synthetic */ double $fatten;
                {
                    this.$fatten = $fatten;
                    super(1);
                }

                @NotNull
                public final Double invoke(@NotNull DataPointAesthetics it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return AesScaling.INSTANCE.strokeWidth(it) * this.$fatten;
                }
            }));
            if (pair2 == null) continue;
            SvgNode line2 = (SvgNode)pair2.component1();
            root.add(line2);
        }
    }

    public final void buildMidlines(@NotNull Aesthetics aesthetics2, double fatten, @NotNull GeomHelper geomHelper, @NotNull Function1<? super DataPointAesthetics, DoubleSegment> lineFactory, @NotNull Function3<? super DataPointAesthetics, ? super SvgNode, ? super DoubleSegment, Unit> handler2) {
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)geomHelper, (String)"geomHelper");
        Intrinsics.checkNotNullParameter(lineFactory, (String)"lineFactory");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        GeomHelper.SvgElementHelper elementHelper = geomHelper.createSvgElementHelper();
        Iterable<DataPointAesthetics> $this$forEach$iv = aesthetics2.dataPoints();
        boolean $i$f$forEach = false;
        Iterator<DataPointAesthetics> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Pair<SvgNode, List<DoubleVector>> pair2;
            DoubleSegment segment2;
            DataPointAesthetics element$iv;
            DataPointAesthetics p = element$iv = iterator2.next();
            boolean bl = false;
            if ((DoubleSegment)lineFactory.invoke((Object)p) == null) continue;
            boolean bl2 = false;
            if (elementHelper.createLine(segment2, p, (Function1<? super DataPointAesthetics, Double>)((Function1)new Function1<DataPointAesthetics, Double>(fatten){
                final /* synthetic */ double $fatten;
                {
                    this.$fatten = $fatten;
                    super(1);
                }

                @NotNull
                public final Double invoke(@NotNull DataPointAesthetics it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return AesScaling.INSTANCE.strokeWidth(it) * this.$fatten;
                }
            })) == null) continue;
            SvgNode svgNode = (SvgNode)pair2.component1();
            List line2 = (List)pair2.component2();
            handler2.invoke((Object)p, (Object)svgNode, (Object)new DoubleSegment((DoubleVector)line2.get(0), (DoubleVector)line2.get(1)));
        }
    }

    @NotNull
    public final LegendKeyElementFactory legendFactory(boolean whiskers, boolean showMidline) {
        return new BoxLegendKeyElementFactory(whiskers, showMidline);
    }
}

