/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.layout;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eJ\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eJ\b\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0014\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\tR\u0011\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\t\u00a8\u0006%"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "", "top", "", "right", "bottom", "left", "(DDDD)V", "getBottom", "()D", "height", "getHeight", "getLeft", "leftTop", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getLeftTop", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getRight", "rightBottom", "getRightBottom", "size", "getSize", "getTop", "width", "getWidth", "inflateRect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "r", "inflateSize", "minus", "other", "plus", "shrinkRect", "shrinkSize", "toString", "", "Companion", "plot-base"})
public final class Thickness {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double top;
    private final double right;
    private final double bottom;
    private final double left;
    @NotNull
    private final DoubleVector leftTop;
    @NotNull
    private final DoubleVector rightBottom;
    private final double width;
    private final double height;
    @NotNull
    private final DoubleVector size;
    @NotNull
    private static final Thickness ZERO = new Thickness(0.0, 0.0, 0.0, 0.0, 15, null);

    public Thickness(double top, double right, double bottom, double left) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
        this.leftTop = new DoubleVector(this.left, this.top);
        this.rightBottom = new DoubleVector(this.right, this.bottom);
        this.width = this.left + this.right;
        this.height = this.top + this.bottom;
        this.size = new DoubleVector(this.width, this.height);
    }

    public /* synthetic */ Thickness(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        if ((n & 8) != 0) {
            d4 = 0.0;
        }
        this(d, d2, d3, d4);
    }

    public final double getTop() {
        return this.top;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getLeft() {
        return this.left;
    }

    @NotNull
    public final DoubleVector getLeftTop() {
        return this.leftTop;
    }

    @NotNull
    public final DoubleVector getRightBottom() {
        return this.rightBottom;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    @NotNull
    public final DoubleVector getSize() {
        return this.size;
    }

    @NotNull
    public final DoubleRectangle inflateRect(@NotNull DoubleRectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return new DoubleRectangle(r.getOrigin().subtract(this.leftTop), r.getDimension().add(this.size));
    }

    @NotNull
    public final DoubleRectangle shrinkRect(@NotNull DoubleRectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return new DoubleRectangle(r.getOrigin().add(this.leftTop), r.getDimension().subtract(this.size));
    }

    @NotNull
    public final DoubleVector inflateSize(@NotNull DoubleVector size2) {
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        return size2.add(this.size);
    }

    @NotNull
    public final DoubleVector shrinkSize(@NotNull DoubleVector size2) {
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        return size2.subtract(this.size);
    }

    @NotNull
    public final Thickness plus(@NotNull Thickness other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Thickness(this.top + other.top, this.right + other.right, this.bottom + other.bottom, this.left + other.left);
    }

    @NotNull
    public final Thickness minus(@NotNull Thickness other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Thickness(this.top - other.top, this.right - other.right, this.bottom - other.bottom, this.left - other.left);
    }

    @NotNull
    public String toString() {
        return "Thickness(top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + ", left=" + this.left + ')';
    }

    public Thickness() {
        this(0.0, 0.0, 0.0, 0.0, 15, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness$Companion;", "", "()V", "ZERO", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "getZERO", "()Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "uniform", "value", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Thickness getZERO() {
            return ZERO;
        }

        @NotNull
        public final Thickness uniform(double value) {
            return new Thickness(value, value, value, value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

