package com.intellij.jupyter.core.jupyter.editor.markdown.latex;
import org.jetbrains.annotations.NotNull;
import java.io.Reader;
%%
%class TexLexer
%public
%final
%{
int yychar;
private CharSequence myEnvName;
TexLexer(@NotNull String text){
      this((Reader)null);
      this.reset(text, 0, text.length(), YYINITIAL);
}
enum TexType {OPEN_INLINE_TEX, OPEN_BLOCK_TEX, CLOSE_TEX, TEX_CHAR, PLAIN_CHAR, TEX_ESCAPED_KEY, TEX_OPEN_SUB_ENV, TEX_CLOSE_SUB_ENV}
%}
%unicode
%char
%type TexType
%state INSIDE_SINGLE
%state INSIDE_MULTIPLE
%state INSIDE_ENV

SINGLE=[$]
MULTIPLE=[$][$]
ENV_OPEN=\\begin\{[a-zA-Z0-9*]+\}
ENV_CLOSE=\\end\{[a-zA-Z0-9*]+\}
TEX_ESCAPED_KEY=\\\p{L}+
%%

<YYINITIAL> {
    {SINGLE} {yybegin(INSIDE_SINGLE); return TexType.OPEN_INLINE_TEX;}
    {MULTIPLE} {yybegin(INSIDE_MULTIPLE); return TexType.OPEN_BLOCK_TEX;}
    {ENV_OPEN} {
              yybegin(INSIDE_ENV);
              myEnvName = TexLexerToolsKt.getEnvName(yytext(), true);
              return TexType.OPEN_BLOCK_TEX;
          }
}
<INSIDE_SINGLE> {
    {SINGLE} {yybegin(YYINITIAL); return TexType.CLOSE_TEX;}
     {ENV_OPEN} {return TexType.TEX_OPEN_SUB_ENV;}
     {ENV_CLOSE} {return TexType.TEX_CLOSE_SUB_ENV;}
    {TEX_ESCAPED_KEY} {return TexType.TEX_ESCAPED_KEY;}
    [^] {return TexType.TEX_CHAR;}
}
<INSIDE_MULTIPLE> {
    {MULTIPLE} {yybegin(YYINITIAL); return TexType.CLOSE_TEX;}
    {ENV_OPEN} {return TexType.TEX_OPEN_SUB_ENV;}
    {ENV_CLOSE} {return TexType.TEX_CLOSE_SUB_ENV;}
    {TEX_ESCAPED_KEY} {return TexType.TEX_ESCAPED_KEY;}
    [^] {return TexType.TEX_CHAR;}
}
<INSIDE_ENV> {
    {ENV_CLOSE} {
              if (! java.util.Objects.equals(TexLexerToolsKt.getEnvName(yytext(), false), myEnvName)) {
                  return TexType.TEX_CLOSE_SUB_ENV;
              }
              yybegin(YYINITIAL); return TexType.CLOSE_TEX;
          }
    {ENV_OPEN} {return TexType.TEX_OPEN_SUB_ENV;}
    {TEX_ESCAPED_KEY} {return TexType.TEX_ESCAPED_KEY;}
    [^] {return TexType.TEX_CHAR;}
}

[^]  {return TexType.PLAIN_CHAR;}
