import React, { useState } from 'react';
import { Schema } from './Schema';
import { SchemaHelpers } from '../helpers';
import { useConfig, useSpec } from '../contexts';
import { CollapseButton } from './CollapseButton';
export var Extensions = function (_a) {
    var _b = _a.name, name = _b === void 0 ? 'Extensions' : _b, item = _a.item;
    var _c = useState(false), expanded = _c[0], setExpanded = _c[1];
    var config = useConfig();
    var document = useSpec();
    var extensions = SchemaHelpers.getCustomExtensions(item);
    if (!extensions || !Object.keys(extensions).length) {
        return null;
    }
    if (!config.extensions || !Object.keys(config.extensions).length) {
        var schema = SchemaHelpers.jsonToSchema(extensions);
        return (schema && (React.createElement("div", { className: "mt-2" },
            React.createElement(Schema, { schemaName: name, schema: schema, onlyTitle: true }))));
    }
    return (React.createElement("div", null,
        React.createElement("div", { className: "flex py-2" },
            React.createElement("div", { className: "min-w-1/4" },
                React.createElement(React.Fragment, null,
                    React.createElement(CollapseButton, { onClick: function () { return setExpanded(function (prev) { return !prev; }); }, expanded: expanded },
                        React.createElement("span", { className: "break-anywhere text-sm ".concat(name) }, name))))),
        React.createElement("div", { className: "rounded p-4 py-2 border bg-gray-100 ".concat(expanded ? 'block' : 'hidden') }, Object.keys(extensions)
            .sort(function (extension1, extension2) {
            return extension1.localeCompare(extension2);
        })
            .map(function (extensionKey) {
            var _a;
            if ((_a = config.extensions) === null || _a === void 0 ? void 0 : _a[extensionKey]) {
                var CustomExtensionComponent = config.extensions[extensionKey];
                return (React.createElement(CustomExtensionComponent, { key: extensionKey, propertyName: extensionKey, propertyValue: extensions[extensionKey], document: document, parent: item }));
            }
            else {
                var extensionSchema = SchemaHelpers.jsonToSchema(extensions[extensionKey]);
                return (React.createElement("div", { key: extensionKey, className: "mt-2" },
                    React.createElement(Schema, { schemaName: extensionKey, schema: extensionSchema })));
            }
        }))));
};
//# sourceMappingURL=Extensions.js.map