/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseObject;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseReplication;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseSchema;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class AltibaseReplicationItem
extends AltibaseObject<AltibaseReplication>
implements DBSAlias {
    private String tableOid;
    private String localSchemaName;
    private String localTableName;
    private String localPartnName;
    private String remoteSchemaName;
    private String remoteTableName;
    private String remotePartnName;
    private boolean isPartitionedRepl;
    private long invalidMaxSn;
    private DBSObject localTable = null;

    protected AltibaseReplicationItem(AltibaseReplication parent, JDBCResultSet resultSet) {
        super(parent, DBUtils.getFullyQualifiedName((DBPDataSource)parent.getDataSource(), (String[])new String[]{JDBCUtils.safeGetString((ResultSet)resultSet, (String)"LOCAL_USER_NAME"), JDBCUtils.safeGetString((ResultSet)resultSet, (String)"LOCAL_TABLE_NAME"), JDBCUtils.safeGetString((ResultSet)resultSet, (String)"LOCAL_PARTITION_NAME")}), true);
        this.tableOid = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TABLE_OID");
        this.isPartitionedRepl = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"REPLICATION_UNIT", (String)"P");
        this.invalidMaxSn = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"INVALID_MAX_SN");
        this.localSchemaName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"LOCAL_USER_NAME");
        this.localTableName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"LOCAL_TABLE_NAME");
        this.localPartnName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"LOCAL_PARTITION_NAME");
        this.remoteSchemaName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REMOTE_USER_NAME");
        this.remoteTableName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REMOTE_TABLE_NAME");
        this.remotePartnName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REMOTE_PARTITION_NAME");
    }

    @Override
    @Property(viewable=false, order=1, hidden=true)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getTableOid() {
        return this.tableOid;
    }

    @Property(viewable=true, linkPossible=true, order=5)
    @NotNull
    public AltibaseTable getReplObjFrom(DBRProgressMonitor monitor) throws DBException {
        if (this.localTable == null) {
            this.localTable = this.getTargetObject(monitor);
        }
        return (AltibaseTable)this.localTable;
    }

    @Property(viewable=true, order=6)
    @NotNull
    public String getReplObjTo() {
        return DBUtils.getFullyQualifiedName((DBPDataSource)((AltibaseReplication)this.parent).getDataSource(), (String[])new String[]{this.remoteSchemaName, this.remoteTableName, this.remotePartnName});
    }

    @Property(viewable=true, order=10)
    public boolean getIsPartitionedRepl() {
        return this.isPartitionedRepl;
    }

    @Property(viewable=true, order=11)
    public long getInvalidMaxSn() {
        return this.invalidMaxSn;
    }

    @NotNull
    public DBSObject getTargetObject(@Nullable DBRProgressMonitor monitor) throws DBException {
        GenericTableBase localTable = null;
        AltibaseSchema refSchema = (AltibaseSchema)this.getDataSource().getSchema(this.localSchemaName);
        if (refSchema != null) {
            localTable = refSchema.getTable(monitor, this.localTableName);
        }
        return localTable;
    }
}

