/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tools.ant.util.FileUtils;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.DitaValReader;
import org.dita.dost.reader.SubjectSchemeReader;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.Job;
import org.dita.dost.writer.ProfilingFilter;

final class FilterModule
extends AbstractPipelineModuleImpl {
    FilterModule() {
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        Map<URI, Set<URI>> dic;
        FilterUtils filterUtils;
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        String transtype = input.getAttribute("transtype");
        File ditavalFile = Optional.of(new File(this.job.tempDir, "ditaot.generated.ditaval")).filter(File::exists).orElse(null);
        DitaValReader ditaValReader = new DitaValReader();
        ditaValReader.setLogger(this.logger);
        ditaValReader.setJob(this.job);
        if (ditavalFile != null) {
            ditaValReader.read(ditavalFile.toURI());
            filterUtils = new FilterUtils(Configuration.printTranstype.contains(transtype), ditaValReader.getFilterMap(), ditaValReader.getForegroundConflictColor(), ditaValReader.getBackgroundConflictColor());
        } else {
            filterUtils = new FilterUtils(Configuration.printTranstype.contains(transtype));
        }
        filterUtils.setLogger(this.logger);
        ProfilingFilter writer = new ProfilingFilter();
        writer.setLogger(this.logger);
        writer.setJob(this.job);
        writer.setFilterUtils(filterUtils);
        SubjectSchemeReader subjectSchemeReader = new SubjectSchemeReader();
        subjectSchemeReader.setLogger(this.logger);
        subjectSchemeReader.setJob(this.job);
        try {
            dic = subjectSchemeReader.readMapFromXML(new File(this.job.tempDir, "subject_scheme.dictionary"));
        }
        catch (IOException e) {
            throw new DITAOTException(e);
        }
        for (Job.FileInfo f : this.job.getFileInfo(this.fileInfoFilter)) {
            File file = new File(this.job.tempDir, f.file.getPath());
            this.logger.info("Processing " + file.getAbsolutePath());
            subjectSchemeReader.reset();
            Set<URI> schemaSet = dic.get(f.uri);
            if (schemaSet != null && !schemaSet.isEmpty()) {
                this.logger.info("Loading subject schemes");
                for (URI schema : schemaSet) {
                    File scheme = new File(this.job.tempDirURI.resolve(schema.getPath() + ".subm"));
                    if (!scheme.exists()) continue;
                    subjectSchemeReader.loadSubjectScheme(scheme);
                }
            }
            writer.setFilterUtils(filterUtils.refine(subjectSchemeReader.getSubjectSchemeMap()));
            writer.setCurrentFile(file.toURI());
            try {
                writer.write(file.getAbsoluteFile());
                if (writer.hasElementOutput()) continue;
                this.logger.info("All content in " + file.getAbsolutePath() + " was filtered out");
                this.job.remove(f);
                FileUtils.delete((File)file);
            }
            catch (Exception e) {
                this.logger.error("Failed to profile " + file.getAbsolutePath() + ": " + e.getMessage());
            }
        }
        try {
            this.job.write();
        }
        catch (IOException e) {
            throw new DITAOTException(e);
        }
        return null;
    }
}

