/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.record;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.record.A;
import org.minidns.record.AAAA;
import org.minidns.record.CNAME;
import org.minidns.record.DLV;
import org.minidns.record.DNAME;
import org.minidns.record.DNSKEY;
import org.minidns.record.DS;
import org.minidns.record.Data;
import org.minidns.record.MX;
import org.minidns.record.NS;
import org.minidns.record.NSEC;
import org.minidns.record.NSEC3;
import org.minidns.record.NSEC3PARAM;
import org.minidns.record.OPENPGPKEY;
import org.minidns.record.OPT;
import org.minidns.record.PTR;
import org.minidns.record.RRSIG;
import org.minidns.record.SOA;
import org.minidns.record.SRV;
import org.minidns.record.TLSA;
import org.minidns.record.TXT;
import org.minidns.record.UNKNOWN;

public final class Record<D extends Data> {
    public final DnsName name;
    public final TYPE type;
    public final CLASS clazz;
    public final int clazzValue;
    public final long ttl;
    public final D payloadData;
    public final boolean unicastQuery;
    private transient byte[] bytes;
    private transient Integer hashCodeCache;

    public static Record<Data> parse(DataInputStream dis, byte[] data) throws IOException {
        Data payloadData;
        DnsName name = DnsName.parse(dis, data);
        int typeValue = dis.readUnsignedShort();
        TYPE type = TYPE.getType(typeValue);
        int clazzValue = dis.readUnsignedShort();
        CLASS clazz = CLASS.getClass(clazzValue & Short.MAX_VALUE);
        boolean unicastQuery = (clazzValue & 0x8000) > 0;
        long ttl = ((long)dis.readUnsignedShort() << 16) + (long)dis.readUnsignedShort();
        int payloadLength = dis.readUnsignedShort();
        switch (type.ordinal()) {
            case 6: {
                payloadData = SOA.parse(dis, data);
                break;
            }
            case 33: {
                payloadData = SRV.parse(dis, data);
                break;
            }
            case 15: {
                payloadData = MX.parse(dis, data);
                break;
            }
            case 28: {
                payloadData = AAAA.parse(dis);
                break;
            }
            case 1: {
                payloadData = A.parse(dis);
                break;
            }
            case 2: {
                payloadData = NS.parse(dis, data);
                break;
            }
            case 5: {
                payloadData = CNAME.parse(dis, data);
                break;
            }
            case 39: {
                payloadData = DNAME.parse(dis, data);
                break;
            }
            case 12: {
                payloadData = PTR.parse(dis, data);
                break;
            }
            case 16: {
                payloadData = TXT.parse(dis, payloadLength);
                break;
            }
            case 41: {
                payloadData = OPT.parse(dis, payloadLength);
                break;
            }
            case 48: {
                payloadData = DNSKEY.parse(dis, payloadLength);
                break;
            }
            case 46: {
                payloadData = RRSIG.parse(dis, data, payloadLength);
                break;
            }
            case 43: {
                payloadData = DS.parse(dis, payloadLength);
                break;
            }
            case 47: {
                payloadData = NSEC.parse(dis, data, payloadLength);
                break;
            }
            case 50: {
                payloadData = NSEC3.parse(dis, payloadLength);
                break;
            }
            case 51: {
                payloadData = NSEC3PARAM.parse(dis);
                break;
            }
            case 52: {
                payloadData = TLSA.parse(dis, payloadLength);
                break;
            }
            case 59: {
                payloadData = OPENPGPKEY.parse(dis, payloadLength);
                break;
            }
            case 82: {
                payloadData = DLV.parse(dis, payloadLength);
                break;
            }
            default: {
                payloadData = UNKNOWN.parse(dis, payloadLength, type);
            }
        }
        return new Record<Data>(name, type, clazz, clazzValue, ttl, payloadData, unicastQuery);
    }

    public Record(DnsName name, TYPE type, CLASS clazz, long ttl, D payloadData, boolean unicastQuery) {
        this(name, type, clazz, clazz.getValue() + (unicastQuery ? 32768 : 0), ttl, payloadData, unicastQuery);
    }

    public Record(String name, TYPE type, CLASS clazz, long ttl, D payloadData, boolean unicastQuery) {
        this(DnsName.from(name), type, clazz, ttl, payloadData, unicastQuery);
    }

    public Record(String name, TYPE type, int clazzValue, long ttl, D payloadData) {
        this(DnsName.from(name), type, CLASS.NONE, clazzValue, ttl, payloadData, false);
    }

    public Record(DnsName name, TYPE type, int clazzValue, long ttl, D payloadData) {
        this(name, type, CLASS.NONE, clazzValue, ttl, payloadData, false);
    }

    private Record(DnsName name, TYPE type, CLASS clazz, int clazzValue, long ttl, D payloadData, boolean unicastQuery) {
        this.name = name;
        this.type = type;
        this.clazz = clazz;
        this.clazzValue = clazzValue;
        this.ttl = ttl;
        this.payloadData = payloadData;
        this.unicastQuery = unicastQuery;
    }

    public void toOutputStream(OutputStream outputStream) throws IOException {
        if (this.payloadData == null) {
            throw new IllegalStateException("Empty Record has no byte representation");
        }
        DataOutputStream dos = new DataOutputStream(outputStream);
        this.name.writeToStream(dos);
        dos.writeShort(this.type.getValue());
        dos.writeShort(this.clazzValue);
        dos.writeInt((int)this.ttl);
        dos.writeShort(((Data)this.payloadData).length());
        ((Data)this.payloadData).toOutputStream(dos);
    }

    public byte[] toByteArray() {
        if (this.bytes == null) {
            int totalSize = this.name.size() + 10 + ((Data)this.payloadData).length();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(totalSize);
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                this.toOutputStream(dos);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.bytes = baos.toByteArray();
        }
        return (byte[])this.bytes.clone();
    }

    public String toString() {
        return this.name.getRawAce() + ".\t" + this.ttl + "\t" + String.valueOf((Object)this.clazz) + "\t" + String.valueOf((Object)this.type) + "\t" + String.valueOf(this.payloadData);
    }

    public boolean isAnswer(Question q) {
        return !(q.type != this.type && q.type != TYPE.ANY || q.clazz != this.clazz && q.clazz != CLASS.ANY || !q.name.equals(this.name));
    }

    public boolean isUnicastQuery() {
        return this.unicastQuery;
    }

    public D getPayload() {
        return this.payloadData;
    }

    public long getTtl() {
        return this.ttl;
    }

    public Question getQuestion() {
        switch (this.type.ordinal()) {
            case 41: {
                return null;
            }
            case 46: {
                RRSIG rrsig = (RRSIG)this.payloadData;
                return new Question(this.name, rrsig.typeCovered, this.clazz);
            }
        }
        return new Question(this.name, this.type, this.clazz);
    }

    public DnsMessage.Builder getQuestionMessage() {
        Question question = this.getQuestion();
        if (question == null) {
            return null;
        }
        return question.asMessageBuilder();
    }

    public int hashCode() {
        if (this.hashCodeCache == null) {
            int hashCode = 1;
            hashCode = 37 * hashCode + this.name.hashCode();
            hashCode = 37 * hashCode + this.type.hashCode();
            hashCode = 37 * hashCode + this.clazz.hashCode();
            hashCode = 37 * hashCode + ((Data)this.payloadData).hashCode();
            this.hashCodeCache = hashCode;
        }
        return this.hashCodeCache;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Record)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Record otherRecord = (Record)other;
        if (!this.name.equals(otherRecord.name)) {
            return false;
        }
        if (this.type != otherRecord.type) {
            return false;
        }
        if (this.clazz != otherRecord.clazz) {
            return false;
        }
        return ((Data)this.payloadData).equals(otherRecord.payloadData);
    }

    public <E extends Data> Record<E> ifPossibleAs(Class<E> dataClass) {
        if (this.type.dataClass == dataClass) {
            return this;
        }
        return null;
    }

    public <E extends Data> Record<E> as(Class<E> dataClass) {
        Record<E> eRecord = this.ifPossibleAs(dataClass);
        if (eRecord == null) {
            throw new IllegalArgumentException("The instance " + String.valueOf(this) + " can not be cast to a Record with" + String.valueOf(dataClass));
        }
        return eRecord;
    }

    public static <E extends Data> void filter(Collection<Record<E>> result, Class<E> dataClass, Collection<Record<? extends Data>> input) {
        for (Record<? extends Data> record : input) {
            Record<E> filteredRecord = record.ifPossibleAs(dataClass);
            if (filteredRecord == null) continue;
            result.add(filteredRecord);
        }
    }

    public static <E extends Data> List<Record<E>> filter(Class<E> dataClass, Collection<Record<? extends Data>> input) {
        ArrayList<Record<E>> result = new ArrayList<Record<E>>(input.size());
        Record.filter(result, dataClass, input);
        return result;
    }

    public static enum TYPE {
        UNKNOWN(-1),
        A(1, A.class),
        NS(2, NS.class),
        MD(3),
        MF(4),
        CNAME(5, CNAME.class),
        SOA(6, SOA.class),
        MB(7),
        MG(8),
        MR(9),
        NULL(10),
        WKS(11),
        PTR(12, PTR.class),
        HINFO(13),
        MINFO(14),
        MX(15, MX.class),
        TXT(16, TXT.class),
        RP(17),
        AFSDB(18),
        X25(19),
        ISDN(20),
        RT(21),
        NSAP(22),
        NSAP_PTR(23),
        SIG(24),
        KEY(25),
        PX(26),
        GPOS(27),
        AAAA(28, AAAA.class),
        LOC(29),
        NXT(30),
        EID(31),
        NIMLOC(32),
        SRV(33, SRV.class),
        ATMA(34),
        NAPTR(35),
        KX(36),
        CERT(37),
        A6(38),
        DNAME(39, DNAME.class),
        SINK(40),
        OPT(41, OPT.class),
        APL(42),
        DS(43, DS.class),
        SSHFP(44),
        IPSECKEY(45),
        RRSIG(46, RRSIG.class),
        NSEC(47, NSEC.class),
        DNSKEY(48, DNSKEY.class),
        DHCID(49),
        NSEC3(50, NSEC3.class),
        NSEC3PARAM(51, NSEC3PARAM.class),
        TLSA(52, TLSA.class),
        HIP(55),
        NINFO(56),
        RKEY(57),
        TALINK(58),
        CDS(59),
        CDNSKEY(60),
        OPENPGPKEY(61, OPENPGPKEY.class),
        CSYNC(62),
        SPF(99),
        UINFO(100),
        UID(101),
        GID(102),
        UNSPEC(103),
        NID(104),
        L32(105),
        L64(106),
        LP(107),
        EUI48(108),
        EUI64(109),
        TKEY(249),
        TSIG(250),
        IXFR(251),
        AXFR(252),
        MAILB(253),
        MAILA(254),
        ANY(255),
        URI(256),
        CAA(257),
        TA(32768),
        DLV(32769, DLV.class);

        private final int value;
        private final Class<?> dataClass;
        private static final Map<Integer, TYPE> INVERSE_LUT;
        private static final Map<Class<?>, TYPE> DATA_LUT;

        private TYPE(int value) {
            this(value, null);
        }

        private <D extends Data> TYPE(int value, Class<D> dataClass) {
            this.value = value;
            this.dataClass = dataClass;
        }

        public int getValue() {
            return this.value;
        }

        public <D extends Data> Class<D> getDataClass() {
            return this.dataClass;
        }

        public static TYPE getType(int value) {
            TYPE type = INVERSE_LUT.get(value);
            if (type == null) {
                return UNKNOWN;
            }
            return type;
        }

        public static <D extends Data> TYPE getType(Class<D> dataClass) {
            return DATA_LUT.get(dataClass);
        }

        static {
            INVERSE_LUT = new HashMap<Integer, TYPE>();
            DATA_LUT = new HashMap();
            for (TYPE t : TYPE.values()) {
                INVERSE_LUT.put(t.getValue(), t);
                if (t.dataClass == null) continue;
                DATA_LUT.put(t.dataClass, t);
            }
        }
    }

    public static enum CLASS {
        IN(1),
        CH(3),
        HS(4),
        NONE(254),
        ANY(255);

        private static final HashMap<Integer, CLASS> INVERSE_LUT;
        private final int value;

        private CLASS(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static CLASS getClass(int value) {
            return INVERSE_LUT.get(value);
        }

        static {
            INVERSE_LUT = new HashMap();
            for (CLASS c : CLASS.values()) {
                INVERSE_LUT.put(c.getValue(), c);
            }
        }
    }
}

