/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.management.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.TabularData;
import org.apache.karaf.scr.management.ServiceComponentRuntimeMBean;
import org.apache.karaf.scr.management.codec.JmxComponentConfiguration;
import org.apache.karaf.scr.management.codec.JmxComponentDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="ServiceComponentRuntimeMBean", enabled=true, immediate=true, properties={"org/apache/karaf/scr/management/internal/ServiceComponentRuntimeMBeanImpl.properties"})
public class ServiceComponentRuntimeMBeanImpl
extends StandardMBean
implements ServiceComponentRuntimeMBean {
    public static final String OBJECT_NAME = "org.apache.karaf:type=scr,name=" + System.getProperty("karaf.name", "root");
    public static final String COMPONENT_NAME = "ServiceComponentRuntimeMBean";
    public static final String COMPONENT_LABEL = "Apache Karaf ServiceComponentRuntime MBean";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceComponentRuntimeMBeanImpl.class);
    private MBeanServer mBeanServer;
    private BundleContext context;
    private ServiceComponentRuntime scrService;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public ServiceComponentRuntimeMBeanImpl() throws NotCompliantMBeanException {
        super(ServiceComponentRuntimeMBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    public void activate(BundleContext context) throws Exception {
        LOGGER.info("Activating the Apache Karaf ServiceComponentRuntime MBean");
        HashMap<ServiceComponentRuntimeMBeanImpl, String> mbeans = new HashMap<ServiceComponentRuntimeMBeanImpl, String>();
        mbeans.put(this, "org.apache.karaf:type=scr,name=${karaf.name}");
        try {
            this.lock.writeLock().lock();
            this.context = context;
            if (this.mBeanServer != null) {
                this.mBeanServer.registerMBean(this, new ObjectName(OBJECT_NAME));
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception registering the SCR Management MBean: " + e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Deactivate
    public void deactivate() throws Exception {
        LOGGER.info("Deactivating the Apache Karaf ServiceComponentRuntime MBean");
        try {
            this.lock.writeLock().lock();
            if (this.mBeanServer != null) {
                this.mBeanServer.unregisterMBean(new ObjectName(OBJECT_NAME));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public TabularData getComponents() {
        return JmxComponentDescription.tableFrom(this.scrService.getComponentDescriptionDTOs(new Bundle[0]));
    }

    @Override
    public TabularData getComponentConfigs() {
        return JmxComponentConfiguration.tableFrom(this.scrService.getComponentDescriptionDTOs(new Bundle[0]).stream().map(c -> this.scrService.getComponentConfigurationDTOs(c)).flatMap(Collection::stream));
    }

    @Override
    public TabularData getComponentConfigs(long bundleId, String componentName) {
        return JmxComponentConfiguration.tableFrom(this.scrService.getComponentConfigurationDTOs(this.findComponent(bundleId, componentName)));
    }

    @Override
    public boolean isComponentEnabled(long bundleId, String componentName) {
        return this.scrService.isComponentEnabled(this.findComponent(bundleId, componentName));
    }

    @Override
    public void enableComponent(long bundleId, String componentName) {
        this.scrService.enableComponent(this.findComponent(bundleId, componentName));
    }

    @Override
    public void disableComponent(long bundleId, String componentName) {
        this.scrService.disableComponent(this.findComponent(bundleId, componentName));
    }

    private ComponentDescriptionDTO findComponent(long bundleId, String componentName) {
        Bundle bundle = this.context.getBundle(bundleId);
        if (bundle != null) {
            return this.scrService.getComponentDescriptionDTO(bundle, componentName);
        }
        throw new IllegalArgumentException("No component found for name: " + componentName);
    }

    @Reference
    public void setmBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public void unsetmBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = null;
    }

    @Reference
    public void setScrService(ServiceComponentRuntime scrService) {
        this.scrService = scrService;
    }

    public void unsetScrService(ServiceComponentRuntime scrService) {
        this.scrService = null;
    }
}

