// Copyright 2022 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the GO_LICENSE file.

package hmacsha512

import "golang.org/x/sys/cpu"

var useSHA512 = cpu.ARM64.HasSHA512

func block(dig *digest, p []byte) {
	if useSHA512 {
		blockAsm(dig, p)
		return
	}
	blockGeneric(dig, p)
}

//go:noescape
func blockAsm(dig *digest, p []byte)
