/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.NumericOp;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CorrespondingPropertyMaker;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;

public class IndentPropertyMaker
extends CorrespondingPropertyMaker {
    private int[] paddingCorresponding;
    private int[] borderWidthCorresponding;

    public IndentPropertyMaker(PropertyMaker baseMaker) {
        super(baseMaker);
    }

    public void setPaddingCorresponding(int[] paddingCorresponding) {
        if (paddingCorresponding == null || paddingCorresponding.length != 4) {
            throw new IllegalArgumentException();
        }
        this.paddingCorresponding = paddingCorresponding;
    }

    public void setBorderWidthCorresponding(int[] borderWidthCorresponding) {
        if (borderWidthCorresponding == null || borderWidthCorresponding.length != 4) {
            throw new IllegalArgumentException();
        }
        this.borderWidthCorresponding = borderWidthCorresponding;
    }

    @Override
    public Property compute(PropertyList propertyList) throws PropertyException {
        if (propertyList.getFObj().getUserAgent().isBreakIndentInheritanceOnReferenceAreaBoundary()) {
            return this.computeAlternativeRuleset(propertyList);
        }
        return this.computeConforming(propertyList);
    }

    public Property computeConforming(PropertyList propertyList) throws PropertyException {
        PropertyList pList = this.getWMPropertyList(propertyList);
        if (pList == null) {
            return null;
        }
        Numeric padding = this.getCorresponding(this.paddingCorresponding, propertyList).getNumeric();
        Numeric border = this.getCorresponding(this.borderWidthCorresponding, propertyList).getNumeric();
        int marginProp = pList.selectFromWritingMode(this.lrtb, this.rltb, this.tbrl, this.tblr);
        if (propertyList.getExplicitOrShorthand(marginProp) == null) {
            Property indent = propertyList.getExplicit(this.baseMaker.propId);
            if (indent == null) {
                return null;
            }
            return indent;
        }
        Numeric margin = propertyList.get(marginProp).getNumeric();
        Numeric v = FixedLength.ZERO_FIXED_LENGTH;
        if (!propertyList.getFObj().generatesReferenceAreas()) {
            v = NumericOp.addition(v, propertyList.getInherited(this.baseMaker.propId).getNumeric());
        }
        v = NumericOp.addition(v, margin);
        v = NumericOp.addition(v, padding);
        v = NumericOp.addition(v, border);
        return v;
    }

    private boolean isInherited(PropertyList pList) {
        if (pList.getFObj().getUserAgent().isBreakIndentInheritanceOnReferenceAreaBoundary()) {
            FONode nd = pList.getFObj().getParent();
            return !(nd instanceof FObj) || !((FObj)nd).generatesReferenceAreas();
        }
        return true;
    }

    public Property computeAlternativeRuleset(PropertyList propertyList) throws PropertyException {
        PropertyList pList = this.getWMPropertyList(propertyList);
        if (pList == null) {
            return null;
        }
        Numeric padding = this.getCorresponding(this.paddingCorresponding, propertyList).getNumeric();
        Numeric border = this.getCorresponding(this.borderWidthCorresponding, propertyList).getNumeric();
        int marginProp = pList.selectFromWritingMode(this.lrtb, this.rltb, this.tbrl, this.tblr);
        boolean marginNearest = false;
        for (PropertyList pl = propertyList.getParentPropertyList(); pl != null && pl.getExplicit(this.baseMaker.propId) == null; pl = pl.getParentPropertyList()) {
            if (pl.getExplicitOrShorthand(marginProp) == null) continue;
            marginNearest = true;
            break;
        }
        if (propertyList.getExplicitOrShorthand(marginProp) == null) {
            Property indent = propertyList.getExplicit(this.baseMaker.propId);
            if (indent == null) {
                if (this.isInherited(propertyList) || !marginNearest) {
                    return null;
                }
                return FixedLength.ZERO_FIXED_LENGTH;
            }
            return indent;
        }
        Numeric margin = propertyList.get(marginProp).getNumeric();
        Numeric v = FixedLength.ZERO_FIXED_LENGTH;
        if (this.isInherited(propertyList)) {
            v = NumericOp.addition(v, propertyList.getInherited(this.baseMaker.propId).getNumeric());
        }
        v = NumericOp.addition(v, margin);
        v = NumericOp.addition(v, padding);
        v = NumericOp.addition(v, border);
        return v;
    }

    private Property getCorresponding(int[] corresponding, PropertyList propertyList) throws PropertyException {
        PropertyList pList = this.getWMPropertyList(propertyList);
        if (pList != null) {
            int wmcorr = pList.selectFromWritingMode(corresponding[0], corresponding[1], corresponding[2], corresponding[3]);
            return propertyList.get(wmcorr);
        }
        return null;
    }
}

