package security

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/security/mgmt/v1.0/security"

// AadConnectivityState1 describes an Azure resource with kind
type AadConnectivityState1 struct {
	// ConnectivityState - Possible values include: 'Discovered', 'NotLicensed', 'Connected'
	ConnectivityState AadConnectivityState `json:"connectivityState,omitempty"`
}

// AadExternalSecuritySolution represents an AAD identity protection solution which sends logs to an OMS
// workspace.
type AadExternalSecuritySolution struct {
	Properties *AadSolutionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	aess.Kind = KindAAD
	objectMap := make(map[string]interface{})
	if aess.Properties != nil {
		objectMap["properties"] = aess.Properties
	}
	if aess.Kind != "" {
		objectMap["kind"] = aess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return nil, false
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return nil, false
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return &aess, true
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return nil, false
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &aess, true
}

// AadSolutionProperties ...
type AadSolutionProperties struct {
	DeviceVendor *string             `json:"deviceVendor,omitempty"`
	DeviceType   *string             `json:"deviceType,omitempty"`
	Workspace    *ConnectedWorkspace `json:"workspace,omitempty"`
	// ConnectivityState - Possible values include: 'Discovered', 'NotLicensed', 'Connected'
	ConnectivityState AadConnectivityState `json:"connectivityState,omitempty"`
}

// ActiveConnectionsNotInAllowedRange number of active connections is not in allowed range.
type ActiveConnectionsNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) MarshalJSON() ([]byte, error) {
	acniar.RuleType = RuleTypeActiveConnectionsNotInAllowedRange
	objectMap := make(map[string]interface{})
	if acniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = acniar.TimeWindowSize
	}
	if acniar.MinThreshold != nil {
		objectMap["minThreshold"] = acniar.MinThreshold
	}
	if acniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = acniar.MaxThreshold
	}
	if acniar.IsEnabled != nil {
		objectMap["isEnabled"] = acniar.IsEnabled
	}
	if acniar.RuleType != "" {
		objectMap["ruleType"] = acniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &acniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &acniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return &acniar, true
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &acniar, true
}

// AdaptiveNetworkHardening the resource whose properties describes the Adaptive Network Hardening settings
// for some Azure resource
type AdaptiveNetworkHardening struct {
	autorest.Response `json:"-"`
	// AdaptiveNetworkHardeningProperties - Properties of the Adaptive Network Hardening resource
	*AdaptiveNetworkHardeningProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AdaptiveNetworkHardening.
func (anh AdaptiveNetworkHardening) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if anh.AdaptiveNetworkHardeningProperties != nil {
		objectMap["properties"] = anh.AdaptiveNetworkHardeningProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AdaptiveNetworkHardening struct.
func (anh *AdaptiveNetworkHardening) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var adaptiveNetworkHardeningProperties AdaptiveNetworkHardeningProperties
				err = json.Unmarshal(*v, &adaptiveNetworkHardeningProperties)
				if err != nil {
					return err
				}
				anh.AdaptiveNetworkHardeningProperties = &adaptiveNetworkHardeningProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				anh.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				anh.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				anh.Type = &typeVar
			}
		}
	}

	return nil
}

// AdaptiveNetworkHardeningEnforceRequest ...
type AdaptiveNetworkHardeningEnforceRequest struct {
	// Rules - The rules to enforce
	Rules *[]Rule `json:"rules,omitempty"`
	// NetworkSecurityGroups - The Azure resource IDs of the effective network security groups that will be updated with the created security rules from the Adaptive Network Hardening rules
	NetworkSecurityGroups *[]string `json:"networkSecurityGroups,omitempty"`
}

// AdaptiveNetworkHardeningProperties adaptive Network Hardening resource properties
type AdaptiveNetworkHardeningProperties struct {
	// Rules - The security rules which are recommended to be effective on the VM
	Rules *[]Rule `json:"rules,omitempty"`
	// RulesCalculationTime - The UTC time on which the rules were calculated
	RulesCalculationTime *date.Time `json:"rulesCalculationTime,omitempty"`
	// EffectiveNetworkSecurityGroups - The Network Security Groups effective on the network interfaces of the protected resource
	EffectiveNetworkSecurityGroups *[]EffectiveNetworkSecurityGroups `json:"effectiveNetworkSecurityGroups,omitempty"`
}

// AdaptiveNetworkHardeningsEnforceFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AdaptiveNetworkHardeningsEnforceFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AdaptiveNetworkHardeningsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AdaptiveNetworkHardeningsEnforceFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AdaptiveNetworkHardeningsEnforceFuture.Result.
func (future *AdaptiveNetworkHardeningsEnforceFuture) result(client AdaptiveNetworkHardeningsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AdaptiveNetworkHardeningsEnforceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("security.AdaptiveNetworkHardeningsEnforceFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AdaptiveNetworkHardeningsList response for ListAdaptiveNetworkHardenings API service call
type AdaptiveNetworkHardeningsList struct {
	autorest.Response `json:"-"`
	// Value - A list of Adaptive Network Hardenings resources
	Value *[]AdaptiveNetworkHardening `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results
	NextLink *string `json:"nextLink,omitempty"`
}

// AdaptiveNetworkHardeningsListIterator provides access to a complete listing of AdaptiveNetworkHardening
// values.
type AdaptiveNetworkHardeningsListIterator struct {
	i    int
	page AdaptiveNetworkHardeningsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AdaptiveNetworkHardeningsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AdaptiveNetworkHardeningsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AdaptiveNetworkHardeningsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AdaptiveNetworkHardeningsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AdaptiveNetworkHardeningsListIterator) Response() AdaptiveNetworkHardeningsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AdaptiveNetworkHardeningsListIterator) Value() AdaptiveNetworkHardening {
	if !iter.page.NotDone() {
		return AdaptiveNetworkHardening{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AdaptiveNetworkHardeningsListIterator type.
func NewAdaptiveNetworkHardeningsListIterator(page AdaptiveNetworkHardeningsListPage) AdaptiveNetworkHardeningsListIterator {
	return AdaptiveNetworkHardeningsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (anhl AdaptiveNetworkHardeningsList) IsEmpty() bool {
	return anhl.Value == nil || len(*anhl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (anhl AdaptiveNetworkHardeningsList) hasNextLink() bool {
	return anhl.NextLink != nil && len(*anhl.NextLink) != 0
}

// adaptiveNetworkHardeningsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (anhl AdaptiveNetworkHardeningsList) adaptiveNetworkHardeningsListPreparer(ctx context.Context) (*http.Request, error) {
	if !anhl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(anhl.NextLink)))
}

// AdaptiveNetworkHardeningsListPage contains a page of AdaptiveNetworkHardening values.
type AdaptiveNetworkHardeningsListPage struct {
	fn   func(context.Context, AdaptiveNetworkHardeningsList) (AdaptiveNetworkHardeningsList, error)
	anhl AdaptiveNetworkHardeningsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AdaptiveNetworkHardeningsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AdaptiveNetworkHardeningsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.anhl)
		if err != nil {
			return err
		}
		page.anhl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AdaptiveNetworkHardeningsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AdaptiveNetworkHardeningsListPage) NotDone() bool {
	return !page.anhl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AdaptiveNetworkHardeningsListPage) Response() AdaptiveNetworkHardeningsList {
	return page.anhl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AdaptiveNetworkHardeningsListPage) Values() []AdaptiveNetworkHardening {
	if page.anhl.IsEmpty() {
		return nil
	}
	return *page.anhl.Value
}

// Creates a new instance of the AdaptiveNetworkHardeningsListPage type.
func NewAdaptiveNetworkHardeningsListPage(cur AdaptiveNetworkHardeningsList, getNextPage func(context.Context, AdaptiveNetworkHardeningsList) (AdaptiveNetworkHardeningsList, error)) AdaptiveNetworkHardeningsListPage {
	return AdaptiveNetworkHardeningsListPage{
		fn:   getNextPage,
		anhl: cur,
	}
}

// BasicAdditionalData details of the sub-assessment
type BasicAdditionalData interface {
	AsSQLServerVulnerabilityProperties() (*SQLServerVulnerabilityProperties, bool)
	AsContainerRegistryVulnerabilityProperties() (*ContainerRegistryVulnerabilityProperties, bool)
	AsServerVulnerabilityProperties() (*ServerVulnerabilityProperties, bool)
	AsAdditionalData() (*AdditionalData, bool)
}

// AdditionalData details of the sub-assessment
type AdditionalData struct {
	// AssessedResourceType - Possible values include: 'AssessedResourceTypeAdditionalData', 'AssessedResourceTypeSQLServerVulnerability', 'AssessedResourceTypeContainerRegistryVulnerability', 'AssessedResourceTypeServerVulnerabilityAssessment'
	AssessedResourceType AssessedResourceType `json:"assessedResourceType,omitempty"`
}

func unmarshalBasicAdditionalData(body []byte) (BasicAdditionalData, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["assessedResourceType"] {
	case string(AssessedResourceTypeSQLServerVulnerability):
		var ssvp SQLServerVulnerabilityProperties
		err := json.Unmarshal(body, &ssvp)
		return ssvp, err
	case string(AssessedResourceTypeContainerRegistryVulnerability):
		var crvp ContainerRegistryVulnerabilityProperties
		err := json.Unmarshal(body, &crvp)
		return crvp, err
	case string(AssessedResourceTypeServerVulnerabilityAssessment):
		var svp ServerVulnerabilityProperties
		err := json.Unmarshal(body, &svp)
		return svp, err
	default:
		var ad AdditionalData
		err := json.Unmarshal(body, &ad)
		return ad, err
	}
}
func unmarshalBasicAdditionalDataArray(body []byte) ([]BasicAdditionalData, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	adArray := make([]BasicAdditionalData, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ad, err := unmarshalBasicAdditionalData(*rawMessage)
		if err != nil {
			return nil, err
		}
		adArray[index] = ad
	}
	return adArray, nil
}

// MarshalJSON is the custom marshaler for AdditionalData.
func (ad AdditionalData) MarshalJSON() ([]byte, error) {
	ad.AssessedResourceType = AssessedResourceTypeAdditionalData
	objectMap := make(map[string]interface{})
	if ad.AssessedResourceType != "" {
		objectMap["assessedResourceType"] = ad.AssessedResourceType
	}
	return json.Marshal(objectMap)
}

// AsSQLServerVulnerabilityProperties is the BasicAdditionalData implementation for AdditionalData.
func (ad AdditionalData) AsSQLServerVulnerabilityProperties() (*SQLServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsContainerRegistryVulnerabilityProperties is the BasicAdditionalData implementation for AdditionalData.
func (ad AdditionalData) AsContainerRegistryVulnerabilityProperties() (*ContainerRegistryVulnerabilityProperties, bool) {
	return nil, false
}

// AsServerVulnerabilityProperties is the BasicAdditionalData implementation for AdditionalData.
func (ad AdditionalData) AsServerVulnerabilityProperties() (*ServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsAdditionalData is the BasicAdditionalData implementation for AdditionalData.
func (ad AdditionalData) AsAdditionalData() (*AdditionalData, bool) {
	return &ad, true
}

// AsBasicAdditionalData is the BasicAdditionalData implementation for AdditionalData.
func (ad AdditionalData) AsBasicAdditionalData() (BasicAdditionalData, bool) {
	return &ad, true
}

// AdvancedThreatProtectionProperties the Advanced Threat Protection settings.
type AdvancedThreatProtectionProperties struct {
	// IsEnabled - Indicates whether Advanced Threat Protection is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// AdvancedThreatProtectionSetting the Advanced Threat Protection resource.
type AdvancedThreatProtectionSetting struct {
	autorest.Response                   `json:"-"`
	*AdvancedThreatProtectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AdvancedThreatProtectionSetting.
func (atps AdvancedThreatProtectionSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atps.AdvancedThreatProtectionProperties != nil {
		objectMap["properties"] = atps.AdvancedThreatProtectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AdvancedThreatProtectionSetting struct.
func (atps *AdvancedThreatProtectionSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var advancedThreatProtectionProperties AdvancedThreatProtectionProperties
				err = json.Unmarshal(*v, &advancedThreatProtectionProperties)
				if err != nil {
					return err
				}
				atps.AdvancedThreatProtectionProperties = &advancedThreatProtectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				atps.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				atps.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				atps.Type = &typeVar
			}
		}
	}

	return nil
}

// Alert security alert
type Alert struct {
	autorest.Response `json:"-"`
	*AlertProperties  `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AlertProperties != nil {
		objectMap["properties"] = a.AlertProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Alert struct.
func (a *Alert) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertProperties AlertProperties
				err = json.Unmarshal(*v, &alertProperties)
				if err != nil {
					return err
				}
				a.AlertProperties = &alertProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertConfidenceReason factors that increase our confidence that the alert is a true positive
type AlertConfidenceReason struct {
	// Type - READ-ONLY; Type of confidence factor
	Type *string `json:"type,omitempty"`
	// Reason - READ-ONLY; description of the confidence reason
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertConfidenceReason.
func (acr AlertConfidenceReason) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AlertEntity changing set of properties depending on the entity type.
type AlertEntity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Type - READ-ONLY; Type of entity
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertEntity.
func (ae AlertEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	for k, v := range ae.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertEntity struct.
func (ae *AlertEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ae.AdditionalProperties == nil {
					ae.AdditionalProperties = make(map[string]interface{})
				}
				ae.AdditionalProperties[k] = additionalProperties
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ae.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertList list of security alerts
type AlertList struct {
	autorest.Response `json:"-"`
	Value             *[]Alert `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertList.
func (al AlertList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if al.Value != nil {
		objectMap["value"] = al.Value
	}
	return json.Marshal(objectMap)
}

// AlertListIterator provides access to a complete listing of Alert values.
type AlertListIterator struct {
	i    int
	page AlertListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertListIterator) Response() AlertList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertListIterator) Value() Alert {
	if !iter.page.NotDone() {
		return Alert{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertListIterator type.
func NewAlertListIterator(page AlertListPage) AlertListIterator {
	return AlertListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AlertList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al AlertList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// alertListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AlertList) alertListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AlertListPage contains a page of Alert values.
type AlertListPage struct {
	fn func(context.Context, AlertList) (AlertList, error)
	al AlertList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertListPage) Response() AlertList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertListPage) Values() []Alert {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AlertListPage type.
func NewAlertListPage(cur AlertList, getNextPage func(context.Context, AlertList) (AlertList, error)) AlertListPage {
	return AlertListPage{
		fn: getNextPage,
		al: cur,
	}
}

// AlertProperties describes security alert properties.
type AlertProperties struct {
	// State - READ-ONLY; State of the alert (Active, Dismissed etc.)
	State *string `json:"state,omitempty"`
	// ReportedTimeUtc - READ-ONLY; The time the incident was reported to Microsoft.Security in UTC
	ReportedTimeUtc *date.Time `json:"reportedTimeUtc,omitempty"`
	// VendorName - READ-ONLY; Name of the vendor that discovered the incident
	VendorName *string `json:"vendorName,omitempty"`
	// AlertName - READ-ONLY; Name of the alert type
	AlertName *string `json:"alertName,omitempty"`
	// AlertDisplayName - READ-ONLY; Display name of the alert type
	AlertDisplayName *string `json:"alertDisplayName,omitempty"`
	// DetectedTimeUtc - READ-ONLY; The time the incident was detected by the vendor
	DetectedTimeUtc *date.Time `json:"detectedTimeUtc,omitempty"`
	// Description - READ-ONLY; Description of the incident and what it means
	Description *string `json:"description,omitempty"`
	// RemediationSteps - READ-ONLY; Recommended steps to reradiate the incident
	RemediationSteps *string `json:"remediationSteps,omitempty"`
	// ActionTaken - READ-ONLY; The action that was taken as a response to the alert (Active, Blocked etc.)
	ActionTaken *string `json:"actionTaken,omitempty"`
	// ReportedSeverity - READ-ONLY; Estimated severity of this alert. Possible values include: 'Silent', 'Information', 'Low', 'High'
	ReportedSeverity ReportedSeverity `json:"reportedSeverity,omitempty"`
	// CompromisedEntity - READ-ONLY; The entity that the incident happened on
	CompromisedEntity *string `json:"compromisedEntity,omitempty"`
	// AssociatedResource - READ-ONLY; Azure resource ID of the associated resource
	AssociatedResource *string                `json:"associatedResource,omitempty"`
	ExtendedProperties map[string]interface{} `json:"extendedProperties"`
	// SystemSource - READ-ONLY; The type of the alerted resource (Azure, Non-Azure)
	SystemSource *string `json:"systemSource,omitempty"`
	// CanBeInvestigated - READ-ONLY; Whether this alert can be investigated with Azure Security Center
	CanBeInvestigated *bool `json:"canBeInvestigated,omitempty"`
	// IsIncident - READ-ONLY; Whether this alert is for incident type or not (otherwise - single alert)
	IsIncident *bool `json:"isIncident,omitempty"`
	// Entities - objects that are related to this alerts
	Entities *[]AlertEntity `json:"entities,omitempty"`
	// ConfidenceScore - READ-ONLY; level of confidence we have on the alert
	ConfidenceScore *float64 `json:"confidenceScore,omitempty"`
	// ConfidenceReasons - reasons the alert got the confidenceScore value
	ConfidenceReasons *[]AlertConfidenceReason `json:"confidenceReasons,omitempty"`
	// SubscriptionID - READ-ONLY; Azure subscription ID of the resource that had the security alert or the subscription ID of the workspace that this resource reports to
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// InstanceID - READ-ONLY; Instance ID of the alert.
	InstanceID *string `json:"instanceId,omitempty"`
	// WorkspaceArmID - READ-ONLY; Azure resource ID of the workspace that the alert was reported to.
	WorkspaceArmID *string `json:"workspaceArmId,omitempty"`
	// CorrelationKey - READ-ONLY; Alerts with the same CorrelationKey will be grouped together in Ibiza.
	CorrelationKey *string `json:"correlationKey,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertProperties.
func (ap AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.ExtendedProperties != nil {
		objectMap["extendedProperties"] = ap.ExtendedProperties
	}
	if ap.Entities != nil {
		objectMap["entities"] = ap.Entities
	}
	if ap.ConfidenceReasons != nil {
		objectMap["confidenceReasons"] = ap.ConfidenceReasons
	}
	return json.Marshal(objectMap)
}

// AlertsSuppressionRule describes the suppression rule
type AlertsSuppressionRule struct {
	autorest.Response                `json:"-"`
	*AlertsSuppressionRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertsSuppressionRule.
func (asr AlertsSuppressionRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asr.AlertsSuppressionRuleProperties != nil {
		objectMap["properties"] = asr.AlertsSuppressionRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertsSuppressionRule struct.
func (asr *AlertsSuppressionRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertsSuppressionRuleProperties AlertsSuppressionRuleProperties
				err = json.Unmarshal(*v, &alertsSuppressionRuleProperties)
				if err != nil {
					return err
				}
				asr.AlertsSuppressionRuleProperties = &alertsSuppressionRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asr.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertsSuppressionRuleProperties describes AlertsSuppressionRule properties
type AlertsSuppressionRuleProperties struct {
	// AlertType - Type of the alert to automatically suppress. For all alert types, use '*'
	AlertType *string `json:"alertType,omitempty"`
	// LastModifiedUtc - READ-ONLY; The last time this rule was modified
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// ExpirationDateUtc - Expiration date of the rule, if value is not provided or provided as null this field will default to the maximum allowed expiration date.
	ExpirationDateUtc *date.Time `json:"expirationDateUtc,omitempty"`
	// Reason - The reason for dismissing the alert
	Reason *string `json:"reason,omitempty"`
	// State - Possible states of the rule. Possible values include: 'RuleStateEnabled', 'RuleStateDisabled', 'RuleStateExpired'
	State RuleState `json:"state,omitempty"`
	// Comment - Any comment regarding the rule
	Comment *string `json:"comment,omitempty"`
	// SuppressionAlertsScope - The suppression conditions
	SuppressionAlertsScope *SuppressionAlertsScope `json:"suppressionAlertsScope,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertsSuppressionRuleProperties.
func (asrp AlertsSuppressionRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asrp.AlertType != nil {
		objectMap["alertType"] = asrp.AlertType
	}
	if asrp.ExpirationDateUtc != nil {
		objectMap["expirationDateUtc"] = asrp.ExpirationDateUtc
	}
	if asrp.Reason != nil {
		objectMap["reason"] = asrp.Reason
	}
	if asrp.State != "" {
		objectMap["state"] = asrp.State
	}
	if asrp.Comment != nil {
		objectMap["comment"] = asrp.Comment
	}
	if asrp.SuppressionAlertsScope != nil {
		objectMap["suppressionAlertsScope"] = asrp.SuppressionAlertsScope
	}
	return json.Marshal(objectMap)
}

// AlertsSuppressionRulesList suppression rules list for subscription.
type AlertsSuppressionRulesList struct {
	autorest.Response `json:"-"`
	Value             *[]AlertsSuppressionRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertsSuppressionRulesList.
func (asrl AlertsSuppressionRulesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asrl.Value != nil {
		objectMap["value"] = asrl.Value
	}
	return json.Marshal(objectMap)
}

// AlertsSuppressionRulesListIterator provides access to a complete listing of AlertsSuppressionRule
// values.
type AlertsSuppressionRulesListIterator struct {
	i    int
	page AlertsSuppressionRulesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertsSuppressionRulesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsSuppressionRulesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertsSuppressionRulesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertsSuppressionRulesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertsSuppressionRulesListIterator) Response() AlertsSuppressionRulesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertsSuppressionRulesListIterator) Value() AlertsSuppressionRule {
	if !iter.page.NotDone() {
		return AlertsSuppressionRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertsSuppressionRulesListIterator type.
func NewAlertsSuppressionRulesListIterator(page AlertsSuppressionRulesListPage) AlertsSuppressionRulesListIterator {
	return AlertsSuppressionRulesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asrl AlertsSuppressionRulesList) IsEmpty() bool {
	return asrl.Value == nil || len(*asrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (asrl AlertsSuppressionRulesList) hasNextLink() bool {
	return asrl.NextLink != nil && len(*asrl.NextLink) != 0
}

// alertsSuppressionRulesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asrl AlertsSuppressionRulesList) alertsSuppressionRulesListPreparer(ctx context.Context) (*http.Request, error) {
	if !asrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asrl.NextLink)))
}

// AlertsSuppressionRulesListPage contains a page of AlertsSuppressionRule values.
type AlertsSuppressionRulesListPage struct {
	fn   func(context.Context, AlertsSuppressionRulesList) (AlertsSuppressionRulesList, error)
	asrl AlertsSuppressionRulesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertsSuppressionRulesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsSuppressionRulesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.asrl)
		if err != nil {
			return err
		}
		page.asrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertsSuppressionRulesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertsSuppressionRulesListPage) NotDone() bool {
	return !page.asrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertsSuppressionRulesListPage) Response() AlertsSuppressionRulesList {
	return page.asrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertsSuppressionRulesListPage) Values() []AlertsSuppressionRule {
	if page.asrl.IsEmpty() {
		return nil
	}
	return *page.asrl.Value
}

// Creates a new instance of the AlertsSuppressionRulesListPage type.
func NewAlertsSuppressionRulesListPage(cur AlertsSuppressionRulesList, getNextPage func(context.Context, AlertsSuppressionRulesList) (AlertsSuppressionRulesList, error)) AlertsSuppressionRulesListPage {
	return AlertsSuppressionRulesListPage{
		fn:   getNextPage,
		asrl: cur,
	}
}

// AllowedConnectionsList list of all possible traffic between Azure resources
type AllowedConnectionsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]AllowedConnectionsResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AllowedConnectionsList.
func (ACL AllowedConnectionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AllowedConnectionsListIterator provides access to a complete listing of AllowedConnectionsResource
// values.
type AllowedConnectionsListIterator struct {
	i    int
	page AllowedConnectionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AllowedConnectionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AllowedConnectionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AllowedConnectionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AllowedConnectionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AllowedConnectionsListIterator) Response() AllowedConnectionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AllowedConnectionsListIterator) Value() AllowedConnectionsResource {
	if !iter.page.NotDone() {
		return AllowedConnectionsResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AllowedConnectionsListIterator type.
func NewAllowedConnectionsListIterator(page AllowedConnectionsListPage) AllowedConnectionsListIterator {
	return AllowedConnectionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ACL AllowedConnectionsList) IsEmpty() bool {
	return ACL.Value == nil || len(*ACL.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ACL AllowedConnectionsList) hasNextLink() bool {
	return ACL.NextLink != nil && len(*ACL.NextLink) != 0
}

// allowedConnectionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ACL AllowedConnectionsList) allowedConnectionsListPreparer(ctx context.Context) (*http.Request, error) {
	if !ACL.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ACL.NextLink)))
}

// AllowedConnectionsListPage contains a page of AllowedConnectionsResource values.
type AllowedConnectionsListPage struct {
	fn  func(context.Context, AllowedConnectionsList) (AllowedConnectionsList, error)
	ACL AllowedConnectionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AllowedConnectionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AllowedConnectionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ACL)
		if err != nil {
			return err
		}
		page.ACL = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AllowedConnectionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AllowedConnectionsListPage) NotDone() bool {
	return !page.ACL.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AllowedConnectionsListPage) Response() AllowedConnectionsList {
	return page.ACL
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AllowedConnectionsListPage) Values() []AllowedConnectionsResource {
	if page.ACL.IsEmpty() {
		return nil
	}
	return *page.ACL.Value
}

// Creates a new instance of the AllowedConnectionsListPage type.
func NewAllowedConnectionsListPage(cur AllowedConnectionsList, getNextPage func(context.Context, AllowedConnectionsList) (AllowedConnectionsList, error)) AllowedConnectionsListPage {
	return AllowedConnectionsListPage{
		fn:  getNextPage,
		ACL: cur,
	}
}

// AllowedConnectionsResource the resource whose properties describes the allowed traffic between Azure
// resources
type AllowedConnectionsResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// AllowedConnectionsResourceProperties - READ-ONLY
	*AllowedConnectionsResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AllowedConnectionsResource.
func (acr AllowedConnectionsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AllowedConnectionsResource struct.
func (acr *AllowedConnectionsResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				acr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				acr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				acr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				acr.Location = &location
			}
		case "properties":
			if v != nil {
				var allowedConnectionsResourceProperties AllowedConnectionsResourceProperties
				err = json.Unmarshal(*v, &allowedConnectionsResourceProperties)
				if err != nil {
					return err
				}
				acr.AllowedConnectionsResourceProperties = &allowedConnectionsResourceProperties
			}
		}
	}

	return nil
}

// AllowedConnectionsResourceProperties describes the allowed traffic between Azure resources
type AllowedConnectionsResourceProperties struct {
	// CalculatedDateTime - READ-ONLY; The UTC time on which the allowed connections resource was calculated
	CalculatedDateTime *date.Time `json:"calculatedDateTime,omitempty"`
	// ConnectableResources - READ-ONLY; List of connectable resources
	ConnectableResources *[]ConnectableResource `json:"connectableResources,omitempty"`
}

// MarshalJSON is the custom marshaler for AllowedConnectionsResourceProperties.
func (acrp AllowedConnectionsResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BasicAllowlistCustomAlertRule a custom alert rule that checks if a value (depends on the custom alert type) is
// allowed.
type BasicAllowlistCustomAlertRule interface {
	AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool)
	AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool)
	AsProcessNotAllowed() (*ProcessNotAllowed, bool)
	AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool)
}

// AllowlistCustomAlertRule a custom alert rule that checks if a value (depends on the custom alert type) is
// allowed.
type AllowlistCustomAlertRule struct {
	// AllowlistValues - The values to allow. The format of the values depends on the rule type.
	AllowlistValues *[]string `json:"allowlistValues,omitempty"`
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

func unmarshalBasicAllowlistCustomAlertRule(body []byte) (BasicAllowlistCustomAlertRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleType"] {
	case string(RuleTypeConnectionToIPNotAllowed):
		var ctina ConnectionToIPNotAllowed
		err := json.Unmarshal(body, &ctina)
		return ctina, err
	case string(RuleTypeLocalUserNotAllowed):
		var luna LocalUserNotAllowed
		err := json.Unmarshal(body, &luna)
		return luna, err
	case string(RuleTypeProcessNotAllowed):
		var pna ProcessNotAllowed
		err := json.Unmarshal(body, &pna)
		return pna, err
	default:
		var acar AllowlistCustomAlertRule
		err := json.Unmarshal(body, &acar)
		return acar, err
	}
}
func unmarshalBasicAllowlistCustomAlertRuleArray(body []byte) ([]BasicAllowlistCustomAlertRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	acarArray := make([]BasicAllowlistCustomAlertRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		acar, err := unmarshalBasicAllowlistCustomAlertRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		acarArray[index] = acar
	}
	return acarArray, nil
}

// MarshalJSON is the custom marshaler for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) MarshalJSON() ([]byte, error) {
	acar.RuleType = RuleTypeAllowlistCustomAlertRule
	objectMap := make(map[string]interface{})
	if acar.AllowlistValues != nil {
		objectMap["allowlistValues"] = acar.AllowlistValues
	}
	if acar.IsEnabled != nil {
		objectMap["isEnabled"] = acar.IsEnabled
	}
	if acar.RuleType != "" {
		objectMap["ruleType"] = acar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return &acar, true
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return &acar, true
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return &acar, true
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &acar, true
}

// AmqpC2DMessagesNotInAllowedRange number of cloud to device messages (AMQP protocol) is not in allowed
// range.
type AmqpC2DMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	acmniar.RuleType = RuleTypeAmqpC2DMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if acmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = acmniar.TimeWindowSize
	}
	if acmniar.MinThreshold != nil {
		objectMap["minThreshold"] = acmniar.MinThreshold
	}
	if acmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = acmniar.MaxThreshold
	}
	if acmniar.IsEnabled != nil {
		objectMap["isEnabled"] = acmniar.IsEnabled
	}
	if acmniar.RuleType != "" {
		objectMap["ruleType"] = acmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &acmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &acmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return &acmniar, true
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &acmniar, true
}

// AmqpC2DRejectedMessagesNotInAllowedRange number of rejected cloud to device messages (AMQP protocol) is
// not in allowed range.
type AmqpC2DRejectedMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	acrmniar.RuleType = RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if acrmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = acrmniar.TimeWindowSize
	}
	if acrmniar.MinThreshold != nil {
		objectMap["minThreshold"] = acrmniar.MinThreshold
	}
	if acrmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = acrmniar.MaxThreshold
	}
	if acrmniar.IsEnabled != nil {
		objectMap["isEnabled"] = acrmniar.IsEnabled
	}
	if acrmniar.RuleType != "" {
		objectMap["ruleType"] = acrmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &acrmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &acrmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return &acrmniar, true
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &acrmniar, true
}

// AmqpD2CMessagesNotInAllowedRange number of device to cloud messages (AMQP protocol) is not in allowed
// range.
type AmqpD2CMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	admniar.RuleType = RuleTypeAmqpD2CMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if admniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = admniar.TimeWindowSize
	}
	if admniar.MinThreshold != nil {
		objectMap["minThreshold"] = admniar.MinThreshold
	}
	if admniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = admniar.MaxThreshold
	}
	if admniar.IsEnabled != nil {
		objectMap["isEnabled"] = admniar.IsEnabled
	}
	if admniar.RuleType != "" {
		objectMap["ruleType"] = admniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &admniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &admniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return &admniar, true
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &admniar, true
}

// AppWhitelistingGroup ...
type AppWhitelistingGroup struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location                  *string `json:"location,omitempty"`
	*AppWhitelistingGroupData `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AppWhitelistingGroup.
func (awg AppWhitelistingGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if awg.AppWhitelistingGroupData != nil {
		objectMap["properties"] = awg.AppWhitelistingGroupData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppWhitelistingGroup struct.
func (awg *AppWhitelistingGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				awg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				awg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				awg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				awg.Location = &location
			}
		case "properties":
			if v != nil {
				var appWhitelistingGroupData AppWhitelistingGroupData
				err = json.Unmarshal(*v, &appWhitelistingGroupData)
				if err != nil {
					return err
				}
				awg.AppWhitelistingGroupData = &appWhitelistingGroupData
			}
		}
	}

	return nil
}

// AppWhitelistingGroupData represents a VM/server group and set of rules that are Recommended by Azure
// Security Center to be allowed
type AppWhitelistingGroupData struct {
	// EnforcementMode - Possible values include: 'Audit', 'Enforce', 'None'
	EnforcementMode EnforcementMode `json:"enforcementMode,omitempty"`
	ProtectionMode  *ProtectionMode `json:"protectionMode,omitempty"`
	// ConfigurationStatus - Possible values include: 'ConfigurationStatus2Configured', 'ConfigurationStatus2NotConfigured', 'ConfigurationStatus2InProgress', 'ConfigurationStatus2Failed', 'ConfigurationStatus2NoStatus'
	ConfigurationStatus ConfigurationStatus2 `json:"configurationStatus,omitempty"`
	// RecommendationStatus - Possible values include: 'RecommendationStatusRecommended', 'RecommendationStatusNotRecommended', 'RecommendationStatusNotAvailable', 'RecommendationStatusNoStatus'
	RecommendationStatus RecommendationStatus           `json:"recommendationStatus,omitempty"`
	Issues               *[]AppWhitelistingIssueSummary `json:"issues,omitempty"`
	// SourceSystem - Possible values include: 'SourceSystemAzureAppLocker', 'SourceSystemAzureAuditD', 'SourceSystemNonAzureAppLocker', 'SourceSystemNonAzureAuditD', 'SourceSystemNone'
	SourceSystem        SourceSystem          `json:"sourceSystem,omitempty"`
	VMRecommendations   *[]VMRecommendation   `json:"vmRecommendations,omitempty"`
	PathRecommendations *[]PathRecommendation `json:"pathRecommendations,omitempty"`
}

// AppWhitelistingGroups represents a list of VM/server groups and set of rules that are Recommended by
// Azure Security Center to be allowed
type AppWhitelistingGroups struct {
	autorest.Response `json:"-"`
	Value             *[]AppWhitelistingGroup `json:"value,omitempty"`
}

// AppWhitelistingIssueSummary represents a summary of the alerts of the VM/server group
type AppWhitelistingIssueSummary struct {
	// Issue - Possible values include: 'ViolationsAudited', 'ViolationsBlocked', 'MsiAndScriptViolationsAudited', 'MsiAndScriptViolationsBlocked', 'ExecutableViolationsAudited', 'RulesViolatedManually'
	Issue Issue `json:"issue,omitempty"`
	// NumberOfVms - The number of machines in the VM/server group that have this alert
	NumberOfVms *float64 `json:"numberOfVms,omitempty"`
}

// AppWhitelistingPutGroupData the altered data of the recommended VM/server group policy
type AppWhitelistingPutGroupData struct {
	// EnforcementMode - The enforcement mode of the group. Can also be defined per collection type by using ProtectionMode. Possible values include: 'EnforcementMode1Audit', 'EnforcementMode1Enforce', 'EnforcementMode1None'
	EnforcementMode EnforcementMode1 `json:"enforcementMode,omitempty"`
	// ProtectionMode - The protection mode of the group per collection type. Can also be defined for all collection types by using EnforcementMode
	ProtectionMode      *ProtectionMode       `json:"protectionMode,omitempty"`
	VMRecommendations   *[]VMRecommendation   `json:"vmRecommendations,omitempty"`
	PathRecommendations *[]PathRecommendation `json:"pathRecommendations,omitempty"`
}

// AscLocation the ASC location of the subscription is in the "name" field
type AscLocation struct {
	autorest.Response `json:"-"`
	Properties        interface{} `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AscLocation.
func (al AscLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if al.Properties != nil {
		objectMap["properties"] = al.Properties
	}
	return json.Marshal(objectMap)
}

// AscLocationList list of locations where ASC saves your data
type AscLocationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]AscLocation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AscLocationList.
func (all AscLocationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AscLocationListIterator provides access to a complete listing of AscLocation values.
type AscLocationListIterator struct {
	i    int
	page AscLocationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AscLocationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AscLocationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AscLocationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AscLocationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AscLocationListIterator) Response() AscLocationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AscLocationListIterator) Value() AscLocation {
	if !iter.page.NotDone() {
		return AscLocation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AscLocationListIterator type.
func NewAscLocationListIterator(page AscLocationListPage) AscLocationListIterator {
	return AscLocationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (all AscLocationList) IsEmpty() bool {
	return all.Value == nil || len(*all.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (all AscLocationList) hasNextLink() bool {
	return all.NextLink != nil && len(*all.NextLink) != 0
}

// ascLocationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (all AscLocationList) ascLocationListPreparer(ctx context.Context) (*http.Request, error) {
	if !all.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(all.NextLink)))
}

// AscLocationListPage contains a page of AscLocation values.
type AscLocationListPage struct {
	fn  func(context.Context, AscLocationList) (AscLocationList, error)
	all AscLocationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AscLocationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AscLocationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.all)
		if err != nil {
			return err
		}
		page.all = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AscLocationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AscLocationListPage) NotDone() bool {
	return !page.all.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AscLocationListPage) Response() AscLocationList {
	return page.all
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AscLocationListPage) Values() []AscLocation {
	if page.all.IsEmpty() {
		return nil
	}
	return *page.all.Value
}

// Creates a new instance of the AscLocationListPage type.
func NewAscLocationListPage(cur AscLocationList, getNextPage func(context.Context, AscLocationList) (AscLocationList, error)) AscLocationListPage {
	return AscLocationListPage{
		fn:  getNextPage,
		all: cur,
	}
}

// AtaExternalSecuritySolution represents an ATA security solution which sends logs to an OMS workspace
type AtaExternalSecuritySolution struct {
	Properties *AtaSolutionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	aess.Kind = KindATA
	objectMap := make(map[string]interface{})
	if aess.Properties != nil {
		objectMap["properties"] = aess.Properties
	}
	if aess.Kind != "" {
		objectMap["kind"] = aess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return nil, false
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return &aess, true
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return nil, false
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return nil, false
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &aess, true
}

// AtaSolutionProperties ...
type AtaSolutionProperties struct {
	LastEventReceived *string `json:"lastEventReceived,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	DeviceVendor         *string                `json:"deviceVendor,omitempty"`
	DeviceType           *string                `json:"deviceType,omitempty"`
	Workspace            *ConnectedWorkspace    `json:"workspace,omitempty"`
}

// MarshalJSON is the custom marshaler for AtaSolutionProperties.
func (asp AtaSolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asp.LastEventReceived != nil {
		objectMap["lastEventReceived"] = asp.LastEventReceived
	}
	if asp.DeviceVendor != nil {
		objectMap["deviceVendor"] = asp.DeviceVendor
	}
	if asp.DeviceType != nil {
		objectMap["deviceType"] = asp.DeviceType
	}
	if asp.Workspace != nil {
		objectMap["workspace"] = asp.Workspace
	}
	for k, v := range asp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AtaSolutionProperties struct.
func (asp *AtaSolutionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "lastEventReceived":
			if v != nil {
				var lastEventReceived string
				err = json.Unmarshal(*v, &lastEventReceived)
				if err != nil {
					return err
				}
				asp.LastEventReceived = &lastEventReceived
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asp.AdditionalProperties == nil {
					asp.AdditionalProperties = make(map[string]interface{})
				}
				asp.AdditionalProperties[k] = additionalProperties
			}
		case "deviceVendor":
			if v != nil {
				var deviceVendor string
				err = json.Unmarshal(*v, &deviceVendor)
				if err != nil {
					return err
				}
				asp.DeviceVendor = &deviceVendor
			}
		case "deviceType":
			if v != nil {
				var deviceType string
				err = json.Unmarshal(*v, &deviceType)
				if err != nil {
					return err
				}
				asp.DeviceType = &deviceType
			}
		case "workspace":
			if v != nil {
				var workspace ConnectedWorkspace
				err = json.Unmarshal(*v, &workspace)
				if err != nil {
					return err
				}
				asp.Workspace = &workspace
			}
		}
	}

	return nil
}

// BasicAuthenticationDetailsProperties settings for cloud authentication management
type BasicAuthenticationDetailsProperties interface {
	AsAwsCredsAuthenticationDetailsProperties() (*AwsCredsAuthenticationDetailsProperties, bool)
	AsAwAssumeRoleAuthenticationDetailsProperties() (*AwAssumeRoleAuthenticationDetailsProperties, bool)
	AsGcpCredentialsDetailsProperties() (*GcpCredentialsDetailsProperties, bool)
	AsAuthenticationDetailsProperties() (*AuthenticationDetailsProperties, bool)
}

// AuthenticationDetailsProperties settings for cloud authentication management
type AuthenticationDetailsProperties struct {
	// AuthenticationProvisioningState - READ-ONLY; State of the multi-cloud connector. Possible values include: 'Valid', 'Invalid', 'Expired', 'IncorrectPolicy'
	AuthenticationProvisioningState AuthenticationProvisioningState `json:"authenticationProvisioningState,omitempty"`
	// GrantedPermissions - READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions *[]PermissionProperty `json:"grantedPermissions,omitempty"`
	// AuthenticationType - Possible values include: 'AuthenticationTypeAuthenticationDetailsProperties', 'AuthenticationTypeAwsCreds', 'AuthenticationTypeAwsAssumeRole', 'AuthenticationTypeGcpCredentials'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

func unmarshalBasicAuthenticationDetailsProperties(body []byte) (BasicAuthenticationDetailsProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["authenticationType"] {
	case string(AuthenticationTypeAwsCreds):
		var acadp AwsCredsAuthenticationDetailsProperties
		err := json.Unmarshal(body, &acadp)
		return acadp, err
	case string(AuthenticationTypeAwsAssumeRole):
		var aaradp AwAssumeRoleAuthenticationDetailsProperties
		err := json.Unmarshal(body, &aaradp)
		return aaradp, err
	case string(AuthenticationTypeGcpCredentials):
		var gcdp GcpCredentialsDetailsProperties
		err := json.Unmarshal(body, &gcdp)
		return gcdp, err
	default:
		var adp AuthenticationDetailsProperties
		err := json.Unmarshal(body, &adp)
		return adp, err
	}
}
func unmarshalBasicAuthenticationDetailsPropertiesArray(body []byte) ([]BasicAuthenticationDetailsProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	adpArray := make([]BasicAuthenticationDetailsProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		adp, err := unmarshalBasicAuthenticationDetailsProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		adpArray[index] = adp
	}
	return adpArray, nil
}

// MarshalJSON is the custom marshaler for AuthenticationDetailsProperties.
func (adp AuthenticationDetailsProperties) MarshalJSON() ([]byte, error) {
	adp.AuthenticationType = AuthenticationTypeAuthenticationDetailsProperties
	objectMap := make(map[string]interface{})
	if adp.AuthenticationType != "" {
		objectMap["authenticationType"] = adp.AuthenticationType
	}
	return json.Marshal(objectMap)
}

// AsAwsCredsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AuthenticationDetailsProperties.
func (adp AuthenticationDetailsProperties) AsAwsCredsAuthenticationDetailsProperties() (*AwsCredsAuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsAwAssumeRoleAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AuthenticationDetailsProperties.
func (adp AuthenticationDetailsProperties) AsAwAssumeRoleAuthenticationDetailsProperties() (*AwAssumeRoleAuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsGcpCredentialsDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AuthenticationDetailsProperties.
func (adp AuthenticationDetailsProperties) AsGcpCredentialsDetailsProperties() (*GcpCredentialsDetailsProperties, bool) {
	return nil, false
}

// AsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AuthenticationDetailsProperties.
func (adp AuthenticationDetailsProperties) AsAuthenticationDetailsProperties() (*AuthenticationDetailsProperties, bool) {
	return &adp, true
}

// AsBasicAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AuthenticationDetailsProperties.
func (adp AuthenticationDetailsProperties) AsBasicAuthenticationDetailsProperties() (BasicAuthenticationDetailsProperties, bool) {
	return &adp, true
}

// Automation the security automation resource.
type Automation struct {
	autorest.Response `json:"-"`
	// AutomationProperties - Security automation data
	*AutomationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Kind of the resource
	Kind *string `json:"kind,omitempty"`
	// Etag - Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string `json:"etag,omitempty"`
	// Tags - A list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Automation.
func (a Automation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AutomationProperties != nil {
		objectMap["properties"] = a.AutomationProperties
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	if a.Kind != nil {
		objectMap["kind"] = a.Kind
	}
	if a.Etag != nil {
		objectMap["etag"] = a.Etag
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Automation struct.
func (a *Automation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var automationProperties AutomationProperties
				err = json.Unmarshal(*v, &automationProperties)
				if err != nil {
					return err
				}
				a.AutomationProperties = &automationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				a.Kind = &kind
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				a.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		}
	}

	return nil
}

// BasicAutomationAction the action that should be triggered.
type BasicAutomationAction interface {
	AsAutomationActionLogicApp() (*AutomationActionLogicApp, bool)
	AsAutomationActionEventHub() (*AutomationActionEventHub, bool)
	AsAutomationActionWorkspace() (*AutomationActionWorkspace, bool)
	AsAutomationAction() (*AutomationAction, bool)
}

// AutomationAction the action that should be triggered.
type AutomationAction struct {
	// ActionType - Possible values include: 'ActionTypeAutomationAction', 'ActionTypeLogicApp', 'ActionTypeEventHub', 'ActionTypeWorkspace'
	ActionType ActionType `json:"actionType,omitempty"`
}

func unmarshalBasicAutomationAction(body []byte) (BasicAutomationAction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["actionType"] {
	case string(ActionTypeLogicApp):
		var aala AutomationActionLogicApp
		err := json.Unmarshal(body, &aala)
		return aala, err
	case string(ActionTypeEventHub):
		var aaeh AutomationActionEventHub
		err := json.Unmarshal(body, &aaeh)
		return aaeh, err
	case string(ActionTypeWorkspace):
		var aaw AutomationActionWorkspace
		err := json.Unmarshal(body, &aaw)
		return aaw, err
	default:
		var aa AutomationAction
		err := json.Unmarshal(body, &aa)
		return aa, err
	}
}
func unmarshalBasicAutomationActionArray(body []byte) ([]BasicAutomationAction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aaArray := make([]BasicAutomationAction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		aa, err := unmarshalBasicAutomationAction(*rawMessage)
		if err != nil {
			return nil, err
		}
		aaArray[index] = aa
	}
	return aaArray, nil
}

// MarshalJSON is the custom marshaler for AutomationAction.
func (aa AutomationAction) MarshalJSON() ([]byte, error) {
	aa.ActionType = ActionTypeAutomationAction
	objectMap := make(map[string]interface{})
	if aa.ActionType != "" {
		objectMap["actionType"] = aa.ActionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationActionLogicApp is the BasicAutomationAction implementation for AutomationAction.
func (aa AutomationAction) AsAutomationActionLogicApp() (*AutomationActionLogicApp, bool) {
	return nil, false
}

// AsAutomationActionEventHub is the BasicAutomationAction implementation for AutomationAction.
func (aa AutomationAction) AsAutomationActionEventHub() (*AutomationActionEventHub, bool) {
	return nil, false
}

// AsAutomationActionWorkspace is the BasicAutomationAction implementation for AutomationAction.
func (aa AutomationAction) AsAutomationActionWorkspace() (*AutomationActionWorkspace, bool) {
	return nil, false
}

// AsAutomationAction is the BasicAutomationAction implementation for AutomationAction.
func (aa AutomationAction) AsAutomationAction() (*AutomationAction, bool) {
	return &aa, true
}

// AsBasicAutomationAction is the BasicAutomationAction implementation for AutomationAction.
func (aa AutomationAction) AsBasicAutomationAction() (BasicAutomationAction, bool) {
	return &aa, true
}

// AutomationActionEventHub the target Event Hub to which event data will be exported. To learn more about
// Security Center continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
type AutomationActionEventHub struct {
	// EventHubResourceID - The target Event Hub Azure Resource ID.
	EventHubResourceID *string `json:"eventHubResourceId,omitempty"`
	// SasPolicyName - READ-ONLY; The target Event Hub SAS policy name.
	SasPolicyName *string `json:"sasPolicyName,omitempty"`
	// ConnectionString - The target Event Hub connection string (it will not be included in any response).
	ConnectionString *string `json:"connectionString,omitempty"`
	// ActionType - Possible values include: 'ActionTypeAutomationAction', 'ActionTypeLogicApp', 'ActionTypeEventHub', 'ActionTypeWorkspace'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) MarshalJSON() ([]byte, error) {
	aaeh.ActionType = ActionTypeEventHub
	objectMap := make(map[string]interface{})
	if aaeh.EventHubResourceID != nil {
		objectMap["eventHubResourceId"] = aaeh.EventHubResourceID
	}
	if aaeh.ConnectionString != nil {
		objectMap["connectionString"] = aaeh.ConnectionString
	}
	if aaeh.ActionType != "" {
		objectMap["actionType"] = aaeh.ActionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationActionLogicApp is the BasicAutomationAction implementation for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) AsAutomationActionLogicApp() (*AutomationActionLogicApp, bool) {
	return nil, false
}

// AsAutomationActionEventHub is the BasicAutomationAction implementation for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) AsAutomationActionEventHub() (*AutomationActionEventHub, bool) {
	return &aaeh, true
}

// AsAutomationActionWorkspace is the BasicAutomationAction implementation for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) AsAutomationActionWorkspace() (*AutomationActionWorkspace, bool) {
	return nil, false
}

// AsAutomationAction is the BasicAutomationAction implementation for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) AsAutomationAction() (*AutomationAction, bool) {
	return nil, false
}

// AsBasicAutomationAction is the BasicAutomationAction implementation for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) AsBasicAutomationAction() (BasicAutomationAction, bool) {
	return &aaeh, true
}

// AutomationActionLogicApp the logic app action that should be triggered. To learn more about Security
// Center's Workflow Automation capabilities, visit https://aka.ms/ASCWorkflowAutomationLearnMore
type AutomationActionLogicApp struct {
	// LogicAppResourceID - The triggered Logic App Azure Resource ID. This can also reside on other subscriptions, given that you have permissions to trigger the Logic App
	LogicAppResourceID *string `json:"logicAppResourceId,omitempty"`
	// URI - The Logic App trigger URI endpoint (it will not be included in any response).
	URI *string `json:"uri,omitempty"`
	// ActionType - Possible values include: 'ActionTypeAutomationAction', 'ActionTypeLogicApp', 'ActionTypeEventHub', 'ActionTypeWorkspace'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) MarshalJSON() ([]byte, error) {
	aala.ActionType = ActionTypeLogicApp
	objectMap := make(map[string]interface{})
	if aala.LogicAppResourceID != nil {
		objectMap["logicAppResourceId"] = aala.LogicAppResourceID
	}
	if aala.URI != nil {
		objectMap["uri"] = aala.URI
	}
	if aala.ActionType != "" {
		objectMap["actionType"] = aala.ActionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationActionLogicApp is the BasicAutomationAction implementation for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) AsAutomationActionLogicApp() (*AutomationActionLogicApp, bool) {
	return &aala, true
}

// AsAutomationActionEventHub is the BasicAutomationAction implementation for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) AsAutomationActionEventHub() (*AutomationActionEventHub, bool) {
	return nil, false
}

// AsAutomationActionWorkspace is the BasicAutomationAction implementation for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) AsAutomationActionWorkspace() (*AutomationActionWorkspace, bool) {
	return nil, false
}

// AsAutomationAction is the BasicAutomationAction implementation for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) AsAutomationAction() (*AutomationAction, bool) {
	return nil, false
}

// AsBasicAutomationAction is the BasicAutomationAction implementation for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) AsBasicAutomationAction() (BasicAutomationAction, bool) {
	return &aala, true
}

// AutomationActionWorkspace the Log Analytics Workspace to which event data will be exported. Security
// alerts data will reside in the 'SecurityAlert' table and the assessments data will reside in the
// 'SecurityRecommendation' table (under the 'Security'/'SecurityCenterFree' solutions). Note that in order
// to view the data in the workspace, the Security Center Log Analytics free/standard solution needs to be
// enabled on that workspace. To learn more about Security Center continuous export capabilities, visit
// https://aka.ms/ASCExportLearnMore
type AutomationActionWorkspace struct {
	// WorkspaceResourceID - The fully qualified Log Analytics Workspace Azure Resource ID.
	WorkspaceResourceID *string `json:"workspaceResourceId,omitempty"`
	// ActionType - Possible values include: 'ActionTypeAutomationAction', 'ActionTypeLogicApp', 'ActionTypeEventHub', 'ActionTypeWorkspace'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) MarshalJSON() ([]byte, error) {
	aaw.ActionType = ActionTypeWorkspace
	objectMap := make(map[string]interface{})
	if aaw.WorkspaceResourceID != nil {
		objectMap["workspaceResourceId"] = aaw.WorkspaceResourceID
	}
	if aaw.ActionType != "" {
		objectMap["actionType"] = aaw.ActionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationActionLogicApp is the BasicAutomationAction implementation for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) AsAutomationActionLogicApp() (*AutomationActionLogicApp, bool) {
	return nil, false
}

// AsAutomationActionEventHub is the BasicAutomationAction implementation for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) AsAutomationActionEventHub() (*AutomationActionEventHub, bool) {
	return nil, false
}

// AsAutomationActionWorkspace is the BasicAutomationAction implementation for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) AsAutomationActionWorkspace() (*AutomationActionWorkspace, bool) {
	return &aaw, true
}

// AsAutomationAction is the BasicAutomationAction implementation for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) AsAutomationAction() (*AutomationAction, bool) {
	return nil, false
}

// AsBasicAutomationAction is the BasicAutomationAction implementation for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) AsBasicAutomationAction() (BasicAutomationAction, bool) {
	return &aaw, true
}

// AutomationList list of security automations response.
type AutomationList struct {
	autorest.Response `json:"-"`
	// Value - The list of security automations under the given scope.
	Value *[]Automation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationList.
func (al AutomationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if al.Value != nil {
		objectMap["value"] = al.Value
	}
	return json.Marshal(objectMap)
}

// AutomationListIterator provides access to a complete listing of Automation values.
type AutomationListIterator struct {
	i    int
	page AutomationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AutomationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutomationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AutomationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AutomationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AutomationListIterator) Response() AutomationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AutomationListIterator) Value() Automation {
	if !iter.page.NotDone() {
		return Automation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AutomationListIterator type.
func NewAutomationListIterator(page AutomationListPage) AutomationListIterator {
	return AutomationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AutomationList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al AutomationList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// automationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AutomationList) automationListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AutomationListPage contains a page of Automation values.
type AutomationListPage struct {
	fn func(context.Context, AutomationList) (AutomationList, error)
	al AutomationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AutomationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutomationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AutomationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AutomationListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AutomationListPage) Response() AutomationList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AutomationListPage) Values() []Automation {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AutomationListPage type.
func NewAutomationListPage(cur AutomationList, getNextPage func(context.Context, AutomationList) (AutomationList, error)) AutomationListPage {
	return AutomationListPage{
		fn: getNextPage,
		al: cur,
	}
}

// AutomationProperties a set of properties that defines the behavior of the automation configuration. To
// learn more about the supported security events data models schemas - please visit
// https://aka.ms/ASCAutomationSchemas.
type AutomationProperties struct {
	// Description - The security automation description.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Indicates whether the security automation is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// Scopes - A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself or a resource group under that subscription. The automation will only apply on defined scopes.
	Scopes *[]AutomationScope `json:"scopes,omitempty"`
	// Sources - A collection of the source event types which evaluate the security automation set of rules.
	Sources *[]AutomationSource `json:"sources,omitempty"`
	// Actions - A collection of the actions which are triggered if all the configured rules evaluations, within at least one rule set, are true.
	Actions *[]BasicAutomationAction `json:"actions,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AutomationProperties struct.
func (ap *AutomationProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ap.Description = &description
			}
		case "isEnabled":
			if v != nil {
				var isEnabled bool
				err = json.Unmarshal(*v, &isEnabled)
				if err != nil {
					return err
				}
				ap.IsEnabled = &isEnabled
			}
		case "scopes":
			if v != nil {
				var scopes []AutomationScope
				err = json.Unmarshal(*v, &scopes)
				if err != nil {
					return err
				}
				ap.Scopes = &scopes
			}
		case "sources":
			if v != nil {
				var sources []AutomationSource
				err = json.Unmarshal(*v, &sources)
				if err != nil {
					return err
				}
				ap.Sources = &sources
			}
		case "actions":
			if v != nil {
				actions, err := unmarshalBasicAutomationActionArray(*v)
				if err != nil {
					return err
				}
				ap.Actions = &actions
			}
		}
	}

	return nil
}

// AutomationRuleSet a rule set which evaluates all its rules upon an event interception. Only when all the
// included rules in the rule set will be evaluated as 'true', will the event trigger the defined actions.
type AutomationRuleSet struct {
	Rules *[]AutomationTriggeringRule `json:"rules,omitempty"`
}

// AutomationScope a single automation scope.
type AutomationScope struct {
	// Description - The resources scope description.
	Description *string `json:"description,omitempty"`
	// ScopePath - The resources scope path. Can be the subscription on which the automation is defined on or a resource group under that subscription (fully qualified Azure resource IDs).
	ScopePath *string `json:"scopePath,omitempty"`
}

// AutomationSource the source event types which evaluate the security automation set of rules. For example
// - security alerts and security assessments. To learn more about the supported security events data
// models schemas - please visit https://aka.ms/ASCAutomationSchemas.
type AutomationSource struct {
	// EventSource - A valid event source type. Possible values include: 'Assessments', 'SubAssessments', 'Alerts', 'SecureScores', 'SecureScoreControls'
	EventSource EventSource `json:"eventSource,omitempty"`
	// RuleSets - A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
	RuleSets *[]AutomationRuleSet `json:"ruleSets,omitempty"`
}

// AutomationTriggeringRule a rule which is evaluated upon event interception. The rule is configured by
// comparing a specific value from the event model to an expected value. This comparison is done by using
// one of the supported operators set.
type AutomationTriggeringRule struct {
	// PropertyJPath - The JPath of the entity model property that should be checked.
	PropertyJPath *string `json:"propertyJPath,omitempty"`
	// PropertyType - The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]. Possible values include: 'String', 'Integer', 'Number', 'Boolean'
	PropertyType PropertyType `json:"propertyType,omitempty"`
	// ExpectedValue - The expected value.
	ExpectedValue *string `json:"expectedValue,omitempty"`
	// Operator - A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType. Possible values include: 'Equals', 'GreaterThan', 'GreaterThanOrEqualTo', 'LesserThan', 'LesserThanOrEqualTo', 'NotEquals', 'Contains', 'StartsWith', 'EndsWith'
	Operator Operator `json:"operator,omitempty"`
}

// AutomationValidationStatus the security automation model state property bag.
type AutomationValidationStatus struct {
	autorest.Response `json:"-"`
	// IsValid - Indicates whether the model is valid or not.
	IsValid *bool `json:"isValid,omitempty"`
	// Message - The validation message.
	Message *string `json:"message,omitempty"`
}

// AutoProvisioningSetting auto provisioning setting
type AutoProvisioningSetting struct {
	autorest.Response `json:"-"`
	// AutoProvisioningSettingProperties - Auto provisioning setting data
	*AutoProvisioningSettingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoProvisioningSetting.
func (aps AutoProvisioningSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aps.AutoProvisioningSettingProperties != nil {
		objectMap["properties"] = aps.AutoProvisioningSettingProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AutoProvisioningSetting struct.
func (aps *AutoProvisioningSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var autoProvisioningSettingProperties AutoProvisioningSettingProperties
				err = json.Unmarshal(*v, &autoProvisioningSettingProperties)
				if err != nil {
					return err
				}
				aps.AutoProvisioningSettingProperties = &autoProvisioningSettingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aps.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aps.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aps.Type = &typeVar
			}
		}
	}

	return nil
}

// AutoProvisioningSettingList list of all the auto provisioning settings response
type AutoProvisioningSettingList struct {
	autorest.Response `json:"-"`
	// Value - List of all the auto provisioning settings
	Value *[]AutoProvisioningSetting `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoProvisioningSettingList.
func (apsl AutoProvisioningSettingList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apsl.Value != nil {
		objectMap["value"] = apsl.Value
	}
	return json.Marshal(objectMap)
}

// AutoProvisioningSettingListIterator provides access to a complete listing of AutoProvisioningSetting
// values.
type AutoProvisioningSettingListIterator struct {
	i    int
	page AutoProvisioningSettingListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AutoProvisioningSettingListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoProvisioningSettingListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AutoProvisioningSettingListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AutoProvisioningSettingListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AutoProvisioningSettingListIterator) Response() AutoProvisioningSettingList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AutoProvisioningSettingListIterator) Value() AutoProvisioningSetting {
	if !iter.page.NotDone() {
		return AutoProvisioningSetting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AutoProvisioningSettingListIterator type.
func NewAutoProvisioningSettingListIterator(page AutoProvisioningSettingListPage) AutoProvisioningSettingListIterator {
	return AutoProvisioningSettingListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (apsl AutoProvisioningSettingList) IsEmpty() bool {
	return apsl.Value == nil || len(*apsl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (apsl AutoProvisioningSettingList) hasNextLink() bool {
	return apsl.NextLink != nil && len(*apsl.NextLink) != 0
}

// autoProvisioningSettingListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (apsl AutoProvisioningSettingList) autoProvisioningSettingListPreparer(ctx context.Context) (*http.Request, error) {
	if !apsl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(apsl.NextLink)))
}

// AutoProvisioningSettingListPage contains a page of AutoProvisioningSetting values.
type AutoProvisioningSettingListPage struct {
	fn   func(context.Context, AutoProvisioningSettingList) (AutoProvisioningSettingList, error)
	apsl AutoProvisioningSettingList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AutoProvisioningSettingListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoProvisioningSettingListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.apsl)
		if err != nil {
			return err
		}
		page.apsl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AutoProvisioningSettingListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AutoProvisioningSettingListPage) NotDone() bool {
	return !page.apsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AutoProvisioningSettingListPage) Response() AutoProvisioningSettingList {
	return page.apsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AutoProvisioningSettingListPage) Values() []AutoProvisioningSetting {
	if page.apsl.IsEmpty() {
		return nil
	}
	return *page.apsl.Value
}

// Creates a new instance of the AutoProvisioningSettingListPage type.
func NewAutoProvisioningSettingListPage(cur AutoProvisioningSettingList, getNextPage func(context.Context, AutoProvisioningSettingList) (AutoProvisioningSettingList, error)) AutoProvisioningSettingListPage {
	return AutoProvisioningSettingListPage{
		fn:   getNextPage,
		apsl: cur,
	}
}

// AutoProvisioningSettingProperties describes properties of an auto provisioning setting
type AutoProvisioningSettingProperties struct {
	// AutoProvision - Describes what kind of security agent provisioning action to take. Possible values include: 'AutoProvisionOn', 'AutoProvisionOff'
	AutoProvision AutoProvision `json:"autoProvision,omitempty"`
}

// AwAssumeRoleAuthenticationDetailsProperties AWS cloud account connector based assume role, the role
// enables delegating access to your AWS resources. The role is composed of role Amazon Resource Name (ARN)
// and external ID. For more details, refer to <a
// href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user.html">Creating a Role to
// Delegate Permissions to an IAM User (write only)</a>
type AwAssumeRoleAuthenticationDetailsProperties struct {
	// AccountID - READ-ONLY; The ID of the cloud account
	AccountID *string `json:"accountId,omitempty"`
	// AwsAssumeRoleArn - Assumed role ID is an identifier that you can use to create temporary security credentials.
	AwsAssumeRoleArn *string `json:"awsAssumeRoleArn,omitempty"`
	// AwsExternalID - A unique identifier that is required when you assume a role in another account.
	AwsExternalID *string `json:"awsExternalId,omitempty"`
	// AuthenticationProvisioningState - READ-ONLY; State of the multi-cloud connector. Possible values include: 'Valid', 'Invalid', 'Expired', 'IncorrectPolicy'
	AuthenticationProvisioningState AuthenticationProvisioningState `json:"authenticationProvisioningState,omitempty"`
	// GrantedPermissions - READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions *[]PermissionProperty `json:"grantedPermissions,omitempty"`
	// AuthenticationType - Possible values include: 'AuthenticationTypeAuthenticationDetailsProperties', 'AuthenticationTypeAwsCreds', 'AuthenticationTypeAwsAssumeRole', 'AuthenticationTypeGcpCredentials'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// MarshalJSON is the custom marshaler for AwAssumeRoleAuthenticationDetailsProperties.
func (aaradp AwAssumeRoleAuthenticationDetailsProperties) MarshalJSON() ([]byte, error) {
	aaradp.AuthenticationType = AuthenticationTypeAwsAssumeRole
	objectMap := make(map[string]interface{})
	if aaradp.AwsAssumeRoleArn != nil {
		objectMap["awsAssumeRoleArn"] = aaradp.AwsAssumeRoleArn
	}
	if aaradp.AwsExternalID != nil {
		objectMap["awsExternalId"] = aaradp.AwsExternalID
	}
	if aaradp.AuthenticationType != "" {
		objectMap["authenticationType"] = aaradp.AuthenticationType
	}
	return json.Marshal(objectMap)
}

// AsAwsCredsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwAssumeRoleAuthenticationDetailsProperties.
func (aaradp AwAssumeRoleAuthenticationDetailsProperties) AsAwsCredsAuthenticationDetailsProperties() (*AwsCredsAuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsAwAssumeRoleAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwAssumeRoleAuthenticationDetailsProperties.
func (aaradp AwAssumeRoleAuthenticationDetailsProperties) AsAwAssumeRoleAuthenticationDetailsProperties() (*AwAssumeRoleAuthenticationDetailsProperties, bool) {
	return &aaradp, true
}

// AsGcpCredentialsDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwAssumeRoleAuthenticationDetailsProperties.
func (aaradp AwAssumeRoleAuthenticationDetailsProperties) AsGcpCredentialsDetailsProperties() (*GcpCredentialsDetailsProperties, bool) {
	return nil, false
}

// AsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwAssumeRoleAuthenticationDetailsProperties.
func (aaradp AwAssumeRoleAuthenticationDetailsProperties) AsAuthenticationDetailsProperties() (*AuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsBasicAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwAssumeRoleAuthenticationDetailsProperties.
func (aaradp AwAssumeRoleAuthenticationDetailsProperties) AsBasicAuthenticationDetailsProperties() (BasicAuthenticationDetailsProperties, bool) {
	return &aaradp, true
}

// AwsCredsAuthenticationDetailsProperties AWS cloud account connector based credentials, the credentials
// is composed of access key ID and secret key, for more details, refer to <a
// href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_create.html">Creating an IAM User in
// Your AWS Account (write only)</a>
type AwsCredsAuthenticationDetailsProperties struct {
	// AccountID - READ-ONLY; The ID of the cloud account
	AccountID *string `json:"accountId,omitempty"`
	// AwsAccessKeyID - Public key element of the AWS credential object (write only)
	AwsAccessKeyID *string `json:"awsAccessKeyId,omitempty"`
	// AwsSecretAccessKey - Secret key element of the AWS credential object (write only)
	AwsSecretAccessKey *string `json:"awsSecretAccessKey,omitempty"`
	// AuthenticationProvisioningState - READ-ONLY; State of the multi-cloud connector. Possible values include: 'Valid', 'Invalid', 'Expired', 'IncorrectPolicy'
	AuthenticationProvisioningState AuthenticationProvisioningState `json:"authenticationProvisioningState,omitempty"`
	// GrantedPermissions - READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions *[]PermissionProperty `json:"grantedPermissions,omitempty"`
	// AuthenticationType - Possible values include: 'AuthenticationTypeAuthenticationDetailsProperties', 'AuthenticationTypeAwsCreds', 'AuthenticationTypeAwsAssumeRole', 'AuthenticationTypeGcpCredentials'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// MarshalJSON is the custom marshaler for AwsCredsAuthenticationDetailsProperties.
func (acadp AwsCredsAuthenticationDetailsProperties) MarshalJSON() ([]byte, error) {
	acadp.AuthenticationType = AuthenticationTypeAwsCreds
	objectMap := make(map[string]interface{})
	if acadp.AwsAccessKeyID != nil {
		objectMap["awsAccessKeyId"] = acadp.AwsAccessKeyID
	}
	if acadp.AwsSecretAccessKey != nil {
		objectMap["awsSecretAccessKey"] = acadp.AwsSecretAccessKey
	}
	if acadp.AuthenticationType != "" {
		objectMap["authenticationType"] = acadp.AuthenticationType
	}
	return json.Marshal(objectMap)
}

// AsAwsCredsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwsCredsAuthenticationDetailsProperties.
func (acadp AwsCredsAuthenticationDetailsProperties) AsAwsCredsAuthenticationDetailsProperties() (*AwsCredsAuthenticationDetailsProperties, bool) {
	return &acadp, true
}

// AsAwAssumeRoleAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwsCredsAuthenticationDetailsProperties.
func (acadp AwsCredsAuthenticationDetailsProperties) AsAwAssumeRoleAuthenticationDetailsProperties() (*AwAssumeRoleAuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsGcpCredentialsDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwsCredsAuthenticationDetailsProperties.
func (acadp AwsCredsAuthenticationDetailsProperties) AsGcpCredentialsDetailsProperties() (*GcpCredentialsDetailsProperties, bool) {
	return nil, false
}

// AsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwsCredsAuthenticationDetailsProperties.
func (acadp AwsCredsAuthenticationDetailsProperties) AsAuthenticationDetailsProperties() (*AuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsBasicAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwsCredsAuthenticationDetailsProperties.
func (acadp AwsCredsAuthenticationDetailsProperties) AsBasicAuthenticationDetailsProperties() (BasicAuthenticationDetailsProperties, bool) {
	return &acadp, true
}

// AzureResourceDetails details of the Azure resource that was assessed
type AzureResourceDetails struct {
	// ID - READ-ONLY; Azure resource Id of the assessed resource
	ID *string `json:"id,omitempty"`
	// Source - Possible values include: 'SourceResourceDetails', 'SourceOnPremiseSQL', 'SourceOnPremise', 'SourceAzure'
	Source Source `json:"source,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureResourceDetails.
func (ard AzureResourceDetails) MarshalJSON() ([]byte, error) {
	ard.Source = SourceAzure
	objectMap := make(map[string]interface{})
	if ard.Source != "" {
		objectMap["source"] = ard.Source
	}
	return json.Marshal(objectMap)
}

// AsOnPremiseSQLResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsOnPremiseSQLResourceDetails() (*OnPremiseSQLResourceDetails, bool) {
	return nil, false
}

// AsOnPremiseResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool) {
	return nil, false
}

// AsBasicOnPremiseResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsBasicOnPremiseResourceDetails() (BasicOnPremiseResourceDetails, bool) {
	return nil, false
}

// AsAzureResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsAzureResourceDetails() (*AzureResourceDetails, bool) {
	return &ard, true
}

// AsResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsResourceDetails() (*ResourceDetails, bool) {
	return nil, false
}

// AsBasicResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsBasicResourceDetails() (BasicResourceDetails, bool) {
	return &ard, true
}

// AzureResourceLink describes an Azure resource with kind
type AzureResourceLink struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureResourceLink.
func (arl AzureResourceLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureTrackedResourceLocation describes an Azure resource with location
type AzureTrackedResourceLocation struct {
	// Location - Location where the resource is stored
	Location *string `json:"location,omitempty"`
}

// Baseline baseline details.
type Baseline struct {
	// ExpectedResults - Expected results.
	ExpectedResults *[][]string `json:"expectedResults,omitempty"`
	// UpdatedTime - Baseline update time (UTC).
	UpdatedTime *date.Time `json:"updatedTime,omitempty"`
}

// BaselineAdjustedResult the rule result adjusted with baseline.
type BaselineAdjustedResult struct {
	Baseline *Baseline `json:"baseline,omitempty"`
	// Status - Possible values include: 'NonFinding', 'Finding', 'InternalError'
	Status RuleStatus `json:"status,omitempty"`
	// ResultsNotInBaseline - Results the are not in baseline.
	ResultsNotInBaseline *[][]string `json:"resultsNotInBaseline,omitempty"`
	// ResultsOnlyInBaseline - Results the are in baseline.
	ResultsOnlyInBaseline *[][]string `json:"resultsOnlyInBaseline,omitempty"`
}

// BenchmarkReference the benchmark references.
type BenchmarkReference struct {
	// Benchmark - The benchmark name.
	Benchmark *string `json:"benchmark,omitempty"`
	// Reference - The benchmark reference.
	Reference *string `json:"reference,omitempty"`
}

// CefExternalSecuritySolution represents a security solution which sends CEF logs to an OMS workspace
type CefExternalSecuritySolution struct {
	Properties *CefSolutionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	cess.Kind = KindCEF
	objectMap := make(map[string]interface{})
	if cess.Properties != nil {
		objectMap["properties"] = cess.Properties
	}
	if cess.Kind != "" {
		objectMap["kind"] = cess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return &cess, true
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return nil, false
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return nil, false
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return nil, false
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &cess, true
}

// CefSolutionProperties ...
type CefSolutionProperties struct {
	Hostname          *string `json:"hostname,omitempty"`
	Agent             *string `json:"agent,omitempty"`
	LastEventReceived *string `json:"lastEventReceived,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	DeviceVendor         *string                `json:"deviceVendor,omitempty"`
	DeviceType           *string                `json:"deviceType,omitempty"`
	Workspace            *ConnectedWorkspace    `json:"workspace,omitempty"`
}

// MarshalJSON is the custom marshaler for CefSolutionProperties.
func (csp CefSolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csp.Hostname != nil {
		objectMap["hostname"] = csp.Hostname
	}
	if csp.Agent != nil {
		objectMap["agent"] = csp.Agent
	}
	if csp.LastEventReceived != nil {
		objectMap["lastEventReceived"] = csp.LastEventReceived
	}
	if csp.DeviceVendor != nil {
		objectMap["deviceVendor"] = csp.DeviceVendor
	}
	if csp.DeviceType != nil {
		objectMap["deviceType"] = csp.DeviceType
	}
	if csp.Workspace != nil {
		objectMap["workspace"] = csp.Workspace
	}
	for k, v := range csp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CefSolutionProperties struct.
func (csp *CefSolutionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "hostname":
			if v != nil {
				var hostname string
				err = json.Unmarshal(*v, &hostname)
				if err != nil {
					return err
				}
				csp.Hostname = &hostname
			}
		case "agent":
			if v != nil {
				var agent string
				err = json.Unmarshal(*v, &agent)
				if err != nil {
					return err
				}
				csp.Agent = &agent
			}
		case "lastEventReceived":
			if v != nil {
				var lastEventReceived string
				err = json.Unmarshal(*v, &lastEventReceived)
				if err != nil {
					return err
				}
				csp.LastEventReceived = &lastEventReceived
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if csp.AdditionalProperties == nil {
					csp.AdditionalProperties = make(map[string]interface{})
				}
				csp.AdditionalProperties[k] = additionalProperties
			}
		case "deviceVendor":
			if v != nil {
				var deviceVendor string
				err = json.Unmarshal(*v, &deviceVendor)
				if err != nil {
					return err
				}
				csp.DeviceVendor = &deviceVendor
			}
		case "deviceType":
			if v != nil {
				var deviceType string
				err = json.Unmarshal(*v, &deviceType)
				if err != nil {
					return err
				}
				csp.DeviceType = &deviceType
			}
		case "workspace":
			if v != nil {
				var workspace ConnectedWorkspace
				err = json.Unmarshal(*v, &workspace)
				if err != nil {
					return err
				}
				csp.Workspace = &workspace
			}
		}
	}

	return nil
}

// CloudError error response structure.
type CloudError struct {
	// CloudErrorBody - Error data
	*CloudErrorBody `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudError.
func (ce CloudError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ce.CloudErrorBody != nil {
		objectMap["error"] = ce.CloudErrorBody
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CloudError struct.
func (ce *CloudError) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "error":
			if v != nil {
				var cloudErrorBody CloudErrorBody
				err = json.Unmarshal(*v, &cloudErrorBody)
				if err != nil {
					return err
				}
				ce.CloudErrorBody = &cloudErrorBody
			}
		}
	}

	return nil
}

// CloudErrorBody error details.
type CloudErrorBody struct {
	// Code - READ-ONLY; An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudErrorBody.
func (ceb CloudErrorBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Compliance compliance of a scope
type Compliance struct {
	autorest.Response `json:"-"`
	// ComplianceProperties - Compliance data
	*ComplianceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Compliance.
func (c Compliance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ComplianceProperties != nil {
		objectMap["properties"] = c.ComplianceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Compliance struct.
func (c *Compliance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var complianceProperties ComplianceProperties
				err = json.Unmarshal(*v, &complianceProperties)
				if err != nil {
					return err
				}
				c.ComplianceProperties = &complianceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ComplianceList list of Compliance objects response
type ComplianceList struct {
	autorest.Response `json:"-"`
	// Value - List of Compliance objects
	Value *[]Compliance `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ComplianceList.
func (cl ComplianceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cl.Value != nil {
		objectMap["value"] = cl.Value
	}
	return json.Marshal(objectMap)
}

// ComplianceListIterator provides access to a complete listing of Compliance values.
type ComplianceListIterator struct {
	i    int
	page ComplianceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ComplianceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComplianceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ComplianceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ComplianceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ComplianceListIterator) Response() ComplianceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ComplianceListIterator) Value() Compliance {
	if !iter.page.NotDone() {
		return Compliance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ComplianceListIterator type.
func NewComplianceListIterator(page ComplianceListPage) ComplianceListIterator {
	return ComplianceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ComplianceList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cl ComplianceList) hasNextLink() bool {
	return cl.NextLink != nil && len(*cl.NextLink) != 0
}

// complianceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ComplianceList) complianceListPreparer(ctx context.Context) (*http.Request, error) {
	if !cl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ComplianceListPage contains a page of Compliance values.
type ComplianceListPage struct {
	fn func(context.Context, ComplianceList) (ComplianceList, error)
	cl ComplianceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ComplianceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComplianceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cl)
		if err != nil {
			return err
		}
		page.cl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ComplianceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ComplianceListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ComplianceListPage) Response() ComplianceList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ComplianceListPage) Values() []Compliance {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ComplianceListPage type.
func NewComplianceListPage(cur ComplianceList, getNextPage func(context.Context, ComplianceList) (ComplianceList, error)) ComplianceListPage {
	return ComplianceListPage{
		fn: getNextPage,
		cl: cur,
	}
}

// ComplianceProperties the Compliance score (percentage) of a Subscription is a sum of all Resources'
// Compliances under the given Subscription. A Resource Compliance is defined as the compliant ('healthy')
// Policy Definitions out of all Policy Definitions applicable to a given resource.
type ComplianceProperties struct {
	// AssessmentTimestampUtcDate - READ-ONLY; The timestamp when the Compliance calculation was conducted.
	AssessmentTimestampUtcDate *date.Time `json:"assessmentTimestampUtcDate,omitempty"`
	// ResourceCount - READ-ONLY; The resource count of the given subscription for which the Compliance calculation was conducted (needed for Management Group Compliance calculation).
	ResourceCount *int32 `json:"resourceCount,omitempty"`
	// AssessmentResult - READ-ONLY; An array of segment, which is the actually the compliance assessment.
	AssessmentResult *[]ComplianceSegment `json:"assessmentResult,omitempty"`
}

// MarshalJSON is the custom marshaler for ComplianceProperties.
func (cp ComplianceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ComplianceSegment a segment of a compliance assessment.
type ComplianceSegment struct {
	// SegmentType - READ-ONLY; The segment type, e.g. compliant, non-compliance, insufficient coverage, N/A, etc.
	SegmentType *string `json:"segmentType,omitempty"`
	// Percentage - READ-ONLY; The size (%) of the segment.
	Percentage *float64 `json:"percentage,omitempty"`
}

// MarshalJSON is the custom marshaler for ComplianceSegment.
func (cs ComplianceSegment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConnectableResource describes the allowed inbound and outbound traffic of an Azure resource
type ConnectableResource struct {
	// ID - READ-ONLY; The Azure resource id
	ID *string `json:"id,omitempty"`
	// InboundConnectedResources - READ-ONLY; The list of Azure resources that the resource has inbound allowed connection from
	InboundConnectedResources *[]ConnectedResource `json:"inboundConnectedResources,omitempty"`
	// OutboundConnectedResources - READ-ONLY; The list of Azure resources that the resource has outbound allowed connection to
	OutboundConnectedResources *[]ConnectedResource `json:"outboundConnectedResources,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectableResource.
func (cr ConnectableResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConnectedResource describes properties of a connected resource
type ConnectedResource struct {
	// ConnectedResourceID - READ-ONLY; The Azure resource id of the connected resource
	ConnectedResourceID *string `json:"connectedResourceId,omitempty"`
	// TCPPorts - READ-ONLY; The allowed tcp ports
	TCPPorts *string `json:"tcpPorts,omitempty"`
	// UDPPorts - READ-ONLY; The allowed udp ports
	UDPPorts *string `json:"udpPorts,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectedResource.
func (cr ConnectedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConnectedWorkspace ...
type ConnectedWorkspace struct {
	// ID - Azure resource ID of the connected OMS workspace
	ID *string `json:"id,omitempty"`
}

// ConnectionToIPNotAllowed outbound connection to an ip that isn't allowed. Allow list consists of ipv4 or
// ipv6 range in CIDR notation.
type ConnectionToIPNotAllowed struct {
	// AllowlistValues - The values to allow. The format of the values depends on the rule type.
	AllowlistValues *[]string `json:"allowlistValues,omitempty"`
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) MarshalJSON() ([]byte, error) {
	ctina.RuleType = RuleTypeConnectionToIPNotAllowed
	objectMap := make(map[string]interface{})
	if ctina.AllowlistValues != nil {
		objectMap["allowlistValues"] = ctina.AllowlistValues
	}
	if ctina.IsEnabled != nil {
		objectMap["isEnabled"] = ctina.IsEnabled
	}
	if ctina.RuleType != "" {
		objectMap["ruleType"] = ctina.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return &ctina, true
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return &ctina, true
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return &ctina, true
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &ctina, true
}

// ConnectorSetting the connector setting
type ConnectorSetting struct {
	autorest.Response `json:"-"`
	// ConnectorSettingProperties - Connector setting data
	*ConnectorSettingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectorSetting.
func (cs ConnectorSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cs.ConnectorSettingProperties != nil {
		objectMap["properties"] = cs.ConnectorSettingProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectorSetting struct.
func (cs *ConnectorSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var connectorSettingProperties ConnectorSettingProperties
				err = json.Unmarshal(*v, &connectorSettingProperties)
				if err != nil {
					return err
				}
				cs.ConnectorSettingProperties = &connectorSettingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = &typeVar
			}
		}
	}

	return nil
}

// ConnectorSettingList for a subscription, list of all cloud account connectors and their settings
type ConnectorSettingList struct {
	autorest.Response `json:"-"`
	// Value - List of all the cloud account connector settings
	Value *[]ConnectorSetting `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectorSettingList.
func (csl ConnectorSettingList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csl.Value != nil {
		objectMap["value"] = csl.Value
	}
	return json.Marshal(objectMap)
}

// ConnectorSettingListIterator provides access to a complete listing of ConnectorSetting values.
type ConnectorSettingListIterator struct {
	i    int
	page ConnectorSettingListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConnectorSettingListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectorSettingListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConnectorSettingListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConnectorSettingListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConnectorSettingListIterator) Response() ConnectorSettingList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConnectorSettingListIterator) Value() ConnectorSetting {
	if !iter.page.NotDone() {
		return ConnectorSetting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConnectorSettingListIterator type.
func NewConnectorSettingListIterator(page ConnectorSettingListPage) ConnectorSettingListIterator {
	return ConnectorSettingListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (csl ConnectorSettingList) IsEmpty() bool {
	return csl.Value == nil || len(*csl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (csl ConnectorSettingList) hasNextLink() bool {
	return csl.NextLink != nil && len(*csl.NextLink) != 0
}

// connectorSettingListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (csl ConnectorSettingList) connectorSettingListPreparer(ctx context.Context) (*http.Request, error) {
	if !csl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(csl.NextLink)))
}

// ConnectorSettingListPage contains a page of ConnectorSetting values.
type ConnectorSettingListPage struct {
	fn  func(context.Context, ConnectorSettingList) (ConnectorSettingList, error)
	csl ConnectorSettingList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConnectorSettingListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectorSettingListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.csl)
		if err != nil {
			return err
		}
		page.csl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConnectorSettingListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConnectorSettingListPage) NotDone() bool {
	return !page.csl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConnectorSettingListPage) Response() ConnectorSettingList {
	return page.csl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConnectorSettingListPage) Values() []ConnectorSetting {
	if page.csl.IsEmpty() {
		return nil
	}
	return *page.csl.Value
}

// Creates a new instance of the ConnectorSettingListPage type.
func NewConnectorSettingListPage(cur ConnectorSettingList, getNextPage func(context.Context, ConnectorSettingList) (ConnectorSettingList, error)) ConnectorSettingListPage {
	return ConnectorSettingListPage{
		fn:  getNextPage,
		csl: cur,
	}
}

// ConnectorSettingProperties describes properties of a connector setting
type ConnectorSettingProperties struct {
	// HybridComputeSettings - Settings for hybrid compute management. These settings are relevant only for Arc autoProvision (Hybrid Compute).
	HybridComputeSettings *HybridComputeSettingsProperties `json:"hybridComputeSettings,omitempty"`
	// AuthenticationDetails - Settings for authentication management, these settings are relevant only for the cloud connector.
	AuthenticationDetails BasicAuthenticationDetailsProperties `json:"authenticationDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ConnectorSettingProperties struct.
func (csp *ConnectorSettingProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "hybridComputeSettings":
			if v != nil {
				var hybridComputeSettings HybridComputeSettingsProperties
				err = json.Unmarshal(*v, &hybridComputeSettings)
				if err != nil {
					return err
				}
				csp.HybridComputeSettings = &hybridComputeSettings
			}
		case "authenticationDetails":
			if v != nil {
				authenticationDetails, err := unmarshalBasicAuthenticationDetailsProperties(*v)
				if err != nil {
					return err
				}
				csp.AuthenticationDetails = authenticationDetails
			}
		}
	}

	return nil
}

// Contact contact details for security issues
type Contact struct {
	autorest.Response `json:"-"`
	// ContactProperties - Security contact data
	*ContactProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Contact.
func (c Contact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ContactProperties != nil {
		objectMap["properties"] = c.ContactProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Contact struct.
func (c *Contact) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var contactProperties ContactProperties
				err = json.Unmarshal(*v, &contactProperties)
				if err != nil {
					return err
				}
				c.ContactProperties = &contactProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ContactList list of security contacts response
type ContactList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of security contacts
	Value *[]Contact `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ContactList.
func (cl ContactList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ContactListIterator provides access to a complete listing of Contact values.
type ContactListIterator struct {
	i    int
	page ContactListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ContactListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContactListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ContactListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ContactListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ContactListIterator) Response() ContactList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ContactListIterator) Value() Contact {
	if !iter.page.NotDone() {
		return Contact{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ContactListIterator type.
func NewContactListIterator(page ContactListPage) ContactListIterator {
	return ContactListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ContactList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cl ContactList) hasNextLink() bool {
	return cl.NextLink != nil && len(*cl.NextLink) != 0
}

// contactListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ContactList) contactListPreparer(ctx context.Context) (*http.Request, error) {
	if !cl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ContactListPage contains a page of Contact values.
type ContactListPage struct {
	fn func(context.Context, ContactList) (ContactList, error)
	cl ContactList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ContactListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContactListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cl)
		if err != nil {
			return err
		}
		page.cl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ContactListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ContactListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ContactListPage) Response() ContactList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ContactListPage) Values() []Contact {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ContactListPage type.
func NewContactListPage(cur ContactList, getNextPage func(context.Context, ContactList) (ContactList, error)) ContactListPage {
	return ContactListPage{
		fn: getNextPage,
		cl: cur,
	}
}

// ContactProperties describes security contact properties
type ContactProperties struct {
	// Email - The email of this security contact
	Email *string `json:"email,omitempty"`
	// Phone - The phone number of this security contact
	Phone *string `json:"phone,omitempty"`
	// AlertNotifications - Whether to send security alerts notifications to the security contact. Possible values include: 'On', 'Off'
	AlertNotifications AlertNotifications `json:"alertNotifications,omitempty"`
	// AlertsToAdmins - Whether to send security alerts notifications to subscription admins. Possible values include: 'AlertsToAdminsOn', 'AlertsToAdminsOff'
	AlertsToAdmins AlertsToAdmins `json:"alertsToAdmins,omitempty"`
}

// ContainerRegistryVulnerabilityProperties additional context fields for container registry Vulnerability
// assessment
type ContainerRegistryVulnerabilityProperties struct {
	// Type - READ-ONLY; Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information Gathered, Vulnerability
	Type *string `json:"type,omitempty"`
	// Cvss - READ-ONLY; Dictionary from cvss version to cvss details object
	Cvss map[string]*CVSS `json:"cvss"`
	// Patchable - READ-ONLY; Indicates whether a patch is available or not
	Patchable *bool `json:"patchable,omitempty"`
	// Cve - READ-ONLY; List of CVEs
	Cve *[]CVE `json:"cve,omitempty"`
	// PublishedTime - READ-ONLY; Published time
	PublishedTime *date.Time `json:"publishedTime,omitempty"`
	// VendorReferences - READ-ONLY
	VendorReferences *[]VendorReference `json:"vendorReferences,omitempty"`
	// RepositoryName - READ-ONLY; Name of the repository which the vulnerable image belongs to
	RepositoryName *string `json:"repositoryName,omitempty"`
	// ImageDigest - READ-ONLY; Digest of the vulnerable image
	ImageDigest *string `json:"imageDigest,omitempty"`
	// AssessedResourceType - Possible values include: 'AssessedResourceTypeAdditionalData', 'AssessedResourceTypeSQLServerVulnerability', 'AssessedResourceTypeContainerRegistryVulnerability', 'AssessedResourceTypeServerVulnerabilityAssessment'
	AssessedResourceType AssessedResourceType `json:"assessedResourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) MarshalJSON() ([]byte, error) {
	crvp.AssessedResourceType = AssessedResourceTypeContainerRegistryVulnerability
	objectMap := make(map[string]interface{})
	if crvp.AssessedResourceType != "" {
		objectMap["assessedResourceType"] = crvp.AssessedResourceType
	}
	return json.Marshal(objectMap)
}

// AsSQLServerVulnerabilityProperties is the BasicAdditionalData implementation for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) AsSQLServerVulnerabilityProperties() (*SQLServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsContainerRegistryVulnerabilityProperties is the BasicAdditionalData implementation for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) AsContainerRegistryVulnerabilityProperties() (*ContainerRegistryVulnerabilityProperties, bool) {
	return &crvp, true
}

// AsServerVulnerabilityProperties is the BasicAdditionalData implementation for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) AsServerVulnerabilityProperties() (*ServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsAdditionalData is the BasicAdditionalData implementation for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) AsAdditionalData() (*AdditionalData, bool) {
	return nil, false
}

// AsBasicAdditionalData is the BasicAdditionalData implementation for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) AsBasicAdditionalData() (BasicAdditionalData, bool) {
	return &crvp, true
}

// BasicCustomAlertRule a custom alert rule.
type BasicCustomAlertRule interface {
	AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool)
	AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool)
	AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool)
	AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool)
	AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool)
	AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool)
	AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool)
	AsListCustomAlertRule() (*ListCustomAlertRule, bool)
	AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool)
	AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool)
	AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool)
	AsProcessNotAllowed() (*ProcessNotAllowed, bool)
	AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool)
	AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool)
	AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool)
	AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool)
	AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool)
	AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool)
	AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool)
	AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool)
	AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool)
	AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool)
	AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool)
	AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool)
	AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool)
	AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool)
	AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool)
	AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool)
	AsCustomAlertRule() (*CustomAlertRule, bool)
}

// CustomAlertRule a custom alert rule.
type CustomAlertRule struct {
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

func unmarshalBasicCustomAlertRule(body []byte) (BasicCustomAlertRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleType"] {
	case string(RuleTypeThresholdCustomAlertRule):
		var tcar ThresholdCustomAlertRule
		err := json.Unmarshal(body, &tcar)
		return tcar, err
	case string(RuleTypeTimeWindowCustomAlertRule):
		var twcar TimeWindowCustomAlertRule
		err := json.Unmarshal(body, &twcar)
		return twcar, err
	case string(RuleTypeAllowlistCustomAlertRule):
		var acar AllowlistCustomAlertRule
		err := json.Unmarshal(body, &acar)
		return acar, err
	case string(RuleTypeDenylistCustomAlertRule):
		var dcar DenylistCustomAlertRule
		err := json.Unmarshal(body, &dcar)
		return dcar, err
	case string(RuleTypeListCustomAlertRule):
		var lcar ListCustomAlertRule
		err := json.Unmarshal(body, &lcar)
		return lcar, err
	case string(RuleTypeConnectionToIPNotAllowed):
		var ctina ConnectionToIPNotAllowed
		err := json.Unmarshal(body, &ctina)
		return ctina, err
	case string(RuleTypeLocalUserNotAllowed):
		var luna LocalUserNotAllowed
		err := json.Unmarshal(body, &luna)
		return luna, err
	case string(RuleTypeProcessNotAllowed):
		var pna ProcessNotAllowed
		err := json.Unmarshal(body, &pna)
		return pna, err
	case string(RuleTypeActiveConnectionsNotInAllowedRange):
		var acniar ActiveConnectionsNotInAllowedRange
		err := json.Unmarshal(body, &acniar)
		return acniar, err
	case string(RuleTypeAmqpC2DMessagesNotInAllowedRange):
		var acmniar AmqpC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &acmniar)
		return acmniar, err
	case string(RuleTypeMqttC2DMessagesNotInAllowedRange):
		var mcmniar MqttC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mcmniar)
		return mcmniar, err
	case string(RuleTypeHTTPC2DMessagesNotInAllowedRange):
		var hcmniar HTTPC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hcmniar)
		return hcmniar, err
	case string(RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange):
		var acrmniar AmqpC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &acrmniar)
		return acrmniar, err
	case string(RuleTypeMqttC2DRejectedMessagesNotInAllowedRange):
		var mcrmniar MqttC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mcrmniar)
		return mcrmniar, err
	case string(RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange):
		var hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hcrmniar)
		return hcrmniar, err
	case string(RuleTypeAmqpD2CMessagesNotInAllowedRange):
		var admniar AmqpD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &admniar)
		return admniar, err
	case string(RuleTypeMqttD2CMessagesNotInAllowedRange):
		var mdmniar MqttD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mdmniar)
		return mdmniar, err
	case string(RuleTypeHTTPD2CMessagesNotInAllowedRange):
		var hdmniar HTTPD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hdmniar)
		return hdmniar, err
	case string(RuleTypeDirectMethodInvokesNotInAllowedRange):
		var dminiar DirectMethodInvokesNotInAllowedRange
		err := json.Unmarshal(body, &dminiar)
		return dminiar, err
	case string(RuleTypeFailedLocalLoginsNotInAllowedRange):
		var fllniar FailedLocalLoginsNotInAllowedRange
		err := json.Unmarshal(body, &fllniar)
		return fllniar, err
	case string(RuleTypeFileUploadsNotInAllowedRange):
		var funiar FileUploadsNotInAllowedRange
		err := json.Unmarshal(body, &funiar)
		return funiar, err
	case string(RuleTypeQueuePurgesNotInAllowedRange):
		var qpniar QueuePurgesNotInAllowedRange
		err := json.Unmarshal(body, &qpniar)
		return qpniar, err
	case string(RuleTypeTwinUpdatesNotInAllowedRange):
		var tuniar TwinUpdatesNotInAllowedRange
		err := json.Unmarshal(body, &tuniar)
		return tuniar, err
	case string(RuleTypeUnauthorizedOperationsNotInAllowedRange):
		var uoniar UnauthorizedOperationsNotInAllowedRange
		err := json.Unmarshal(body, &uoniar)
		return uoniar, err
	default:
		var car CustomAlertRule
		err := json.Unmarshal(body, &car)
		return car, err
	}
}
func unmarshalBasicCustomAlertRuleArray(body []byte) ([]BasicCustomAlertRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	carArray := make([]BasicCustomAlertRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		car, err := unmarshalBasicCustomAlertRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		carArray[index] = car
	}
	return carArray, nil
}

// MarshalJSON is the custom marshaler for CustomAlertRule.
func (car CustomAlertRule) MarshalJSON() ([]byte, error) {
	car.RuleType = RuleTypeCustomAlertRule
	objectMap := make(map[string]interface{})
	if car.IsEnabled != nil {
		objectMap["isEnabled"] = car.IsEnabled
	}
	if car.RuleType != "" {
		objectMap["ruleType"] = car.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return &car, true
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &car, true
}

// CVE CVE details
type CVE struct {
	// Title - READ-ONLY; CVE title
	Title *string `json:"title,omitempty"`
	// Link - READ-ONLY; Link url
	Link *string `json:"link,omitempty"`
}

// MarshalJSON is the custom marshaler for CVE.
func (c CVE) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CVSS CVSS details
type CVSS struct {
	// Base - READ-ONLY; CVSS base
	Base *float64 `json:"base,omitempty"`
}

// MarshalJSON is the custom marshaler for CVSS.
func (c CVSS) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DataExportSetting represents a data export setting
type DataExportSetting struct {
	// DataExportSettingProperties - Data export setting data
	*DataExportSettingProperties `json:"properties,omitempty"`
	// Kind - the kind of the settings string (DataExportSetting). Possible values include: 'SettingKindDataExportSetting', 'SettingKindAlertSuppressionSetting'
	Kind SettingKind `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataExportSetting.
func (desVar DataExportSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if desVar.DataExportSettingProperties != nil {
		objectMap["properties"] = desVar.DataExportSettingProperties
	}
	if desVar.Kind != "" {
		objectMap["kind"] = desVar.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataExportSetting struct.
func (desVar *DataExportSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataExportSettingProperties DataExportSettingProperties
				err = json.Unmarshal(*v, &dataExportSettingProperties)
				if err != nil {
					return err
				}
				desVar.DataExportSettingProperties = &dataExportSettingProperties
			}
		case "kind":
			if v != nil {
				var kind SettingKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				desVar.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				desVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				desVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				desVar.Type = &typeVar
			}
		}
	}

	return nil
}

// DataExportSettingProperties the data export setting properties
type DataExportSettingProperties struct {
	// Enabled - Is the data export setting is enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DenylistCustomAlertRule a custom alert rule that checks if a value (depends on the custom alert type) is
// denied.
type DenylistCustomAlertRule struct {
	// DenylistValues - The values to deny. The format of the values depends on the rule type.
	DenylistValues *[]string `json:"denylistValues,omitempty"`
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) MarshalJSON() ([]byte, error) {
	dcar.RuleType = RuleTypeDenylistCustomAlertRule
	objectMap := make(map[string]interface{})
	if dcar.DenylistValues != nil {
		objectMap["denylistValues"] = dcar.DenylistValues
	}
	if dcar.IsEnabled != nil {
		objectMap["isEnabled"] = dcar.IsEnabled
	}
	if dcar.RuleType != "" {
		objectMap["ruleType"] = dcar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return &dcar, true
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return &dcar, true
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &dcar, true
}

// DeviceSecurityGroup the device security group resource
type DeviceSecurityGroup struct {
	autorest.Response `json:"-"`
	// DeviceSecurityGroupProperties - Device Security group data
	*DeviceSecurityGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceSecurityGroup.
func (dsg DeviceSecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsg.DeviceSecurityGroupProperties != nil {
		objectMap["properties"] = dsg.DeviceSecurityGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeviceSecurityGroup struct.
func (dsg *DeviceSecurityGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var deviceSecurityGroupProperties DeviceSecurityGroupProperties
				err = json.Unmarshal(*v, &deviceSecurityGroupProperties)
				if err != nil {
					return err
				}
				dsg.DeviceSecurityGroupProperties = &deviceSecurityGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dsg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dsg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dsg.Type = &typeVar
			}
		}
	}

	return nil
}

// DeviceSecurityGroupList list of device security groups
type DeviceSecurityGroupList struct {
	autorest.Response `json:"-"`
	// Value - List of device security group objects
	Value *[]DeviceSecurityGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceSecurityGroupList.
func (dsgl DeviceSecurityGroupList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsgl.Value != nil {
		objectMap["value"] = dsgl.Value
	}
	return json.Marshal(objectMap)
}

// DeviceSecurityGroupListIterator provides access to a complete listing of DeviceSecurityGroup values.
type DeviceSecurityGroupListIterator struct {
	i    int
	page DeviceSecurityGroupListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeviceSecurityGroupListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeviceSecurityGroupListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeviceSecurityGroupListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeviceSecurityGroupListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeviceSecurityGroupListIterator) Response() DeviceSecurityGroupList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeviceSecurityGroupListIterator) Value() DeviceSecurityGroup {
	if !iter.page.NotDone() {
		return DeviceSecurityGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeviceSecurityGroupListIterator type.
func NewDeviceSecurityGroupListIterator(page DeviceSecurityGroupListPage) DeviceSecurityGroupListIterator {
	return DeviceSecurityGroupListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dsgl DeviceSecurityGroupList) IsEmpty() bool {
	return dsgl.Value == nil || len(*dsgl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dsgl DeviceSecurityGroupList) hasNextLink() bool {
	return dsgl.NextLink != nil && len(*dsgl.NextLink) != 0
}

// deviceSecurityGroupListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dsgl DeviceSecurityGroupList) deviceSecurityGroupListPreparer(ctx context.Context) (*http.Request, error) {
	if !dsgl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dsgl.NextLink)))
}

// DeviceSecurityGroupListPage contains a page of DeviceSecurityGroup values.
type DeviceSecurityGroupListPage struct {
	fn   func(context.Context, DeviceSecurityGroupList) (DeviceSecurityGroupList, error)
	dsgl DeviceSecurityGroupList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeviceSecurityGroupListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeviceSecurityGroupListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dsgl)
		if err != nil {
			return err
		}
		page.dsgl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeviceSecurityGroupListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeviceSecurityGroupListPage) NotDone() bool {
	return !page.dsgl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeviceSecurityGroupListPage) Response() DeviceSecurityGroupList {
	return page.dsgl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeviceSecurityGroupListPage) Values() []DeviceSecurityGroup {
	if page.dsgl.IsEmpty() {
		return nil
	}
	return *page.dsgl.Value
}

// Creates a new instance of the DeviceSecurityGroupListPage type.
func NewDeviceSecurityGroupListPage(cur DeviceSecurityGroupList, getNextPage func(context.Context, DeviceSecurityGroupList) (DeviceSecurityGroupList, error)) DeviceSecurityGroupListPage {
	return DeviceSecurityGroupListPage{
		fn:   getNextPage,
		dsgl: cur,
	}
}

// DeviceSecurityGroupProperties describes properties of a security group.
type DeviceSecurityGroupProperties struct {
	// ThresholdRules - The list of custom alert threshold rules.
	ThresholdRules *[]BasicThresholdCustomAlertRule `json:"thresholdRules,omitempty"`
	// TimeWindowRules - The list of custom alert time-window rules.
	TimeWindowRules *[]BasicTimeWindowCustomAlertRule `json:"timeWindowRules,omitempty"`
	// AllowlistRules - The allow-list custom alert rules.
	AllowlistRules *[]BasicAllowlistCustomAlertRule `json:"allowlistRules,omitempty"`
	// DenylistRules - The deny-list custom alert rules.
	DenylistRules *[]DenylistCustomAlertRule `json:"denylistRules,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DeviceSecurityGroupProperties struct.
func (dsgp *DeviceSecurityGroupProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "thresholdRules":
			if v != nil {
				thresholdRules, err := unmarshalBasicThresholdCustomAlertRuleArray(*v)
				if err != nil {
					return err
				}
				dsgp.ThresholdRules = &thresholdRules
			}
		case "timeWindowRules":
			if v != nil {
				timeWindowRules, err := unmarshalBasicTimeWindowCustomAlertRuleArray(*v)
				if err != nil {
					return err
				}
				dsgp.TimeWindowRules = &timeWindowRules
			}
		case "allowlistRules":
			if v != nil {
				allowlistRules, err := unmarshalBasicAllowlistCustomAlertRuleArray(*v)
				if err != nil {
					return err
				}
				dsgp.AllowlistRules = &allowlistRules
			}
		case "denylistRules":
			if v != nil {
				var denylistRules []DenylistCustomAlertRule
				err = json.Unmarshal(*v, &denylistRules)
				if err != nil {
					return err
				}
				dsgp.DenylistRules = &denylistRules
			}
		}
	}

	return nil
}

// DirectMethodInvokesNotInAllowedRange number of direct method invokes is not in allowed range.
type DirectMethodInvokesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	dminiar.RuleType = RuleTypeDirectMethodInvokesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if dminiar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = dminiar.TimeWindowSize
	}
	if dminiar.MinThreshold != nil {
		objectMap["minThreshold"] = dminiar.MinThreshold
	}
	if dminiar.MaxThreshold != nil {
		objectMap["maxThreshold"] = dminiar.MaxThreshold
	}
	if dminiar.IsEnabled != nil {
		objectMap["isEnabled"] = dminiar.IsEnabled
	}
	if dminiar.RuleType != "" {
		objectMap["ruleType"] = dminiar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &dminiar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &dminiar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return &dminiar, true
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &dminiar, true
}

// DiscoveredSecuritySolution ...
type DiscoveredSecuritySolution struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location                              *string `json:"location,omitempty"`
	*DiscoveredSecuritySolutionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DiscoveredSecuritySolution.
func (dss DiscoveredSecuritySolution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dss.DiscoveredSecuritySolutionProperties != nil {
		objectMap["properties"] = dss.DiscoveredSecuritySolutionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiscoveredSecuritySolution struct.
func (dss *DiscoveredSecuritySolution) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dss.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dss.Location = &location
			}
		case "properties":
			if v != nil {
				var discoveredSecuritySolutionProperties DiscoveredSecuritySolutionProperties
				err = json.Unmarshal(*v, &discoveredSecuritySolutionProperties)
				if err != nil {
					return err
				}
				dss.DiscoveredSecuritySolutionProperties = &discoveredSecuritySolutionProperties
			}
		}
	}

	return nil
}

// DiscoveredSecuritySolutionList ...
type DiscoveredSecuritySolutionList struct {
	autorest.Response `json:"-"`
	Value             *[]DiscoveredSecuritySolution `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DiscoveredSecuritySolutionList.
func (dssl DiscoveredSecuritySolutionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dssl.Value != nil {
		objectMap["value"] = dssl.Value
	}
	return json.Marshal(objectMap)
}

// DiscoveredSecuritySolutionListIterator provides access to a complete listing of
// DiscoveredSecuritySolution values.
type DiscoveredSecuritySolutionListIterator struct {
	i    int
	page DiscoveredSecuritySolutionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiscoveredSecuritySolutionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiscoveredSecuritySolutionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiscoveredSecuritySolutionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiscoveredSecuritySolutionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiscoveredSecuritySolutionListIterator) Response() DiscoveredSecuritySolutionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiscoveredSecuritySolutionListIterator) Value() DiscoveredSecuritySolution {
	if !iter.page.NotDone() {
		return DiscoveredSecuritySolution{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiscoveredSecuritySolutionListIterator type.
func NewDiscoveredSecuritySolutionListIterator(page DiscoveredSecuritySolutionListPage) DiscoveredSecuritySolutionListIterator {
	return DiscoveredSecuritySolutionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dssl DiscoveredSecuritySolutionList) IsEmpty() bool {
	return dssl.Value == nil || len(*dssl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dssl DiscoveredSecuritySolutionList) hasNextLink() bool {
	return dssl.NextLink != nil && len(*dssl.NextLink) != 0
}

// discoveredSecuritySolutionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dssl DiscoveredSecuritySolutionList) discoveredSecuritySolutionListPreparer(ctx context.Context) (*http.Request, error) {
	if !dssl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dssl.NextLink)))
}

// DiscoveredSecuritySolutionListPage contains a page of DiscoveredSecuritySolution values.
type DiscoveredSecuritySolutionListPage struct {
	fn   func(context.Context, DiscoveredSecuritySolutionList) (DiscoveredSecuritySolutionList, error)
	dssl DiscoveredSecuritySolutionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiscoveredSecuritySolutionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiscoveredSecuritySolutionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dssl)
		if err != nil {
			return err
		}
		page.dssl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiscoveredSecuritySolutionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiscoveredSecuritySolutionListPage) NotDone() bool {
	return !page.dssl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiscoveredSecuritySolutionListPage) Response() DiscoveredSecuritySolutionList {
	return page.dssl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiscoveredSecuritySolutionListPage) Values() []DiscoveredSecuritySolution {
	if page.dssl.IsEmpty() {
		return nil
	}
	return *page.dssl.Value
}

// Creates a new instance of the DiscoveredSecuritySolutionListPage type.
func NewDiscoveredSecuritySolutionListPage(cur DiscoveredSecuritySolutionList, getNextPage func(context.Context, DiscoveredSecuritySolutionList) (DiscoveredSecuritySolutionList, error)) DiscoveredSecuritySolutionListPage {
	return DiscoveredSecuritySolutionListPage{
		fn:   getNextPage,
		dssl: cur,
	}
}

// DiscoveredSecuritySolutionProperties ...
type DiscoveredSecuritySolutionProperties struct {
	// SecurityFamily - The security family of the discovered solution. Possible values include: 'Waf', 'Ngfw', 'SaasWaf', 'Va'
	SecurityFamily Family `json:"securityFamily,omitempty"`
	// Offer - The security solutions' image offer
	Offer *string `json:"offer,omitempty"`
	// Publisher - The security solutions' image publisher
	Publisher *string `json:"publisher,omitempty"`
	// Sku - The security solutions' image sku
	Sku *string `json:"sku,omitempty"`
}

// EffectiveNetworkSecurityGroups describes the Network Security Groups effective on a network interface
type EffectiveNetworkSecurityGroups struct {
	// NetworkInterface - The Azure resource ID of the network interface
	NetworkInterface *string `json:"networkInterface,omitempty"`
	// NetworkSecurityGroups - The Network Security Groups effective on the network interface
	NetworkSecurityGroups *[]string `json:"networkSecurityGroups,omitempty"`
}

// ETag entity tag is used for comparing two or more entities from the same requested resource.
type ETag struct {
	// Etag - Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string `json:"etag,omitempty"`
}

// BasicExternalSecuritySolution represents a security solution external to Azure Security Center which sends
// information to an OMS workspace and whose data is displayed by Azure Security Center.
type BasicExternalSecuritySolution interface {
	AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool)
	AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool)
	AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool)
	AsExternalSecuritySolution() (*ExternalSecuritySolution, bool)
}

// ExternalSecuritySolution represents a security solution external to Azure Security Center which sends
// information to an OMS workspace and whose data is displayed by Azure Security Center.
type ExternalSecuritySolution struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

func unmarshalBasicExternalSecuritySolution(body []byte) (BasicExternalSecuritySolution, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindCEF):
		var cess CefExternalSecuritySolution
		err := json.Unmarshal(body, &cess)
		return cess, err
	case string(KindATA):
		var aess AtaExternalSecuritySolution
		err := json.Unmarshal(body, &aess)
		return aess, err
	case string(KindAAD):
		var aess AadExternalSecuritySolution
		err := json.Unmarshal(body, &aess)
		return aess, err
	default:
		var ess ExternalSecuritySolution
		err := json.Unmarshal(body, &ess)
		return ess, err
	}
}
func unmarshalBasicExternalSecuritySolutionArray(body []byte) ([]BasicExternalSecuritySolution, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	essArray := make([]BasicExternalSecuritySolution, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ess, err := unmarshalBasicExternalSecuritySolution(*rawMessage)
		if err != nil {
			return nil, err
		}
		essArray[index] = ess
	}
	return essArray, nil
}

// MarshalJSON is the custom marshaler for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	ess.Kind = KindExternalSecuritySolution
	objectMap := make(map[string]interface{})
	if ess.Kind != "" {
		objectMap["kind"] = ess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return nil, false
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return nil, false
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return nil, false
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return &ess, true
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &ess, true
}

// ExternalSecuritySolutionKind1 describes an Azure resource with kind
type ExternalSecuritySolutionKind1 struct {
	// Kind - The kind of the external solution. Possible values include: 'CEF', 'ATA', 'AAD'
	Kind ExternalSecuritySolutionKind `json:"kind,omitempty"`
}

// ExternalSecuritySolutionList ...
type ExternalSecuritySolutionList struct {
	autorest.Response `json:"-"`
	Value             *[]BasicExternalSecuritySolution `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExternalSecuritySolutionList.
func (essl ExternalSecuritySolutionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if essl.Value != nil {
		objectMap["value"] = essl.Value
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExternalSecuritySolutionList struct.
func (essl *ExternalSecuritySolutionList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicExternalSecuritySolutionArray(*v)
				if err != nil {
					return err
				}
				essl.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				essl.NextLink = &nextLink
			}
		}
	}

	return nil
}

// ExternalSecuritySolutionListIterator provides access to a complete listing of ExternalSecuritySolution
// values.
type ExternalSecuritySolutionListIterator struct {
	i    int
	page ExternalSecuritySolutionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExternalSecuritySolutionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExternalSecuritySolutionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExternalSecuritySolutionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExternalSecuritySolutionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExternalSecuritySolutionListIterator) Response() ExternalSecuritySolutionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExternalSecuritySolutionListIterator) Value() BasicExternalSecuritySolution {
	if !iter.page.NotDone() {
		return ExternalSecuritySolution{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExternalSecuritySolutionListIterator type.
func NewExternalSecuritySolutionListIterator(page ExternalSecuritySolutionListPage) ExternalSecuritySolutionListIterator {
	return ExternalSecuritySolutionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (essl ExternalSecuritySolutionList) IsEmpty() bool {
	return essl.Value == nil || len(*essl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (essl ExternalSecuritySolutionList) hasNextLink() bool {
	return essl.NextLink != nil && len(*essl.NextLink) != 0
}

// externalSecuritySolutionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (essl ExternalSecuritySolutionList) externalSecuritySolutionListPreparer(ctx context.Context) (*http.Request, error) {
	if !essl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(essl.NextLink)))
}

// ExternalSecuritySolutionListPage contains a page of BasicExternalSecuritySolution values.
type ExternalSecuritySolutionListPage struct {
	fn   func(context.Context, ExternalSecuritySolutionList) (ExternalSecuritySolutionList, error)
	essl ExternalSecuritySolutionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExternalSecuritySolutionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExternalSecuritySolutionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.essl)
		if err != nil {
			return err
		}
		page.essl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExternalSecuritySolutionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExternalSecuritySolutionListPage) NotDone() bool {
	return !page.essl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExternalSecuritySolutionListPage) Response() ExternalSecuritySolutionList {
	return page.essl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExternalSecuritySolutionListPage) Values() []BasicExternalSecuritySolution {
	if page.essl.IsEmpty() {
		return nil
	}
	return *page.essl.Value
}

// Creates a new instance of the ExternalSecuritySolutionListPage type.
func NewExternalSecuritySolutionListPage(cur ExternalSecuritySolutionList, getNextPage func(context.Context, ExternalSecuritySolutionList) (ExternalSecuritySolutionList, error)) ExternalSecuritySolutionListPage {
	return ExternalSecuritySolutionListPage{
		fn:   getNextPage,
		essl: cur,
	}
}

// ExternalSecuritySolutionModel ...
type ExternalSecuritySolutionModel struct {
	autorest.Response `json:"-"`
	Value             BasicExternalSecuritySolution `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ExternalSecuritySolutionModel struct.
func (essm *ExternalSecuritySolutionModel) UnmarshalJSON(body []byte) error {
	ess, err := unmarshalBasicExternalSecuritySolution(body)
	if err != nil {
		return err
	}
	essm.Value = ess

	return nil
}

// ExternalSecuritySolutionProperties the solution properties (correspond to the solution kind)
type ExternalSecuritySolutionProperties struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	DeviceVendor         *string                `json:"deviceVendor,omitempty"`
	DeviceType           *string                `json:"deviceType,omitempty"`
	Workspace            *ConnectedWorkspace    `json:"workspace,omitempty"`
}

// MarshalJSON is the custom marshaler for ExternalSecuritySolutionProperties.
func (essp ExternalSecuritySolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if essp.DeviceVendor != nil {
		objectMap["deviceVendor"] = essp.DeviceVendor
	}
	if essp.DeviceType != nil {
		objectMap["deviceType"] = essp.DeviceType
	}
	if essp.Workspace != nil {
		objectMap["workspace"] = essp.Workspace
	}
	for k, v := range essp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExternalSecuritySolutionProperties struct.
func (essp *ExternalSecuritySolutionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if essp.AdditionalProperties == nil {
					essp.AdditionalProperties = make(map[string]interface{})
				}
				essp.AdditionalProperties[k] = additionalProperties
			}
		case "deviceVendor":
			if v != nil {
				var deviceVendor string
				err = json.Unmarshal(*v, &deviceVendor)
				if err != nil {
					return err
				}
				essp.DeviceVendor = &deviceVendor
			}
		case "deviceType":
			if v != nil {
				var deviceType string
				err = json.Unmarshal(*v, &deviceType)
				if err != nil {
					return err
				}
				essp.DeviceType = &deviceType
			}
		case "workspace":
			if v != nil {
				var workspace ConnectedWorkspace
				err = json.Unmarshal(*v, &workspace)
				if err != nil {
					return err
				}
				essp.Workspace = &workspace
			}
		}
	}

	return nil
}

// FailedLocalLoginsNotInAllowedRange number of failed local logins is not in allowed range.
type FailedLocalLoginsNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) MarshalJSON() ([]byte, error) {
	fllniar.RuleType = RuleTypeFailedLocalLoginsNotInAllowedRange
	objectMap := make(map[string]interface{})
	if fllniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = fllniar.TimeWindowSize
	}
	if fllniar.MinThreshold != nil {
		objectMap["minThreshold"] = fllniar.MinThreshold
	}
	if fllniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = fllniar.MaxThreshold
	}
	if fllniar.IsEnabled != nil {
		objectMap["isEnabled"] = fllniar.IsEnabled
	}
	if fllniar.RuleType != "" {
		objectMap["ruleType"] = fllniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &fllniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &fllniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return &fllniar, true
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &fllniar, true
}

// FileUploadsNotInAllowedRange number of file uploads is not in allowed range.
type FileUploadsNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) MarshalJSON() ([]byte, error) {
	funiar.RuleType = RuleTypeFileUploadsNotInAllowedRange
	objectMap := make(map[string]interface{})
	if funiar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = funiar.TimeWindowSize
	}
	if funiar.MinThreshold != nil {
		objectMap["minThreshold"] = funiar.MinThreshold
	}
	if funiar.MaxThreshold != nil {
		objectMap["maxThreshold"] = funiar.MaxThreshold
	}
	if funiar.IsEnabled != nil {
		objectMap["isEnabled"] = funiar.IsEnabled
	}
	if funiar.RuleType != "" {
		objectMap["ruleType"] = funiar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &funiar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &funiar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return &funiar, true
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &funiar, true
}

// GcpCredentialsDetailsProperties GCP cloud account connector based service to service credentials, the
// credentials are composed of the organization ID and a JSON API key (write only)
type GcpCredentialsDetailsProperties struct {
	// OrganizationID - The organization ID of the GCP cloud account
	OrganizationID *string `json:"organizationId,omitempty"`
	// Type - Type field of the API key (write only)
	Type *string `json:"type,omitempty"`
	// ProjectID - Project ID field of the API key (write only)
	ProjectID *string `json:"projectId,omitempty"`
	// PrivateKeyID - Private key ID field of the API key (write only)
	PrivateKeyID *string `json:"privateKeyId,omitempty"`
	// PrivateKey - Private key field of the API key (write only)
	PrivateKey *string `json:"privateKey,omitempty"`
	// ClientEmail - Client email field of the API key (write only)
	ClientEmail *string `json:"clientEmail,omitempty"`
	// ClientID - Client ID field of the API key (write only)
	ClientID *string `json:"clientId,omitempty"`
	// AuthURI - Auth URI field of the API key (write only)
	AuthURI *string `json:"authUri,omitempty"`
	// TokenURI - Token URI field of the API key (write only)
	TokenURI *string `json:"tokenUri,omitempty"`
	// AuthProviderX509CertURL - Auth provider x509 certificate URL field of the API key (write only)
	AuthProviderX509CertURL *string `json:"authProviderX509CertUrl,omitempty"`
	// ClientX509CertURL - Client x509 certificate URL field of the API key (write only)
	ClientX509CertURL *string `json:"clientX509CertUrl,omitempty"`
	// AuthenticationProvisioningState - READ-ONLY; State of the multi-cloud connector. Possible values include: 'Valid', 'Invalid', 'Expired', 'IncorrectPolicy'
	AuthenticationProvisioningState AuthenticationProvisioningState `json:"authenticationProvisioningState,omitempty"`
	// GrantedPermissions - READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions *[]PermissionProperty `json:"grantedPermissions,omitempty"`
	// AuthenticationType - Possible values include: 'AuthenticationTypeAuthenticationDetailsProperties', 'AuthenticationTypeAwsCreds', 'AuthenticationTypeAwsAssumeRole', 'AuthenticationTypeGcpCredentials'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// MarshalJSON is the custom marshaler for GcpCredentialsDetailsProperties.
func (gcdp GcpCredentialsDetailsProperties) MarshalJSON() ([]byte, error) {
	gcdp.AuthenticationType = AuthenticationTypeGcpCredentials
	objectMap := make(map[string]interface{})
	if gcdp.OrganizationID != nil {
		objectMap["organizationId"] = gcdp.OrganizationID
	}
	if gcdp.Type != nil {
		objectMap["type"] = gcdp.Type
	}
	if gcdp.ProjectID != nil {
		objectMap["projectId"] = gcdp.ProjectID
	}
	if gcdp.PrivateKeyID != nil {
		objectMap["privateKeyId"] = gcdp.PrivateKeyID
	}
	if gcdp.PrivateKey != nil {
		objectMap["privateKey"] = gcdp.PrivateKey
	}
	if gcdp.ClientEmail != nil {
		objectMap["clientEmail"] = gcdp.ClientEmail
	}
	if gcdp.ClientID != nil {
		objectMap["clientId"] = gcdp.ClientID
	}
	if gcdp.AuthURI != nil {
		objectMap["authUri"] = gcdp.AuthURI
	}
	if gcdp.TokenURI != nil {
		objectMap["tokenUri"] = gcdp.TokenURI
	}
	if gcdp.AuthProviderX509CertURL != nil {
		objectMap["authProviderX509CertUrl"] = gcdp.AuthProviderX509CertURL
	}
	if gcdp.ClientX509CertURL != nil {
		objectMap["clientX509CertUrl"] = gcdp.ClientX509CertURL
	}
	if gcdp.AuthenticationType != "" {
		objectMap["authenticationType"] = gcdp.AuthenticationType
	}
	return json.Marshal(objectMap)
}

// AsAwsCredsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for GcpCredentialsDetailsProperties.
func (gcdp GcpCredentialsDetailsProperties) AsAwsCredsAuthenticationDetailsProperties() (*AwsCredsAuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsAwAssumeRoleAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for GcpCredentialsDetailsProperties.
func (gcdp GcpCredentialsDetailsProperties) AsAwAssumeRoleAuthenticationDetailsProperties() (*AwAssumeRoleAuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsGcpCredentialsDetailsProperties is the BasicAuthenticationDetailsProperties implementation for GcpCredentialsDetailsProperties.
func (gcdp GcpCredentialsDetailsProperties) AsGcpCredentialsDetailsProperties() (*GcpCredentialsDetailsProperties, bool) {
	return &gcdp, true
}

// AsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for GcpCredentialsDetailsProperties.
func (gcdp GcpCredentialsDetailsProperties) AsAuthenticationDetailsProperties() (*AuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsBasicAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for GcpCredentialsDetailsProperties.
func (gcdp GcpCredentialsDetailsProperties) AsBasicAuthenticationDetailsProperties() (BasicAuthenticationDetailsProperties, bool) {
	return &gcdp, true
}

// HTTPC2DMessagesNotInAllowedRange number of cloud to device messages (HTTP protocol) is not in allowed
// range.
type HTTPC2DMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	hcmniar.RuleType = RuleTypeHTTPC2DMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if hcmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = hcmniar.TimeWindowSize
	}
	if hcmniar.MinThreshold != nil {
		objectMap["minThreshold"] = hcmniar.MinThreshold
	}
	if hcmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = hcmniar.MaxThreshold
	}
	if hcmniar.IsEnabled != nil {
		objectMap["isEnabled"] = hcmniar.IsEnabled
	}
	if hcmniar.RuleType != "" {
		objectMap["ruleType"] = hcmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &hcmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &hcmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return &hcmniar, true
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &hcmniar, true
}

// HTTPC2DRejectedMessagesNotInAllowedRange number of rejected cloud to device messages (HTTP protocol) is
// not in allowed range.
type HTTPC2DRejectedMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	hcrmniar.RuleType = RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if hcrmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = hcrmniar.TimeWindowSize
	}
	if hcrmniar.MinThreshold != nil {
		objectMap["minThreshold"] = hcrmniar.MinThreshold
	}
	if hcrmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = hcrmniar.MaxThreshold
	}
	if hcrmniar.IsEnabled != nil {
		objectMap["isEnabled"] = hcrmniar.IsEnabled
	}
	if hcrmniar.RuleType != "" {
		objectMap["ruleType"] = hcrmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &hcrmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &hcrmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return &hcrmniar, true
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &hcrmniar, true
}

// HTTPD2CMessagesNotInAllowedRange number of device to cloud messages (HTTP protocol) is not in allowed
// range.
type HTTPD2CMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	hdmniar.RuleType = RuleTypeHTTPD2CMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if hdmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = hdmniar.TimeWindowSize
	}
	if hdmniar.MinThreshold != nil {
		objectMap["minThreshold"] = hdmniar.MinThreshold
	}
	if hdmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = hdmniar.MaxThreshold
	}
	if hdmniar.IsEnabled != nil {
		objectMap["isEnabled"] = hdmniar.IsEnabled
	}
	if hdmniar.RuleType != "" {
		objectMap["ruleType"] = hdmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &hdmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &hdmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return &hdmniar, true
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &hdmniar, true
}

// HybridComputeSettingsProperties settings for hybrid compute management
type HybridComputeSettingsProperties struct {
	// HybridComputeProvisioningState - READ-ONLY; State of the service principal and its secret. Possible values include: 'HybridComputeProvisioningStateValid', 'HybridComputeProvisioningStateInvalid', 'HybridComputeProvisioningStateExpired'
	HybridComputeProvisioningState HybridComputeProvisioningState `json:"hybridComputeProvisioningState,omitempty"`
	// AutoProvision - Whether or not to automatically install Azure Arc (hybrid compute) agents on machines. Possible values include: 'AutoProvisionOn', 'AutoProvisionOff'
	AutoProvision AutoProvision `json:"autoProvision,omitempty"`
	// ResourceGroupName - The name of the resource group where Arc (Hybrid Compute) connectors are connected.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// Region - The location where the metadata of machines will be stored
	Region *string `json:"region,omitempty"`
	// ProxyServer - For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
	ProxyServer *ProxyServerProperties `json:"proxyServer,omitempty"`
	// ServicePrincipal - An object to access resources that are secured by an Azure AD tenant.
	ServicePrincipal *ServicePrincipalProperties `json:"servicePrincipal,omitempty"`
}

// MarshalJSON is the custom marshaler for HybridComputeSettingsProperties.
func (hcsp HybridComputeSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hcsp.AutoProvision != "" {
		objectMap["autoProvision"] = hcsp.AutoProvision
	}
	if hcsp.ResourceGroupName != nil {
		objectMap["resourceGroupName"] = hcsp.ResourceGroupName
	}
	if hcsp.Region != nil {
		objectMap["region"] = hcsp.Region
	}
	if hcsp.ProxyServer != nil {
		objectMap["proxyServer"] = hcsp.ProxyServer
	}
	if hcsp.ServicePrincipal != nil {
		objectMap["servicePrincipal"] = hcsp.ServicePrincipal
	}
	return json.Marshal(objectMap)
}

// InformationProtectionKeyword the information type keyword.
type InformationProtectionKeyword struct {
	// Pattern - The keyword pattern.
	Pattern *string `json:"pattern,omitempty"`
	// Custom - Indicates whether the keyword is custom or not.
	Custom *bool `json:"custom,omitempty"`
	// CanBeNumeric - Indicates whether the keyword can be applied on numeric types or not.
	CanBeNumeric *bool `json:"canBeNumeric,omitempty"`
	// Excluded - Indicates whether the keyword is excluded or not.
	Excluded *bool `json:"excluded,omitempty"`
}

// InformationProtectionPolicy information protection policy.
type InformationProtectionPolicy struct {
	autorest.Response `json:"-"`
	// InformationProtectionPolicyProperties - Information protection policy data
	*InformationProtectionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for InformationProtectionPolicy.
func (ipp InformationProtectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipp.InformationProtectionPolicyProperties != nil {
		objectMap["properties"] = ipp.InformationProtectionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InformationProtectionPolicy struct.
func (ipp *InformationProtectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var informationProtectionPolicyProperties InformationProtectionPolicyProperties
				err = json.Unmarshal(*v, &informationProtectionPolicyProperties)
				if err != nil {
					return err
				}
				ipp.InformationProtectionPolicyProperties = &informationProtectionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ipp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ipp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ipp.Type = &typeVar
			}
		}
	}

	return nil
}

// InformationProtectionPolicyList information protection policies response.
type InformationProtectionPolicyList struct {
	autorest.Response `json:"-"`
	// Value - List of information protection policies.
	Value *[]InformationProtectionPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InformationProtectionPolicyList.
func (ippl InformationProtectionPolicyList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ippl.Value != nil {
		objectMap["value"] = ippl.Value
	}
	return json.Marshal(objectMap)
}

// InformationProtectionPolicyListIterator provides access to a complete listing of
// InformationProtectionPolicy values.
type InformationProtectionPolicyListIterator struct {
	i    int
	page InformationProtectionPolicyListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InformationProtectionPolicyListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InformationProtectionPolicyListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InformationProtectionPolicyListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InformationProtectionPolicyListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InformationProtectionPolicyListIterator) Response() InformationProtectionPolicyList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InformationProtectionPolicyListIterator) Value() InformationProtectionPolicy {
	if !iter.page.NotDone() {
		return InformationProtectionPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InformationProtectionPolicyListIterator type.
func NewInformationProtectionPolicyListIterator(page InformationProtectionPolicyListPage) InformationProtectionPolicyListIterator {
	return InformationProtectionPolicyListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ippl InformationProtectionPolicyList) IsEmpty() bool {
	return ippl.Value == nil || len(*ippl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ippl InformationProtectionPolicyList) hasNextLink() bool {
	return ippl.NextLink != nil && len(*ippl.NextLink) != 0
}

// informationProtectionPolicyListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ippl InformationProtectionPolicyList) informationProtectionPolicyListPreparer(ctx context.Context) (*http.Request, error) {
	if !ippl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ippl.NextLink)))
}

// InformationProtectionPolicyListPage contains a page of InformationProtectionPolicy values.
type InformationProtectionPolicyListPage struct {
	fn   func(context.Context, InformationProtectionPolicyList) (InformationProtectionPolicyList, error)
	ippl InformationProtectionPolicyList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InformationProtectionPolicyListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InformationProtectionPolicyListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ippl)
		if err != nil {
			return err
		}
		page.ippl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InformationProtectionPolicyListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InformationProtectionPolicyListPage) NotDone() bool {
	return !page.ippl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InformationProtectionPolicyListPage) Response() InformationProtectionPolicyList {
	return page.ippl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InformationProtectionPolicyListPage) Values() []InformationProtectionPolicy {
	if page.ippl.IsEmpty() {
		return nil
	}
	return *page.ippl.Value
}

// Creates a new instance of the InformationProtectionPolicyListPage type.
func NewInformationProtectionPolicyListPage(cur InformationProtectionPolicyList, getNextPage func(context.Context, InformationProtectionPolicyList) (InformationProtectionPolicyList, error)) InformationProtectionPolicyListPage {
	return InformationProtectionPolicyListPage{
		fn:   getNextPage,
		ippl: cur,
	}
}

// InformationProtectionPolicyProperties describes properties of an information protection policy.
type InformationProtectionPolicyProperties struct {
	// LastModifiedUtc - READ-ONLY; Describes the last UTC time the policy was modified.
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// Version - READ-ONLY; Describes the version of the policy.
	Version *string `json:"version,omitempty"`
	// Labels - Dictionary of sensitivity labels.
	Labels map[string]*SensitivityLabel `json:"labels"`
	// InformationTypes - The sensitivity information types.
	InformationTypes map[string]*InformationType `json:"informationTypes"`
}

// MarshalJSON is the custom marshaler for InformationProtectionPolicyProperties.
func (ippp InformationProtectionPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ippp.Labels != nil {
		objectMap["labels"] = ippp.Labels
	}
	if ippp.InformationTypes != nil {
		objectMap["informationTypes"] = ippp.InformationTypes
	}
	return json.Marshal(objectMap)
}

// InformationType the information type.
type InformationType struct {
	// DisplayName - The name of the information type.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description of the information type.
	Description *string `json:"description,omitempty"`
	// Order - The order of the information type.
	Order *int32 `json:"order,omitempty"`
	// RecommendedLabelID - The recommended label id to be associated with this information type.
	RecommendedLabelID *uuid.UUID `json:"recommendedLabelId,omitempty"`
	// Enabled - Indicates whether the information type is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// Custom - Indicates whether the information type is custom or not.
	Custom *bool `json:"custom,omitempty"`
	// Keywords - The information type keywords.
	Keywords *[]InformationProtectionKeyword `json:"keywords,omitempty"`
}

// JitNetworkAccessPoliciesList ...
type JitNetworkAccessPoliciesList struct {
	autorest.Response `json:"-"`
	Value             *[]JitNetworkAccessPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for JitNetworkAccessPoliciesList.
func (jnapl JitNetworkAccessPoliciesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jnapl.Value != nil {
		objectMap["value"] = jnapl.Value
	}
	return json.Marshal(objectMap)
}

// JitNetworkAccessPoliciesListIterator provides access to a complete listing of JitNetworkAccessPolicy
// values.
type JitNetworkAccessPoliciesListIterator struct {
	i    int
	page JitNetworkAccessPoliciesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JitNetworkAccessPoliciesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JitNetworkAccessPoliciesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JitNetworkAccessPoliciesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JitNetworkAccessPoliciesListIterator) Response() JitNetworkAccessPoliciesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JitNetworkAccessPoliciesListIterator) Value() JitNetworkAccessPolicy {
	if !iter.page.NotDone() {
		return JitNetworkAccessPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JitNetworkAccessPoliciesListIterator type.
func NewJitNetworkAccessPoliciesListIterator(page JitNetworkAccessPoliciesListPage) JitNetworkAccessPoliciesListIterator {
	return JitNetworkAccessPoliciesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jnapl JitNetworkAccessPoliciesList) IsEmpty() bool {
	return jnapl.Value == nil || len(*jnapl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jnapl JitNetworkAccessPoliciesList) hasNextLink() bool {
	return jnapl.NextLink != nil && len(*jnapl.NextLink) != 0
}

// jitNetworkAccessPoliciesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jnapl JitNetworkAccessPoliciesList) jitNetworkAccessPoliciesListPreparer(ctx context.Context) (*http.Request, error) {
	if !jnapl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jnapl.NextLink)))
}

// JitNetworkAccessPoliciesListPage contains a page of JitNetworkAccessPolicy values.
type JitNetworkAccessPoliciesListPage struct {
	fn    func(context.Context, JitNetworkAccessPoliciesList) (JitNetworkAccessPoliciesList, error)
	jnapl JitNetworkAccessPoliciesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JitNetworkAccessPoliciesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jnapl)
		if err != nil {
			return err
		}
		page.jnapl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JitNetworkAccessPoliciesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JitNetworkAccessPoliciesListPage) NotDone() bool {
	return !page.jnapl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JitNetworkAccessPoliciesListPage) Response() JitNetworkAccessPoliciesList {
	return page.jnapl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JitNetworkAccessPoliciesListPage) Values() []JitNetworkAccessPolicy {
	if page.jnapl.IsEmpty() {
		return nil
	}
	return *page.jnapl.Value
}

// Creates a new instance of the JitNetworkAccessPoliciesListPage type.
func NewJitNetworkAccessPoliciesListPage(cur JitNetworkAccessPoliciesList, getNextPage func(context.Context, JitNetworkAccessPoliciesList) (JitNetworkAccessPoliciesList, error)) JitNetworkAccessPoliciesListPage {
	return JitNetworkAccessPoliciesListPage{
		fn:    getNextPage,
		jnapl: cur,
	}
}

// JitNetworkAccessPolicy ...
type JitNetworkAccessPolicy struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Kind - Kind of the resource
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location                          *string `json:"location,omitempty"`
	*JitNetworkAccessPolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for JitNetworkAccessPolicy.
func (jnap JitNetworkAccessPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jnap.Kind != nil {
		objectMap["kind"] = jnap.Kind
	}
	if jnap.JitNetworkAccessPolicyProperties != nil {
		objectMap["properties"] = jnap.JitNetworkAccessPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JitNetworkAccessPolicy struct.
func (jnap *JitNetworkAccessPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jnap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jnap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jnap.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				jnap.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				jnap.Location = &location
			}
		case "properties":
			if v != nil {
				var jitNetworkAccessPolicyProperties JitNetworkAccessPolicyProperties
				err = json.Unmarshal(*v, &jitNetworkAccessPolicyProperties)
				if err != nil {
					return err
				}
				jnap.JitNetworkAccessPolicyProperties = &jitNetworkAccessPolicyProperties
			}
		}
	}

	return nil
}

// JitNetworkAccessPolicyInitiatePort ...
type JitNetworkAccessPolicyInitiatePort struct {
	Number *int32 `json:"number,omitempty"`
	// AllowedSourceAddressPrefix - Source of the allowed traffic. If omitted, the request will be for the source IP address of the initiate request.
	AllowedSourceAddressPrefix *string `json:"allowedSourceAddressPrefix,omitempty"`
	// EndTimeUtc - The time to close the request in UTC
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
}

// JitNetworkAccessPolicyInitiateRequest ...
type JitNetworkAccessPolicyInitiateRequest struct {
	// VirtualMachines - A list of virtual machines & ports to open access for
	VirtualMachines *[]JitNetworkAccessPolicyInitiateVirtualMachine `json:"virtualMachines,omitempty"`
	// Justification - The justification for making the initiate request
	Justification *string `json:"justification,omitempty"`
}

// JitNetworkAccessPolicyInitiateVirtualMachine ...
type JitNetworkAccessPolicyInitiateVirtualMachine struct {
	// ID - Resource ID of the virtual machine that is linked to this policy
	ID *string `json:"id,omitempty"`
	// Ports - The ports to open for the resource with the `id`
	Ports *[]JitNetworkAccessPolicyInitiatePort `json:"ports,omitempty"`
}

// JitNetworkAccessPolicyProperties ...
type JitNetworkAccessPolicyProperties struct {
	// VirtualMachines - Configurations for Microsoft.Compute/virtualMachines resource type.
	VirtualMachines *[]JitNetworkAccessPolicyVirtualMachine `json:"virtualMachines,omitempty"`
	Requests        *[]JitNetworkAccessRequest              `json:"requests,omitempty"`
	// ProvisioningState - READ-ONLY; Gets the provisioning state of the Just-in-Time policy.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for JitNetworkAccessPolicyProperties.
func (jnapp JitNetworkAccessPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jnapp.VirtualMachines != nil {
		objectMap["virtualMachines"] = jnapp.VirtualMachines
	}
	if jnapp.Requests != nil {
		objectMap["requests"] = jnapp.Requests
	}
	return json.Marshal(objectMap)
}

// JitNetworkAccessPolicyVirtualMachine ...
type JitNetworkAccessPolicyVirtualMachine struct {
	// ID - Resource ID of the virtual machine that is linked to this policy
	ID *string `json:"id,omitempty"`
	// Ports - Port configurations for the virtual machine
	Ports *[]JitNetworkAccessPortRule `json:"ports,omitempty"`
	// PublicIPAddress - Public IP address of the Azure Firewall that is linked to this policy, if applicable
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
}

// JitNetworkAccessPortRule ...
type JitNetworkAccessPortRule struct {
	Number *int32 `json:"number,omitempty"`
	// Protocol - Possible values include: 'TCP', 'UDP', 'All'
	Protocol Protocol `json:"protocol,omitempty"`
	// AllowedSourceAddressPrefix - Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
	AllowedSourceAddressPrefix *string `json:"allowedSourceAddressPrefix,omitempty"`
	// AllowedSourceAddressPrefixes - Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
	AllowedSourceAddressPrefixes *[]string `json:"allowedSourceAddressPrefixes,omitempty"`
	// MaxRequestAccessDuration - Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
	MaxRequestAccessDuration *string `json:"maxRequestAccessDuration,omitempty"`
}

// JitNetworkAccessRequest ...
type JitNetworkAccessRequest struct {
	autorest.Response `json:"-"`
	VirtualMachines   *[]JitNetworkAccessRequestVirtualMachine `json:"virtualMachines,omitempty"`
	// StartTimeUtc - The start time of the request in UTC
	StartTimeUtc *date.Time `json:"startTimeUtc,omitempty"`
	// Requestor - The identity of the person who made the request
	Requestor *string `json:"requestor,omitempty"`
	// Justification - The justification for making the initiate request
	Justification *string `json:"justification,omitempty"`
}

// JitNetworkAccessRequestPort ...
type JitNetworkAccessRequestPort struct {
	Number *int32 `json:"number,omitempty"`
	// AllowedSourceAddressPrefix - Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
	AllowedSourceAddressPrefix *string `json:"allowedSourceAddressPrefix,omitempty"`
	// AllowedSourceAddressPrefixes - Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
	AllowedSourceAddressPrefixes *[]string `json:"allowedSourceAddressPrefixes,omitempty"`
	// EndTimeUtc - The date & time at which the request ends in UTC
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
	// Status - The status of the port. Possible values include: 'Revoked', 'Initiated'
	Status Status `json:"status,omitempty"`
	// StatusReason - A description of why the `status` has its value. Possible values include: 'StatusReasonExpired', 'StatusReasonUserRequested', 'StatusReasonNewerRequestInitiated'
	StatusReason StatusReason `json:"statusReason,omitempty"`
	// MappedPort - The port which is mapped to this port's `number` in the Azure Firewall, if applicable
	MappedPort *int32 `json:"mappedPort,omitempty"`
}

// JitNetworkAccessRequestVirtualMachine ...
type JitNetworkAccessRequestVirtualMachine struct {
	// ID - Resource ID of the virtual machine that is linked to this policy
	ID *string `json:"id,omitempty"`
	// Ports - The ports that were opened for the virtual machine
	Ports *[]JitNetworkAccessRequestPort `json:"ports,omitempty"`
}

// Kind describes an Azure resource with kind
type Kind struct {
	// Kind - Kind of the resource
	Kind *string `json:"kind,omitempty"`
}

// BasicListCustomAlertRule a List custom alert rule.
type BasicListCustomAlertRule interface {
	AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool)
	AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool)
	AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool)
	AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool)
	AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool)
	AsProcessNotAllowed() (*ProcessNotAllowed, bool)
	AsListCustomAlertRule() (*ListCustomAlertRule, bool)
}

// ListCustomAlertRule a List custom alert rule.
type ListCustomAlertRule struct {
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

func unmarshalBasicListCustomAlertRule(body []byte) (BasicListCustomAlertRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleType"] {
	case string(RuleTypeAllowlistCustomAlertRule):
		var acar AllowlistCustomAlertRule
		err := json.Unmarshal(body, &acar)
		return acar, err
	case string(RuleTypeDenylistCustomAlertRule):
		var dcar DenylistCustomAlertRule
		err := json.Unmarshal(body, &dcar)
		return dcar, err
	case string(RuleTypeConnectionToIPNotAllowed):
		var ctina ConnectionToIPNotAllowed
		err := json.Unmarshal(body, &ctina)
		return ctina, err
	case string(RuleTypeLocalUserNotAllowed):
		var luna LocalUserNotAllowed
		err := json.Unmarshal(body, &luna)
		return luna, err
	case string(RuleTypeProcessNotAllowed):
		var pna ProcessNotAllowed
		err := json.Unmarshal(body, &pna)
		return pna, err
	default:
		var lcar ListCustomAlertRule
		err := json.Unmarshal(body, &lcar)
		return lcar, err
	}
}
func unmarshalBasicListCustomAlertRuleArray(body []byte) ([]BasicListCustomAlertRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	lcarArray := make([]BasicListCustomAlertRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		lcar, err := unmarshalBasicListCustomAlertRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		lcarArray[index] = lcar
	}
	return lcarArray, nil
}

// MarshalJSON is the custom marshaler for ListCustomAlertRule.
func (lcar ListCustomAlertRule) MarshalJSON() ([]byte, error) {
	lcar.RuleType = RuleTypeListCustomAlertRule
	objectMap := make(map[string]interface{})
	if lcar.IsEnabled != nil {
		objectMap["isEnabled"] = lcar.IsEnabled
	}
	if lcar.RuleType != "" {
		objectMap["ruleType"] = lcar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return &lcar, true
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return &lcar, true
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &lcar, true
}

// LocalUserNotAllowed login by a local user that isn't allowed. Allow list consists of login names to
// allow.
type LocalUserNotAllowed struct {
	// AllowlistValues - The values to allow. The format of the values depends on the rule type.
	AllowlistValues *[]string `json:"allowlistValues,omitempty"`
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) MarshalJSON() ([]byte, error) {
	luna.RuleType = RuleTypeLocalUserNotAllowed
	objectMap := make(map[string]interface{})
	if luna.AllowlistValues != nil {
		objectMap["allowlistValues"] = luna.AllowlistValues
	}
	if luna.IsEnabled != nil {
		objectMap["isEnabled"] = luna.IsEnabled
	}
	if luna.RuleType != "" {
		objectMap["ruleType"] = luna.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return &luna, true
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return &luna, true
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return &luna, true
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &luna, true
}

// Location describes an Azure resource with location
type Location struct {
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for Location.
func (l Location) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MqttC2DMessagesNotInAllowedRange number of cloud to device messages (MQTT protocol) is not in allowed
// range.
type MqttC2DMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	mcmniar.RuleType = RuleTypeMqttC2DMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if mcmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = mcmniar.TimeWindowSize
	}
	if mcmniar.MinThreshold != nil {
		objectMap["minThreshold"] = mcmniar.MinThreshold
	}
	if mcmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = mcmniar.MaxThreshold
	}
	if mcmniar.IsEnabled != nil {
		objectMap["isEnabled"] = mcmniar.IsEnabled
	}
	if mcmniar.RuleType != "" {
		objectMap["ruleType"] = mcmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &mcmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &mcmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return &mcmniar, true
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &mcmniar, true
}

// MqttC2DRejectedMessagesNotInAllowedRange number of rejected cloud to device messages (MQTT protocol) is
// not in allowed range.
type MqttC2DRejectedMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	mcrmniar.RuleType = RuleTypeMqttC2DRejectedMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if mcrmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = mcrmniar.TimeWindowSize
	}
	if mcrmniar.MinThreshold != nil {
		objectMap["minThreshold"] = mcrmniar.MinThreshold
	}
	if mcrmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = mcrmniar.MaxThreshold
	}
	if mcrmniar.IsEnabled != nil {
		objectMap["isEnabled"] = mcrmniar.IsEnabled
	}
	if mcrmniar.RuleType != "" {
		objectMap["ruleType"] = mcrmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &mcrmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &mcrmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return &mcrmniar, true
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &mcrmniar, true
}

// MqttD2CMessagesNotInAllowedRange number of device to cloud messages (MQTT protocol) is not in allowed
// range.
type MqttD2CMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	mdmniar.RuleType = RuleTypeMqttD2CMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if mdmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = mdmniar.TimeWindowSize
	}
	if mdmniar.MinThreshold != nil {
		objectMap["minThreshold"] = mdmniar.MinThreshold
	}
	if mdmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = mdmniar.MaxThreshold
	}
	if mdmniar.IsEnabled != nil {
		objectMap["isEnabled"] = mdmniar.IsEnabled
	}
	if mdmniar.RuleType != "" {
		objectMap["ruleType"] = mdmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &mdmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &mdmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return &mdmniar, true
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &mdmniar, true
}

// BasicOnPremiseResourceDetails details of the On Premise resource that was assessed
type BasicOnPremiseResourceDetails interface {
	AsOnPremiseSQLResourceDetails() (*OnPremiseSQLResourceDetails, bool)
	AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool)
}

// OnPremiseResourceDetails details of the On Premise resource that was assessed
type OnPremiseResourceDetails struct {
	// WorkspaceID - Azure resource Id of the workspace the machine is attached to
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// Vmuuid - The unique Id of the machine
	Vmuuid *string `json:"vmuuid,omitempty"`
	// SourceComputerID - The oms agent Id installed on the machine
	SourceComputerID *string `json:"sourceComputerId,omitempty"`
	// MachineName - The name of the machine
	MachineName *string `json:"machineName,omitempty"`
	// Source - Possible values include: 'SourceResourceDetails', 'SourceOnPremiseSQL', 'SourceOnPremise', 'SourceAzure'
	Source Source `json:"source,omitempty"`
}

func unmarshalBasicOnPremiseResourceDetails(body []byte) (BasicOnPremiseResourceDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["source"] {
	case string(SourceOnPremiseSQL):
		var opsrd OnPremiseSQLResourceDetails
		err := json.Unmarshal(body, &opsrd)
		return opsrd, err
	default:
		var oprd OnPremiseResourceDetails
		err := json.Unmarshal(body, &oprd)
		return oprd, err
	}
}
func unmarshalBasicOnPremiseResourceDetailsArray(body []byte) ([]BasicOnPremiseResourceDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	oprdArray := make([]BasicOnPremiseResourceDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		oprd, err := unmarshalBasicOnPremiseResourceDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		oprdArray[index] = oprd
	}
	return oprdArray, nil
}

// MarshalJSON is the custom marshaler for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) MarshalJSON() ([]byte, error) {
	oprd.Source = SourceOnPremise
	objectMap := make(map[string]interface{})
	if oprd.WorkspaceID != nil {
		objectMap["workspaceId"] = oprd.WorkspaceID
	}
	if oprd.Vmuuid != nil {
		objectMap["vmuuid"] = oprd.Vmuuid
	}
	if oprd.SourceComputerID != nil {
		objectMap["sourceComputerId"] = oprd.SourceComputerID
	}
	if oprd.MachineName != nil {
		objectMap["machineName"] = oprd.MachineName
	}
	if oprd.Source != "" {
		objectMap["source"] = oprd.Source
	}
	return json.Marshal(objectMap)
}

// AsOnPremiseSQLResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsOnPremiseSQLResourceDetails() (*OnPremiseSQLResourceDetails, bool) {
	return nil, false
}

// AsOnPremiseResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool) {
	return &oprd, true
}

// AsBasicOnPremiseResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsBasicOnPremiseResourceDetails() (BasicOnPremiseResourceDetails, bool) {
	return &oprd, true
}

// AsAzureResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsAzureResourceDetails() (*AzureResourceDetails, bool) {
	return nil, false
}

// AsResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsResourceDetails() (*ResourceDetails, bool) {
	return nil, false
}

// AsBasicResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsBasicResourceDetails() (BasicResourceDetails, bool) {
	return &oprd, true
}

// OnPremiseSQLResourceDetails details of the On Premise Sql resource that was assessed
type OnPremiseSQLResourceDetails struct {
	// ServerName - The Sql server name installed on the machine
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - The Sql database name installed on the machine
	DatabaseName *string `json:"databaseName,omitempty"`
	// WorkspaceID - Azure resource Id of the workspace the machine is attached to
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// Vmuuid - The unique Id of the machine
	Vmuuid *string `json:"vmuuid,omitempty"`
	// SourceComputerID - The oms agent Id installed on the machine
	SourceComputerID *string `json:"sourceComputerId,omitempty"`
	// MachineName - The name of the machine
	MachineName *string `json:"machineName,omitempty"`
	// Source - Possible values include: 'SourceResourceDetails', 'SourceOnPremiseSQL', 'SourceOnPremise', 'SourceAzure'
	Source Source `json:"source,omitempty"`
}

// MarshalJSON is the custom marshaler for OnPremiseSQLResourceDetails.
func (opsrd OnPremiseSQLResourceDetails) MarshalJSON() ([]byte, error) {
	opsrd.Source = SourceOnPremiseSQL
	objectMap := make(map[string]interface{})
	if opsrd.ServerName != nil {
		objectMap["serverName"] = opsrd.ServerName
	}
	if opsrd.DatabaseName != nil {
		objectMap["databaseName"] = opsrd.DatabaseName
	}
	if opsrd.WorkspaceID != nil {
		objectMap["workspaceId"] = opsrd.WorkspaceID
	}
	if opsrd.Vmuuid != nil {
		objectMap["vmuuid"] = opsrd.Vmuuid
	}
	if opsrd.SourceComputerID != nil {
		objectMap["sourceComputerId"] = opsrd.SourceComputerID
	}
	if opsrd.MachineName != nil {
		objectMap["machineName"] = opsrd.MachineName
	}
	if opsrd.Source != "" {
		objectMap["source"] = opsrd.Source
	}
	return json.Marshal(objectMap)
}

// AsOnPremiseSQLResourceDetails is the BasicResourceDetails implementation for OnPremiseSQLResourceDetails.
func (opsrd OnPremiseSQLResourceDetails) AsOnPremiseSQLResourceDetails() (*OnPremiseSQLResourceDetails, bool) {
	return &opsrd, true
}

// AsOnPremiseResourceDetails is the BasicResourceDetails implementation for OnPremiseSQLResourceDetails.
func (opsrd OnPremiseSQLResourceDetails) AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool) {
	return nil, false
}

// AsBasicOnPremiseResourceDetails is the BasicResourceDetails implementation for OnPremiseSQLResourceDetails.
func (opsrd OnPremiseSQLResourceDetails) AsBasicOnPremiseResourceDetails() (BasicOnPremiseResourceDetails, bool) {
	return &opsrd, true
}

// AsAzureResourceDetails is the BasicResourceDetails implementation for OnPremiseSQLResourceDetails.
func (opsrd OnPremiseSQLResourceDetails) AsAzureResourceDetails() (*AzureResourceDetails, bool) {
	return nil, false
}

// AsResourceDetails is the BasicResourceDetails implementation for OnPremiseSQLResourceDetails.
func (opsrd OnPremiseSQLResourceDetails) AsResourceDetails() (*ResourceDetails, bool) {
	return nil, false
}

// AsBasicResourceDetails is the BasicResourceDetails implementation for OnPremiseSQLResourceDetails.
func (opsrd OnPremiseSQLResourceDetails) AsBasicResourceDetails() (BasicResourceDetails, bool) {
	return &opsrd, true
}

// Operation possible operation in the REST API of Microsoft.Security
type Operation struct {
	// Name - READ-ONLY; Name of the operation
	Name *string `json:"name,omitempty"`
	// Origin - READ-ONLY; Where the operation is originated
	Origin  *string           `json:"origin,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay security operation display
type OperationDisplay struct {
	// Provider - READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The display name of the security operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (od OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationList list of possible operations for Microsoft.Security resource provider
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - List of Security operations
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationList.
func (ol OperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ol.Value != nil {
		objectMap["value"] = ol.Value
	}
	return json.Marshal(objectMap)
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// PathRecommendation represents a path that is recommended to be allowed and its properties
type PathRecommendation struct {
	// Path - The full path to whitelist
	Path *string `json:"path,omitempty"`
	// Action - Possible values include: 'Recommended', 'Add', 'Remove'
	Action Action `json:"action,omitempty"`
	// Type - Possible values include: 'File', 'FileHash', 'PublisherSignature', 'ProductSignature', 'BinarySignature', 'VersionAndAboveSignature'
	Type          Type           `json:"type,omitempty"`
	PublisherInfo *PublisherInfo `json:"publisherInfo,omitempty"`
	// Common - Whether the path is commonly run on the machine
	Common    *bool                 `json:"common,omitempty"`
	UserSids  *[]string             `json:"userSids,omitempty"`
	Usernames *[]UserRecommendation `json:"usernames,omitempty"`
	// FileType - Possible values include: 'FileTypeExe', 'FileTypeDll', 'FileTypeMsi', 'FileTypeScript', 'FileTypeExecutable', 'FileTypeUnknown'
	FileType FileType `json:"fileType,omitempty"`
	// ConfigurationStatus - Possible values include: 'ConfigurationStatus1Configured', 'ConfigurationStatus1NotConfigured', 'ConfigurationStatus1InProgress', 'ConfigurationStatus1Failed', 'ConfigurationStatus1NoStatus'
	ConfigurationStatus ConfigurationStatus1 `json:"configurationStatus,omitempty"`
}

// Pricing pricing tier will be applied for the scope based on the resource ID
type Pricing struct {
	autorest.Response `json:"-"`
	// PricingProperties - Pricing data
	*PricingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Pricing.
func (p Pricing) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PricingProperties != nil {
		objectMap["properties"] = p.PricingProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Pricing struct.
func (p *Pricing) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var pricingProperties PricingProperties
				err = json.Unmarshal(*v, &pricingProperties)
				if err != nil {
					return err
				}
				p.PricingProperties = &pricingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// PricingList list of pricing configurations response
type PricingList struct {
	autorest.Response `json:"-"`
	// Value - List of pricing configurations
	Value *[]Pricing `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PricingList.
func (pl PricingList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pl.Value != nil {
		objectMap["value"] = pl.Value
	}
	return json.Marshal(objectMap)
}

// PricingListIterator provides access to a complete listing of Pricing values.
type PricingListIterator struct {
	i    int
	page PricingListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PricingListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PricingListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PricingListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PricingListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PricingListIterator) Response() PricingList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PricingListIterator) Value() Pricing {
	if !iter.page.NotDone() {
		return Pricing{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PricingListIterator type.
func NewPricingListIterator(page PricingListPage) PricingListIterator {
	return PricingListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pl PricingList) IsEmpty() bool {
	return pl.Value == nil || len(*pl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pl PricingList) hasNextLink() bool {
	return pl.NextLink != nil && len(*pl.NextLink) != 0
}

// pricingListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pl PricingList) pricingListPreparer(ctx context.Context) (*http.Request, error) {
	if !pl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pl.NextLink)))
}

// PricingListPage contains a page of Pricing values.
type PricingListPage struct {
	fn func(context.Context, PricingList) (PricingList, error)
	pl PricingList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PricingListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PricingListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pl)
		if err != nil {
			return err
		}
		page.pl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PricingListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PricingListPage) NotDone() bool {
	return !page.pl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PricingListPage) Response() PricingList {
	return page.pl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PricingListPage) Values() []Pricing {
	if page.pl.IsEmpty() {
		return nil
	}
	return *page.pl.Value
}

// Creates a new instance of the PricingListPage type.
func NewPricingListPage(cur PricingList, getNextPage func(context.Context, PricingList) (PricingList, error)) PricingListPage {
	return PricingListPage{
		fn: getNextPage,
		pl: cur,
	}
}

// PricingProperties pricing data
type PricingProperties struct {
	// PricingTier - Pricing tier type. Possible values include: 'Free', 'Standard'
	PricingTier PricingTier `json:"pricingTier,omitempty"`
}

// ProcessNotAllowed execution of a process that isn't allowed. Allow list consists of process names to
// allow.
type ProcessNotAllowed struct {
	// AllowlistValues - The values to allow. The format of the values depends on the rule type.
	AllowlistValues *[]string `json:"allowlistValues,omitempty"`
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessNotAllowed.
func (pna ProcessNotAllowed) MarshalJSON() ([]byte, error) {
	pna.RuleType = RuleTypeProcessNotAllowed
	objectMap := make(map[string]interface{})
	if pna.AllowlistValues != nil {
		objectMap["allowlistValues"] = pna.AllowlistValues
	}
	if pna.IsEnabled != nil {
		objectMap["isEnabled"] = pna.IsEnabled
	}
	if pna.RuleType != "" {
		objectMap["ruleType"] = pna.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return &pna, true
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return &pna, true
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return &pna, true
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &pna, true
}

// ProtectionMode the protection mode of the collection/file types. Exe/Msi/Script are used for Windows,
// Executable is used for Linux.
type ProtectionMode struct {
	// Exe - Possible values include: 'ExeAudit', 'ExeEnforce', 'ExeNone'
	Exe Exe `json:"exe,omitempty"`
	// Msi - Possible values include: 'MsiAudit', 'MsiEnforce', 'MsiNone'
	Msi Msi `json:"msi,omitempty"`
	// Script - Possible values include: 'ScriptAudit', 'ScriptEnforce', 'ScriptNone'
	Script Script `json:"script,omitempty"`
	// Executable - Possible values include: 'ExecutableAudit', 'ExecutableEnforce', 'ExecutableNone'
	Executable Executable `json:"executable,omitempty"`
}

// ProxyServerProperties for a non-Azure machine that is not connected directly to the internet, specify a
// proxy server that the non-Azure machine can use.
type ProxyServerProperties struct {
	// IP - Proxy server IP
	IP *string `json:"ip,omitempty"`
	// Port - Proxy server port
	Port *string `json:"port,omitempty"`
}

// PublisherInfo represents the publisher information of a process/rule
type PublisherInfo struct {
	// PublisherName - The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
	PublisherName *string `json:"publisherName,omitempty"`
	// ProductName - The product name taken from the file's version resource
	ProductName *string `json:"productName,omitempty"`
	// BinaryName - The "OriginalName" field taken from the file's version resource
	BinaryName *string `json:"binaryName,omitempty"`
	// Version - The binary file version taken from the file's version resource
	Version *string `json:"version,omitempty"`
}

// QueryCheck the rule query details.
type QueryCheck struct {
	// Query - The rule query.
	Query *string `json:"query,omitempty"`
	// ExpectedResult - Expected result.
	ExpectedResult *[][]string `json:"expectedResult,omitempty"`
	// ColumnNames - Column names of expected result.
	ColumnNames *[]string `json:"columnNames,omitempty"`
}

// QueuePurgesNotInAllowedRange number of device queue purges is not in allowed range.
type QueuePurgesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	qpniar.RuleType = RuleTypeQueuePurgesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if qpniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = qpniar.TimeWindowSize
	}
	if qpniar.MinThreshold != nil {
		objectMap["minThreshold"] = qpniar.MinThreshold
	}
	if qpniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = qpniar.MaxThreshold
	}
	if qpniar.IsEnabled != nil {
		objectMap["isEnabled"] = qpniar.IsEnabled
	}
	if qpniar.RuleType != "" {
		objectMap["ruleType"] = qpniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &qpniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &qpniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return &qpniar, true
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &qpniar, true
}

// RegulatoryComplianceAssessment regulatory compliance assessment details and state
type RegulatoryComplianceAssessment struct {
	autorest.Response `json:"-"`
	// RegulatoryComplianceAssessmentProperties - Regulatory compliance assessment data
	*RegulatoryComplianceAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceAssessment.
func (rca RegulatoryComplianceAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rca.RegulatoryComplianceAssessmentProperties != nil {
		objectMap["properties"] = rca.RegulatoryComplianceAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegulatoryComplianceAssessment struct.
func (rca *RegulatoryComplianceAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var regulatoryComplianceAssessmentProperties RegulatoryComplianceAssessmentProperties
				err = json.Unmarshal(*v, &regulatoryComplianceAssessmentProperties)
				if err != nil {
					return err
				}
				rca.RegulatoryComplianceAssessmentProperties = &regulatoryComplianceAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rca.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rca.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rca.Type = &typeVar
			}
		}
	}

	return nil
}

// RegulatoryComplianceAssessmentList list of regulatory compliance assessment response
type RegulatoryComplianceAssessmentList struct {
	autorest.Response `json:"-"`
	Value             *[]RegulatoryComplianceAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceAssessmentList.
func (rcal RegulatoryComplianceAssessmentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcal.Value != nil {
		objectMap["value"] = rcal.Value
	}
	return json.Marshal(objectMap)
}

// RegulatoryComplianceAssessmentListIterator provides access to a complete listing of
// RegulatoryComplianceAssessment values.
type RegulatoryComplianceAssessmentListIterator struct {
	i    int
	page RegulatoryComplianceAssessmentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegulatoryComplianceAssessmentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceAssessmentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegulatoryComplianceAssessmentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegulatoryComplianceAssessmentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegulatoryComplianceAssessmentListIterator) Response() RegulatoryComplianceAssessmentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegulatoryComplianceAssessmentListIterator) Value() RegulatoryComplianceAssessment {
	if !iter.page.NotDone() {
		return RegulatoryComplianceAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegulatoryComplianceAssessmentListIterator type.
func NewRegulatoryComplianceAssessmentListIterator(page RegulatoryComplianceAssessmentListPage) RegulatoryComplianceAssessmentListIterator {
	return RegulatoryComplianceAssessmentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rcal RegulatoryComplianceAssessmentList) IsEmpty() bool {
	return rcal.Value == nil || len(*rcal.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rcal RegulatoryComplianceAssessmentList) hasNextLink() bool {
	return rcal.NextLink != nil && len(*rcal.NextLink) != 0
}

// regulatoryComplianceAssessmentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rcal RegulatoryComplianceAssessmentList) regulatoryComplianceAssessmentListPreparer(ctx context.Context) (*http.Request, error) {
	if !rcal.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rcal.NextLink)))
}

// RegulatoryComplianceAssessmentListPage contains a page of RegulatoryComplianceAssessment values.
type RegulatoryComplianceAssessmentListPage struct {
	fn   func(context.Context, RegulatoryComplianceAssessmentList) (RegulatoryComplianceAssessmentList, error)
	rcal RegulatoryComplianceAssessmentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegulatoryComplianceAssessmentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceAssessmentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rcal)
		if err != nil {
			return err
		}
		page.rcal = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegulatoryComplianceAssessmentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegulatoryComplianceAssessmentListPage) NotDone() bool {
	return !page.rcal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegulatoryComplianceAssessmentListPage) Response() RegulatoryComplianceAssessmentList {
	return page.rcal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegulatoryComplianceAssessmentListPage) Values() []RegulatoryComplianceAssessment {
	if page.rcal.IsEmpty() {
		return nil
	}
	return *page.rcal.Value
}

// Creates a new instance of the RegulatoryComplianceAssessmentListPage type.
func NewRegulatoryComplianceAssessmentListPage(cur RegulatoryComplianceAssessmentList, getNextPage func(context.Context, RegulatoryComplianceAssessmentList) (RegulatoryComplianceAssessmentList, error)) RegulatoryComplianceAssessmentListPage {
	return RegulatoryComplianceAssessmentListPage{
		fn:   getNextPage,
		rcal: cur,
	}
}

// RegulatoryComplianceAssessmentProperties regulatory compliance assessment data
type RegulatoryComplianceAssessmentProperties struct {
	// Description - READ-ONLY; The description of the regulatory compliance assessment
	Description *string `json:"description,omitempty"`
	// AssessmentType - READ-ONLY; The expected type of assessment contained in the AssessmentDetailsLink
	AssessmentType *string `json:"assessmentType,omitempty"`
	// AssessmentDetailsLink - READ-ONLY; Link to more detailed assessment results data. The response type will be according to the assessmentType field
	AssessmentDetailsLink *string `json:"assessmentDetailsLink,omitempty"`
	// State - Aggregative state based on the assessment's scanned resources states. Possible values include: 'StatePassed', 'StateFailed', 'StateSkipped', 'StateUnsupported'
	State State `json:"state,omitempty"`
	// PassedResources - READ-ONLY; The given assessment's related resources count with passed state.
	PassedResources *int32 `json:"passedResources,omitempty"`
	// FailedResources - READ-ONLY; The given assessment's related resources count with failed state.
	FailedResources *int32 `json:"failedResources,omitempty"`
	// SkippedResources - READ-ONLY; The given assessment's related resources count with skipped state.
	SkippedResources *int32 `json:"skippedResources,omitempty"`
	// UnsupportedResources - READ-ONLY; The given assessment's related resources count with unsupported state.
	UnsupportedResources *int32 `json:"unsupportedResources,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceAssessmentProperties.
func (rcap RegulatoryComplianceAssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcap.State != "" {
		objectMap["state"] = rcap.State
	}
	return json.Marshal(objectMap)
}

// RegulatoryComplianceControl regulatory compliance control details and state
type RegulatoryComplianceControl struct {
	autorest.Response `json:"-"`
	// RegulatoryComplianceControlProperties - Regulatory compliance control data
	*RegulatoryComplianceControlProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceControl.
func (rcc RegulatoryComplianceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcc.RegulatoryComplianceControlProperties != nil {
		objectMap["properties"] = rcc.RegulatoryComplianceControlProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegulatoryComplianceControl struct.
func (rcc *RegulatoryComplianceControl) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var regulatoryComplianceControlProperties RegulatoryComplianceControlProperties
				err = json.Unmarshal(*v, &regulatoryComplianceControlProperties)
				if err != nil {
					return err
				}
				rcc.RegulatoryComplianceControlProperties = &regulatoryComplianceControlProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rcc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rcc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rcc.Type = &typeVar
			}
		}
	}

	return nil
}

// RegulatoryComplianceControlList list of regulatory compliance controls response
type RegulatoryComplianceControlList struct {
	autorest.Response `json:"-"`
	// Value - List of regulatory compliance controls
	Value *[]RegulatoryComplianceControl `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceControlList.
func (rccl RegulatoryComplianceControlList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rccl.Value != nil {
		objectMap["value"] = rccl.Value
	}
	return json.Marshal(objectMap)
}

// RegulatoryComplianceControlListIterator provides access to a complete listing of
// RegulatoryComplianceControl values.
type RegulatoryComplianceControlListIterator struct {
	i    int
	page RegulatoryComplianceControlListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegulatoryComplianceControlListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceControlListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegulatoryComplianceControlListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegulatoryComplianceControlListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegulatoryComplianceControlListIterator) Response() RegulatoryComplianceControlList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegulatoryComplianceControlListIterator) Value() RegulatoryComplianceControl {
	if !iter.page.NotDone() {
		return RegulatoryComplianceControl{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegulatoryComplianceControlListIterator type.
func NewRegulatoryComplianceControlListIterator(page RegulatoryComplianceControlListPage) RegulatoryComplianceControlListIterator {
	return RegulatoryComplianceControlListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rccl RegulatoryComplianceControlList) IsEmpty() bool {
	return rccl.Value == nil || len(*rccl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rccl RegulatoryComplianceControlList) hasNextLink() bool {
	return rccl.NextLink != nil && len(*rccl.NextLink) != 0
}

// regulatoryComplianceControlListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rccl RegulatoryComplianceControlList) regulatoryComplianceControlListPreparer(ctx context.Context) (*http.Request, error) {
	if !rccl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rccl.NextLink)))
}

// RegulatoryComplianceControlListPage contains a page of RegulatoryComplianceControl values.
type RegulatoryComplianceControlListPage struct {
	fn   func(context.Context, RegulatoryComplianceControlList) (RegulatoryComplianceControlList, error)
	rccl RegulatoryComplianceControlList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegulatoryComplianceControlListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceControlListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rccl)
		if err != nil {
			return err
		}
		page.rccl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegulatoryComplianceControlListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegulatoryComplianceControlListPage) NotDone() bool {
	return !page.rccl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegulatoryComplianceControlListPage) Response() RegulatoryComplianceControlList {
	return page.rccl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegulatoryComplianceControlListPage) Values() []RegulatoryComplianceControl {
	if page.rccl.IsEmpty() {
		return nil
	}
	return *page.rccl.Value
}

// Creates a new instance of the RegulatoryComplianceControlListPage type.
func NewRegulatoryComplianceControlListPage(cur RegulatoryComplianceControlList, getNextPage func(context.Context, RegulatoryComplianceControlList) (RegulatoryComplianceControlList, error)) RegulatoryComplianceControlListPage {
	return RegulatoryComplianceControlListPage{
		fn:   getNextPage,
		rccl: cur,
	}
}

// RegulatoryComplianceControlProperties regulatory compliance control data
type RegulatoryComplianceControlProperties struct {
	// Description - READ-ONLY; The description of the regulatory compliance control
	Description *string `json:"description,omitempty"`
	// State - Aggregative state based on the control's supported assessments states. Possible values include: 'StatePassed', 'StateFailed', 'StateSkipped', 'StateUnsupported'
	State State `json:"state,omitempty"`
	// PassedAssessments - READ-ONLY; The number of supported regulatory compliance assessments of the given control with a passed state
	PassedAssessments *int32 `json:"passedAssessments,omitempty"`
	// FailedAssessments - READ-ONLY; The number of supported regulatory compliance assessments of the given control with a failed state
	FailedAssessments *int32 `json:"failedAssessments,omitempty"`
	// SkippedAssessments - READ-ONLY; The number of supported regulatory compliance assessments of the given control with a skipped state
	SkippedAssessments *int32 `json:"skippedAssessments,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceControlProperties.
func (rccp RegulatoryComplianceControlProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rccp.State != "" {
		objectMap["state"] = rccp.State
	}
	return json.Marshal(objectMap)
}

// RegulatoryComplianceStandard regulatory compliance standard details and state
type RegulatoryComplianceStandard struct {
	autorest.Response `json:"-"`
	// RegulatoryComplianceStandardProperties - Regulatory compliance standard data
	*RegulatoryComplianceStandardProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceStandard.
func (rcs RegulatoryComplianceStandard) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcs.RegulatoryComplianceStandardProperties != nil {
		objectMap["properties"] = rcs.RegulatoryComplianceStandardProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegulatoryComplianceStandard struct.
func (rcs *RegulatoryComplianceStandard) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var regulatoryComplianceStandardProperties RegulatoryComplianceStandardProperties
				err = json.Unmarshal(*v, &regulatoryComplianceStandardProperties)
				if err != nil {
					return err
				}
				rcs.RegulatoryComplianceStandardProperties = &regulatoryComplianceStandardProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rcs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rcs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rcs.Type = &typeVar
			}
		}
	}

	return nil
}

// RegulatoryComplianceStandardList list of regulatory compliance standards response
type RegulatoryComplianceStandardList struct {
	autorest.Response `json:"-"`
	Value             *[]RegulatoryComplianceStandard `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceStandardList.
func (rcsl RegulatoryComplianceStandardList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcsl.Value != nil {
		objectMap["value"] = rcsl.Value
	}
	return json.Marshal(objectMap)
}

// RegulatoryComplianceStandardListIterator provides access to a complete listing of
// RegulatoryComplianceStandard values.
type RegulatoryComplianceStandardListIterator struct {
	i    int
	page RegulatoryComplianceStandardListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegulatoryComplianceStandardListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceStandardListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegulatoryComplianceStandardListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegulatoryComplianceStandardListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegulatoryComplianceStandardListIterator) Response() RegulatoryComplianceStandardList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegulatoryComplianceStandardListIterator) Value() RegulatoryComplianceStandard {
	if !iter.page.NotDone() {
		return RegulatoryComplianceStandard{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegulatoryComplianceStandardListIterator type.
func NewRegulatoryComplianceStandardListIterator(page RegulatoryComplianceStandardListPage) RegulatoryComplianceStandardListIterator {
	return RegulatoryComplianceStandardListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rcsl RegulatoryComplianceStandardList) IsEmpty() bool {
	return rcsl.Value == nil || len(*rcsl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rcsl RegulatoryComplianceStandardList) hasNextLink() bool {
	return rcsl.NextLink != nil && len(*rcsl.NextLink) != 0
}

// regulatoryComplianceStandardListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rcsl RegulatoryComplianceStandardList) regulatoryComplianceStandardListPreparer(ctx context.Context) (*http.Request, error) {
	if !rcsl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rcsl.NextLink)))
}

// RegulatoryComplianceStandardListPage contains a page of RegulatoryComplianceStandard values.
type RegulatoryComplianceStandardListPage struct {
	fn   func(context.Context, RegulatoryComplianceStandardList) (RegulatoryComplianceStandardList, error)
	rcsl RegulatoryComplianceStandardList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegulatoryComplianceStandardListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceStandardListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rcsl)
		if err != nil {
			return err
		}
		page.rcsl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegulatoryComplianceStandardListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegulatoryComplianceStandardListPage) NotDone() bool {
	return !page.rcsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegulatoryComplianceStandardListPage) Response() RegulatoryComplianceStandardList {
	return page.rcsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegulatoryComplianceStandardListPage) Values() []RegulatoryComplianceStandard {
	if page.rcsl.IsEmpty() {
		return nil
	}
	return *page.rcsl.Value
}

// Creates a new instance of the RegulatoryComplianceStandardListPage type.
func NewRegulatoryComplianceStandardListPage(cur RegulatoryComplianceStandardList, getNextPage func(context.Context, RegulatoryComplianceStandardList) (RegulatoryComplianceStandardList, error)) RegulatoryComplianceStandardListPage {
	return RegulatoryComplianceStandardListPage{
		fn:   getNextPage,
		rcsl: cur,
	}
}

// RegulatoryComplianceStandardProperties regulatory compliance standard data
type RegulatoryComplianceStandardProperties struct {
	// State - Aggregative state based on the standard's supported controls states. Possible values include: 'StatePassed', 'StateFailed', 'StateSkipped', 'StateUnsupported'
	State State `json:"state,omitempty"`
	// PassedControls - READ-ONLY; The number of supported regulatory compliance controls of the given standard with a passed state
	PassedControls *int32 `json:"passedControls,omitempty"`
	// FailedControls - READ-ONLY; The number of supported regulatory compliance controls of the given standard with a failed state
	FailedControls *int32 `json:"failedControls,omitempty"`
	// SkippedControls - READ-ONLY; The number of supported regulatory compliance controls of the given standard with a skipped state
	SkippedControls *int32 `json:"skippedControls,omitempty"`
	// UnsupportedControls - READ-ONLY; The number of regulatory compliance controls of the given standard which are unsupported by automated assessments
	UnsupportedControls *int32 `json:"unsupportedControls,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceStandardProperties.
func (rcsp RegulatoryComplianceStandardProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcsp.State != "" {
		objectMap["state"] = rcsp.State
	}
	return json.Marshal(objectMap)
}

// Remediation remediation details.
type Remediation struct {
	// Description - Remediation description.
	Description *string `json:"description,omitempty"`
	// Scripts - Remediation script.
	Scripts *[]string `json:"scripts,omitempty"`
	// Automated - Is remediation automated.
	Automated *bool `json:"automated,omitempty"`
	// PortalLink - Optional link to remediate in Azure Portal.
	PortalLink *string `json:"portalLink,omitempty"`
}

// Resource describes an Azure resource.
type Resource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BasicResourceDetails details of the resource that was assessed
type BasicResourceDetails interface {
	AsOnPremiseSQLResourceDetails() (*OnPremiseSQLResourceDetails, bool)
	AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool)
	AsBasicOnPremiseResourceDetails() (BasicOnPremiseResourceDetails, bool)
	AsAzureResourceDetails() (*AzureResourceDetails, bool)
	AsResourceDetails() (*ResourceDetails, bool)
}

// ResourceDetails details of the resource that was assessed
type ResourceDetails struct {
	// Source - Possible values include: 'SourceResourceDetails', 'SourceOnPremiseSQL', 'SourceOnPremise', 'SourceAzure'
	Source Source `json:"source,omitempty"`
}

func unmarshalBasicResourceDetails(body []byte) (BasicResourceDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["source"] {
	case string(SourceOnPremiseSQL):
		var opsrd OnPremiseSQLResourceDetails
		err := json.Unmarshal(body, &opsrd)
		return opsrd, err
	case string(SourceOnPremise):
		var oprd OnPremiseResourceDetails
		err := json.Unmarshal(body, &oprd)
		return oprd, err
	case string(SourceAzure):
		var ard AzureResourceDetails
		err := json.Unmarshal(body, &ard)
		return ard, err
	default:
		var rd ResourceDetails
		err := json.Unmarshal(body, &rd)
		return rd, err
	}
}
func unmarshalBasicResourceDetailsArray(body []byte) ([]BasicResourceDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rdArray := make([]BasicResourceDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rd, err := unmarshalBasicResourceDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		rdArray[index] = rd
	}
	return rdArray, nil
}

// MarshalJSON is the custom marshaler for ResourceDetails.
func (rd ResourceDetails) MarshalJSON() ([]byte, error) {
	rd.Source = SourceResourceDetails
	objectMap := make(map[string]interface{})
	if rd.Source != "" {
		objectMap["source"] = rd.Source
	}
	return json.Marshal(objectMap)
}

// AsOnPremiseSQLResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsOnPremiseSQLResourceDetails() (*OnPremiseSQLResourceDetails, bool) {
	return nil, false
}

// AsOnPremiseResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool) {
	return nil, false
}

// AsBasicOnPremiseResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsBasicOnPremiseResourceDetails() (BasicOnPremiseResourceDetails, bool) {
	return nil, false
}

// AsAzureResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsAzureResourceDetails() (*AzureResourceDetails, bool) {
	return nil, false
}

// AsResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsResourceDetails() (*ResourceDetails, bool) {
	return &rd, true
}

// AsBasicResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsBasicResourceDetails() (BasicResourceDetails, bool) {
	return &rd, true
}

// Rule describes remote addresses that is recommended to communicate with the Azure resource on some
// (Protocol, Port, Direction). All other remote addresses are recommended to be blocked
type Rule struct {
	// Name - The name of the rule
	Name *string `json:"name,omitempty"`
	// Direction - The rule's direction. Possible values include: 'Inbound', 'Outbound'
	Direction Direction `json:"direction,omitempty"`
	// DestinationPort - The rule's destination port
	DestinationPort *int32 `json:"destinationPort,omitempty"`
	// Protocols - The rule's transport protocols
	Protocols *[]TransportProtocol `json:"protocols,omitempty"`
	// IPAddresses - The remote IP addresses that should be able to communicate with the Azure resource on the rule's destination port and protocol
	IPAddresses *[]string `json:"ipAddresses,omitempty"`
}

// RuleResults rule results.
type RuleResults struct {
	autorest.Response `json:"-"`
	Properties        *RuleResultsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleResults.
func (rr RuleResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rr.Properties != nil {
		objectMap["properties"] = rr.Properties
	}
	return json.Marshal(objectMap)
}

// RuleResultsInput rule results input.
type RuleResultsInput struct {
	// LatestScan - Take results from latest scan.
	LatestScan *bool `json:"latestScan,omitempty"`
	// Results - Expected results to be inserted into the baseline.
	// Leave this field empty it LatestScan == true.
	Results *[][]string `json:"results,omitempty"`
}

// RuleResultsProperties rule results properties.
type RuleResultsProperties struct {
	// Results - Expected results in the baseline.
	Results *[][]string `json:"results,omitempty"`
}

// RulesResults a list of rules results.
type RulesResults struct {
	autorest.Response `json:"-"`
	// Value - List of rule results.
	Value *[]RuleResults `json:"value,omitempty"`
}

// RulesResultsInput rules results input.
type RulesResultsInput struct {
	// LatestScan - Take results from latest scan.
	LatestScan *bool `json:"latestScan,omitempty"`
	// Results - Expected results to be inserted into the baseline.
	// Leave this field empty it LatestScan == true.
	Results map[string][][]string `json:"results"`
}

// MarshalJSON is the custom marshaler for RulesResultsInput.
func (rri RulesResultsInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rri.LatestScan != nil {
		objectMap["latestScan"] = rri.LatestScan
	}
	if rri.Results != nil {
		objectMap["results"] = rri.Results
	}
	return json.Marshal(objectMap)
}

// Scan a vulnerability assessment scan record.
type Scan struct {
	autorest.Response `json:"-"`
	Properties        *ScanProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Scan.
func (s Scan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Properties != nil {
		objectMap["properties"] = s.Properties
	}
	return json.Marshal(objectMap)
}

// ScanProperties a vulnerability assessment scan record properties.
type ScanProperties struct {
	// TriggerType - Possible values include: 'OnDemand', 'Recurring'
	TriggerType ScanTriggerType `json:"triggerType,omitempty"`
	// State - Possible values include: 'ScanStateFailed', 'ScanStateFailedToRun', 'ScanStateInProgress', 'ScanStatePassed'
	State ScanState `json:"state,omitempty"`
	// Server - The server name.
	Server *string `json:"server,omitempty"`
	// Database - The database name.
	Database *string `json:"database,omitempty"`
	// SQLVersion - The SQL version.
	SQLVersion *string `json:"sqlVersion,omitempty"`
	// StartTime - The scan start time (UTC).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Scan results are valid until end time (UTC).
	EndTime *date.Time `json:"endTime,omitempty"`
	// HighSeverityFailedRulesCount - The number of failed rules with high severity.
	HighSeverityFailedRulesCount *int32 `json:"highSeverityFailedRulesCount,omitempty"`
	// MediumSeverityFailedRulesCount - The number of failed rules with medium severity.
	MediumSeverityFailedRulesCount *int32 `json:"mediumSeverityFailedRulesCount,omitempty"`
	// LowSeverityFailedRulesCount - The number of failed rules with low severity.
	LowSeverityFailedRulesCount *int32 `json:"lowSeverityFailedRulesCount,omitempty"`
	// TotalPassedRulesCount - The number of total passed rules.
	TotalPassedRulesCount *int32 `json:"totalPassedRulesCount,omitempty"`
	// TotalFailedRulesCount - The number of total failed rules.
	TotalFailedRulesCount *int32 `json:"totalFailedRulesCount,omitempty"`
	// TotalRulesCount - The number of total rules assessed.
	TotalRulesCount *int32 `json:"totalRulesCount,omitempty"`
	// IsBaselineApplied - Baseline created for this database, and has one or more rules.
	IsBaselineApplied *bool `json:"isBaselineApplied,omitempty"`
}

// ScanResult a vulnerability assessment scan result for a single rule.
type ScanResult struct {
	autorest.Response `json:"-"`
	Properties        *ScanResultProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ScanResult.
func (sr ScanResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Properties != nil {
		objectMap["properties"] = sr.Properties
	}
	return json.Marshal(objectMap)
}

// ScanResultProperties a vulnerability assessment scan result properties for a single rule.
type ScanResultProperties struct {
	// RuleID - The rule Id.
	RuleID *string `json:"ruleId,omitempty"`
	// Status - Possible values include: 'NonFinding', 'Finding', 'InternalError'
	Status RuleStatus `json:"status,omitempty"`
	// IsTrimmed - Indicated whether the results specified here are trimmed.
	IsTrimmed *bool `json:"isTrimmed,omitempty"`
	// QueryResults - The results of the query that was run.
	QueryResults           *[][]string             `json:"queryResults,omitempty"`
	Remediation            *Remediation            `json:"remediation,omitempty"`
	BaselineAdjustedResult *BaselineAdjustedResult `json:"baselineAdjustedResult,omitempty"`
	RuleMetadata           *VaRule                 `json:"ruleMetadata,omitempty"`
}

// ScanResults a list of vulnerability assessment scan results.
type ScanResults struct {
	autorest.Response `json:"-"`
	// Value - List of vulnerability assessment scan results.
	Value *[]ScanResult `json:"value,omitempty"`
}

// Scans a list of vulnerability assessment scan records.
type Scans struct {
	autorest.Response `json:"-"`
	// Value - List of vulnerability assessment scan records.
	Value *[]Scan `json:"value,omitempty"`
}

// ScopeElement a more specific scope used to identify the alerts to suppress.
type ScopeElement struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Field - The alert entity type to suppress by.
	Field *string `json:"field,omitempty"`
}

// MarshalJSON is the custom marshaler for ScopeElement.
func (se ScopeElement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if se.Field != nil {
		objectMap["field"] = se.Field
	}
	for k, v := range se.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScopeElement struct.
func (se *ScopeElement) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if se.AdditionalProperties == nil {
					se.AdditionalProperties = make(map[string]interface{})
				}
				se.AdditionalProperties[k] = additionalProperties
			}
		case "field":
			if v != nil {
				var field string
				err = json.Unmarshal(*v, &field)
				if err != nil {
					return err
				}
				se.Field = &field
			}
		}
	}

	return nil
}

// ScoreDetails calculation result data
type ScoreDetails struct {
	// Max - READ-ONLY; Maximum score available
	Max *int32 `json:"max,omitempty"`
	// Current - READ-ONLY; Current score
	Current *float64 `json:"current,omitempty"`
	// Percentage - READ-ONLY; Ratio of the current score divided by the maximum. Rounded to 4 digits after the decimal point
	Percentage *float64 `json:"percentage,omitempty"`
}

// MarshalJSON is the custom marshaler for ScoreDetails.
func (sd ScoreDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SecureScoreControlDefinitionItem information about the security control.
type SecureScoreControlDefinitionItem struct {
	*SecureScoreControlDefinitionItemProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreControlDefinitionItem.
func (sscdi SecureScoreControlDefinitionItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sscdi.SecureScoreControlDefinitionItemProperties != nil {
		objectMap["properties"] = sscdi.SecureScoreControlDefinitionItemProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecureScoreControlDefinitionItem struct.
func (sscdi *SecureScoreControlDefinitionItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var secureScoreControlDefinitionItemProperties SecureScoreControlDefinitionItemProperties
				err = json.Unmarshal(*v, &secureScoreControlDefinitionItemProperties)
				if err != nil {
					return err
				}
				sscdi.SecureScoreControlDefinitionItemProperties = &secureScoreControlDefinitionItemProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sscdi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sscdi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sscdi.Type = &typeVar
			}
		}
	}

	return nil
}

// SecureScoreControlDefinitionItemProperties security Control Definition Properties.
type SecureScoreControlDefinitionItemProperties struct {
	// DisplayName - READ-ONLY; User friendly display name of the control
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; User friendly description of the control
	Description *string `json:"description,omitempty"`
	// MaxScore - READ-ONLY; Maximum control score (0..10)
	MaxScore *int32 `json:"maxScore,omitempty"`
	// Source - READ-ONLY; Source object from which the control was created
	Source *SecureScoreControlDefinitionSource `json:"source,omitempty"`
	// AssessmentDefinitions - READ-ONLY; Array of assessments metadata IDs that are included in this security control
	AssessmentDefinitions *[]AzureResourceLink `json:"assessmentDefinitions,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreControlDefinitionItemProperties.
func (sscdip SecureScoreControlDefinitionItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SecureScoreControlDefinitionList list of security controls definition
type SecureScoreControlDefinitionList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Collection of security controls definition in this page
	Value *[]SecureScoreControlDefinitionItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreControlDefinitionList.
func (sscdl SecureScoreControlDefinitionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SecureScoreControlDefinitionListIterator provides access to a complete listing of
// SecureScoreControlDefinitionItem values.
type SecureScoreControlDefinitionListIterator struct {
	i    int
	page SecureScoreControlDefinitionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecureScoreControlDefinitionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecureScoreControlDefinitionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecureScoreControlDefinitionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecureScoreControlDefinitionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecureScoreControlDefinitionListIterator) Response() SecureScoreControlDefinitionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecureScoreControlDefinitionListIterator) Value() SecureScoreControlDefinitionItem {
	if !iter.page.NotDone() {
		return SecureScoreControlDefinitionItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecureScoreControlDefinitionListIterator type.
func NewSecureScoreControlDefinitionListIterator(page SecureScoreControlDefinitionListPage) SecureScoreControlDefinitionListIterator {
	return SecureScoreControlDefinitionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sscdl SecureScoreControlDefinitionList) IsEmpty() bool {
	return sscdl.Value == nil || len(*sscdl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sscdl SecureScoreControlDefinitionList) hasNextLink() bool {
	return sscdl.NextLink != nil && len(*sscdl.NextLink) != 0
}

// secureScoreControlDefinitionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sscdl SecureScoreControlDefinitionList) secureScoreControlDefinitionListPreparer(ctx context.Context) (*http.Request, error) {
	if !sscdl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sscdl.NextLink)))
}

// SecureScoreControlDefinitionListPage contains a page of SecureScoreControlDefinitionItem values.
type SecureScoreControlDefinitionListPage struct {
	fn    func(context.Context, SecureScoreControlDefinitionList) (SecureScoreControlDefinitionList, error)
	sscdl SecureScoreControlDefinitionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecureScoreControlDefinitionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecureScoreControlDefinitionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sscdl)
		if err != nil {
			return err
		}
		page.sscdl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecureScoreControlDefinitionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecureScoreControlDefinitionListPage) NotDone() bool {
	return !page.sscdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecureScoreControlDefinitionListPage) Response() SecureScoreControlDefinitionList {
	return page.sscdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecureScoreControlDefinitionListPage) Values() []SecureScoreControlDefinitionItem {
	if page.sscdl.IsEmpty() {
		return nil
	}
	return *page.sscdl.Value
}

// Creates a new instance of the SecureScoreControlDefinitionListPage type.
func NewSecureScoreControlDefinitionListPage(cur SecureScoreControlDefinitionList, getNextPage func(context.Context, SecureScoreControlDefinitionList) (SecureScoreControlDefinitionList, error)) SecureScoreControlDefinitionListPage {
	return SecureScoreControlDefinitionListPage{
		fn:    getNextPage,
		sscdl: cur,
	}
}

// SecureScoreControlDefinitionSource the type of the security control (For example, BuiltIn)
type SecureScoreControlDefinitionSource struct {
	// SourceType - The type of security control (for example, BuiltIn). Possible values include: 'BuiltIn', 'Custom'
	SourceType ControlType `json:"sourceType,omitempty"`
}

// SecureScoreControlDetails details of the security control, its score, and the health status of the
// relevant resources.
type SecureScoreControlDetails struct {
	*SecureScoreControlScoreDetails `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreControlDetails.
func (sscd SecureScoreControlDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sscd.SecureScoreControlScoreDetails != nil {
		objectMap["properties"] = sscd.SecureScoreControlScoreDetails
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecureScoreControlDetails struct.
func (sscd *SecureScoreControlDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var secureScoreControlScoreDetails SecureScoreControlScoreDetails
				err = json.Unmarshal(*v, &secureScoreControlScoreDetails)
				if err != nil {
					return err
				}
				sscd.SecureScoreControlScoreDetails = &secureScoreControlScoreDetails
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sscd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sscd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sscd.Type = &typeVar
			}
		}
	}

	return nil
}

// SecureScoreControlList list of security controls
type SecureScoreControlList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Collection of security controls in this page
	Value *[]SecureScoreControlDetails `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreControlList.
func (sscl SecureScoreControlList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SecureScoreControlListIterator provides access to a complete listing of SecureScoreControlDetails
// values.
type SecureScoreControlListIterator struct {
	i    int
	page SecureScoreControlListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecureScoreControlListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecureScoreControlListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecureScoreControlListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecureScoreControlListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecureScoreControlListIterator) Response() SecureScoreControlList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecureScoreControlListIterator) Value() SecureScoreControlDetails {
	if !iter.page.NotDone() {
		return SecureScoreControlDetails{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecureScoreControlListIterator type.
func NewSecureScoreControlListIterator(page SecureScoreControlListPage) SecureScoreControlListIterator {
	return SecureScoreControlListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sscl SecureScoreControlList) IsEmpty() bool {
	return sscl.Value == nil || len(*sscl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sscl SecureScoreControlList) hasNextLink() bool {
	return sscl.NextLink != nil && len(*sscl.NextLink) != 0
}

// secureScoreControlListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sscl SecureScoreControlList) secureScoreControlListPreparer(ctx context.Context) (*http.Request, error) {
	if !sscl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sscl.NextLink)))
}

// SecureScoreControlListPage contains a page of SecureScoreControlDetails values.
type SecureScoreControlListPage struct {
	fn   func(context.Context, SecureScoreControlList) (SecureScoreControlList, error)
	sscl SecureScoreControlList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecureScoreControlListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecureScoreControlListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sscl)
		if err != nil {
			return err
		}
		page.sscl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecureScoreControlListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecureScoreControlListPage) NotDone() bool {
	return !page.sscl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecureScoreControlListPage) Response() SecureScoreControlList {
	return page.sscl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecureScoreControlListPage) Values() []SecureScoreControlDetails {
	if page.sscl.IsEmpty() {
		return nil
	}
	return *page.sscl.Value
}

// Creates a new instance of the SecureScoreControlListPage type.
func NewSecureScoreControlListPage(cur SecureScoreControlList, getNextPage func(context.Context, SecureScoreControlList) (SecureScoreControlList, error)) SecureScoreControlListPage {
	return SecureScoreControlListPage{
		fn:   getNextPage,
		sscl: cur,
	}
}

// SecureScoreControlScore calculation result data
type SecureScoreControlScore struct {
	// Max - READ-ONLY; Maximum control score (0..10)
	Max *int32 `json:"max,omitempty"`
	// Current - READ-ONLY; Actual score for the control = (achieved points / total points) * max score. if total points is zeroed, the return number is 0.00
	Current *float64 `json:"current,omitempty"`
	// Percentage - READ-ONLY; Ratio of the current score divided by the maximum. Rounded to 4 digits after the decimal point
	Percentage *float64 `json:"percentage,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreControlScore.
func (sscs SecureScoreControlScore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SecureScoreControlScoreDetails calculation result data in control level
type SecureScoreControlScoreDetails struct {
	// DisplayName - READ-ONLY; User friendly display name of the control
	DisplayName *string `json:"displayName,omitempty"`
	// ScoreDetails - Actual score object for the control
	*ScoreDetails `json:"score,omitempty"`
	// HealthyResourceCount - READ-ONLY; Number of healthy resources in the control
	HealthyResourceCount *int32 `json:"healthyResourceCount,omitempty"`
	// UnhealthyResourceCount - READ-ONLY; Number of unhealthy resources in the control
	UnhealthyResourceCount *int32 `json:"unhealthyResourceCount,omitempty"`
	// NotApplicableResourceCount - READ-ONLY; Number of not applicable resources in the control
	NotApplicableResourceCount *int32 `json:"notApplicableResourceCount,omitempty"`
	// Weight - READ-ONLY; The relative weight for this specific control in each of your subscriptions. Used when calculating an aggregated score for this control across all of your subscriptions.
	Weight     *int64                            `json:"weight,omitempty"`
	Definition *SecureScoreControlDefinitionItem `json:"definition,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreControlScoreDetails.
func (sscsd SecureScoreControlScoreDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sscsd.ScoreDetails != nil {
		objectMap["score"] = sscsd.ScoreDetails
	}
	if sscsd.Definition != nil {
		objectMap["definition"] = sscsd.Definition
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecureScoreControlScoreDetails struct.
func (sscsd *SecureScoreControlScoreDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				sscsd.DisplayName = &displayName
			}
		case "score":
			if v != nil {
				var scoreDetails ScoreDetails
				err = json.Unmarshal(*v, &scoreDetails)
				if err != nil {
					return err
				}
				sscsd.ScoreDetails = &scoreDetails
			}
		case "healthyResourceCount":
			if v != nil {
				var healthyResourceCount int32
				err = json.Unmarshal(*v, &healthyResourceCount)
				if err != nil {
					return err
				}
				sscsd.HealthyResourceCount = &healthyResourceCount
			}
		case "unhealthyResourceCount":
			if v != nil {
				var unhealthyResourceCount int32
				err = json.Unmarshal(*v, &unhealthyResourceCount)
				if err != nil {
					return err
				}
				sscsd.UnhealthyResourceCount = &unhealthyResourceCount
			}
		case "notApplicableResourceCount":
			if v != nil {
				var notApplicableResourceCount int32
				err = json.Unmarshal(*v, &notApplicableResourceCount)
				if err != nil {
					return err
				}
				sscsd.NotApplicableResourceCount = &notApplicableResourceCount
			}
		case "weight":
			if v != nil {
				var weight int64
				err = json.Unmarshal(*v, &weight)
				if err != nil {
					return err
				}
				sscsd.Weight = &weight
			}
		case "definition":
			if v != nil {
				var definition SecureScoreControlDefinitionItem
				err = json.Unmarshal(*v, &definition)
				if err != nil {
					return err
				}
				sscsd.Definition = &definition
			}
		}
	}

	return nil
}

// SecureScoreItem secure score item data model
type SecureScoreItem struct {
	autorest.Response `json:"-"`
	// SecureScoreItemProperties - READ-ONLY; Secure score item
	*SecureScoreItemProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreItem.
func (ssi SecureScoreItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecureScoreItem struct.
func (ssi *SecureScoreItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var secureScoreItemProperties SecureScoreItemProperties
				err = json.Unmarshal(*v, &secureScoreItemProperties)
				if err != nil {
					return err
				}
				ssi.SecureScoreItemProperties = &secureScoreItemProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssi.Type = &typeVar
			}
		}
	}

	return nil
}

// SecureScoreItemProperties describes properties of a calculated secure score.
type SecureScoreItemProperties struct {
	// DisplayName - READ-ONLY; The initiative’s name
	DisplayName *string `json:"displayName,omitempty"`
	// ScoreDetails - READ-ONLY; score object
	*ScoreDetails `json:"score,omitempty"`
	// Weight - READ-ONLY; The relative weight for each subscription. Used when calculating an aggregated secure score for multiple subscriptions.
	Weight *int64 `json:"weight,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreItemProperties.
func (ssip SecureScoreItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecureScoreItemProperties struct.
func (ssip *SecureScoreItemProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				ssip.DisplayName = &displayName
			}
		case "score":
			if v != nil {
				var scoreDetails ScoreDetails
				err = json.Unmarshal(*v, &scoreDetails)
				if err != nil {
					return err
				}
				ssip.ScoreDetails = &scoreDetails
			}
		case "weight":
			if v != nil {
				var weight int64
				err = json.Unmarshal(*v, &weight)
				if err != nil {
					return err
				}
				ssip.Weight = &weight
			}
		}
	}

	return nil
}

// SecureScoresList list of secure scores
type SecureScoresList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Collection of secure scores in this page
	Value *[]SecureScoreItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoresList.
func (ssl SecureScoresList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SecureScoresListIterator provides access to a complete listing of SecureScoreItem values.
type SecureScoresListIterator struct {
	i    int
	page SecureScoresListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecureScoresListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecureScoresListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecureScoresListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecureScoresListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecureScoresListIterator) Response() SecureScoresList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecureScoresListIterator) Value() SecureScoreItem {
	if !iter.page.NotDone() {
		return SecureScoreItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecureScoresListIterator type.
func NewSecureScoresListIterator(page SecureScoresListPage) SecureScoresListIterator {
	return SecureScoresListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ssl SecureScoresList) IsEmpty() bool {
	return ssl.Value == nil || len(*ssl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ssl SecureScoresList) hasNextLink() bool {
	return ssl.NextLink != nil && len(*ssl.NextLink) != 0
}

// secureScoresListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ssl SecureScoresList) secureScoresListPreparer(ctx context.Context) (*http.Request, error) {
	if !ssl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ssl.NextLink)))
}

// SecureScoresListPage contains a page of SecureScoreItem values.
type SecureScoresListPage struct {
	fn  func(context.Context, SecureScoresList) (SecureScoresList, error)
	ssl SecureScoresList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecureScoresListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecureScoresListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ssl)
		if err != nil {
			return err
		}
		page.ssl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecureScoresListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecureScoresListPage) NotDone() bool {
	return !page.ssl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecureScoresListPage) Response() SecureScoresList {
	return page.ssl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecureScoresListPage) Values() []SecureScoreItem {
	if page.ssl.IsEmpty() {
		return nil
	}
	return *page.ssl.Value
}

// Creates a new instance of the SecureScoresListPage type.
func NewSecureScoresListPage(cur SecureScoresList, getNextPage func(context.Context, SecureScoresList) (SecureScoresList, error)) SecureScoresListPage {
	return SecureScoresListPage{
		fn:  getNextPage,
		ssl: cur,
	}
}

// SensitivityLabel the sensitivity label.
type SensitivityLabel struct {
	// DisplayName - The name of the sensitivity label.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description of the sensitivity label.
	Description *string `json:"description,omitempty"`
	// Rank - The rank of the sensitivity label. Possible values include: 'RankNone', 'RankLow', 'RankMedium', 'RankHigh', 'RankCritical'
	Rank Rank `json:"rank,omitempty"`
	// Order - The order of the sensitivity label.
	Order *int32 `json:"order,omitempty"`
	// Enabled - Indicates whether the label is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
}

// ServerVulnerabilityProperties additional context fields for server vulnerability assessment
type ServerVulnerabilityProperties struct {
	// Type - READ-ONLY; Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information Gathered
	Type *string `json:"type,omitempty"`
	// Cvss - READ-ONLY; Dictionary from cvss version to cvss details object
	Cvss map[string]*CVSS `json:"cvss"`
	// Patchable - READ-ONLY; Indicates whether a patch is available or not
	Patchable *bool `json:"patchable,omitempty"`
	// Cve - READ-ONLY; List of CVEs
	Cve *[]CVE `json:"cve,omitempty"`
	// Threat - READ-ONLY; Threat name
	Threat *string `json:"threat,omitempty"`
	// PublishedTime - READ-ONLY; Published time
	PublishedTime *date.Time `json:"publishedTime,omitempty"`
	// VendorReferences - READ-ONLY
	VendorReferences *[]VendorReference `json:"vendorReferences,omitempty"`
	// AssessedResourceType - Possible values include: 'AssessedResourceTypeAdditionalData', 'AssessedResourceTypeSQLServerVulnerability', 'AssessedResourceTypeContainerRegistryVulnerability', 'AssessedResourceTypeServerVulnerabilityAssessment'
	AssessedResourceType AssessedResourceType `json:"assessedResourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) MarshalJSON() ([]byte, error) {
	svp.AssessedResourceType = AssessedResourceTypeServerVulnerabilityAssessment
	objectMap := make(map[string]interface{})
	if svp.AssessedResourceType != "" {
		objectMap["assessedResourceType"] = svp.AssessedResourceType
	}
	return json.Marshal(objectMap)
}

// AsSQLServerVulnerabilityProperties is the BasicAdditionalData implementation for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) AsSQLServerVulnerabilityProperties() (*SQLServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsContainerRegistryVulnerabilityProperties is the BasicAdditionalData implementation for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) AsContainerRegistryVulnerabilityProperties() (*ContainerRegistryVulnerabilityProperties, bool) {
	return nil, false
}

// AsServerVulnerabilityProperties is the BasicAdditionalData implementation for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) AsServerVulnerabilityProperties() (*ServerVulnerabilityProperties, bool) {
	return &svp, true
}

// AsAdditionalData is the BasicAdditionalData implementation for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) AsAdditionalData() (*AdditionalData, bool) {
	return nil, false
}

// AsBasicAdditionalData is the BasicAdditionalData implementation for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) AsBasicAdditionalData() (BasicAdditionalData, bool) {
	return &svp, true
}

// ServicePrincipalProperties details of the service principal.
type ServicePrincipalProperties struct {
	// ApplicationID - Application ID of service principal.
	ApplicationID *string `json:"applicationId,omitempty"`
	// Secret - A secret string that the application uses to prove its identity, also can be referred to as application password (write only).
	Secret *string `json:"secret,omitempty"`
}

// Setting represents a security setting in Azure Security Center.
type Setting struct {
	autorest.Response `json:"-"`
	// Kind - the kind of the settings string (DataExportSetting). Possible values include: 'SettingKindDataExportSetting', 'SettingKindAlertSuppressionSetting'
	Kind SettingKind `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Setting.
func (s Setting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Kind != "" {
		objectMap["kind"] = s.Kind
	}
	return json.Marshal(objectMap)
}

// SettingResource the kind of the security setting
type SettingResource struct {
	// Kind - the kind of the settings string (DataExportSetting). Possible values include: 'SettingKindDataExportSetting', 'SettingKindAlertSuppressionSetting'
	Kind SettingKind `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SettingResource.
func (sr SettingResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Kind != "" {
		objectMap["kind"] = sr.Kind
	}
	return json.Marshal(objectMap)
}

// SettingsList subscription settings list.
type SettingsList struct {
	autorest.Response `json:"-"`
	// Value - The settings list.
	Value *[]Setting `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SettingsList.
func (sl SettingsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sl.Value != nil {
		objectMap["value"] = sl.Value
	}
	return json.Marshal(objectMap)
}

// SettingsListIterator provides access to a complete listing of Setting values.
type SettingsListIterator struct {
	i    int
	page SettingsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SettingsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SettingsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SettingsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SettingsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SettingsListIterator) Response() SettingsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SettingsListIterator) Value() Setting {
	if !iter.page.NotDone() {
		return Setting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SettingsListIterator type.
func NewSettingsListIterator(page SettingsListPage) SettingsListIterator {
	return SettingsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl SettingsList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sl SettingsList) hasNextLink() bool {
	return sl.NextLink != nil && len(*sl.NextLink) != 0
}

// settingsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl SettingsList) settingsListPreparer(ctx context.Context) (*http.Request, error) {
	if !sl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// SettingsListPage contains a page of Setting values.
type SettingsListPage struct {
	fn func(context.Context, SettingsList) (SettingsList, error)
	sl SettingsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SettingsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SettingsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sl)
		if err != nil {
			return err
		}
		page.sl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SettingsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SettingsListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SettingsListPage) Response() SettingsList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SettingsListPage) Values() []Setting {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the SettingsListPage type.
func NewSettingsListPage(cur SettingsList, getNextPage func(context.Context, SettingsList) (SettingsList, error)) SettingsListPage {
	return SettingsListPage{
		fn: getNextPage,
		sl: cur,
	}
}

// SQLServerVulnerabilityProperties details of the resource that was assessed
type SQLServerVulnerabilityProperties struct {
	// Type - READ-ONLY; The resource type the sub assessment refers to in its resource details
	Type *string `json:"type,omitempty"`
	// Query - READ-ONLY; The T-SQL query that runs on your SQL database to perform the particular check
	Query *string `json:"query,omitempty"`
	// AssessedResourceType - Possible values include: 'AssessedResourceTypeAdditionalData', 'AssessedResourceTypeSQLServerVulnerability', 'AssessedResourceTypeContainerRegistryVulnerability', 'AssessedResourceTypeServerVulnerabilityAssessment'
	AssessedResourceType AssessedResourceType `json:"assessedResourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) MarshalJSON() ([]byte, error) {
	ssvp.AssessedResourceType = AssessedResourceTypeSQLServerVulnerability
	objectMap := make(map[string]interface{})
	if ssvp.AssessedResourceType != "" {
		objectMap["assessedResourceType"] = ssvp.AssessedResourceType
	}
	return json.Marshal(objectMap)
}

// AsSQLServerVulnerabilityProperties is the BasicAdditionalData implementation for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) AsSQLServerVulnerabilityProperties() (*SQLServerVulnerabilityProperties, bool) {
	return &ssvp, true
}

// AsContainerRegistryVulnerabilityProperties is the BasicAdditionalData implementation for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) AsContainerRegistryVulnerabilityProperties() (*ContainerRegistryVulnerabilityProperties, bool) {
	return nil, false
}

// AsServerVulnerabilityProperties is the BasicAdditionalData implementation for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) AsServerVulnerabilityProperties() (*ServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsAdditionalData is the BasicAdditionalData implementation for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) AsAdditionalData() (*AdditionalData, bool) {
	return nil, false
}

// AsBasicAdditionalData is the BasicAdditionalData implementation for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) AsBasicAdditionalData() (BasicAdditionalData, bool) {
	return &ssvp, true
}

// SubAssessment security sub-assessment on a resource
type SubAssessment struct {
	autorest.Response        `json:"-"`
	*SubAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubAssessment.
func (sa SubAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sa.SubAssessmentProperties != nil {
		objectMap["properties"] = sa.SubAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubAssessment struct.
func (sa *SubAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subAssessmentProperties SubAssessmentProperties
				err = json.Unmarshal(*v, &subAssessmentProperties)
				if err != nil {
					return err
				}
				sa.SubAssessmentProperties = &subAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sa.Type = &typeVar
			}
		}
	}

	return nil
}

// SubAssessmentList list of security sub-assessments
type SubAssessmentList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]SubAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SubAssessmentList.
func (sal SubAssessmentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SubAssessmentListIterator provides access to a complete listing of SubAssessment values.
type SubAssessmentListIterator struct {
	i    int
	page SubAssessmentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubAssessmentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAssessmentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubAssessmentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubAssessmentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubAssessmentListIterator) Response() SubAssessmentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubAssessmentListIterator) Value() SubAssessment {
	if !iter.page.NotDone() {
		return SubAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubAssessmentListIterator type.
func NewSubAssessmentListIterator(page SubAssessmentListPage) SubAssessmentListIterator {
	return SubAssessmentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sal SubAssessmentList) IsEmpty() bool {
	return sal.Value == nil || len(*sal.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sal SubAssessmentList) hasNextLink() bool {
	return sal.NextLink != nil && len(*sal.NextLink) != 0
}

// subAssessmentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sal SubAssessmentList) subAssessmentListPreparer(ctx context.Context) (*http.Request, error) {
	if !sal.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sal.NextLink)))
}

// SubAssessmentListPage contains a page of SubAssessment values.
type SubAssessmentListPage struct {
	fn  func(context.Context, SubAssessmentList) (SubAssessmentList, error)
	sal SubAssessmentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubAssessmentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAssessmentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sal)
		if err != nil {
			return err
		}
		page.sal = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubAssessmentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubAssessmentListPage) NotDone() bool {
	return !page.sal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubAssessmentListPage) Response() SubAssessmentList {
	return page.sal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubAssessmentListPage) Values() []SubAssessment {
	if page.sal.IsEmpty() {
		return nil
	}
	return *page.sal.Value
}

// Creates a new instance of the SubAssessmentListPage type.
func NewSubAssessmentListPage(cur SubAssessmentList, getNextPage func(context.Context, SubAssessmentList) (SubAssessmentList, error)) SubAssessmentListPage {
	return SubAssessmentListPage{
		fn:  getNextPage,
		sal: cur,
	}
}

// SubAssessmentProperties describes properties of an sub-assessment.
type SubAssessmentProperties struct {
	// ID - READ-ONLY; Vulnerability ID
	ID *string `json:"id,omitempty"`
	// DisplayName - READ-ONLY; User friendly display name of the sub-assessment
	DisplayName *string              `json:"displayName,omitempty"`
	Status      *SubAssessmentStatus `json:"status,omitempty"`
	// Remediation - READ-ONLY; Information on how to remediate this sub-assessment
	Remediation *string `json:"remediation,omitempty"`
	// Impact - READ-ONLY; Description of the impact of this sub-assessment
	Impact *string `json:"impact,omitempty"`
	// Category - READ-ONLY; Category of the sub-assessment
	Category *string `json:"category,omitempty"`
	// Description - READ-ONLY; Human readable description of the assessment status
	Description *string `json:"description,omitempty"`
	// TimeGenerated - READ-ONLY; The date and time the sub-assessment was generated
	TimeGenerated   *date.Time           `json:"timeGenerated,omitempty"`
	ResourceDetails BasicResourceDetails `json:"resourceDetails,omitempty"`
	AdditionalData  BasicAdditionalData  `json:"additionalData,omitempty"`
}

// MarshalJSON is the custom marshaler for SubAssessmentProperties.
func (sap SubAssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sap.Status != nil {
		objectMap["status"] = sap.Status
	}
	objectMap["resourceDetails"] = sap.ResourceDetails
	objectMap["additionalData"] = sap.AdditionalData
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubAssessmentProperties struct.
func (sap *SubAssessmentProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sap.ID = &ID
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				sap.DisplayName = &displayName
			}
		case "status":
			if v != nil {
				var status SubAssessmentStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				sap.Status = &status
			}
		case "remediation":
			if v != nil {
				var remediation string
				err = json.Unmarshal(*v, &remediation)
				if err != nil {
					return err
				}
				sap.Remediation = &remediation
			}
		case "impact":
			if v != nil {
				var impact string
				err = json.Unmarshal(*v, &impact)
				if err != nil {
					return err
				}
				sap.Impact = &impact
			}
		case "category":
			if v != nil {
				var category string
				err = json.Unmarshal(*v, &category)
				if err != nil {
					return err
				}
				sap.Category = &category
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				sap.Description = &description
			}
		case "timeGenerated":
			if v != nil {
				var timeGenerated date.Time
				err = json.Unmarshal(*v, &timeGenerated)
				if err != nil {
					return err
				}
				sap.TimeGenerated = &timeGenerated
			}
		case "resourceDetails":
			if v != nil {
				resourceDetails, err := unmarshalBasicResourceDetails(*v)
				if err != nil {
					return err
				}
				sap.ResourceDetails = resourceDetails
			}
		case "additionalData":
			if v != nil {
				additionalData, err := unmarshalBasicAdditionalData(*v)
				if err != nil {
					return err
				}
				sap.AdditionalData = additionalData
			}
		}
	}

	return nil
}

// SubAssessmentStatus status of the sub-assessment
type SubAssessmentStatus struct {
	// Code - READ-ONLY; Programmatic code for the status of the assessment. Possible values include: 'Healthy', 'Unhealthy', 'NotApplicable'
	Code SubAssessmentStatusCode `json:"code,omitempty"`
	// Cause - READ-ONLY; Programmatic code for the cause of the assessment status
	Cause *string `json:"cause,omitempty"`
	// Description - READ-ONLY; Human readable description of the assessment status
	Description *string `json:"description,omitempty"`
	// Severity - READ-ONLY; The sub-assessment severity level. Possible values include: 'SeverityLow', 'SeverityMedium', 'SeverityHigh'
	Severity Severity `json:"severity,omitempty"`
}

// MarshalJSON is the custom marshaler for SubAssessmentStatus.
func (sas SubAssessmentStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SuppressionAlertsScope ...
type SuppressionAlertsScope struct {
	// AllOf - All the conditions inside need to be true in order to suppress the alert
	AllOf *[]ScopeElement `json:"allOf,omitempty"`
}

// Tags a list of key value pairs that describe the resource.
type Tags struct {
	// Tags - A list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Tags.
func (t Tags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.Tags != nil {
		objectMap["tags"] = t.Tags
	}
	return json.Marshal(objectMap)
}

// Task security task that we recommend to do in order to strengthen security
type Task struct {
	autorest.Response `json:"-"`
	*TaskProperties   `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Task.
func (t Task) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.TaskProperties != nil {
		objectMap["properties"] = t.TaskProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Task struct.
func (t *Task) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var taskProperties TaskProperties
				err = json.Unmarshal(*v, &taskProperties)
				if err != nil {
					return err
				}
				t.TaskProperties = &taskProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		}
	}

	return nil
}

// TaskList list of security task recommendations
type TaskList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]Task `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskList.
func (tl TaskList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TaskListIterator provides access to a complete listing of Task values.
type TaskListIterator struct {
	i    int
	page TaskListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TaskListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TaskListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TaskListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TaskListIterator) Response() TaskList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TaskListIterator) Value() Task {
	if !iter.page.NotDone() {
		return Task{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TaskListIterator type.
func NewTaskListIterator(page TaskListPage) TaskListIterator {
	return TaskListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tl TaskList) IsEmpty() bool {
	return tl.Value == nil || len(*tl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tl TaskList) hasNextLink() bool {
	return tl.NextLink != nil && len(*tl.NextLink) != 0
}

// taskListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tl TaskList) taskListPreparer(ctx context.Context) (*http.Request, error) {
	if !tl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tl.NextLink)))
}

// TaskListPage contains a page of Task values.
type TaskListPage struct {
	fn func(context.Context, TaskList) (TaskList, error)
	tl TaskList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TaskListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tl)
		if err != nil {
			return err
		}
		page.tl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TaskListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TaskListPage) NotDone() bool {
	return !page.tl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TaskListPage) Response() TaskList {
	return page.tl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TaskListPage) Values() []Task {
	if page.tl.IsEmpty() {
		return nil
	}
	return *page.tl.Value
}

// Creates a new instance of the TaskListPage type.
func NewTaskListPage(cur TaskList, getNextPage func(context.Context, TaskList) (TaskList, error)) TaskListPage {
	return TaskListPage{
		fn: getNextPage,
		tl: cur,
	}
}

// TaskParameters changing set of properties, depending on the task type that is derived from the name
// field
type TaskParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - READ-ONLY; Name of the task type
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskParameters.
func (tp TaskParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	for k, v := range tp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TaskParameters struct.
func (tp *TaskParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if tp.AdditionalProperties == nil {
					tp.AdditionalProperties = make(map[string]interface{})
				}
				tp.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tp.Name = &name
			}
		}
	}

	return nil
}

// TaskProperties describes properties of a task.
type TaskProperties struct {
	// State - READ-ONLY; State of the task (Active, Resolved etc.)
	State *string `json:"state,omitempty"`
	// CreationTimeUtc - READ-ONLY; The time this task was discovered in UTC
	CreationTimeUtc        *date.Time      `json:"creationTimeUtc,omitempty"`
	SecurityTaskParameters *TaskParameters `json:"securityTaskParameters,omitempty"`
	// LastStateChangeTimeUtc - READ-ONLY; The time this task's details were last changed in UTC
	LastStateChangeTimeUtc *date.Time `json:"lastStateChangeTimeUtc,omitempty"`
	// SubState - READ-ONLY; Additional data on the state of the task
	SubState *string `json:"subState,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskProperties.
func (tp TaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.SecurityTaskParameters != nil {
		objectMap["securityTaskParameters"] = tp.SecurityTaskParameters
	}
	return json.Marshal(objectMap)
}

// BasicThresholdCustomAlertRule a custom alert rule that checks if a value (depends on the custom alert type) is
// within the given range.
type BasicThresholdCustomAlertRule interface {
	AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool)
	AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool)
	AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool)
	AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool)
	AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool)
	AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool)
	AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool)
	AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool)
	AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool)
	AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool)
	AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool)
	AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool)
	AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool)
	AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool)
	AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool)
	AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool)
	AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool)
	AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool)
	AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool)
}

// ThresholdCustomAlertRule a custom alert rule that checks if a value (depends on the custom alert type) is
// within the given range.
type ThresholdCustomAlertRule struct {
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

func unmarshalBasicThresholdCustomAlertRule(body []byte) (BasicThresholdCustomAlertRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleType"] {
	case string(RuleTypeTimeWindowCustomAlertRule):
		var twcar TimeWindowCustomAlertRule
		err := json.Unmarshal(body, &twcar)
		return twcar, err
	case string(RuleTypeActiveConnectionsNotInAllowedRange):
		var acniar ActiveConnectionsNotInAllowedRange
		err := json.Unmarshal(body, &acniar)
		return acniar, err
	case string(RuleTypeAmqpC2DMessagesNotInAllowedRange):
		var acmniar AmqpC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &acmniar)
		return acmniar, err
	case string(RuleTypeMqttC2DMessagesNotInAllowedRange):
		var mcmniar MqttC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mcmniar)
		return mcmniar, err
	case string(RuleTypeHTTPC2DMessagesNotInAllowedRange):
		var hcmniar HTTPC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hcmniar)
		return hcmniar, err
	case string(RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange):
		var acrmniar AmqpC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &acrmniar)
		return acrmniar, err
	case string(RuleTypeMqttC2DRejectedMessagesNotInAllowedRange):
		var mcrmniar MqttC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mcrmniar)
		return mcrmniar, err
	case string(RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange):
		var hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hcrmniar)
		return hcrmniar, err
	case string(RuleTypeAmqpD2CMessagesNotInAllowedRange):
		var admniar AmqpD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &admniar)
		return admniar, err
	case string(RuleTypeMqttD2CMessagesNotInAllowedRange):
		var mdmniar MqttD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mdmniar)
		return mdmniar, err
	case string(RuleTypeHTTPD2CMessagesNotInAllowedRange):
		var hdmniar HTTPD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hdmniar)
		return hdmniar, err
	case string(RuleTypeDirectMethodInvokesNotInAllowedRange):
		var dminiar DirectMethodInvokesNotInAllowedRange
		err := json.Unmarshal(body, &dminiar)
		return dminiar, err
	case string(RuleTypeFailedLocalLoginsNotInAllowedRange):
		var fllniar FailedLocalLoginsNotInAllowedRange
		err := json.Unmarshal(body, &fllniar)
		return fllniar, err
	case string(RuleTypeFileUploadsNotInAllowedRange):
		var funiar FileUploadsNotInAllowedRange
		err := json.Unmarshal(body, &funiar)
		return funiar, err
	case string(RuleTypeQueuePurgesNotInAllowedRange):
		var qpniar QueuePurgesNotInAllowedRange
		err := json.Unmarshal(body, &qpniar)
		return qpniar, err
	case string(RuleTypeTwinUpdatesNotInAllowedRange):
		var tuniar TwinUpdatesNotInAllowedRange
		err := json.Unmarshal(body, &tuniar)
		return tuniar, err
	case string(RuleTypeUnauthorizedOperationsNotInAllowedRange):
		var uoniar UnauthorizedOperationsNotInAllowedRange
		err := json.Unmarshal(body, &uoniar)
		return uoniar, err
	default:
		var tcar ThresholdCustomAlertRule
		err := json.Unmarshal(body, &tcar)
		return tcar, err
	}
}
func unmarshalBasicThresholdCustomAlertRuleArray(body []byte) ([]BasicThresholdCustomAlertRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tcarArray := make([]BasicThresholdCustomAlertRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		tcar, err := unmarshalBasicThresholdCustomAlertRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		tcarArray[index] = tcar
	}
	return tcarArray, nil
}

// MarshalJSON is the custom marshaler for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) MarshalJSON() ([]byte, error) {
	tcar.RuleType = RuleTypeThresholdCustomAlertRule
	objectMap := make(map[string]interface{})
	if tcar.MinThreshold != nil {
		objectMap["minThreshold"] = tcar.MinThreshold
	}
	if tcar.MaxThreshold != nil {
		objectMap["maxThreshold"] = tcar.MaxThreshold
	}
	if tcar.IsEnabled != nil {
		objectMap["isEnabled"] = tcar.IsEnabled
	}
	if tcar.RuleType != "" {
		objectMap["ruleType"] = tcar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return &tcar, true
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &tcar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &tcar, true
}

// BasicTimeWindowCustomAlertRule a custom alert rule that checks if the number of activities (depends on the custom
// alert type) in a time window is within the given range.
type BasicTimeWindowCustomAlertRule interface {
	AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool)
	AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool)
	AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool)
	AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool)
	AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool)
	AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool)
	AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool)
	AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool)
	AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool)
	AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool)
	AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool)
	AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool)
	AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool)
	AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool)
	AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool)
	AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool)
	AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool)
}

// TimeWindowCustomAlertRule a custom alert rule that checks if the number of activities (depends on the custom
// alert type) in a time window is within the given range.
type TimeWindowCustomAlertRule struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

func unmarshalBasicTimeWindowCustomAlertRule(body []byte) (BasicTimeWindowCustomAlertRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleType"] {
	case string(RuleTypeActiveConnectionsNotInAllowedRange):
		var acniar ActiveConnectionsNotInAllowedRange
		err := json.Unmarshal(body, &acniar)
		return acniar, err
	case string(RuleTypeAmqpC2DMessagesNotInAllowedRange):
		var acmniar AmqpC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &acmniar)
		return acmniar, err
	case string(RuleTypeMqttC2DMessagesNotInAllowedRange):
		var mcmniar MqttC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mcmniar)
		return mcmniar, err
	case string(RuleTypeHTTPC2DMessagesNotInAllowedRange):
		var hcmniar HTTPC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hcmniar)
		return hcmniar, err
	case string(RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange):
		var acrmniar AmqpC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &acrmniar)
		return acrmniar, err
	case string(RuleTypeMqttC2DRejectedMessagesNotInAllowedRange):
		var mcrmniar MqttC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mcrmniar)
		return mcrmniar, err
	case string(RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange):
		var hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hcrmniar)
		return hcrmniar, err
	case string(RuleTypeAmqpD2CMessagesNotInAllowedRange):
		var admniar AmqpD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &admniar)
		return admniar, err
	case string(RuleTypeMqttD2CMessagesNotInAllowedRange):
		var mdmniar MqttD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mdmniar)
		return mdmniar, err
	case string(RuleTypeHTTPD2CMessagesNotInAllowedRange):
		var hdmniar HTTPD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hdmniar)
		return hdmniar, err
	case string(RuleTypeDirectMethodInvokesNotInAllowedRange):
		var dminiar DirectMethodInvokesNotInAllowedRange
		err := json.Unmarshal(body, &dminiar)
		return dminiar, err
	case string(RuleTypeFailedLocalLoginsNotInAllowedRange):
		var fllniar FailedLocalLoginsNotInAllowedRange
		err := json.Unmarshal(body, &fllniar)
		return fllniar, err
	case string(RuleTypeFileUploadsNotInAllowedRange):
		var funiar FileUploadsNotInAllowedRange
		err := json.Unmarshal(body, &funiar)
		return funiar, err
	case string(RuleTypeQueuePurgesNotInAllowedRange):
		var qpniar QueuePurgesNotInAllowedRange
		err := json.Unmarshal(body, &qpniar)
		return qpniar, err
	case string(RuleTypeTwinUpdatesNotInAllowedRange):
		var tuniar TwinUpdatesNotInAllowedRange
		err := json.Unmarshal(body, &tuniar)
		return tuniar, err
	case string(RuleTypeUnauthorizedOperationsNotInAllowedRange):
		var uoniar UnauthorizedOperationsNotInAllowedRange
		err := json.Unmarshal(body, &uoniar)
		return uoniar, err
	default:
		var twcar TimeWindowCustomAlertRule
		err := json.Unmarshal(body, &twcar)
		return twcar, err
	}
}
func unmarshalBasicTimeWindowCustomAlertRuleArray(body []byte) ([]BasicTimeWindowCustomAlertRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	twcarArray := make([]BasicTimeWindowCustomAlertRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		twcar, err := unmarshalBasicTimeWindowCustomAlertRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		twcarArray[index] = twcar
	}
	return twcarArray, nil
}

// MarshalJSON is the custom marshaler for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) MarshalJSON() ([]byte, error) {
	twcar.RuleType = RuleTypeTimeWindowCustomAlertRule
	objectMap := make(map[string]interface{})
	if twcar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = twcar.TimeWindowSize
	}
	if twcar.MinThreshold != nil {
		objectMap["minThreshold"] = twcar.MinThreshold
	}
	if twcar.MaxThreshold != nil {
		objectMap["maxThreshold"] = twcar.MaxThreshold
	}
	if twcar.IsEnabled != nil {
		objectMap["isEnabled"] = twcar.IsEnabled
	}
	if twcar.RuleType != "" {
		objectMap["ruleType"] = twcar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &twcar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return &twcar, true
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &twcar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &twcar, true
}

// TopologyList ...
type TopologyList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]TopologyResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for TopologyList.
func (tl TopologyList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TopologyListIterator provides access to a complete listing of TopologyResource values.
type TopologyListIterator struct {
	i    int
	page TopologyListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TopologyListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopologyListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TopologyListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TopologyListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TopologyListIterator) Response() TopologyList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TopologyListIterator) Value() TopologyResource {
	if !iter.page.NotDone() {
		return TopologyResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TopologyListIterator type.
func NewTopologyListIterator(page TopologyListPage) TopologyListIterator {
	return TopologyListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tl TopologyList) IsEmpty() bool {
	return tl.Value == nil || len(*tl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tl TopologyList) hasNextLink() bool {
	return tl.NextLink != nil && len(*tl.NextLink) != 0
}

// topologyListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tl TopologyList) topologyListPreparer(ctx context.Context) (*http.Request, error) {
	if !tl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tl.NextLink)))
}

// TopologyListPage contains a page of TopologyResource values.
type TopologyListPage struct {
	fn func(context.Context, TopologyList) (TopologyList, error)
	tl TopologyList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TopologyListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopologyListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tl)
		if err != nil {
			return err
		}
		page.tl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TopologyListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TopologyListPage) NotDone() bool {
	return !page.tl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TopologyListPage) Response() TopologyList {
	return page.tl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TopologyListPage) Values() []TopologyResource {
	if page.tl.IsEmpty() {
		return nil
	}
	return *page.tl.Value
}

// Creates a new instance of the TopologyListPage type.
func NewTopologyListPage(cur TopologyList, getNextPage func(context.Context, TopologyList) (TopologyList, error)) TopologyListPage {
	return TopologyListPage{
		fn: getNextPage,
		tl: cur,
	}
}

// TopologyResource ...
type TopologyResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// TopologyResourceProperties - READ-ONLY
	*TopologyResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TopologyResource.
func (tr TopologyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TopologyResource struct.
func (tr *TopologyResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tr.Location = &location
			}
		case "properties":
			if v != nil {
				var topologyResourceProperties TopologyResourceProperties
				err = json.Unmarshal(*v, &topologyResourceProperties)
				if err != nil {
					return err
				}
				tr.TopologyResourceProperties = &topologyResourceProperties
			}
		}
	}

	return nil
}

// TopologyResourceProperties ...
type TopologyResourceProperties struct {
	// CalculatedDateTime - READ-ONLY; The UTC time on which the topology was calculated
	CalculatedDateTime *date.Time `json:"calculatedDateTime,omitempty"`
	// TopologyResources - READ-ONLY; Azure resources which are part of this topology resource
	TopologyResources *[]TopologySingleResource `json:"topologyResources,omitempty"`
}

// MarshalJSON is the custom marshaler for TopologyResourceProperties.
func (trp TopologyResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TopologySingleResource ...
type TopologySingleResource struct {
	// ResourceID - READ-ONLY; Azure resource id
	ResourceID *string `json:"resourceId,omitempty"`
	// Severity - READ-ONLY; The security severity of the resource
	Severity *string `json:"severity,omitempty"`
	// RecommendationsExist - READ-ONLY; Indicates if the resource has security recommendations
	RecommendationsExist *bool `json:"recommendationsExist,omitempty"`
	// NetworkZones - READ-ONLY; Indicates the resource connectivity level to the Internet (InternetFacing, Internal ,etc.)
	NetworkZones *string `json:"networkZones,omitempty"`
	// TopologyScore - READ-ONLY; Score of the resource based on its security severity
	TopologyScore *int32 `json:"topologyScore,omitempty"`
	// Location - READ-ONLY; The location of this resource
	Location *string `json:"location,omitempty"`
	// Parents - READ-ONLY; Azure resources connected to this resource which are in higher level in the topology view
	Parents *[]TopologySingleResourceParent `json:"parents,omitempty"`
	// Children - READ-ONLY; Azure resources connected to this resource which are in lower level in the topology view
	Children *[]TopologySingleResourceChild `json:"children,omitempty"`
}

// MarshalJSON is the custom marshaler for TopologySingleResource.
func (tsr TopologySingleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TopologySingleResourceChild ...
type TopologySingleResourceChild struct {
	// ResourceID - READ-ONLY; Azure resource id which serves as child resource in topology view
	ResourceID *string `json:"resourceId,omitempty"`
}

// MarshalJSON is the custom marshaler for TopologySingleResourceChild.
func (tsrc TopologySingleResourceChild) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TopologySingleResourceParent ...
type TopologySingleResourceParent struct {
	// ResourceID - READ-ONLY; Azure resource id which serves as parent resource in topology view
	ResourceID *string `json:"resourceId,omitempty"`
}

// MarshalJSON is the custom marshaler for TopologySingleResourceParent.
func (tsrp TopologySingleResourceParent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TrackedResource describes an Azure tracked resource.
type TrackedResource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Kind of the resource
	Kind *string `json:"kind,omitempty"`
	// Etag - Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string `json:"etag,omitempty"`
	// Tags - A list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Kind != nil {
		objectMap["kind"] = tr.Kind
	}
	if tr.Etag != nil {
		objectMap["etag"] = tr.Etag
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// TwinUpdatesNotInAllowedRange number of twin updates is not in allowed range.
type TwinUpdatesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	tuniar.RuleType = RuleTypeTwinUpdatesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if tuniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = tuniar.TimeWindowSize
	}
	if tuniar.MinThreshold != nil {
		objectMap["minThreshold"] = tuniar.MinThreshold
	}
	if tuniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = tuniar.MaxThreshold
	}
	if tuniar.IsEnabled != nil {
		objectMap["isEnabled"] = tuniar.IsEnabled
	}
	if tuniar.RuleType != "" {
		objectMap["ruleType"] = tuniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &tuniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &tuniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return &tuniar, true
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for TwinUpdatesNotInAllowedRange.
func (tuniar TwinUpdatesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &tuniar, true
}

// UnauthorizedOperationsNotInAllowedRange number of unauthorized operations is not in allowed range.
type UnauthorizedOperationsNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) MarshalJSON() ([]byte, error) {
	uoniar.RuleType = RuleTypeUnauthorizedOperationsNotInAllowedRange
	objectMap := make(map[string]interface{})
	if uoniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = uoniar.TimeWindowSize
	}
	if uoniar.MinThreshold != nil {
		objectMap["minThreshold"] = uoniar.MinThreshold
	}
	if uoniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = uoniar.MaxThreshold
	}
	if uoniar.IsEnabled != nil {
		objectMap["isEnabled"] = uoniar.IsEnabled
	}
	if uoniar.RuleType != "" {
		objectMap["ruleType"] = uoniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &uoniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &uoniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return &uoniar, true
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for UnauthorizedOperationsNotInAllowedRange.
func (uoniar UnauthorizedOperationsNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &uoniar, true
}

// UserRecommendation represents a user that is recommended to be allowed for a certain rule
type UserRecommendation struct {
	// Username - Represents a user that is recommended to be allowed for a certain rule
	Username *string `json:"username,omitempty"`
	// RecommendationAction - Possible values include: 'RecommendationAction1Recommended', 'RecommendationAction1Add', 'RecommendationAction1Remove'
	RecommendationAction RecommendationAction1 `json:"recommendationAction,omitempty"`
}

// VaRule vulnerability assessment rule metadata details.
type VaRule struct {
	// RuleID - The rule Id.
	RuleID *string `json:"ruleId,omitempty"`
	// Severity - Possible values include: 'RuleSeverityHigh', 'RuleSeverityMedium', 'RuleSeverityLow', 'RuleSeverityInformational', 'RuleSeverityObsolete'
	Severity RuleSeverity `json:"severity,omitempty"`
	// Category - The rule category.
	Category *string `json:"category,omitempty"`
	// RuleType - Possible values include: 'Binary', 'BaselineExpected', 'PositiveList', 'NegativeList'
	RuleType RuleType `json:"ruleType,omitempty"`
	// Title - The rule title.
	Title *string `json:"title,omitempty"`
	// Description - The rule description.
	Description *string `json:"description,omitempty"`
	// Rationale - The rule rationale.
	Rationale  *string     `json:"rationale,omitempty"`
	QueryCheck *QueryCheck `json:"queryCheck,omitempty"`
	// BenchmarkReferences - The benchmark references.
	BenchmarkReferences *[]BenchmarkReference `json:"benchmarkReferences,omitempty"`
}

// VendorReference vendor reference
type VendorReference struct {
	// Title - READ-ONLY; Link title
	Title *string `json:"title,omitempty"`
	// Link - READ-ONLY; Link url
	Link *string `json:"link,omitempty"`
}

// MarshalJSON is the custom marshaler for VendorReference.
func (vr VendorReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VMRecommendation represents a machine that is part of a VM/server group
type VMRecommendation struct {
	// ConfigurationStatus - Possible values include: 'Configured', 'NotConfigured', 'InProgress', 'Failed', 'NoStatus'
	ConfigurationStatus ConfigurationStatus `json:"configurationStatus,omitempty"`
	// RecommendationAction - Possible values include: 'RecommendationActionRecommended', 'RecommendationActionAdd', 'RecommendationActionRemove'
	RecommendationAction RecommendationAction `json:"recommendationAction,omitempty"`
	ResourceID           *string              `json:"resourceId,omitempty"`
	// EnforcementSupport - Possible values include: 'Supported', 'NotSupported', 'Unknown'
	EnforcementSupport EnforcementSupport `json:"enforcementSupport,omitempty"`
}

// WorkspaceSetting configures where to store the OMS agent data for workspaces under a scope
type WorkspaceSetting struct {
	autorest.Response `json:"-"`
	// WorkspaceSettingProperties - Workspace setting data
	*WorkspaceSettingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceSetting.
func (ws WorkspaceSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ws.WorkspaceSettingProperties != nil {
		objectMap["properties"] = ws.WorkspaceSettingProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspaceSetting struct.
func (ws *WorkspaceSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceSettingProperties WorkspaceSettingProperties
				err = json.Unmarshal(*v, &workspaceSettingProperties)
				if err != nil {
					return err
				}
				ws.WorkspaceSettingProperties = &workspaceSettingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ws.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ws.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ws.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkspaceSettingList list of workspace settings response
type WorkspaceSettingList struct {
	autorest.Response `json:"-"`
	// Value - List of workspace settings
	Value *[]WorkspaceSetting `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceSettingList.
func (wsl WorkspaceSettingList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wsl.Value != nil {
		objectMap["value"] = wsl.Value
	}
	return json.Marshal(objectMap)
}

// WorkspaceSettingListIterator provides access to a complete listing of WorkspaceSetting values.
type WorkspaceSettingListIterator struct {
	i    int
	page WorkspaceSettingListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkspaceSettingListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceSettingListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkspaceSettingListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkspaceSettingListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkspaceSettingListIterator) Response() WorkspaceSettingList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkspaceSettingListIterator) Value() WorkspaceSetting {
	if !iter.page.NotDone() {
		return WorkspaceSetting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkspaceSettingListIterator type.
func NewWorkspaceSettingListIterator(page WorkspaceSettingListPage) WorkspaceSettingListIterator {
	return WorkspaceSettingListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wsl WorkspaceSettingList) IsEmpty() bool {
	return wsl.Value == nil || len(*wsl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wsl WorkspaceSettingList) hasNextLink() bool {
	return wsl.NextLink != nil && len(*wsl.NextLink) != 0
}

// workspaceSettingListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wsl WorkspaceSettingList) workspaceSettingListPreparer(ctx context.Context) (*http.Request, error) {
	if !wsl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wsl.NextLink)))
}

// WorkspaceSettingListPage contains a page of WorkspaceSetting values.
type WorkspaceSettingListPage struct {
	fn  func(context.Context, WorkspaceSettingList) (WorkspaceSettingList, error)
	wsl WorkspaceSettingList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkspaceSettingListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceSettingListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wsl)
		if err != nil {
			return err
		}
		page.wsl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkspaceSettingListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkspaceSettingListPage) NotDone() bool {
	return !page.wsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkspaceSettingListPage) Response() WorkspaceSettingList {
	return page.wsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkspaceSettingListPage) Values() []WorkspaceSetting {
	if page.wsl.IsEmpty() {
		return nil
	}
	return *page.wsl.Value
}

// Creates a new instance of the WorkspaceSettingListPage type.
func NewWorkspaceSettingListPage(cur WorkspaceSettingList, getNextPage func(context.Context, WorkspaceSettingList) (WorkspaceSettingList, error)) WorkspaceSettingListPage {
	return WorkspaceSettingListPage{
		fn:  getNextPage,
		wsl: cur,
	}
}

// WorkspaceSettingProperties workspace setting data
type WorkspaceSettingProperties struct {
	// WorkspaceID - The full Azure ID of the workspace to save the data in
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// Scope - All the VMs in this scope will send their security data to the mentioned workspace unless overridden by a setting with more specific scope
	Scope *string `json:"scope,omitempty"`
}
