package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListScenarioParameters invokes the cloudcallcenter.ListScenarioParameters API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listscenarioparameters.html
func (client *Client) ListScenarioParameters(request *ListScenarioParametersRequest) (response *ListScenarioParametersResponse, err error) {
	response = CreateListScenarioParametersResponse()
	err = client.DoAction(request, response)
	return
}

// ListScenarioParametersWithChan invokes the cloudcallcenter.ListScenarioParameters API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listscenarioparameters.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListScenarioParametersWithChan(request *ListScenarioParametersRequest) (<-chan *ListScenarioParametersResponse, <-chan error) {
	responseChan := make(chan *ListScenarioParametersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListScenarioParameters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListScenarioParametersWithCallback invokes the cloudcallcenter.ListScenarioParameters API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listscenarioparameters.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListScenarioParametersWithCallback(request *ListScenarioParametersRequest, callback func(response *ListScenarioParametersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListScenarioParametersResponse
		var err error
		defer close(result)
		response, err = client.ListScenarioParameters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListScenarioParametersRequest is the request struct for api ListScenarioParameters
type ListScenarioParametersRequest struct {
	*requests.RpcRequest
	Type       string `position:"Query" name:"Type"`
	InstanceId string `position:"Query" name:"InstanceId"`
	ScenarioId string `position:"Query" name:"ScenarioId"`
}

// ListScenarioParametersResponse is the response struct for api ListScenarioParameters
type ListScenarioParametersResponse struct {
	*responses.BaseResponse
	RequestId          string              `json:"RequestId" xml:"RequestId"`
	Success            bool                `json:"Success" xml:"Success"`
	Code               string              `json:"Code" xml:"Code"`
	Message            string              `json:"Message" xml:"Message"`
	HttpStatusCode     int                 `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ScenarioParameters []ScenarioParameter `json:"ScenarioParameters" xml:"ScenarioParameters"`
}

// CreateListScenarioParametersRequest creates a request to invoke ListScenarioParameters API
func CreateListScenarioParametersRequest() (request *ListScenarioParametersRequest) {
	request = &ListScenarioParametersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListScenarioParameters", "", "")
	request.Method = requests.POST
	return
}

// CreateListScenarioParametersResponse creates a response to parse from ListScenarioParameters response
func CreateListScenarioParametersResponse() (response *ListScenarioParametersResponse) {
	response = &ListScenarioParametersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
