package cloudphoto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InactivatePhotos invokes the cloudphoto.InactivatePhotos API synchronously
// api document: https://help.aliyun.com/api/cloudphoto/inactivatephotos.html
func (client *Client) InactivatePhotos(request *InactivatePhotosRequest) (response *InactivatePhotosResponse, err error) {
	response = CreateInactivatePhotosResponse()
	err = client.DoAction(request, response)
	return
}

// InactivatePhotosWithChan invokes the cloudphoto.InactivatePhotos API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/inactivatephotos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InactivatePhotosWithChan(request *InactivatePhotosRequest) (<-chan *InactivatePhotosResponse, <-chan error) {
	responseChan := make(chan *InactivatePhotosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InactivatePhotos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InactivatePhotosWithCallback invokes the cloudphoto.InactivatePhotos API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/inactivatephotos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InactivatePhotosWithCallback(request *InactivatePhotosRequest, callback func(response *InactivatePhotosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InactivatePhotosResponse
		var err error
		defer close(result)
		response, err = client.InactivatePhotos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InactivatePhotosRequest is the request struct for api InactivatePhotos
type InactivatePhotosRequest struct {
	*requests.RpcRequest
	LibraryId    string           `position:"Query" name:"LibraryId"`
	PhotoId      *[]string        `position:"Query" name:"PhotoId"  type:"Repeated"`
	StoreName    string           `position:"Query" name:"StoreName"`
	InactiveTime requests.Integer `position:"Query" name:"InactiveTime"`
}

// InactivatePhotosResponse is the response struct for api InactivatePhotos
type InactivatePhotosResponse struct {
	*responses.BaseResponse
	Code      string   `json:"Code" xml:"Code"`
	Message   string   `json:"Message" xml:"Message"`
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Action    string   `json:"Action" xml:"Action"`
	Results   []Result `json:"Results" xml:"Results"`
}

// CreateInactivatePhotosRequest creates a request to invoke InactivatePhotos API
func CreateInactivatePhotosRequest() (request *InactivatePhotosRequest) {
	request = &InactivatePhotosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudPhoto", "2017-07-11", "InactivatePhotos", "cloudphoto", "openAPI")
	return
}

// CreateInactivatePhotosResponse creates a response to parse from InactivatePhotos response
func CreateInactivatePhotosResponse() (response *InactivatePhotosResponse) {
	response = &InactivatePhotosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
