package democenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDemoAccessToken invokes the democenter.CreateDemoAccessToken API synchronously
// api document: https://help.aliyun.com/api/democenter/createdemoaccesstoken.html
func (client *Client) CreateDemoAccessToken(request *CreateDemoAccessTokenRequest) (response *CreateDemoAccessTokenResponse, err error) {
	response = CreateCreateDemoAccessTokenResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDemoAccessTokenWithChan invokes the democenter.CreateDemoAccessToken API asynchronously
// api document: https://help.aliyun.com/api/democenter/createdemoaccesstoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDemoAccessTokenWithChan(request *CreateDemoAccessTokenRequest) (<-chan *CreateDemoAccessTokenResponse, <-chan error) {
	responseChan := make(chan *CreateDemoAccessTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDemoAccessToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDemoAccessTokenWithCallback invokes the democenter.CreateDemoAccessToken API asynchronously
// api document: https://help.aliyun.com/api/democenter/createdemoaccesstoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDemoAccessTokenWithCallback(request *CreateDemoAccessTokenRequest, callback func(response *CreateDemoAccessTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDemoAccessTokenResponse
		var err error
		defer close(result)
		response, err = client.CreateDemoAccessToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDemoAccessTokenRequest is the request struct for api CreateDemoAccessToken
type CreateDemoAccessTokenRequest struct {
	*requests.RpcRequest
	Edition requests.Integer `position:"Body" name:"Edition"`
	DemoId  requests.Integer `position:"Body" name:"DemoId"`
}

// CreateDemoAccessTokenResponse is the response struct for api CreateDemoAccessToken
type CreateDemoAccessTokenResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	DemoAccessToken string `json:"DemoAccessToken" xml:"DemoAccessToken"`
	ExpiredDate     string `json:"ExpiredDate" xml:"ExpiredDate"`
	OpenUserId      string `json:"OpenUserId" xml:"OpenUserId"`
	DemoTrialPage   string `json:"DemoTrialPage" xml:"DemoTrialPage"`
	DemoDetailPage  string `json:"DemoDetailPage" xml:"DemoDetailPage"`
}

// CreateCreateDemoAccessTokenRequest creates a request to invoke CreateDemoAccessToken API
func CreateCreateDemoAccessTokenRequest() (request *CreateDemoAccessTokenRequest) {
	request = &CreateDemoAccessTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DemoCenter", "2020-01-21", "CreateDemoAccessToken", "", "")
	return
}

// CreateCreateDemoAccessTokenResponse creates a response to parse from CreateDemoAccessToken response
func CreateCreateDemoAccessTokenResponse() (response *CreateDemoAccessTokenResponse) {
	response = &CreateDemoAccessTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
