package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachLoadBalancers invokes the ess.AttachLoadBalancers API synchronously
func (client *Client) AttachLoadBalancers(request *AttachLoadBalancersRequest) (response *AttachLoadBalancersResponse, err error) {
	response = CreateAttachLoadBalancersResponse()
	err = client.DoAction(request, response)
	return
}

// AttachLoadBalancersWithChan invokes the ess.AttachLoadBalancers API asynchronously
func (client *Client) AttachLoadBalancersWithChan(request *AttachLoadBalancersRequest) (<-chan *AttachLoadBalancersResponse, <-chan error) {
	responseChan := make(chan *AttachLoadBalancersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachLoadBalancers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachLoadBalancersWithCallback invokes the ess.AttachLoadBalancers API asynchronously
func (client *Client) AttachLoadBalancersWithCallback(request *AttachLoadBalancersRequest, callback func(response *AttachLoadBalancersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachLoadBalancersResponse
		var err error
		defer close(result)
		response, err = client.AttachLoadBalancers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachLoadBalancersRequest is the request struct for api AttachLoadBalancers
type AttachLoadBalancersRequest struct {
	*requests.RpcRequest
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ScalingGroupId       string           `position:"Query" name:"ScalingGroupId"`
	ForceAttach          requests.Boolean `position:"Query" name:"ForceAttach"`
	LoadBalancer         *[]string        `position:"Query" name:"LoadBalancer"  type:"Repeated"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Async                requests.Boolean `position:"Query" name:"Async"`
}

// AttachLoadBalancersResponse is the response struct for api AttachLoadBalancers
type AttachLoadBalancersResponse struct {
	*responses.BaseResponse
	ScalingActivityId string `json:"ScalingActivityId" xml:"ScalingActivityId"`
	RequestId         string `json:"RequestId" xml:"RequestId"`
}

// CreateAttachLoadBalancersRequest creates a request to invoke AttachLoadBalancers API
func CreateAttachLoadBalancersRequest() (request *AttachLoadBalancersRequest) {
	request = &AttachLoadBalancersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "AttachLoadBalancers", "ess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachLoadBalancersResponse creates a response to parse from AttachLoadBalancers response
func CreateAttachLoadBalancersResponse() (response *AttachLoadBalancersResponse) {
	response = &AttachLoadBalancersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
