package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchUnbindProjectDevices invokes the iot.BatchUnbindProjectDevices API synchronously
func (client *Client) BatchUnbindProjectDevices(request *BatchUnbindProjectDevicesRequest) (response *BatchUnbindProjectDevicesResponse, err error) {
	response = CreateBatchUnbindProjectDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// BatchUnbindProjectDevicesWithChan invokes the iot.BatchUnbindProjectDevices API asynchronously
func (client *Client) BatchUnbindProjectDevicesWithChan(request *BatchUnbindProjectDevicesRequest) (<-chan *BatchUnbindProjectDevicesResponse, <-chan error) {
	responseChan := make(chan *BatchUnbindProjectDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchUnbindProjectDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchUnbindProjectDevicesWithCallback invokes the iot.BatchUnbindProjectDevices API asynchronously
func (client *Client) BatchUnbindProjectDevicesWithCallback(request *BatchUnbindProjectDevicesRequest, callback func(response *BatchUnbindProjectDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchUnbindProjectDevicesResponse
		var err error
		defer close(result)
		response, err = client.BatchUnbindProjectDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchUnbindProjectDevicesRequest is the request struct for api BatchUnbindProjectDevices
type BatchUnbindProjectDevicesRequest struct {
	*requests.RpcRequest
	IotInstanceId string                              `position:"Body" name:"IotInstanceId"`
	ProjectId     string                              `position:"Body" name:"ProjectId"`
	Devices       *[]BatchUnbindProjectDevicesDevices `position:"Body" name:"Devices"  type:"Repeated"`
	ApiProduct    string                              `position:"Body" name:"ApiProduct"`
	ApiRevision   string                              `position:"Body" name:"ApiRevision"`
}

// BatchUnbindProjectDevicesDevices is a repeated param struct in BatchUnbindProjectDevicesRequest
type BatchUnbindProjectDevicesDevices struct {
	DeviceName string `name:"DeviceName"`
	ProductKey string `name:"ProductKey"`
}

// BatchUnbindProjectDevicesResponse is the response struct for api BatchUnbindProjectDevices
type BatchUnbindProjectDevicesResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         bool   `json:"Data" xml:"Data"`
}

// CreateBatchUnbindProjectDevicesRequest creates a request to invoke BatchUnbindProjectDevices API
func CreateBatchUnbindProjectDevicesRequest() (request *BatchUnbindProjectDevicesRequest) {
	request = &BatchUnbindProjectDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchUnbindProjectDevices", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchUnbindProjectDevicesResponse creates a response to parse from BatchUnbindProjectDevices response
func CreateBatchUnbindProjectDevicesResponse() (response *BatchUnbindProjectDevicesResponse) {
	response = &BatchUnbindProjectDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
