package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindNodeLabel invokes the retailcloud.UnbindNodeLabel API synchronously
func (client *Client) UnbindNodeLabel(request *UnbindNodeLabelRequest) (response *UnbindNodeLabelResponse, err error) {
	response = CreateUnbindNodeLabelResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindNodeLabelWithChan invokes the retailcloud.UnbindNodeLabel API asynchronously
func (client *Client) UnbindNodeLabelWithChan(request *UnbindNodeLabelRequest) (<-chan *UnbindNodeLabelResponse, <-chan error) {
	responseChan := make(chan *UnbindNodeLabelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindNodeLabel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindNodeLabelWithCallback invokes the retailcloud.UnbindNodeLabel API asynchronously
func (client *Client) UnbindNodeLabelWithCallback(request *UnbindNodeLabelRequest, callback func(response *UnbindNodeLabelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindNodeLabelResponse
		var err error
		defer close(result)
		response, err = client.UnbindNodeLabel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindNodeLabelRequest is the request struct for api UnbindNodeLabel
type UnbindNodeLabelRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	LabelKey   string `position:"Query" name:"LabelKey"`
	LabelValue string `position:"Query" name:"LabelValue"`
	ClusterId  string `position:"Query" name:"ClusterId"`
}

// UnbindNodeLabelResponse is the response struct for api UnbindNodeLabel
type UnbindNodeLabelResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUnbindNodeLabelRequest creates a request to invoke UnbindNodeLabel API
func CreateUnbindNodeLabelRequest() (request *UnbindNodeLabelRequest) {
	request = &UnbindNodeLabelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "UnbindNodeLabel", "", "")
	request.Method = requests.POST
	return
}

// CreateUnbindNodeLabelResponse creates a response to parse from UnbindNodeLabel response
func CreateUnbindNodeLabelResponse() (response *UnbindNodeLabelResponse) {
	response = &UnbindNodeLabelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
