package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssociateQos invokes the smartag.AssociateQos API synchronously
func (client *Client) AssociateQos(request *AssociateQosRequest) (response *AssociateQosResponse, err error) {
	response = CreateAssociateQosResponse()
	err = client.DoAction(request, response)
	return
}

// AssociateQosWithChan invokes the smartag.AssociateQos API asynchronously
func (client *Client) AssociateQosWithChan(request *AssociateQosRequest) (<-chan *AssociateQosResponse, <-chan error) {
	responseChan := make(chan *AssociateQosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssociateQos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssociateQosWithCallback invokes the smartag.AssociateQos API asynchronously
func (client *Client) AssociateQosWithCallback(request *AssociateQosRequest, callback func(response *AssociateQosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssociateQosResponse
		var err error
		defer close(result)
		response, err = client.AssociateQos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssociateQosRequest is the request struct for api AssociateQos
type AssociateQosRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	QosId                string           `position:"Query" name:"QosId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// AssociateQosResponse is the response struct for api AssociateQos
type AssociateQosResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAssociateQosRequest creates a request to invoke AssociateQos API
func CreateAssociateQosRequest() (request *AssociateQosRequest) {
	request = &AssociateQosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "AssociateQos", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAssociateQosResponse creates a response to parse from AssociateQos response
func CreateAssociateQosResponse() (response *AssociateQosResponse) {
	response = &AssociateQosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
