package videoseg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SegmentHalfBody invokes the videoseg.SegmentHalfBody API synchronously
func (client *Client) SegmentHalfBody(request *SegmentHalfBodyRequest) (response *SegmentHalfBodyResponse, err error) {
	response = CreateSegmentHalfBodyResponse()
	err = client.DoAction(request, response)
	return
}

// SegmentHalfBodyWithChan invokes the videoseg.SegmentHalfBody API asynchronously
func (client *Client) SegmentHalfBodyWithChan(request *SegmentHalfBodyRequest) (<-chan *SegmentHalfBodyResponse, <-chan error) {
	responseChan := make(chan *SegmentHalfBodyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SegmentHalfBody(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SegmentHalfBodyWithCallback invokes the videoseg.SegmentHalfBody API asynchronously
func (client *Client) SegmentHalfBodyWithCallback(request *SegmentHalfBodyRequest, callback func(response *SegmentHalfBodyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SegmentHalfBodyResponse
		var err error
		defer close(result)
		response, err = client.SegmentHalfBody(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SegmentHalfBodyRequest is the request struct for api SegmentHalfBody
type SegmentHalfBodyRequest struct {
	*requests.RpcRequest
	Async    requests.Boolean `position:"Body" name:"Async"`
	VideoUrl string           `position:"Body" name:"VideoUrl"`
}

// SegmentHalfBodyResponse is the response struct for api SegmentHalfBody
type SegmentHalfBodyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSegmentHalfBodyRequest creates a request to invoke SegmentHalfBody API
func CreateSegmentHalfBodyRequest() (request *SegmentHalfBodyRequest) {
	request = &SegmentHalfBodyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videoseg", "2020-03-20", "SegmentHalfBody", "videoseg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSegmentHalfBodyResponse creates a response to parse from SegmentHalfBody response
func CreateSegmentHalfBodyResponse() (response *SegmentHalfBodyResponse) {
	response = &SegmentHalfBodyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
