// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/visualinspection/v1beta1/service.proto

package visualinspection

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// A solution is a set of models and algorithms combined together that will
// solve a specific visual inspection problem.
type Solution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique name for the solution.
	// This is an alphanumeric identifier generated by the system
	// ([A-Z][A-Z0-9]+).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A user friendly display name for the solution.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Data input file specifies the input dataset for creating (training)
	// the solution. This must be a GCS URI path i.e. of the form
	// gs://<bucket_name>/<path to file>. The data file format is JSONL with each
	// line following the format below (also see examples for Board Inspection
	// and Cosmetic Inspection below).
	// ```
	// {
	//   # Note: Only needed for Board inspection.
	//   "golden_images": [
	//     {
	//        "template_image_gcs_uri": "GCS path to template image.",
	//        "inspection_area_and_regions": [
	//          {
	//            "inspection_area": {
	//              "inspection_area_id": "<unique id for inspection area.",
	//              "bounding_poly": {
	//                "normalized_vertices": [
	//                  { "x": 0.1,  "y": 0.2 },
	//                  { "x": 0.1,  "y": 0.2 },
	//                  { "x": 0.1,  "y": 0.2 },
	//                  { "x": 0.1,  "y": 0.2 },
	//                ]
	//              }
	//            },
	//            "regions": [
	//              "bounding_poly": {
	//                "normalized_vertices": [
	//                  { "x": 0.1,  "y": 0.2 },
	//                  { "x": 0.1,  "y": 0.2 },
	//                  { "x": 0.1,  "y": 0.2 },
	//                  { "x": 0.1,  "y": 0.2 },
	//                ]
	//              },
	//              "region_metadata": {
	//                "region_id": "<region id>",
	//                "region_name": "<region name>",
	//                "component_id": "<component id>",
	//                "component_name": "<component name>"
	//                "other_keywords": {
	//                  "keyword1": "value1",
	//                  "keyword2": "value2"
	//                }
	//              }
	//            ]
	//          }
	//        ]
	//      }
	//   ]
	//   # finetune_from_solution_id can be omitted.
	//   "finetune_from_solution_id": "<id of existing solution>",
	//
	//
	//   "image_and_annotations": [
	//     {
	//       "image_gcs_uri": "<path to the image.",
	//       "image_properties": {
	//         "image_property1": "value1",
	//         "image_property2": "value2"
	//       },
	//       "inspection_state":
	//
	// "INSPECTION_STATE_UNLABELED|INSPECTION_STATE_NON_DEFECTIVE|INSPECTION_STATE_DEFECTIVE",
	//
	//       # Note: Only needed for Board inspection.
	//       "region_id_and_defective_labels": [
	//         {
	//           "inspection_area_id": "<inspection area id>",
	//           "region_id": "<region id>",
	//           "inspection_state":
	//
	// "INSPECTION_STATE_UNLABELED|INSPECTION_STATE_NON_DEFECTIVE|INSPECTION_STATE_DEFECTIVE",
	//           "defect_label_name": "defect label name."
	//         }
	//       ],
	//       # Note: Only needed for Cosmetic Inspection.
	//       "localized_region": [
	//         {
	//           "bounding_poly": {
	//             "normalized_vertices": [
	//               { "x": 0.1,  "y": 0.2 },
	//               { "x": 0.1,  "y": 0.2 },
	//               { "x": 0.1,  "y": 0.2 },
	//               { "x": 0.1,  "y": 0.2 },
	//             ]
	//           },
	//           "region_metadata": {
	//             "region_id": "<region id>",
	//             "region_name": "<region name>",
	//             "component_id": "<component id>",
	//             "component_name": "<component name>"
	//             "other_keywords": {
	//               "keyword1": "value1",
	//               "keyword2": "value2"
	//             }
	//           }
	//         }
	//       ],
	//       # Note: Only needed for Cosmetic Inspection.
	//       "segmentation_annotation": {
	//         "mask": {
	//           "mask": {
	//             "gcs_uri": "<gcs path to the image.>",
	//             "class_map": {
	//               1: "scratch",
	//               2: "glue"
	//             }
	//           }
	//         }
	//       }
	//     }
	//   ]
	// }
	//
	// ```
	// Here's an example for Board Inspection.
	// {
	//   # Note: Only needed for Board inspection.
	//   "golden_images": [
	//     {
	//        "template_image_gcs_uri": "GCS path to template image.",
	//        "inspection_area_and_regions": [
	//          {
	//            "inspection_area": {
	//              "inspection_area_id": "<unique id for inspection area.",
	//              "bounding_poly": {
	//                "normalized_vertices": [
	//                  { "x": 0.1,  "y": 0.2 },
	//                  { "x": 0.1,  "y": 0.2 },
	//                  { "x": 0.1,  "y": 0.2 },
	//                  { "x": 0.1,  "y": 0.2 },
	//                ]
	//              }
	//            },
	//            "regions": [
	//              "bounding_poly": {
	//                "normalized_vertices": [
	//                  { "x": 0.1,  "y": 0.2 },
	//                  { "x": 0.1,  "y": 0.2 },
	//                  { "x": 0.1,  "y": 0.2 },
	//                  { "x": 0.1,  "y": 0.2 },
	//                ]
	//              },
	//              "region_metadata": {
	//                "region_id": "<region id>",
	//                "region_name": "<region name>",
	//                "component_id": "<component id>",
	//                "component_name": "<component name>"
	//                "other_keywords": {
	//                  "keyword1": "value1",
	//                  "keyword2": "value2"
	//                }
	//              }
	//            ]
	//          }
	//        ]
	//      }
	//   ]
	//   # finetune_from_solution_id can be omitted.
	//   "finetune_from_solution_id": "<id of existing solution>",
	//
	//
	//   "image_and_annotations": [
	//     {
	//       "image_gcs_uri": "<path to the image.",
	//       "image_properties": {
	//         "image_property1": "value1",
	//         "image_property2": "value2"
	//       },
	//       "inspection_state":
	//
	// "INSPECTION_STATE_UNLABELED|INSPECTION_STATE_NON_DEFECTIVE|INSPECTION_STATE_DEFECTIVE",
	//
	//       # Note: Only needed for Board inspection.
	//       "region_id_and_defective_labels": [
	//         {
	//           "inspection_area_id": "<inspection area id>",
	//           "region_id": "<region id>",
	//           "inspection_state":
	//
	// "INSPECTION_STATE_UNLABELED|INSPECTION_STATE_NON_DEFECTIVE|INSPECTION_STATE_DEFECTIVE",
	//           "defect_label_name": "defect label name."
	//         }
	//       ],
	//     }
	//   ]
	// }
	//
	// ```
	// Here's an example for Cosmetic Inspection.
	// /```
	// {
	//   # finetune_from_solution_id can be omitted.
	//   "finetune_from_solution_id": "<id of existing solution>",
	//   "image_and_annotations": [
	//     {
	//       "image_gcs_uri": "<path to the image.",
	//       "image_properties": {
	//         "image_property1": "value1",
	//         "image_property2": "value2"
	//       },
	//       "inspection_state":
	//
	// "INSPECTION_STATE_UNLABELED|INSPECTION_STATE_NON_DEFECTIVE|INSPECTION_STATE_DEFECTIVE",
	//
	//       # Note: Only needed for Cosmetic Inspection.
	//       "localized_region": [
	//         {
	//           "bounding_poly": {
	//             "normalized_vertices": [
	//               { "x": 0.1,  "y": 0.2 },
	//               { "x": 0.1,  "y": 0.2 },
	//               { "x": 0.1,  "y": 0.2 },
	//               { "x": 0.1,  "y": 0.2 },
	//             ]
	//           },
	//           "region_metadata": {
	//             "region_id": "<region id>",
	//             "region_name": "<region name>",
	//             "component_id": "<component id>",
	//             "component_name": "<component name>"
	//             "other_keywords": {
	//               "keyword1": "value1",
	//               "keyword2": "value2"
	//             }
	//           }
	//         }
	//       ],
	//       # Note: Only needed for Cosmetic Inspection.
	//       "segmentation_annotation": {
	//         "mask": {
	//           "mask": {
	//             "gcs_uri": "<gcs path to the image.>",
	//             "class_map": {
	//               1: "scratch",
	//               2: "glue"
	//             }
	//           }
	//         }
	//       }
	//     }
	//   ]
	// }
	// ```
	GcsDataInputUri string `protobuf:"bytes,3,opt,name=gcs_data_input_uri,json=gcsDataInputUri,proto3" json:"gcs_data_input_uri,omitempty"`
	// Optional. Type of the solution. Valid values are:
	// *    `assembly`: Solution for finding defects in PCB like components. This
	//                  is the default value.
	// *    `cosmetic`: Solution for finding cosmetic defects on a device.
	//                  Examples include finding scratches or dust particles on
	//                  a device.
	Type string `protobuf:"bytes,7,opt,name=type,proto3" json:"type,omitempty"`
	// Optional. Solution creation train configuration.
	TrainingConfig *Solution_TrainingConfig `protobuf:"bytes,9,opt,name=training_config,json=trainingConfig,proto3" json:"training_config,omitempty"`
	// Output only. Timestamp when the all the models in the solution were trained
	// and evaluated.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this solution was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. A description for this Solution.
	Description string `protobuf:"bytes,10,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The Dataset of this Solution.
	DatasetId string `protobuf:"bytes,11,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Optional. The labels with user-defined metadata to organize your Solutions.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label keys must start with a letter.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	Labels map[string]string `protobuf:"bytes,12,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The SolutionType of this Solution. This restricts the allowable
	// Modules and the linkage between them according to predefined solution
	// schema.
	SolutionType *Solution_SolutionType `protobuf:"bytes,13,opt,name=solution_type,json=solutionType,proto3" json:"solution_type,omitempty"`
}

func (x *Solution) Reset() {
	*x = Solution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Solution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Solution) ProtoMessage() {}

func (x *Solution) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Solution.ProtoReflect.Descriptor instead.
func (*Solution) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{0}
}

func (x *Solution) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Solution) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Solution) GetGcsDataInputUri() string {
	if x != nil {
		return x.GcsDataInputUri
	}
	return ""
}

func (x *Solution) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Solution) GetTrainingConfig() *Solution_TrainingConfig {
	if x != nil {
		return x.TrainingConfig
	}
	return nil
}

func (x *Solution) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Solution) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Solution) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Solution) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *Solution) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Solution) GetSolutionType() *Solution_SolutionType {
	if x != nil {
		return x.SolutionType
	}
	return nil
}

// Solution operation metadata.
type SolutionOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *SolutionOperationMetadata) Reset() {
	*x = SolutionOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SolutionOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SolutionOperationMetadata) ProtoMessage() {}

func (x *SolutionOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SolutionOperationMetadata.ProtoReflect.Descriptor instead.
func (*SolutionOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{1}
}

func (x *SolutionOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for creating a solution.
type CreateSolutionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Solution to create.
	Solution *Solution `protobuf:"bytes,2,opt,name=solution,proto3" json:"solution,omitempty"`
}

func (x *CreateSolutionRequest) Reset() {
	*x = CreateSolutionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSolutionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSolutionRequest) ProtoMessage() {}

func (x *CreateSolutionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSolutionRequest.ProtoReflect.Descriptor instead.
func (*CreateSolutionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{2}
}

func (x *CreateSolutionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSolutionRequest) GetSolution() *Solution {
	if x != nil {
		return x.Solution
	}
	return nil
}

// Request method for listing solutions.
type ListSolutionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of solutions to return. The service may return fewer
	// than this value. If unspecified, at moast 50 solutions will be returned.
	// The maximum value is 100; values above 100 will be coerced to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListSolutions` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListSolutions` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListSolutionsRequest) Reset() {
	*x = ListSolutionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSolutionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSolutionsRequest) ProtoMessage() {}

func (x *ListSolutionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSolutionsRequest.ProtoReflect.Descriptor instead.
func (*ListSolutionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListSolutionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSolutionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSolutionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSolutionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response method for listing solutions.
type ListSolutionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The solutions for this project.
	Solutions []*Solution `protobuf:"bytes,1,rep,name=solutions,proto3" json:"solutions,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSolutionsResponse) Reset() {
	*x = ListSolutionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSolutionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSolutionsResponse) ProtoMessage() {}

func (x *ListSolutionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSolutionsResponse.ProtoReflect.Descriptor instead.
func (*ListSolutionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListSolutionsResponse) GetSolutions() []*Solution {
	if x != nil {
		return x.Solutions
	}
	return nil
}

func (x *ListSolutionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// For requesting details about a particular solution.
type GetSolutionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Solution identifier.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSolutionRequest) Reset() {
	*x = GetSolutionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSolutionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSolutionRequest) ProtoMessage() {}

func (x *GetSolutionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSolutionRequest.ProtoReflect.Descriptor instead.
func (*GetSolutionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{5}
}

func (x *GetSolutionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Export solution metadata to distinguish that the operation is an export
// solution operation.
type ExportSolutionOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *ExportSolutionOperationMetadata) Reset() {
	*x = ExportSolutionOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportSolutionOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportSolutionOperationMetadata) ProtoMessage() {}

func (x *ExportSolutionOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportSolutionOperationMetadata.ProtoReflect.Descriptor instead.
func (*ExportSolutionOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{6}
}

func (x *ExportSolutionOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Deploy solution metadata to distinguish that the operation is an export
// solution operation.
type DeploySolutionOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *DeploySolutionOperationMetadata) Reset() {
	*x = DeploySolutionOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeploySolutionOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeploySolutionOperationMetadata) ProtoMessage() {}

func (x *DeploySolutionOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeploySolutionOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeploySolutionOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeploySolutionOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Undeploy solution metadata to distinguish that the operation is an export
// solution operation.
type UndeploySolutionOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *UndeploySolutionOperationMetadata) Reset() {
	*x = UndeploySolutionOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeploySolutionOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeploySolutionOperationMetadata) ProtoMessage() {}

func (x *UndeploySolutionOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeploySolutionOperationMetadata.ProtoReflect.Descriptor instead.
func (*UndeploySolutionOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{8}
}

func (x *UndeploySolutionOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for creating a SolutionArtifact.
type CreateSolutionArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. SolutionArtifact to create.
	SolutionArtifact *SolutionArtifact `protobuf:"bytes,2,opt,name=solution_artifact,json=solutionArtifact,proto3" json:"solution_artifact,omitempty"`
}

func (x *CreateSolutionArtifactRequest) Reset() {
	*x = CreateSolutionArtifactRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSolutionArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSolutionArtifactRequest) ProtoMessage() {}

func (x *CreateSolutionArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSolutionArtifactRequest.ProtoReflect.Descriptor instead.
func (*CreateSolutionArtifactRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{9}
}

func (x *CreateSolutionArtifactRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSolutionArtifactRequest) GetSolutionArtifact() *SolutionArtifact {
	if x != nil {
		return x.SolutionArtifact
	}
	return nil
}

// CreateSolutionArtifact operation metadata.
type CreateSolutionArtifactOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *CreateSolutionArtifactOperationMetadata) Reset() {
	*x = CreateSolutionArtifactOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSolutionArtifactOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSolutionArtifactOperationMetadata) ProtoMessage() {}

func (x *CreateSolutionArtifactOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSolutionArtifactOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateSolutionArtifactOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{10}
}

func (x *CreateSolutionArtifactOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for listing SolutionArtifacts.
type ListSolutionArtifactsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of SolutionArtifacts to return. The service may return
	// fewer than this value. If unspecified, at most 20 Modules will be
	// returned. The maximum value is 100; values above 100 will be coerced to
	// 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListSolutionArtifacts` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListSolutionArtifacts`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSolutionArtifactsRequest) Reset() {
	*x = ListSolutionArtifactsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSolutionArtifactsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSolutionArtifactsRequest) ProtoMessage() {}

func (x *ListSolutionArtifactsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSolutionArtifactsRequest.ProtoReflect.Descriptor instead.
func (*ListSolutionArtifactsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListSolutionArtifactsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSolutionArtifactsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSolutionArtifactsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSolutionArtifactsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for ListSolutionArtifacts.
type ListSolutionArtifactsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SolutionArtifact.
	SolutionArtifacts []*SolutionArtifact `protobuf:"bytes,1,rep,name=solution_artifacts,json=solutionArtifacts,proto3" json:"solution_artifacts,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSolutionArtifactsResponse) Reset() {
	*x = ListSolutionArtifactsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSolutionArtifactsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSolutionArtifactsResponse) ProtoMessage() {}

func (x *ListSolutionArtifactsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSolutionArtifactsResponse.ProtoReflect.Descriptor instead.
func (*ListSolutionArtifactsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{12}
}

func (x *ListSolutionArtifactsResponse) GetSolutionArtifacts() []*SolutionArtifact {
	if x != nil {
		return x.SolutionArtifacts
	}
	return nil
}

func (x *ListSolutionArtifactsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for getting a SolutionArtifact.
type GetSolutionArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. SolutionArtifact identifier.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSolutionArtifactRequest) Reset() {
	*x = GetSolutionArtifactRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSolutionArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSolutionArtifactRequest) ProtoMessage() {}

func (x *GetSolutionArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSolutionArtifactRequest.ProtoReflect.Descriptor instead.
func (*GetSolutionArtifactRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{13}
}

func (x *GetSolutionArtifactRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for deleting a SolutionArtifact.
type DeleteSolutionArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. SolutionArtifact identifier.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSolutionArtifactRequest) Reset() {
	*x = DeleteSolutionArtifactRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSolutionArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSolutionArtifactRequest) ProtoMessage() {}

func (x *DeleteSolutionArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSolutionArtifactRequest.ProtoReflect.Descriptor instead.
func (*DeleteSolutionArtifactRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{14}
}

func (x *DeleteSolutionArtifactRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Operation metadata for DeleteSolutionArtifact.
type DeleteSolutionArtifactOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *DeleteSolutionArtifactOperationMetadata) Reset() {
	*x = DeleteSolutionArtifactOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSolutionArtifactOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSolutionArtifactOperationMetadata) ProtoMessage() {}

func (x *DeleteSolutionArtifactOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSolutionArtifactOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteSolutionArtifactOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteSolutionArtifactOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for updating a SolutionArtifact.
type UpdateSolutionArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The SolutionArtifact which replaces the resource on the server.
	SolutionArtifact *SolutionArtifact `protobuf:"bytes,1,opt,name=solution_artifact,json=solutionArtifact,proto3" json:"solution_artifact,omitempty"`
	// Required. The update mask applies to the resource.
	// For the `FieldMask` definition, see
	//
	// [FieldMask](https:
	// //developers.google.com/protocol-buffers
	// // /docs/reference/google.protobuf#fieldmask).
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSolutionArtifactRequest) Reset() {
	*x = UpdateSolutionArtifactRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSolutionArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSolutionArtifactRequest) ProtoMessage() {}

func (x *UpdateSolutionArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSolutionArtifactRequest.ProtoReflect.Descriptor instead.
func (*UpdateSolutionArtifactRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{16}
}

func (x *UpdateSolutionArtifactRequest) GetSolutionArtifact() *SolutionArtifact {
	if x != nil {
		return x.SolutionArtifact
	}
	return nil
}

func (x *UpdateSolutionArtifactRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// CreateDataset operation metadata.
type CreateDatasetOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *CreateDatasetOperationMetadata) Reset() {
	*x = CreateDatasetOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDatasetOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDatasetOperationMetadata) ProtoMessage() {}

func (x *CreateDatasetOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDatasetOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateDatasetOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{17}
}

func (x *CreateDatasetOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for getting a Dataset.
type GetDatasetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Dataset identifier.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDatasetRequest) Reset() {
	*x = GetDatasetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDatasetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDatasetRequest) ProtoMessage() {}

func (x *GetDatasetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDatasetRequest.ProtoReflect.Descriptor instead.
func (*GetDatasetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{18}
}

func (x *GetDatasetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for deleting a Dataset.
type DeleteDatasetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Dataset identifier.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDatasetRequest) Reset() {
	*x = DeleteDatasetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDatasetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDatasetRequest) ProtoMessage() {}

func (x *DeleteDatasetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDatasetRequest.ProtoReflect.Descriptor instead.
func (*DeleteDatasetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteDatasetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for listing Datasets.
type ListDatasetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of Dataset to return. The service may return fewer
	// than this value. If unspecified, at most 20 Datasets will be returned.
	// The maximum value is 100; values above 100 will be coerced to 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListDatasets` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListDatasets` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDatasetsRequest) Reset() {
	*x = ListDatasetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDatasetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDatasetsRequest) ProtoMessage() {}

func (x *ListDatasetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDatasetsRequest.ProtoReflect.Descriptor instead.
func (*ListDatasetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{20}
}

func (x *ListDatasetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDatasetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDatasetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDatasetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for ListDatasets.
type ListDatasetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The datasets for this project.
	Datasets []*Dataset `protobuf:"bytes,1,rep,name=datasets,proto3" json:"datasets,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDatasetsResponse) Reset() {
	*x = ListDatasetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDatasetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDatasetsResponse) ProtoMessage() {}

func (x *ListDatasetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDatasetsResponse.ProtoReflect.Descriptor instead.
func (*ListDatasetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{21}
}

func (x *ListDatasetsResponse) GetDatasets() []*Dataset {
	if x != nil {
		return x.Datasets
	}
	return nil
}

func (x *ListDatasetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for importing a Dataset.
type ImportDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Dataset identifier.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired input locations. The contents of all input locations
	// will be imported in one batch.
	ImportConfigs []*ImportDataConfig `protobuf:"bytes,2,rep,name=import_configs,json=importConfigs,proto3" json:"import_configs,omitempty"`
}

func (x *ImportDataRequest) Reset() {
	*x = ImportDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDataRequest) ProtoMessage() {}

func (x *ImportDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDataRequest.ProtoReflect.Descriptor instead.
func (*ImportDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{22}
}

func (x *ImportDataRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ImportDataRequest) GetImportConfigs() []*ImportDataConfig {
	if x != nil {
		return x.ImportConfigs
	}
	return nil
}

// ImportData operation metadata.
type ImportDataOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *ImportDataOperationMetadata) Reset() {
	*x = ImportDataOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportDataOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDataOperationMetadata) ProtoMessage() {}

func (x *ImportDataOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDataOperationMetadata.ProtoReflect.Descriptor instead.
func (*ImportDataOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{23}
}

func (x *ImportDataOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for exporting a Dataset.
type ExportDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Dataset identifier.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired output location.
	ExportConfig *ExportDataConfig `protobuf:"bytes,2,opt,name=export_config,json=exportConfig,proto3" json:"export_config,omitempty"`
}

func (x *ExportDataRequest) Reset() {
	*x = ExportDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDataRequest) ProtoMessage() {}

func (x *ExportDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDataRequest.ProtoReflect.Descriptor instead.
func (*ExportDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{24}
}

func (x *ExportDataRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExportDataRequest) GetExportConfig() *ExportDataConfig {
	if x != nil {
		return x.ExportConfig
	}
	return nil
}

// ExportData operation metadata.
type ExportDataOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *ExportDataOperationMetadata) Reset() {
	*x = ExportDataOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportDataOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDataOperationMetadata) ProtoMessage() {}

func (x *ExportDataOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDataOperationMetadata.ProtoReflect.Descriptor instead.
func (*ExportDataOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{25}
}

func (x *ExportDataOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// DeleteDataset operation metadata.
type DeleteDatasetOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *DeleteDatasetOperationMetadata) Reset() {
	*x = DeleteDatasetOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDatasetOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDatasetOperationMetadata) ProtoMessage() {}

func (x *DeleteDatasetOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDatasetOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteDatasetOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{26}
}

func (x *DeleteDatasetOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for getting an Image.
type GetImageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Image identifier.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetImageRequest) Reset() {
	*x = GetImageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetImageRequest) ProtoMessage() {}

func (x *GetImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetImageRequest.ProtoReflect.Descriptor instead.
func (*GetImageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{27}
}

func (x *GetImageRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for listing Images.
type ListImagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of images to return. The service may return fewer
	// than this value. If unspecified, at most 20 images will be returned.
	// The maximum value is 200; values above 200 will be coerced to 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListImages` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListImages` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListImagesRequest) Reset() {
	*x = ListImagesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListImagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImagesRequest) ProtoMessage() {}

func (x *ListImagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImagesRequest.ProtoReflect.Descriptor instead.
func (*ListImagesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{28}
}

func (x *ListImagesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListImagesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListImagesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListImagesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for ListImages.
type ListImagesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The images for this dataset.
	Images []*Image `protobuf:"bytes,1,rep,name=images,proto3" json:"images,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListImagesResponse) Reset() {
	*x = ListImagesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListImagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImagesResponse) ProtoMessage() {}

func (x *ListImagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImagesResponse.ProtoReflect.Descriptor instead.
func (*ListImagesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{29}
}

func (x *ListImagesResponse) GetImages() []*Image {
	if x != nil {
		return x.Images
	}
	return nil
}

func (x *ListImagesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for creating a AnnotationSet.
type CreateAnnotationSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. AnnotationSet to create.
	AnnotationSet *AnnotationSet `protobuf:"bytes,2,opt,name=annotation_set,json=annotationSet,proto3" json:"annotation_set,omitempty"`
}

func (x *CreateAnnotationSetRequest) Reset() {
	*x = CreateAnnotationSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAnnotationSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnnotationSetRequest) ProtoMessage() {}

func (x *CreateAnnotationSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnnotationSetRequest.ProtoReflect.Descriptor instead.
func (*CreateAnnotationSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{30}
}

func (x *CreateAnnotationSetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAnnotationSetRequest) GetAnnotationSet() *AnnotationSet {
	if x != nil {
		return x.AnnotationSet
	}
	return nil
}

// Request for listing AnnotationSets.
type ListAnnotationSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of AnnotationSets to return. The service may return
	// fewer than this value. If unspecified, at most 20 AnnotationSets will be
	// returned. The maximum value is 100; values above 100 will be coerced to
	// 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAnnotationSets` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListAnnotationSets` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAnnotationSetsRequest) Reset() {
	*x = ListAnnotationSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnnotationSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnnotationSetsRequest) ProtoMessage() {}

func (x *ListAnnotationSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnnotationSetsRequest.ProtoReflect.Descriptor instead.
func (*ListAnnotationSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{31}
}

func (x *ListAnnotationSetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAnnotationSetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAnnotationSetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAnnotationSetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for ListAnnotationSets.
type ListAnnotationSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The annotationsets for this project.
	AnnotationSets []*AnnotationSet `protobuf:"bytes,1,rep,name=annotation_sets,json=annotationSets,proto3" json:"annotation_sets,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAnnotationSetsResponse) Reset() {
	*x = ListAnnotationSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnnotationSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnnotationSetsResponse) ProtoMessage() {}

func (x *ListAnnotationSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnnotationSetsResponse.ProtoReflect.Descriptor instead.
func (*ListAnnotationSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{32}
}

func (x *ListAnnotationSetsResponse) GetAnnotationSets() []*AnnotationSet {
	if x != nil {
		return x.AnnotationSets
	}
	return nil
}

func (x *ListAnnotationSetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Operation metadata for DeleteAnnotationSet.
type DeleteAnnotationSetOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *DeleteAnnotationSetOperationMetadata) Reset() {
	*x = DeleteAnnotationSetOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAnnotationSetOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAnnotationSetOperationMetadata) ProtoMessage() {}

func (x *DeleteAnnotationSetOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAnnotationSetOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteAnnotationSetOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{33}
}

func (x *DeleteAnnotationSetOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for creating a AnnotationSpec.
type CreateAnnotationSpecRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. AnnotationSpec to create.
	AnnotationSpec *AnnotationSpec `protobuf:"bytes,2,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
}

func (x *CreateAnnotationSpecRequest) Reset() {
	*x = CreateAnnotationSpecRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAnnotationSpecRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnnotationSpecRequest) ProtoMessage() {}

func (x *CreateAnnotationSpecRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnnotationSpecRequest.ProtoReflect.Descriptor instead.
func (*CreateAnnotationSpecRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{34}
}

func (x *CreateAnnotationSpecRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAnnotationSpecRequest) GetAnnotationSpec() *AnnotationSpec {
	if x != nil {
		return x.AnnotationSpec
	}
	return nil
}

// Request for listing AnnotationSpecs.
type ListAnnotationSpecsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of AnnotationSpecs to return. The service may return
	// fewer than this value. If unspecified, at most 20 AnnotationSpecs will be
	// returned. The maximum value is 100; values above 100 will be coerced to
	// 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAnnotationSpecs` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListAnnotationSpecs`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAnnotationSpecsRequest) Reset() {
	*x = ListAnnotationSpecsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnnotationSpecsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnnotationSpecsRequest) ProtoMessage() {}

func (x *ListAnnotationSpecsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnnotationSpecsRequest.ProtoReflect.Descriptor instead.
func (*ListAnnotationSpecsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{35}
}

func (x *ListAnnotationSpecsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAnnotationSpecsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAnnotationSpecsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAnnotationSpecsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for ListAnnotationSpecs.
type ListAnnotationSpecsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The annotationspecs for this project.
	AnnotationSpecs []*AnnotationSpec `protobuf:"bytes,1,rep,name=annotation_specs,json=annotationSpecs,proto3" json:"annotation_specs,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAnnotationSpecsResponse) Reset() {
	*x = ListAnnotationSpecsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnnotationSpecsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnnotationSpecsResponse) ProtoMessage() {}

func (x *ListAnnotationSpecsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnnotationSpecsResponse.ProtoReflect.Descriptor instead.
func (*ListAnnotationSpecsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{36}
}

func (x *ListAnnotationSpecsResponse) GetAnnotationSpecs() []*AnnotationSpec {
	if x != nil {
		return x.AnnotationSpecs
	}
	return nil
}

func (x *ListAnnotationSpecsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Operation Metadata for DeleteAnnotationSpec.
type DeleteAnnotationSpecOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *DeleteAnnotationSpecOperationMetadata) Reset() {
	*x = DeleteAnnotationSpecOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAnnotationSpecOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAnnotationSpecOperationMetadata) ProtoMessage() {}

func (x *DeleteAnnotationSpecOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAnnotationSpecOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteAnnotationSpecOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{37}
}

func (x *DeleteAnnotationSpecOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for listing Annotations.
type ListAnnotationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of annotations to return. The service may return
	// fewer than this value. If unspecified, at most 20 annotations will be
	// returned. The maximum value is 100; values above 100 will be coerced to
	// 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAnnotations` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListAnnotations`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAnnotationsRequest) Reset() {
	*x = ListAnnotationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnnotationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnnotationsRequest) ProtoMessage() {}

func (x *ListAnnotationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnnotationsRequest.ProtoReflect.Descriptor instead.
func (*ListAnnotationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{38}
}

func (x *ListAnnotationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAnnotationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAnnotationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAnnotationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for ListAnnotations.
type ListAnnotationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The annotations for this image.
	Annotations []*Annotation `protobuf:"bytes,1,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAnnotationsResponse) Reset() {
	*x = ListAnnotationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnnotationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnnotationsResponse) ProtoMessage() {}

func (x *ListAnnotationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnnotationsResponse.ProtoReflect.Descriptor instead.
func (*ListAnnotationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{39}
}

func (x *ListAnnotationsResponse) GetAnnotations() []*Annotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *ListAnnotationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Operation metadata for DeleteAnnotation.
type DeleteAnnotationOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *DeleteAnnotationOperationMetadata) Reset() {
	*x = DeleteAnnotationOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAnnotationOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAnnotationOperationMetadata) ProtoMessage() {}

func (x *DeleteAnnotationOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAnnotationOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteAnnotationOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{40}
}

func (x *DeleteAnnotationOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for creating a Module.
type CreateModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Module to create.
	Module *Module `protobuf:"bytes,2,opt,name=module,proto3" json:"module,omitempty"`
}

func (x *CreateModuleRequest) Reset() {
	*x = CreateModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateModuleRequest) ProtoMessage() {}

func (x *CreateModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateModuleRequest.ProtoReflect.Descriptor instead.
func (*CreateModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{41}
}

func (x *CreateModuleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateModuleRequest) GetModule() *Module {
	if x != nil {
		return x.Module
	}
	return nil
}

// Request for listing Modules.
type ListModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of Modules to return. The service may return
	// fewer than this value. If unspecified, at most 20 Modules will be
	// returned. The maximum value is 100; values above 100 will be coerced to
	// 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListModules` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListModules`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListModulesRequest) Reset() {
	*x = ListModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModulesRequest) ProtoMessage() {}

func (x *ListModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListModulesRequest.ProtoReflect.Descriptor instead.
func (*ListModulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{42}
}

func (x *ListModulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListModulesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListModulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListModulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for ListModules.
type ListModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Modules.
	Modules []*Module `protobuf:"bytes,1,rep,name=modules,proto3" json:"modules,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListModulesResponse) Reset() {
	*x = ListModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModulesResponse) ProtoMessage() {}

func (x *ListModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListModulesResponse.ProtoReflect.Descriptor instead.
func (*ListModulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{43}
}

func (x *ListModulesResponse) GetModules() []*Module {
	if x != nil {
		return x.Modules
	}
	return nil
}

func (x *ListModulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for getting a Module.
type GetModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Module identifier.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetModuleRequest) Reset() {
	*x = GetModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModuleRequest) ProtoMessage() {}

func (x *GetModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModuleRequest.ProtoReflect.Descriptor instead.
func (*GetModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{44}
}

func (x *GetModuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for deleting a Module.
type DeleteModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Module identifier.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteModuleRequest) Reset() {
	*x = DeleteModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteModuleRequest) ProtoMessage() {}

func (x *DeleteModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteModuleRequest.ProtoReflect.Descriptor instead.
func (*DeleteModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{45}
}

func (x *DeleteModuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Operation metadata for DeleteModule.
type DeleteModuleOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *DeleteModuleOperationMetadata) Reset() {
	*x = DeleteModuleOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteModuleOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteModuleOperationMetadata) ProtoMessage() {}

func (x *DeleteModuleOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteModuleOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteModuleOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{46}
}

func (x *DeleteModuleOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for updating a Module.
type UpdateModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Module which replaces the resource on the server.
	Module *Module `protobuf:"bytes,1,opt,name=module,proto3" json:"module,omitempty"`
	// Required. The update mask applies to the resource.
	// For the `FieldMask` definition, see
	//
	// [FieldMask](https:
	// //developers.google.com/protocol-buffers
	// // /docs/reference/google.protobuf#fieldmask).
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateModuleRequest) Reset() {
	*x = UpdateModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateModuleRequest) ProtoMessage() {}

func (x *UpdateModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateModuleRequest.ProtoReflect.Descriptor instead.
func (*UpdateModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{47}
}

func (x *UpdateModuleRequest) GetModule() *Module {
	if x != nil {
		return x.Module
	}
	return nil
}

func (x *UpdateModuleRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for creating a Model. This invokes the training process for
// the parent Module.
type CreateModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Model to create.
	Model *Model `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *CreateModelRequest) Reset() {
	*x = CreateModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateModelRequest) ProtoMessage() {}

func (x *CreateModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateModelRequest.ProtoReflect.Descriptor instead.
func (*CreateModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{48}
}

func (x *CreateModelRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateModelRequest) GetModel() *Model {
	if x != nil {
		return x.Model
	}
	return nil
}

// Operation metadata for CreateModel.
type CreateModelOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *CreateModelOperationMetadata) Reset() {
	*x = CreateModelOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateModelOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateModelOperationMetadata) ProtoMessage() {}

func (x *CreateModelOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateModelOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateModelOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{49}
}

func (x *CreateModelOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for listing Models.
type ListModelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of Models to return. The service may return
	// fewer than this value. If unspecified, at most 20 Models will be
	// returned. The maximum value is 100; values above 100 will be coerced to
	// 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListModels` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListModels`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListModelsRequest) Reset() {
	*x = ListModelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListModelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModelsRequest) ProtoMessage() {}

func (x *ListModelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListModelsRequest.ProtoReflect.Descriptor instead.
func (*ListModelsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{50}
}

func (x *ListModelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListModelsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListModelsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListModelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for ListModels.
type ListModelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Model.
	Models []*Model `protobuf:"bytes,1,rep,name=models,proto3" json:"models,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListModelsResponse) Reset() {
	*x = ListModelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListModelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModelsResponse) ProtoMessage() {}

func (x *ListModelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListModelsResponse.ProtoReflect.Descriptor instead.
func (*ListModelsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{51}
}

func (x *ListModelsResponse) GetModels() []*Model {
	if x != nil {
		return x.Models
	}
	return nil
}

func (x *ListModelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for getting a Model.
type GetModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Model identifier.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetModelRequest) Reset() {
	*x = GetModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModelRequest) ProtoMessage() {}

func (x *GetModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModelRequest.ProtoReflect.Descriptor instead.
func (*GetModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{52}
}

func (x *GetModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for deleting a Model.
type DeleteModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Model identifier.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteModelRequest) Reset() {
	*x = DeleteModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteModelRequest) ProtoMessage() {}

func (x *DeleteModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteModelRequest.ProtoReflect.Descriptor instead.
func (*DeleteModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{53}
}

func (x *DeleteModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Operation metadata for DeleteModel.
type DeleteModelOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *DeleteModelOperationMetadata) Reset() {
	*x = DeleteModelOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteModelOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteModelOperationMetadata) ProtoMessage() {}

func (x *DeleteModelOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteModelOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteModelOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{54}
}

func (x *DeleteModelOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for updating a Model.
type UpdateModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Model which replaces the resource on the server.
	Model *Model `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The update mask applies to the resource.
	// For the `FieldMask` definition, see
	//
	// [FieldMask](https:
	// //developers.google.com/protocol-buffers
	// // /docs/reference/google.protobuf#fieldmask).
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateModelRequest) Reset() {
	*x = UpdateModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateModelRequest) ProtoMessage() {}

func (x *UpdateModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateModelRequest.ProtoReflect.Descriptor instead.
func (*UpdateModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{55}
}

func (x *UpdateModelRequest) GetModel() *Model {
	if x != nil {
		return x.Model
	}
	return nil
}

func (x *UpdateModelRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for listing ModelEvaluations.
type ListModelEvaluationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent identifier.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of ModelEvaluations to return. The service may return
	// fewer than this value. If unspecified, at most 20 ModelEvaluations will be
	// returned. The maximum value is 100; values above 100 will be coerced to
	// 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ModelEvaluations` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ModelEvaluations`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListModelEvaluationsRequest) Reset() {
	*x = ListModelEvaluationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListModelEvaluationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModelEvaluationsRequest) ProtoMessage() {}

func (x *ListModelEvaluationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListModelEvaluationsRequest.ProtoReflect.Descriptor instead.
func (*ListModelEvaluationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{56}
}

func (x *ListModelEvaluationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListModelEvaluationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListModelEvaluationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListModelEvaluationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for ListModelEvaluations.
type ListModelEvaluationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ModelEvaluation.
	ModelEvaluations []*ModelEvaluation `protobuf:"bytes,1,rep,name=model_evaluations,json=modelEvaluations,proto3" json:"model_evaluations,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListModelEvaluationsResponse) Reset() {
	*x = ListModelEvaluationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListModelEvaluationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModelEvaluationsResponse) ProtoMessage() {}

func (x *ListModelEvaluationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListModelEvaluationsResponse.ProtoReflect.Descriptor instead.
func (*ListModelEvaluationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{57}
}

func (x *ListModelEvaluationsResponse) GetModelEvaluations() []*ModelEvaluation {
	if x != nil {
		return x.ModelEvaluations
	}
	return nil
}

func (x *ListModelEvaluationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for getting a ModelEvaluation.
type GetModelEvaluationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ModelEvaluation identifier.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetModelEvaluationRequest) Reset() {
	*x = GetModelEvaluationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetModelEvaluationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModelEvaluationRequest) ProtoMessage() {}

func (x *GetModelEvaluationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModelEvaluationRequest.ProtoReflect.Descriptor instead.
func (*GetModelEvaluationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{58}
}

func (x *GetModelEvaluationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for enriching the Dataset with predicted Annotations from a
// Model.
type WritePredictionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Model identifier.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// A score threshold in the range [0, 1] to filter output Annotations. If set,
	// only Annotations with at least this score will be saved in the output
	// AnnotationSet. Otherwise a default value will be used based on the Module.
	OutputScoreThreshold float32 `protobuf:"fixed32,2,opt,name=output_score_threshold,json=outputScoreThreshold,proto3" json:"output_score_threshold,omitempty"`
	// An IOU (intersection over union) threshold in the range [0, 1] to use for
	// matching Annotations for some Module types. New Annotations must have at
	// least this IOU in in relation to an old Anotation to be considered
	// matching. If not provided, a default value will be used based on the
	// Module.
	OutputMatchingIouThreshold float32 `protobuf:"fixed32,3,opt,name=output_matching_iou_threshold,json=outputMatchingIouThreshold,proto3" json:"output_matching_iou_threshold,omitempty"`
	// By default WritePredictions copies all Annotation labels from old
	// Annotations to new Annotations. These fields give finer control over which
	// label keys to copy. If provided, only keys in this list will be copied.
	LabelKeysCopyAllowlist []string `protobuf:"bytes,4,rep,name=label_keys_copy_allowlist,json=labelKeysCopyAllowlist,proto3" json:"label_keys_copy_allowlist,omitempty"`
	// If provided, no keys in this list will be copied, even if they appear
	// in the allowlist.
	LabelKeysCopyDenylist []string `protobuf:"bytes,5,rep,name=label_keys_copy_denylist,json=labelKeysCopyDenylist,proto3" json:"label_keys_copy_denylist,omitempty"`
}

func (x *WritePredictionsRequest) Reset() {
	*x = WritePredictionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WritePredictionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WritePredictionsRequest) ProtoMessage() {}

func (x *WritePredictionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WritePredictionsRequest.ProtoReflect.Descriptor instead.
func (*WritePredictionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{59}
}

func (x *WritePredictionsRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *WritePredictionsRequest) GetOutputScoreThreshold() float32 {
	if x != nil {
		return x.OutputScoreThreshold
	}
	return 0
}

func (x *WritePredictionsRequest) GetOutputMatchingIouThreshold() float32 {
	if x != nil {
		return x.OutputMatchingIouThreshold
	}
	return 0
}

func (x *WritePredictionsRequest) GetLabelKeysCopyAllowlist() []string {
	if x != nil {
		return x.LabelKeysCopyAllowlist
	}
	return nil
}

func (x *WritePredictionsRequest) GetLabelKeysCopyDenylist() []string {
	if x != nil {
		return x.LabelKeysCopyDenylist
	}
	return nil
}

// Operation metadata for WritePredictions.
type WritePredictionsOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *WritePredictionsOperationMetadata) Reset() {
	*x = WritePredictionsOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WritePredictionsOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WritePredictionsOperationMetadata) ProtoMessage() {}

func (x *WritePredictionsOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WritePredictionsOperationMetadata.ProtoReflect.Descriptor instead.
func (*WritePredictionsOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{60}
}

func (x *WritePredictionsOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for creating a SpecialistPool.
type CreateSpecialistPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent Project name for the new SpecialistPool.
	// The form is `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The SpecialistPool to create.
	SpecialistPool *SpecialistPool `protobuf:"bytes,2,opt,name=specialist_pool,json=specialistPool,proto3" json:"specialist_pool,omitempty"`
}

func (x *CreateSpecialistPoolRequest) Reset() {
	*x = CreateSpecialistPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSpecialistPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSpecialistPoolRequest) ProtoMessage() {}

func (x *CreateSpecialistPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSpecialistPoolRequest.ProtoReflect.Descriptor instead.
func (*CreateSpecialistPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{61}
}

func (x *CreateSpecialistPoolRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSpecialistPoolRequest) GetSpecialistPool() *SpecialistPool {
	if x != nil {
		return x.SpecialistPool
	}
	return nil
}

// Operation metadata for CreateSpecialistPool.
type CreateSpecialistPoolOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *CreateSpecialistPoolOperationMetadata) Reset() {
	*x = CreateSpecialistPoolOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSpecialistPoolOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSpecialistPoolOperationMetadata) ProtoMessage() {}

func (x *CreateSpecialistPoolOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSpecialistPoolOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateSpecialistPoolOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{62}
}

func (x *CreateSpecialistPoolOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for getting a SpecialistPool.
type GetSpecialistPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the SpecialistPool resource.
	// The form is
	//
	// `projects/{project}/locations/{location}/specialistPools/{specialist_pool}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSpecialistPoolRequest) Reset() {
	*x = GetSpecialistPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSpecialistPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSpecialistPoolRequest) ProtoMessage() {}

func (x *GetSpecialistPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSpecialistPoolRequest.ProtoReflect.Descriptor instead.
func (*GetSpecialistPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{63}
}

func (x *GetSpecialistPoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for updating a SpecialistPool.
type UpdateSpecialistPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The SpecialistPool which replaces the resource on the server.
	SpecialistPool *SpecialistPool `protobuf:"bytes,1,opt,name=specialist_pool,json=specialistPool,proto3" json:"specialist_pool,omitempty"`
	// Required. The update mask applies to the resource.
	// For the `FieldMask` definition, see
	//
	// [FieldMask](https:
	// //developers.google.com/protocol-buffers
	// // /docs/reference/google.protobuf#fieldmask).
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSpecialistPoolRequest) Reset() {
	*x = UpdateSpecialistPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSpecialistPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSpecialistPoolRequest) ProtoMessage() {}

func (x *UpdateSpecialistPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSpecialistPoolRequest.ProtoReflect.Descriptor instead.
func (*UpdateSpecialistPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{64}
}

func (x *UpdateSpecialistPoolRequest) GetSpecialistPool() *SpecialistPool {
	if x != nil {
		return x.SpecialistPool
	}
	return nil
}

func (x *UpdateSpecialistPoolRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Operation metadata for UpdateSpecialistPool.
type UpdateSpecialistPoolOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *UpdateSpecialistPoolOperationMetadata) Reset() {
	*x = UpdateSpecialistPoolOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSpecialistPoolOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSpecialistPoolOperationMetadata) ProtoMessage() {}

func (x *UpdateSpecialistPoolOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSpecialistPoolOperationMetadata.ProtoReflect.Descriptor instead.
func (*UpdateSpecialistPoolOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{65}
}

func (x *UpdateSpecialistPoolOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request message for listing SpecialistPools.
type ListSpecialistPoolsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the SpecialistPool's parent resource.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The number of SpecialistPools to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListSpecialistPoolsRequest` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListSpecialistPoolsRequest` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListSpecialistPoolsRequest) Reset() {
	*x = ListSpecialistPoolsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSpecialistPoolsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpecialistPoolsRequest) ProtoMessage() {}

func (x *ListSpecialistPoolsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpecialistPoolsRequest.ProtoReflect.Descriptor instead.
func (*ListSpecialistPoolsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{66}
}

func (x *ListSpecialistPoolsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSpecialistPoolsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSpecialistPoolsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSpecialistPoolsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for ListSpecialistPools.
type ListSpecialistPoolsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of SpecialistPools that matches the specified filter in the request.
	SpecialistPools []*SpecialistPool `protobuf:"bytes,1,rep,name=specialist_pools,json=specialistPools,proto3" json:"specialist_pools,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSpecialistPoolsResponse) Reset() {
	*x = ListSpecialistPoolsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSpecialistPoolsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpecialistPoolsResponse) ProtoMessage() {}

func (x *ListSpecialistPoolsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpecialistPoolsResponse.ProtoReflect.Descriptor instead.
func (*ListSpecialistPoolsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{67}
}

func (x *ListSpecialistPoolsResponse) GetSpecialistPools() []*SpecialistPool {
	if x != nil {
		return x.SpecialistPools
	}
	return nil
}

func (x *ListSpecialistPoolsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for deleting a specialist pool.
type DeleteSpecialistPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the SpecialistPool to delete. Format:
	//
	// `projects/{project}/locations/{location}/specialistPools/{specialist_pool}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSpecialistPoolRequest) Reset() {
	*x = DeleteSpecialistPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSpecialistPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSpecialistPoolRequest) ProtoMessage() {}

func (x *DeleteSpecialistPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSpecialistPoolRequest.ProtoReflect.Descriptor instead.
func (*DeleteSpecialistPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{68}
}

func (x *DeleteSpecialistPoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Operation metadata for DeleteSpecialistPool.
type DeleteSpecialistPoolOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *DeleteSpecialistPoolOperationMetadata) Reset() {
	*x = DeleteSpecialistPoolOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSpecialistPoolOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSpecialistPoolOperationMetadata) ProtoMessage() {}

func (x *DeleteSpecialistPoolOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSpecialistPoolOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteSpecialistPoolOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{69}
}

func (x *DeleteSpecialistPoolOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request for creating a labeling job.
type CreateLabelingJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent of the LabelingJob.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The LabelingJob to create.
	LabelingJob *LabelingJob `protobuf:"bytes,2,opt,name=labeling_job,json=labelingJob,proto3" json:"labeling_job,omitempty"`
}

func (x *CreateLabelingJobRequest) Reset() {
	*x = CreateLabelingJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateLabelingJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateLabelingJobRequest) ProtoMessage() {}

func (x *CreateLabelingJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateLabelingJobRequest.ProtoReflect.Descriptor instead.
func (*CreateLabelingJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{70}
}

func (x *CreateLabelingJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateLabelingJobRequest) GetLabelingJob() *LabelingJob {
	if x != nil {
		return x.LabelingJob
	}
	return nil
}

// Request for getting a labeling job.
type GetLabelingJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the LabelingJob.
	// Format:
	// `projects/{project}/locations/{location}/labelingJobs/{labeling_job}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetLabelingJobRequest) Reset() {
	*x = GetLabelingJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLabelingJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLabelingJobRequest) ProtoMessage() {}

func (x *GetLabelingJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLabelingJobRequest.ProtoReflect.Descriptor instead.
func (*GetLabelingJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{71}
}

func (x *GetLabelingJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for listing labeling jobs.
type ListLabelingJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the LabelingJob's parent resource.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The number of labeling jobs to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListLabelingJobsRequest` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListLabelingJobsRequest` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListLabelingJobsRequest) Reset() {
	*x = ListLabelingJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLabelingJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelingJobsRequest) ProtoMessage() {}

func (x *ListLabelingJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLabelingJobsRequest.ProtoReflect.Descriptor instead.
func (*ListLabelingJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{72}
}

func (x *ListLabelingJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListLabelingJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLabelingJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListLabelingJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for listing labeling jobs.
type ListLabelingJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of SpecialistPools that matches the specified filter in the request.
	LabelingJobs []*LabelingJob `protobuf:"bytes,1,rep,name=labeling_jobs,json=labelingJobs,proto3" json:"labeling_jobs,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListLabelingJobsResponse) Reset() {
	*x = ListLabelingJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLabelingJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelingJobsResponse) ProtoMessage() {}

func (x *ListLabelingJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLabelingJobsResponse.ProtoReflect.Descriptor instead.
func (*ListLabelingJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{73}
}

func (x *ListLabelingJobsResponse) GetLabelingJobs() []*LabelingJob {
	if x != nil {
		return x.LabelingJobs
	}
	return nil
}

func (x *ListLabelingJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for deleting a labeling job.
type DeleteLabelingJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the labeling job to delete. Format:
	// `projects/{project}/locations/{location}/labelingJobs/{labeling_job}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteLabelingJobRequest) Reset() {
	*x = DeleteLabelingJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteLabelingJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteLabelingJobRequest) ProtoMessage() {}

func (x *DeleteLabelingJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteLabelingJobRequest.ProtoReflect.Descriptor instead.
func (*DeleteLabelingJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{74}
}

func (x *DeleteLabelingJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Operation metadata for deleting a labeling job.
type DeleteLabelingJobOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *DeleteLabelingJobOperationMetadata) Reset() {
	*x = DeleteLabelingJobOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteLabelingJobOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteLabelingJobOperationMetadata) ProtoMessage() {}

func (x *DeleteLabelingJobOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteLabelingJobOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteLabelingJobOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{75}
}

func (x *DeleteLabelingJobOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

// Request message for cancelling a labeling job.
type CancelLabelingJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the labeling job to cancel. Format:
	// `projects/{project}/locations/{location}/labelingJobs/{labeling_job}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelLabelingJobRequest) Reset() {
	*x = CancelLabelingJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelLabelingJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelLabelingJobRequest) ProtoMessage() {}

func (x *CancelLabelingJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelLabelingJobRequest.ProtoReflect.Descriptor instead.
func (*CancelLabelingJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{76}
}

func (x *CancelLabelingJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for BatchPredict.
type BatchPredictRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. SolutionArtifact identifier.
	SolutionArtifact string `protobuf:"bytes,1,opt,name=solution_artifact,json=solutionArtifact,proto3" json:"solution_artifact,omitempty"`
	// Required. The input configuration for batch prediction.
	// The Cloud Storage path of input file. Accepted forms:
	// * Full object path, e.g. gs://bucket/directory/object.csv in which each
	// line is the full path to a image file.
	InputUri string `protobuf:"bytes,2,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Required. The Cloud Storage location of the directory where the output is
	// to be written to. Output directory will contain:
	// 1. output.jsonl
	// # Each line is a JSON format of PredictionResult.
	//
	// 2. category_masks (for MaskAnnotation)
	// # Directory of masks - referenced via annotation in output.jsonl.
	//
	// 3. confidence_masks (for MaskAnnotation)
	// # Directory of masks - referenced via annotation in output.jsonl.
	OutputGcsDir *GcsDestination `protobuf:"bytes,3,opt,name=output_gcs_dir,json=outputGcsDir,proto3" json:"output_gcs_dir,omitempty"`
}

func (x *BatchPredictRequest) Reset() {
	*x = BatchPredictRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchPredictRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchPredictRequest) ProtoMessage() {}

func (x *BatchPredictRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchPredictRequest.ProtoReflect.Descriptor instead.
func (*BatchPredictRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{77}
}

func (x *BatchPredictRequest) GetSolutionArtifact() string {
	if x != nil {
		return x.SolutionArtifact
	}
	return ""
}

func (x *BatchPredictRequest) GetInputUri() string {
	if x != nil {
		return x.InputUri
	}
	return ""
}

func (x *BatchPredictRequest) GetOutputGcsDir() *GcsDestination {
	if x != nil {
		return x.OutputGcsDir
	}
	return nil
}

// Operation metadata for BatchPreidct.
type BatchPredictOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Common operation metadata.
	CommonOperationMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_operation_metadata,json=commonOperationMetadata,proto3" json:"common_operation_metadata,omitempty"`
}

func (x *BatchPredictOperationMetadata) Reset() {
	*x = BatchPredictOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchPredictOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchPredictOperationMetadata) ProtoMessage() {}

func (x *BatchPredictOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchPredictOperationMetadata.ProtoReflect.Descriptor instead.
func (*BatchPredictOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{78}
}

func (x *BatchPredictOperationMetadata) GetCommonOperationMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonOperationMetadata
	}
	return nil
}

type BatchPredictResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BatchPredictResponse) Reset() {
	*x = BatchPredictResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchPredictResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchPredictResponse) ProtoMessage() {}

func (x *BatchPredictResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchPredictResponse.ProtoReflect.Descriptor instead.
func (*BatchPredictResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{79}
}

type ExportDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExportDataResponse) Reset() {
	*x = ExportDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDataResponse) ProtoMessage() {}

func (x *ExportDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDataResponse.ProtoReflect.Descriptor instead.
func (*ExportDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{80}
}

type ImportDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ImportDataResponse) Reset() {
	*x = ImportDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDataResponse) ProtoMessage() {}

func (x *ImportDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDataResponse.ProtoReflect.Descriptor instead.
func (*ImportDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{81}
}

type WritePredictionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WritePredictionsResponse) Reset() {
	*x = WritePredictionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WritePredictionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WritePredictionsResponse) ProtoMessage() {}

func (x *WritePredictionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WritePredictionsResponse.ProtoReflect.Descriptor instead.
func (*WritePredictionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{82}
}

// Configuration specific to training parameters.
type Solution_TrainingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Training time for each individual artifacts.
	TrainingDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=training_duration,json=trainingDuration,proto3" json:"training_duration,omitempty"`
	// Optional. Structured object containing parameters to fine tune the
	// training behavior.
	Parameters *structpb.Struct `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *Solution_TrainingConfig) Reset() {
	*x = Solution_TrainingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Solution_TrainingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Solution_TrainingConfig) ProtoMessage() {}

func (x *Solution_TrainingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Solution_TrainingConfig.ProtoReflect.Descriptor instead.
func (*Solution_TrainingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Solution_TrainingConfig) GetTrainingDuration() *durationpb.Duration {
	if x != nil {
		return x.TrainingDuration
	}
	return nil
}

func (x *Solution_TrainingConfig) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// A predefined SolutionType.
type Solution_SolutionType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The predefined type of this Solution.
	//
	// Types that are assignable to Type:
	//	*Solution_SolutionType_AssemblyInspection
	//	*Solution_SolutionType_CosmeticInspection
	//	*Solution_SolutionType_CustomInspection
	Type isSolution_SolutionType_Type `protobuf_oneof:"type"`
}

func (x *Solution_SolutionType) Reset() {
	*x = Solution_SolutionType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Solution_SolutionType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Solution_SolutionType) ProtoMessage() {}

func (x *Solution_SolutionType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Solution_SolutionType.ProtoReflect.Descriptor instead.
func (*Solution_SolutionType) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{0, 1}
}

func (m *Solution_SolutionType) GetType() isSolution_SolutionType_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *Solution_SolutionType) GetAssemblyInspection() *Solution_SolutionType_AssemblyInspectionOptions {
	if x, ok := x.GetType().(*Solution_SolutionType_AssemblyInspection); ok {
		return x.AssemblyInspection
	}
	return nil
}

func (x *Solution_SolutionType) GetCosmeticInspection() *Solution_SolutionType_CosmeticInspectionOptions {
	if x, ok := x.GetType().(*Solution_SolutionType_CosmeticInspection); ok {
		return x.CosmeticInspection
	}
	return nil
}

func (x *Solution_SolutionType) GetCustomInspection() *Solution_SolutionType_CustomInspectionOptions {
	if x, ok := x.GetType().(*Solution_SolutionType_CustomInspection); ok {
		return x.CustomInspection
	}
	return nil
}

type isSolution_SolutionType_Type interface {
	isSolution_SolutionType_Type()
}

type Solution_SolutionType_AssemblyInspection struct {
	// Predefined solution for assembly inspection.
	AssemblyInspection *Solution_SolutionType_AssemblyInspectionOptions `protobuf:"bytes,1,opt,name=assembly_inspection,json=assemblyInspection,proto3,oneof"`
}

type Solution_SolutionType_CosmeticInspection struct {
	// Predefined solution for cosmetic inspection.
	CosmeticInspection *Solution_SolutionType_CosmeticInspectionOptions `protobuf:"bytes,2,opt,name=cosmetic_inspection,json=cosmeticInspection,proto3,oneof"`
}

type Solution_SolutionType_CustomInspection struct {
	// Customized solution for inspection.
	CustomInspection *Solution_SolutionType_CustomInspectionOptions `protobuf:"bytes,3,opt,name=custom_inspection,json=customInspection,proto3,oneof"`
}

func (*Solution_SolutionType_AssemblyInspection) isSolution_SolutionType_Type() {}

func (*Solution_SolutionType_CosmeticInspection) isSolution_SolutionType_Type() {}

func (*Solution_SolutionType_CustomInspection) isSolution_SolutionType_Type() {}

// Options for an assembly inspection Solution.
type Solution_SolutionType_AssemblyInspectionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Solution_SolutionType_AssemblyInspectionOptions) Reset() {
	*x = Solution_SolutionType_AssemblyInspectionOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Solution_SolutionType_AssemblyInspectionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Solution_SolutionType_AssemblyInspectionOptions) ProtoMessage() {}

func (x *Solution_SolutionType_AssemblyInspectionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Solution_SolutionType_AssemblyInspectionOptions.ProtoReflect.Descriptor instead.
func (*Solution_SolutionType_AssemblyInspectionOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{0, 1, 0}
}

// Options for cosmetic inspection Solution.
type Solution_SolutionType_CosmeticInspectionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Solution_SolutionType_CosmeticInspectionOptions) Reset() {
	*x = Solution_SolutionType_CosmeticInspectionOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Solution_SolutionType_CosmeticInspectionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Solution_SolutionType_CosmeticInspectionOptions) ProtoMessage() {}

func (x *Solution_SolutionType_CosmeticInspectionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Solution_SolutionType_CosmeticInspectionOptions.ProtoReflect.Descriptor instead.
func (*Solution_SolutionType_CosmeticInspectionOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{0, 1, 1}
}

// Options for a custom inspection Solution.
type Solution_SolutionType_CustomInspectionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Solution_SolutionType_CustomInspectionOptions) Reset() {
	*x = Solution_SolutionType_CustomInspectionOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Solution_SolutionType_CustomInspectionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Solution_SolutionType_CustomInspectionOptions) ProtoMessage() {}

func (x *Solution_SolutionType_CustomInspectionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Solution_SolutionType_CustomInspectionOptions.ProtoReflect.Descriptor instead.
func (*Solution_SolutionType_CustomInspectionOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP(), []int{0, 1, 2}
}

var File_google_cloud_visualinspection_v1beta1_service_proto protoreflect.FileDescriptor

var file_google_cloud_visualinspection_v1beta1_service_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x67, 0x65, 0x6f, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x75,
	0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xd8, 0x0b, 0x0a, 0x08, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x12, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0f, 0x67, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69,
	0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x6c, 0x0a, 0x0f, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x58, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x66, 0x0a, 0x0d, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x9b, 0x01, 0x0a, 0x0e, 0x54, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x11, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x89, 0x04, 0x0a, 0x0c, 0x53, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x89, 0x01, 0x0a, 0x13, 0x61, 0x73, 0x73, 0x65,
	0x6d, 0x62, 0x6c, 0x79, 0x5f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x6d, 0x62, 0x6c, 0x79, 0x49, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52,
	0x12, 0x61, 0x73, 0x73, 0x65, 0x6d, 0x62, 0x6c, 0x79, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x89, 0x01, 0x0a, 0x13, 0x63, 0x6f, 0x73, 0x6d, 0x65, 0x74, 0x69, 0x63,
	0x5f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x43, 0x6f, 0x73, 0x6d, 0x65, 0x74, 0x69, 0x63, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x12, 0x63, 0x6f, 0x73,
	0x6d, 0x65, 0x74, 0x69, 0x63, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x83, 0x01, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x48, 0x00, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x1b, 0x0a, 0x19, 0x41, 0x73, 0x73, 0x65, 0x6d, 0x62, 0x6c,
	0x79, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0x1b, 0x0a, 0x19, 0x43, 0x6f, 0x73, 0x6d, 0x65, 0x74, 0x69, 0x63, 0x49, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a,
	0x19, 0x0a, 0x17, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x6b, 0xea,
	0x41, 0x68, 0x0a, 0x28, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0x9c, 0x01, 0x0a, 0x19, 0x53,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xb3, 0x01, 0x0a, 0x15, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a,
	0x08, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xb4, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x12, 0x28, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x8e, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x4d, 0x0a, 0x09, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5a, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x53, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xa2, 0x01, 0x0a, 0x1f, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xa2, 0x01, 0x0a, 0x1f, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x19,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xa4, 0x01,
	0x0a, 0x21, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x22, 0xdc, 0x01, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x69, 0x0a, 0x11, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x10, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x22, 0xaa, 0x01, 0x0a, 0x27, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x7f, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x22, 0xc4, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x76, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xaf, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x12, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x11,
	0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6a, 0x0a, 0x1a, 0x47, 0x65, 0x74,
	0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6d, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xaa, 0x01, 0x0a, 0x27, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0xcc, 0x01, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x69, 0x0a, 0x11, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0xa1, 0x01, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x22, 0x58, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a,
	0x27, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5b,
	0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb2, 0x01, 0x0a, 0x13,
	0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x8a, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x08, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x08, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xbd, 0x01,
	0x0a, 0x11, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x76, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x63, 0x0a, 0x0e, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d,
	0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x22, 0x9e, 0x01,
	0x0a, 0x1b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a,
	0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xbb,
	0x01, 0x0a, 0x11, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x76, 0x69, 0x73, 0x75,
	0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x0d, 0x65, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c,
	0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x9e, 0x01, 0x0a,
	0x1b, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x19,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xa1, 0x01,
	0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0x54, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x76, 0x69, 0x73, 0x75,
	0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xae, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x82, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x44, 0x0a, 0x06, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x06, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcd, 0x01,
	0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x60, 0x0a, 0x0e, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x22, 0xbe, 0x01,
	0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa3,
	0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a,
	0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x52, 0x0e, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa7, 0x01, 0x0a, 0x24, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a,
	0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xd2,
	0x01, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x63,
	0x0a, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x22, 0xc0, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x76, 0x69, 0x73, 0x75,
	0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa7, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x10, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xa8, 0x01, 0x0a, 0x25, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xb8, 0x01, 0x0a, 0x16,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x96, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x53, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xa4, 0x01, 0x0a, 0x21, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xa9, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x22, 0xb0, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x28, 0x12, 0x26, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x86, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a,
	0x07, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x07, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x56,
	0x0a, 0x10, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x59, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xa0, 0x01, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x22, 0xa3, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75,
	0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa4, 0x01, 0x0a, 0x12, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x76, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x22, 0x9f, 0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x22, 0xae, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x27, 0x12, 0x25, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x82, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x06, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x54, 0x0a, 0x0f, 0x47, 0x65, 0x74,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x57, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9f, 0x01, 0x0a, 0x1c, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75,
	0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x9f, 0x01, 0x0a, 0x12, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x47, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xc2, 0x01, 0x0a,
	0x1b, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x31, 0x12, 0x2f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xab, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x63, 0x0a, 0x11, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x65, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x68, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x31, 0x0a, 0x2f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcb, 0x02, 0x0a, 0x17, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x34, 0x0a, 0x16, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x14, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x12, 0x41, 0x0a, 0x1d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6f, 0x75, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x1a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x49, 0x6f, 0x75, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x12, 0x39, 0x0a, 0x19, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6b, 0x65, 0x79,
	0x73, 0x5f, 0x63, 0x6f, 0x70, 0x79, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x16, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x4b, 0x65, 0x79,
	0x73, 0x43, 0x6f, 0x70, 0x79, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74, 0x12, 0x37,
	0x0a, 0x18, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x5f, 0x63, 0x6f, 0x70,
	0x79, 0x5f, 0x64, 0x65, 0x6e, 0x79, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x15, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x4b, 0x65, 0x79, 0x73, 0x43, 0x6f, 0x70, 0x79, 0x44,
	0x65, 0x6e, 0x79, 0x6c, 0x69, 0x73, 0x74, 0x22, 0xa4, 0x01, 0x0a, 0x21, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a,
	0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xd2,
	0x01, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
	0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69,
	0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x63,
	0x0a, 0x0f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50,
	0x6f, 0x6f, 0x6c, 0x22, 0xa8, 0x01, 0x0a, 0x25, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a,
	0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x66,
	0x0a, 0x18, 0x47, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50,
	0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30,
	0x0a, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc4, 0x01, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x63, 0x0a, 0x0f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61,
	0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69,
	0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x73, 0x70, 0x65,
	0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa8, 0x01,
	0x0a, 0x25, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69,
	0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xc0, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12,
	0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa7, 0x01, 0x0a, 0x1b,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f,
	0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x10, 0x73,
	0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70,
	0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0f, 0x73, 0x70,
	0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x69, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x76, 0x69, 0x73, 0x75,
	0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x65, 0x63,
	0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xa8, 0x01, 0x0a, 0x25, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69,
	0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xc3, 0x01, 0x0a, 0x18,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f,
	0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x12, 0x2b, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x0c, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f,
	0x62, 0x22, 0x60, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x0a, 0x2b, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xba, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x22, 0x9b, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a,
	0x0d, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x63,
	0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x0a, 0x2b, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xa5, 0x01, 0x0a, 0x22, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x63, 0x0a, 0x18, 0x43,
	0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x80, 0x02, 0x0a, 0x13, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x65, 0x0a, 0x11, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x10, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x55, 0x72,
	0x69, 0x12, 0x60, 0x0a, 0x0e, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x67, 0x63, 0x73, 0x5f,
	0x64, 0x69, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x47, 0x63, 0x73,
	0x44, 0x69, 0x72, 0x22, 0xa0, 0x01, 0x0a, 0x1d, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x16, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x14,
	0x0a, 0x12, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x14, 0x0a, 0x12, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1a, 0x0a, 0x18, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0xde, 0x53, 0x0a, 0x10, 0x56, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xed, 0x01, 0x0a, 0x0e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7e, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3e, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x08, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0xca, 0x41, 0x25, 0x0a, 0x08, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x19, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xcf, 0x01, 0x0a, 0x0d,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34,
	0x12, 0x32, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xbc, 0x01,
	0x0a, 0x0b, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xba, 0x02, 0x0a,
	0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xba, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x3a, 0x11, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0xda, 0x41, 0x18, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0xca, 0x41, 0x3b, 0x0a, 0x10,
	0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x12, 0x27, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xfb, 0x01, 0x0a, 0x15, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x73, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x57,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xe8, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x53,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12,
	0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x22, 0x55, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x98, 0x02, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x44, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x98, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x2a, 0x46, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x40, 0x0a, 0x15, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x12, 0x27, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xad, 0x02,
	0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x22, 0x93, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6d,
	0x32, 0x58, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x11, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0xda, 0x41, 0x1d,
	0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xbe, 0x02,
	0x0a, 0x0c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x12, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd2, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x65, 0x22, 0x60, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x2c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x2c, 0x20, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x2c, 0x20, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x67,
	0x63, 0x73, 0x5f, 0x64, 0x69, 0x72, 0xca, 0x41, 0x35, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x1d, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xb8,
	0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12,
	0x31, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xcb, 0x01, 0x0a, 0x0c, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xe7, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x37, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0xf9, 0x01, 0x0a, 0x0a, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x91, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x41, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x3a, 0x01, 0x2a, 0xda, 0x41, 0x13, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0xca, 0x41, 0x31, 0x0a, 0x12, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x1b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xf8, 0x01,
	0x0a, 0x0a, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75,
	0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x90, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x22, 0x3c,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x3a, 0x01, 0x2a, 0xda,
	0x41, 0x12, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0xca, 0x41, 0x31, 0x0a, 0x12, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xbb, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x22, 0x49, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xce, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x82, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x12,
	0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x22, 0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54,
	0x22, 0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x73, 0x3a, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x65, 0x74, 0xda, 0x41, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x12, 0xee, 0x01, 0x0a,
	0x12, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44,
	0x12, 0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x88, 0x02,
	0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65,
	0x63, 0x22, 0x75, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x22, 0x43, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x73, 0x3a, 0x0f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0xda,
	0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x12, 0xf2, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x73,
	0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12,
	0x43, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xeb, 0x01,
	0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x59, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x12, 0x48, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xd7, 0x01, 0x0a, 0x0c,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75,
	0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x5c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x22,
	0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x06, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0xda, 0x41, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0xd3, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xc0, 0x01, 0x0a, 0x09,
	0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf0,
	0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x84, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3e, 0x2a, 0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x36, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0xe3, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x68, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x32, 0x43, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x06, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0xda, 0x41, 0x12, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xf5, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x8b, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x22, 0x45, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x73, 0x3a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0xca, 0x41, 0x25, 0x0a, 0x05, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x12, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xd9, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x56, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x12, 0x45, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xc6, 0x01, 0x0a, 0x08,
	0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x54,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x12, 0x45, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf6, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x2a, 0x45, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x35, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xe6, 0x01,
	0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54, 0x32, 0x4b,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0xda, 0x41, 0x11, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x8a, 0x02, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x69, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a,
	0x12, 0x58, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x45,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0xf7, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75,
	0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x12, 0x58, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x9e, 0x02,
	0x0a, 0x10, 0x57, 0x72, 0x69, 0x74, 0x65, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xaa, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5c, 0x22, 0x57, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x77, 0x72, 0x69, 0x74, 0x65, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0xca, 0x41,
	0x3d, 0x0a, 0x18, 0x57, 0x72, 0x69, 0x74, 0x65, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xa0,
	0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
	0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74,
	0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa4, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4b, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x70,
	0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x3a, 0x0f, 0x73,
	0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0xda, 0x41,
	0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69,
	0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0xca, 0x41, 0x37, 0x0a, 0x0e, 0x53, 0x70, 0x65, 0x63,
	0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x25, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0xd4, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
	0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x22,
	0x47, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb5, 0x02, 0x0a, 0x14, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f,
	0x6c, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb9, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x32, 0x48, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
	0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50,
	0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
	0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0xda, 0x41, 0x1b, 0x73, 0x70, 0x65, 0x63, 0x69,
	0x61, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41, 0x37, 0x0a, 0x0e, 0x53, 0x70, 0x65, 0x63, 0x69,
	0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x25, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0xe7, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
	0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50,
	0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69,
	0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c,
	0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x84, 0x02, 0x0a, 0x14, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50,
	0x6f, 0x6f, 0x6c, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x88, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x2a,
	0x38, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73,
	0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0xca, 0x41, 0x3e, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x25, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0xeb, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f,
	0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x22, 0x61, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x45, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x73, 0x3a, 0x0c, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x6f, 0x62, 0xda, 0x41, 0x13, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x6f, 0x62, 0x12,
	0xc8, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a,
	0x6f, 0x62, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x4a, 0x6f, 0x62, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xdb, 0x01, 0x0a, 0x10, 0x4c,
	0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x73, 0x12,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x73, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xf8, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x12, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x82,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x2a, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x3b, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x22, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a,
	0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0xbc, 0x01, 0x0a, 0x11, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x1a, 0x53, 0xca, 0x41, 0x1f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xff, 0x01, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x50, 0x01, 0x5a, 0x55, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0xaa, 0x02,
	0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56,
	0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x49, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02,
	0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_visualinspection_v1beta1_service_proto_rawDescOnce sync.Once
	file_google_cloud_visualinspection_v1beta1_service_proto_rawDescData = file_google_cloud_visualinspection_v1beta1_service_proto_rawDesc
)

func file_google_cloud_visualinspection_v1beta1_service_proto_rawDescGZIP() []byte {
	file_google_cloud_visualinspection_v1beta1_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_visualinspection_v1beta1_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_visualinspection_v1beta1_service_proto_rawDescData)
	})
	return file_google_cloud_visualinspection_v1beta1_service_proto_rawDescData
}

var file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes = make([]protoimpl.MessageInfo, 89)
var file_google_cloud_visualinspection_v1beta1_service_proto_goTypes = []interface{}{
	(*Solution)(nil),                                        // 0: google.cloud.visualinspection.v1beta1.Solution
	(*SolutionOperationMetadata)(nil),                       // 1: google.cloud.visualinspection.v1beta1.SolutionOperationMetadata
	(*CreateSolutionRequest)(nil),                           // 2: google.cloud.visualinspection.v1beta1.CreateSolutionRequest
	(*ListSolutionsRequest)(nil),                            // 3: google.cloud.visualinspection.v1beta1.ListSolutionsRequest
	(*ListSolutionsResponse)(nil),                           // 4: google.cloud.visualinspection.v1beta1.ListSolutionsResponse
	(*GetSolutionRequest)(nil),                              // 5: google.cloud.visualinspection.v1beta1.GetSolutionRequest
	(*ExportSolutionOperationMetadata)(nil),                 // 6: google.cloud.visualinspection.v1beta1.ExportSolutionOperationMetadata
	(*DeploySolutionOperationMetadata)(nil),                 // 7: google.cloud.visualinspection.v1beta1.DeploySolutionOperationMetadata
	(*UndeploySolutionOperationMetadata)(nil),               // 8: google.cloud.visualinspection.v1beta1.UndeploySolutionOperationMetadata
	(*CreateSolutionArtifactRequest)(nil),                   // 9: google.cloud.visualinspection.v1beta1.CreateSolutionArtifactRequest
	(*CreateSolutionArtifactOperationMetadata)(nil),         // 10: google.cloud.visualinspection.v1beta1.CreateSolutionArtifactOperationMetadata
	(*ListSolutionArtifactsRequest)(nil),                    // 11: google.cloud.visualinspection.v1beta1.ListSolutionArtifactsRequest
	(*ListSolutionArtifactsResponse)(nil),                   // 12: google.cloud.visualinspection.v1beta1.ListSolutionArtifactsResponse
	(*GetSolutionArtifactRequest)(nil),                      // 13: google.cloud.visualinspection.v1beta1.GetSolutionArtifactRequest
	(*DeleteSolutionArtifactRequest)(nil),                   // 14: google.cloud.visualinspection.v1beta1.DeleteSolutionArtifactRequest
	(*DeleteSolutionArtifactOperationMetadata)(nil),         // 15: google.cloud.visualinspection.v1beta1.DeleteSolutionArtifactOperationMetadata
	(*UpdateSolutionArtifactRequest)(nil),                   // 16: google.cloud.visualinspection.v1beta1.UpdateSolutionArtifactRequest
	(*CreateDatasetOperationMetadata)(nil),                  // 17: google.cloud.visualinspection.v1beta1.CreateDatasetOperationMetadata
	(*GetDatasetRequest)(nil),                               // 18: google.cloud.visualinspection.v1beta1.GetDatasetRequest
	(*DeleteDatasetRequest)(nil),                            // 19: google.cloud.visualinspection.v1beta1.DeleteDatasetRequest
	(*ListDatasetsRequest)(nil),                             // 20: google.cloud.visualinspection.v1beta1.ListDatasetsRequest
	(*ListDatasetsResponse)(nil),                            // 21: google.cloud.visualinspection.v1beta1.ListDatasetsResponse
	(*ImportDataRequest)(nil),                               // 22: google.cloud.visualinspection.v1beta1.ImportDataRequest
	(*ImportDataOperationMetadata)(nil),                     // 23: google.cloud.visualinspection.v1beta1.ImportDataOperationMetadata
	(*ExportDataRequest)(nil),                               // 24: google.cloud.visualinspection.v1beta1.ExportDataRequest
	(*ExportDataOperationMetadata)(nil),                     // 25: google.cloud.visualinspection.v1beta1.ExportDataOperationMetadata
	(*DeleteDatasetOperationMetadata)(nil),                  // 26: google.cloud.visualinspection.v1beta1.DeleteDatasetOperationMetadata
	(*GetImageRequest)(nil),                                 // 27: google.cloud.visualinspection.v1beta1.GetImageRequest
	(*ListImagesRequest)(nil),                               // 28: google.cloud.visualinspection.v1beta1.ListImagesRequest
	(*ListImagesResponse)(nil),                              // 29: google.cloud.visualinspection.v1beta1.ListImagesResponse
	(*CreateAnnotationSetRequest)(nil),                      // 30: google.cloud.visualinspection.v1beta1.CreateAnnotationSetRequest
	(*ListAnnotationSetsRequest)(nil),                       // 31: google.cloud.visualinspection.v1beta1.ListAnnotationSetsRequest
	(*ListAnnotationSetsResponse)(nil),                      // 32: google.cloud.visualinspection.v1beta1.ListAnnotationSetsResponse
	(*DeleteAnnotationSetOperationMetadata)(nil),            // 33: google.cloud.visualinspection.v1beta1.DeleteAnnotationSetOperationMetadata
	(*CreateAnnotationSpecRequest)(nil),                     // 34: google.cloud.visualinspection.v1beta1.CreateAnnotationSpecRequest
	(*ListAnnotationSpecsRequest)(nil),                      // 35: google.cloud.visualinspection.v1beta1.ListAnnotationSpecsRequest
	(*ListAnnotationSpecsResponse)(nil),                     // 36: google.cloud.visualinspection.v1beta1.ListAnnotationSpecsResponse
	(*DeleteAnnotationSpecOperationMetadata)(nil),           // 37: google.cloud.visualinspection.v1beta1.DeleteAnnotationSpecOperationMetadata
	(*ListAnnotationsRequest)(nil),                          // 38: google.cloud.visualinspection.v1beta1.ListAnnotationsRequest
	(*ListAnnotationsResponse)(nil),                         // 39: google.cloud.visualinspection.v1beta1.ListAnnotationsResponse
	(*DeleteAnnotationOperationMetadata)(nil),               // 40: google.cloud.visualinspection.v1beta1.DeleteAnnotationOperationMetadata
	(*CreateModuleRequest)(nil),                             // 41: google.cloud.visualinspection.v1beta1.CreateModuleRequest
	(*ListModulesRequest)(nil),                              // 42: google.cloud.visualinspection.v1beta1.ListModulesRequest
	(*ListModulesResponse)(nil),                             // 43: google.cloud.visualinspection.v1beta1.ListModulesResponse
	(*GetModuleRequest)(nil),                                // 44: google.cloud.visualinspection.v1beta1.GetModuleRequest
	(*DeleteModuleRequest)(nil),                             // 45: google.cloud.visualinspection.v1beta1.DeleteModuleRequest
	(*DeleteModuleOperationMetadata)(nil),                   // 46: google.cloud.visualinspection.v1beta1.DeleteModuleOperationMetadata
	(*UpdateModuleRequest)(nil),                             // 47: google.cloud.visualinspection.v1beta1.UpdateModuleRequest
	(*CreateModelRequest)(nil),                              // 48: google.cloud.visualinspection.v1beta1.CreateModelRequest
	(*CreateModelOperationMetadata)(nil),                    // 49: google.cloud.visualinspection.v1beta1.CreateModelOperationMetadata
	(*ListModelsRequest)(nil),                               // 50: google.cloud.visualinspection.v1beta1.ListModelsRequest
	(*ListModelsResponse)(nil),                              // 51: google.cloud.visualinspection.v1beta1.ListModelsResponse
	(*GetModelRequest)(nil),                                 // 52: google.cloud.visualinspection.v1beta1.GetModelRequest
	(*DeleteModelRequest)(nil),                              // 53: google.cloud.visualinspection.v1beta1.DeleteModelRequest
	(*DeleteModelOperationMetadata)(nil),                    // 54: google.cloud.visualinspection.v1beta1.DeleteModelOperationMetadata
	(*UpdateModelRequest)(nil),                              // 55: google.cloud.visualinspection.v1beta1.UpdateModelRequest
	(*ListModelEvaluationsRequest)(nil),                     // 56: google.cloud.visualinspection.v1beta1.ListModelEvaluationsRequest
	(*ListModelEvaluationsResponse)(nil),                    // 57: google.cloud.visualinspection.v1beta1.ListModelEvaluationsResponse
	(*GetModelEvaluationRequest)(nil),                       // 58: google.cloud.visualinspection.v1beta1.GetModelEvaluationRequest
	(*WritePredictionsRequest)(nil),                         // 59: google.cloud.visualinspection.v1beta1.WritePredictionsRequest
	(*WritePredictionsOperationMetadata)(nil),               // 60: google.cloud.visualinspection.v1beta1.WritePredictionsOperationMetadata
	(*CreateSpecialistPoolRequest)(nil),                     // 61: google.cloud.visualinspection.v1beta1.CreateSpecialistPoolRequest
	(*CreateSpecialistPoolOperationMetadata)(nil),           // 62: google.cloud.visualinspection.v1beta1.CreateSpecialistPoolOperationMetadata
	(*GetSpecialistPoolRequest)(nil),                        // 63: google.cloud.visualinspection.v1beta1.GetSpecialistPoolRequest
	(*UpdateSpecialistPoolRequest)(nil),                     // 64: google.cloud.visualinspection.v1beta1.UpdateSpecialistPoolRequest
	(*UpdateSpecialistPoolOperationMetadata)(nil),           // 65: google.cloud.visualinspection.v1beta1.UpdateSpecialistPoolOperationMetadata
	(*ListSpecialistPoolsRequest)(nil),                      // 66: google.cloud.visualinspection.v1beta1.ListSpecialistPoolsRequest
	(*ListSpecialistPoolsResponse)(nil),                     // 67: google.cloud.visualinspection.v1beta1.ListSpecialistPoolsResponse
	(*DeleteSpecialistPoolRequest)(nil),                     // 68: google.cloud.visualinspection.v1beta1.DeleteSpecialistPoolRequest
	(*DeleteSpecialistPoolOperationMetadata)(nil),           // 69: google.cloud.visualinspection.v1beta1.DeleteSpecialistPoolOperationMetadata
	(*CreateLabelingJobRequest)(nil),                        // 70: google.cloud.visualinspection.v1beta1.CreateLabelingJobRequest
	(*GetLabelingJobRequest)(nil),                           // 71: google.cloud.visualinspection.v1beta1.GetLabelingJobRequest
	(*ListLabelingJobsRequest)(nil),                         // 72: google.cloud.visualinspection.v1beta1.ListLabelingJobsRequest
	(*ListLabelingJobsResponse)(nil),                        // 73: google.cloud.visualinspection.v1beta1.ListLabelingJobsResponse
	(*DeleteLabelingJobRequest)(nil),                        // 74: google.cloud.visualinspection.v1beta1.DeleteLabelingJobRequest
	(*DeleteLabelingJobOperationMetadata)(nil),              // 75: google.cloud.visualinspection.v1beta1.DeleteLabelingJobOperationMetadata
	(*CancelLabelingJobRequest)(nil),                        // 76: google.cloud.visualinspection.v1beta1.CancelLabelingJobRequest
	(*BatchPredictRequest)(nil),                             // 77: google.cloud.visualinspection.v1beta1.BatchPredictRequest
	(*BatchPredictOperationMetadata)(nil),                   // 78: google.cloud.visualinspection.v1beta1.BatchPredictOperationMetadata
	(*BatchPredictResponse)(nil),                            // 79: google.cloud.visualinspection.v1beta1.BatchPredictResponse
	(*ExportDataResponse)(nil),                              // 80: google.cloud.visualinspection.v1beta1.ExportDataResponse
	(*ImportDataResponse)(nil),                              // 81: google.cloud.visualinspection.v1beta1.ImportDataResponse
	(*WritePredictionsResponse)(nil),                        // 82: google.cloud.visualinspection.v1beta1.WritePredictionsResponse
	(*Solution_TrainingConfig)(nil),                         // 83: google.cloud.visualinspection.v1beta1.Solution.TrainingConfig
	(*Solution_SolutionType)(nil),                           // 84: google.cloud.visualinspection.v1beta1.Solution.SolutionType
	nil,                                                     // 85: google.cloud.visualinspection.v1beta1.Solution.LabelsEntry
	(*Solution_SolutionType_AssemblyInspectionOptions)(nil), // 86: google.cloud.visualinspection.v1beta1.Solution.SolutionType.AssemblyInspectionOptions
	(*Solution_SolutionType_CosmeticInspectionOptions)(nil), // 87: google.cloud.visualinspection.v1beta1.Solution.SolutionType.CosmeticInspectionOptions
	(*Solution_SolutionType_CustomInspectionOptions)(nil),   // 88: google.cloud.visualinspection.v1beta1.Solution.SolutionType.CustomInspectionOptions
	(*timestamppb.Timestamp)(nil),                           // 89: google.protobuf.Timestamp
	(*CommonOperationMetadata)(nil),                         // 90: google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	(*SolutionArtifact)(nil),                                // 91: google.cloud.visualinspection.v1beta1.SolutionArtifact
	(*fieldmaskpb.FieldMask)(nil),                           // 92: google.protobuf.FieldMask
	(*Dataset)(nil),                                         // 93: google.cloud.visualinspection.v1beta1.Dataset
	(*ImportDataConfig)(nil),                                // 94: google.cloud.visualinspection.v1beta1.ImportDataConfig
	(*ExportDataConfig)(nil),                                // 95: google.cloud.visualinspection.v1beta1.ExportDataConfig
	(*Image)(nil),                                           // 96: google.cloud.visualinspection.v1beta1.Image
	(*AnnotationSet)(nil),                                   // 97: google.cloud.visualinspection.v1beta1.AnnotationSet
	(*AnnotationSpec)(nil),                                  // 98: google.cloud.visualinspection.v1beta1.AnnotationSpec
	(*Annotation)(nil),                                      // 99: google.cloud.visualinspection.v1beta1.Annotation
	(*Module)(nil),                                          // 100: google.cloud.visualinspection.v1beta1.Module
	(*Model)(nil),                                           // 101: google.cloud.visualinspection.v1beta1.Model
	(*ModelEvaluation)(nil),                                 // 102: google.cloud.visualinspection.v1beta1.ModelEvaluation
	(*SpecialistPool)(nil),                                  // 103: google.cloud.visualinspection.v1beta1.SpecialistPool
	(*LabelingJob)(nil),                                     // 104: google.cloud.visualinspection.v1beta1.LabelingJob
	(*GcsDestination)(nil),                                  // 105: google.cloud.visualinspection.v1beta1.GcsDestination
	(*durationpb.Duration)(nil),                             // 106: google.protobuf.Duration
	(*structpb.Struct)(nil),                                 // 107: google.protobuf.Struct
	(*longrunning.Operation)(nil),                           // 108: google.longrunning.Operation
	(*emptypb.Empty)(nil),                                   // 109: google.protobuf.Empty
}
var file_google_cloud_visualinspection_v1beta1_service_proto_depIdxs = []int32{
	83,  // 0: google.cloud.visualinspection.v1beta1.Solution.training_config:type_name -> google.cloud.visualinspection.v1beta1.Solution.TrainingConfig
	89,  // 1: google.cloud.visualinspection.v1beta1.Solution.create_time:type_name -> google.protobuf.Timestamp
	89,  // 2: google.cloud.visualinspection.v1beta1.Solution.update_time:type_name -> google.protobuf.Timestamp
	85,  // 3: google.cloud.visualinspection.v1beta1.Solution.labels:type_name -> google.cloud.visualinspection.v1beta1.Solution.LabelsEntry
	84,  // 4: google.cloud.visualinspection.v1beta1.Solution.solution_type:type_name -> google.cloud.visualinspection.v1beta1.Solution.SolutionType
	90,  // 5: google.cloud.visualinspection.v1beta1.SolutionOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	0,   // 6: google.cloud.visualinspection.v1beta1.CreateSolutionRequest.solution:type_name -> google.cloud.visualinspection.v1beta1.Solution
	0,   // 7: google.cloud.visualinspection.v1beta1.ListSolutionsResponse.solutions:type_name -> google.cloud.visualinspection.v1beta1.Solution
	90,  // 8: google.cloud.visualinspection.v1beta1.ExportSolutionOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	90,  // 9: google.cloud.visualinspection.v1beta1.DeploySolutionOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	90,  // 10: google.cloud.visualinspection.v1beta1.UndeploySolutionOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	91,  // 11: google.cloud.visualinspection.v1beta1.CreateSolutionArtifactRequest.solution_artifact:type_name -> google.cloud.visualinspection.v1beta1.SolutionArtifact
	90,  // 12: google.cloud.visualinspection.v1beta1.CreateSolutionArtifactOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	91,  // 13: google.cloud.visualinspection.v1beta1.ListSolutionArtifactsResponse.solution_artifacts:type_name -> google.cloud.visualinspection.v1beta1.SolutionArtifact
	90,  // 14: google.cloud.visualinspection.v1beta1.DeleteSolutionArtifactOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	91,  // 15: google.cloud.visualinspection.v1beta1.UpdateSolutionArtifactRequest.solution_artifact:type_name -> google.cloud.visualinspection.v1beta1.SolutionArtifact
	92,  // 16: google.cloud.visualinspection.v1beta1.UpdateSolutionArtifactRequest.update_mask:type_name -> google.protobuf.FieldMask
	90,  // 17: google.cloud.visualinspection.v1beta1.CreateDatasetOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	93,  // 18: google.cloud.visualinspection.v1beta1.ListDatasetsResponse.datasets:type_name -> google.cloud.visualinspection.v1beta1.Dataset
	94,  // 19: google.cloud.visualinspection.v1beta1.ImportDataRequest.import_configs:type_name -> google.cloud.visualinspection.v1beta1.ImportDataConfig
	90,  // 20: google.cloud.visualinspection.v1beta1.ImportDataOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	95,  // 21: google.cloud.visualinspection.v1beta1.ExportDataRequest.export_config:type_name -> google.cloud.visualinspection.v1beta1.ExportDataConfig
	90,  // 22: google.cloud.visualinspection.v1beta1.ExportDataOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	90,  // 23: google.cloud.visualinspection.v1beta1.DeleteDatasetOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	96,  // 24: google.cloud.visualinspection.v1beta1.ListImagesResponse.images:type_name -> google.cloud.visualinspection.v1beta1.Image
	97,  // 25: google.cloud.visualinspection.v1beta1.CreateAnnotationSetRequest.annotation_set:type_name -> google.cloud.visualinspection.v1beta1.AnnotationSet
	97,  // 26: google.cloud.visualinspection.v1beta1.ListAnnotationSetsResponse.annotation_sets:type_name -> google.cloud.visualinspection.v1beta1.AnnotationSet
	90,  // 27: google.cloud.visualinspection.v1beta1.DeleteAnnotationSetOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	98,  // 28: google.cloud.visualinspection.v1beta1.CreateAnnotationSpecRequest.annotation_spec:type_name -> google.cloud.visualinspection.v1beta1.AnnotationSpec
	98,  // 29: google.cloud.visualinspection.v1beta1.ListAnnotationSpecsResponse.annotation_specs:type_name -> google.cloud.visualinspection.v1beta1.AnnotationSpec
	90,  // 30: google.cloud.visualinspection.v1beta1.DeleteAnnotationSpecOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	99,  // 31: google.cloud.visualinspection.v1beta1.ListAnnotationsResponse.annotations:type_name -> google.cloud.visualinspection.v1beta1.Annotation
	90,  // 32: google.cloud.visualinspection.v1beta1.DeleteAnnotationOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	100, // 33: google.cloud.visualinspection.v1beta1.CreateModuleRequest.module:type_name -> google.cloud.visualinspection.v1beta1.Module
	100, // 34: google.cloud.visualinspection.v1beta1.ListModulesResponse.modules:type_name -> google.cloud.visualinspection.v1beta1.Module
	90,  // 35: google.cloud.visualinspection.v1beta1.DeleteModuleOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	100, // 36: google.cloud.visualinspection.v1beta1.UpdateModuleRequest.module:type_name -> google.cloud.visualinspection.v1beta1.Module
	92,  // 37: google.cloud.visualinspection.v1beta1.UpdateModuleRequest.update_mask:type_name -> google.protobuf.FieldMask
	101, // 38: google.cloud.visualinspection.v1beta1.CreateModelRequest.model:type_name -> google.cloud.visualinspection.v1beta1.Model
	90,  // 39: google.cloud.visualinspection.v1beta1.CreateModelOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	101, // 40: google.cloud.visualinspection.v1beta1.ListModelsResponse.models:type_name -> google.cloud.visualinspection.v1beta1.Model
	90,  // 41: google.cloud.visualinspection.v1beta1.DeleteModelOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	101, // 42: google.cloud.visualinspection.v1beta1.UpdateModelRequest.model:type_name -> google.cloud.visualinspection.v1beta1.Model
	92,  // 43: google.cloud.visualinspection.v1beta1.UpdateModelRequest.update_mask:type_name -> google.protobuf.FieldMask
	102, // 44: google.cloud.visualinspection.v1beta1.ListModelEvaluationsResponse.model_evaluations:type_name -> google.cloud.visualinspection.v1beta1.ModelEvaluation
	90,  // 45: google.cloud.visualinspection.v1beta1.WritePredictionsOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	103, // 46: google.cloud.visualinspection.v1beta1.CreateSpecialistPoolRequest.specialist_pool:type_name -> google.cloud.visualinspection.v1beta1.SpecialistPool
	90,  // 47: google.cloud.visualinspection.v1beta1.CreateSpecialistPoolOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	103, // 48: google.cloud.visualinspection.v1beta1.UpdateSpecialistPoolRequest.specialist_pool:type_name -> google.cloud.visualinspection.v1beta1.SpecialistPool
	92,  // 49: google.cloud.visualinspection.v1beta1.UpdateSpecialistPoolRequest.update_mask:type_name -> google.protobuf.FieldMask
	90,  // 50: google.cloud.visualinspection.v1beta1.UpdateSpecialistPoolOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	103, // 51: google.cloud.visualinspection.v1beta1.ListSpecialistPoolsResponse.specialist_pools:type_name -> google.cloud.visualinspection.v1beta1.SpecialistPool
	90,  // 52: google.cloud.visualinspection.v1beta1.DeleteSpecialistPoolOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	104, // 53: google.cloud.visualinspection.v1beta1.CreateLabelingJobRequest.labeling_job:type_name -> google.cloud.visualinspection.v1beta1.LabelingJob
	104, // 54: google.cloud.visualinspection.v1beta1.ListLabelingJobsResponse.labeling_jobs:type_name -> google.cloud.visualinspection.v1beta1.LabelingJob
	90,  // 55: google.cloud.visualinspection.v1beta1.DeleteLabelingJobOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	105, // 56: google.cloud.visualinspection.v1beta1.BatchPredictRequest.output_gcs_dir:type_name -> google.cloud.visualinspection.v1beta1.GcsDestination
	90,  // 57: google.cloud.visualinspection.v1beta1.BatchPredictOperationMetadata.common_operation_metadata:type_name -> google.cloud.visualinspection.v1beta1.CommonOperationMetadata
	106, // 58: google.cloud.visualinspection.v1beta1.Solution.TrainingConfig.training_duration:type_name -> google.protobuf.Duration
	107, // 59: google.cloud.visualinspection.v1beta1.Solution.TrainingConfig.parameters:type_name -> google.protobuf.Struct
	86,  // 60: google.cloud.visualinspection.v1beta1.Solution.SolutionType.assembly_inspection:type_name -> google.cloud.visualinspection.v1beta1.Solution.SolutionType.AssemblyInspectionOptions
	87,  // 61: google.cloud.visualinspection.v1beta1.Solution.SolutionType.cosmetic_inspection:type_name -> google.cloud.visualinspection.v1beta1.Solution.SolutionType.CosmeticInspectionOptions
	88,  // 62: google.cloud.visualinspection.v1beta1.Solution.SolutionType.custom_inspection:type_name -> google.cloud.visualinspection.v1beta1.Solution.SolutionType.CustomInspectionOptions
	2,   // 63: google.cloud.visualinspection.v1beta1.VisualInspection.CreateSolution:input_type -> google.cloud.visualinspection.v1beta1.CreateSolutionRequest
	3,   // 64: google.cloud.visualinspection.v1beta1.VisualInspection.ListSolutions:input_type -> google.cloud.visualinspection.v1beta1.ListSolutionsRequest
	5,   // 65: google.cloud.visualinspection.v1beta1.VisualInspection.GetSolution:input_type -> google.cloud.visualinspection.v1beta1.GetSolutionRequest
	9,   // 66: google.cloud.visualinspection.v1beta1.VisualInspection.CreateSolutionArtifact:input_type -> google.cloud.visualinspection.v1beta1.CreateSolutionArtifactRequest
	11,  // 67: google.cloud.visualinspection.v1beta1.VisualInspection.ListSolutionArtifacts:input_type -> google.cloud.visualinspection.v1beta1.ListSolutionArtifactsRequest
	13,  // 68: google.cloud.visualinspection.v1beta1.VisualInspection.GetSolutionArtifact:input_type -> google.cloud.visualinspection.v1beta1.GetSolutionArtifactRequest
	14,  // 69: google.cloud.visualinspection.v1beta1.VisualInspection.DeleteSolutionArtifact:input_type -> google.cloud.visualinspection.v1beta1.DeleteSolutionArtifactRequest
	16,  // 70: google.cloud.visualinspection.v1beta1.VisualInspection.UpdateSolutionArtifact:input_type -> google.cloud.visualinspection.v1beta1.UpdateSolutionArtifactRequest
	77,  // 71: google.cloud.visualinspection.v1beta1.VisualInspection.BatchPredict:input_type -> google.cloud.visualinspection.v1beta1.BatchPredictRequest
	18,  // 72: google.cloud.visualinspection.v1beta1.VisualInspection.GetDataset:input_type -> google.cloud.visualinspection.v1beta1.GetDatasetRequest
	20,  // 73: google.cloud.visualinspection.v1beta1.VisualInspection.ListDatasets:input_type -> google.cloud.visualinspection.v1beta1.ListDatasetsRequest
	19,  // 74: google.cloud.visualinspection.v1beta1.VisualInspection.DeleteDataset:input_type -> google.cloud.visualinspection.v1beta1.DeleteDatasetRequest
	22,  // 75: google.cloud.visualinspection.v1beta1.VisualInspection.ImportData:input_type -> google.cloud.visualinspection.v1beta1.ImportDataRequest
	24,  // 76: google.cloud.visualinspection.v1beta1.VisualInspection.ExportData:input_type -> google.cloud.visualinspection.v1beta1.ExportDataRequest
	27,  // 77: google.cloud.visualinspection.v1beta1.VisualInspection.GetImage:input_type -> google.cloud.visualinspection.v1beta1.GetImageRequest
	28,  // 78: google.cloud.visualinspection.v1beta1.VisualInspection.ListImages:input_type -> google.cloud.visualinspection.v1beta1.ListImagesRequest
	30,  // 79: google.cloud.visualinspection.v1beta1.VisualInspection.CreateAnnotationSet:input_type -> google.cloud.visualinspection.v1beta1.CreateAnnotationSetRequest
	31,  // 80: google.cloud.visualinspection.v1beta1.VisualInspection.ListAnnotationSets:input_type -> google.cloud.visualinspection.v1beta1.ListAnnotationSetsRequest
	34,  // 81: google.cloud.visualinspection.v1beta1.VisualInspection.CreateAnnotationSpec:input_type -> google.cloud.visualinspection.v1beta1.CreateAnnotationSpecRequest
	35,  // 82: google.cloud.visualinspection.v1beta1.VisualInspection.ListAnnotationSpecs:input_type -> google.cloud.visualinspection.v1beta1.ListAnnotationSpecsRequest
	38,  // 83: google.cloud.visualinspection.v1beta1.VisualInspection.ListAnnotations:input_type -> google.cloud.visualinspection.v1beta1.ListAnnotationsRequest
	41,  // 84: google.cloud.visualinspection.v1beta1.VisualInspection.CreateModule:input_type -> google.cloud.visualinspection.v1beta1.CreateModuleRequest
	42,  // 85: google.cloud.visualinspection.v1beta1.VisualInspection.ListModules:input_type -> google.cloud.visualinspection.v1beta1.ListModulesRequest
	44,  // 86: google.cloud.visualinspection.v1beta1.VisualInspection.GetModule:input_type -> google.cloud.visualinspection.v1beta1.GetModuleRequest
	45,  // 87: google.cloud.visualinspection.v1beta1.VisualInspection.DeleteModule:input_type -> google.cloud.visualinspection.v1beta1.DeleteModuleRequest
	47,  // 88: google.cloud.visualinspection.v1beta1.VisualInspection.UpdateModule:input_type -> google.cloud.visualinspection.v1beta1.UpdateModuleRequest
	48,  // 89: google.cloud.visualinspection.v1beta1.VisualInspection.CreateModel:input_type -> google.cloud.visualinspection.v1beta1.CreateModelRequest
	50,  // 90: google.cloud.visualinspection.v1beta1.VisualInspection.ListModels:input_type -> google.cloud.visualinspection.v1beta1.ListModelsRequest
	52,  // 91: google.cloud.visualinspection.v1beta1.VisualInspection.GetModel:input_type -> google.cloud.visualinspection.v1beta1.GetModelRequest
	53,  // 92: google.cloud.visualinspection.v1beta1.VisualInspection.DeleteModel:input_type -> google.cloud.visualinspection.v1beta1.DeleteModelRequest
	55,  // 93: google.cloud.visualinspection.v1beta1.VisualInspection.UpdateModel:input_type -> google.cloud.visualinspection.v1beta1.UpdateModelRequest
	56,  // 94: google.cloud.visualinspection.v1beta1.VisualInspection.ListModelEvaluations:input_type -> google.cloud.visualinspection.v1beta1.ListModelEvaluationsRequest
	58,  // 95: google.cloud.visualinspection.v1beta1.VisualInspection.GetModelEvaluation:input_type -> google.cloud.visualinspection.v1beta1.GetModelEvaluationRequest
	59,  // 96: google.cloud.visualinspection.v1beta1.VisualInspection.WritePredictions:input_type -> google.cloud.visualinspection.v1beta1.WritePredictionsRequest
	61,  // 97: google.cloud.visualinspection.v1beta1.VisualInspection.CreateSpecialistPool:input_type -> google.cloud.visualinspection.v1beta1.CreateSpecialistPoolRequest
	63,  // 98: google.cloud.visualinspection.v1beta1.VisualInspection.GetSpecialistPool:input_type -> google.cloud.visualinspection.v1beta1.GetSpecialistPoolRequest
	64,  // 99: google.cloud.visualinspection.v1beta1.VisualInspection.UpdateSpecialistPool:input_type -> google.cloud.visualinspection.v1beta1.UpdateSpecialistPoolRequest
	66,  // 100: google.cloud.visualinspection.v1beta1.VisualInspection.ListSpecialistPools:input_type -> google.cloud.visualinspection.v1beta1.ListSpecialistPoolsRequest
	68,  // 101: google.cloud.visualinspection.v1beta1.VisualInspection.DeleteSpecialistPool:input_type -> google.cloud.visualinspection.v1beta1.DeleteSpecialistPoolRequest
	70,  // 102: google.cloud.visualinspection.v1beta1.VisualInspection.CreateLabelingJob:input_type -> google.cloud.visualinspection.v1beta1.CreateLabelingJobRequest
	71,  // 103: google.cloud.visualinspection.v1beta1.VisualInspection.GetLabelingJob:input_type -> google.cloud.visualinspection.v1beta1.GetLabelingJobRequest
	72,  // 104: google.cloud.visualinspection.v1beta1.VisualInspection.ListLabelingJobs:input_type -> google.cloud.visualinspection.v1beta1.ListLabelingJobsRequest
	74,  // 105: google.cloud.visualinspection.v1beta1.VisualInspection.DeleteLabelingJob:input_type -> google.cloud.visualinspection.v1beta1.DeleteLabelingJobRequest
	76,  // 106: google.cloud.visualinspection.v1beta1.VisualInspection.CancelLabelingJob:input_type -> google.cloud.visualinspection.v1beta1.CancelLabelingJobRequest
	108, // 107: google.cloud.visualinspection.v1beta1.VisualInspection.CreateSolution:output_type -> google.longrunning.Operation
	4,   // 108: google.cloud.visualinspection.v1beta1.VisualInspection.ListSolutions:output_type -> google.cloud.visualinspection.v1beta1.ListSolutionsResponse
	0,   // 109: google.cloud.visualinspection.v1beta1.VisualInspection.GetSolution:output_type -> google.cloud.visualinspection.v1beta1.Solution
	108, // 110: google.cloud.visualinspection.v1beta1.VisualInspection.CreateSolutionArtifact:output_type -> google.longrunning.Operation
	12,  // 111: google.cloud.visualinspection.v1beta1.VisualInspection.ListSolutionArtifacts:output_type -> google.cloud.visualinspection.v1beta1.ListSolutionArtifactsResponse
	91,  // 112: google.cloud.visualinspection.v1beta1.VisualInspection.GetSolutionArtifact:output_type -> google.cloud.visualinspection.v1beta1.SolutionArtifact
	108, // 113: google.cloud.visualinspection.v1beta1.VisualInspection.DeleteSolutionArtifact:output_type -> google.longrunning.Operation
	91,  // 114: google.cloud.visualinspection.v1beta1.VisualInspection.UpdateSolutionArtifact:output_type -> google.cloud.visualinspection.v1beta1.SolutionArtifact
	108, // 115: google.cloud.visualinspection.v1beta1.VisualInspection.BatchPredict:output_type -> google.longrunning.Operation
	93,  // 116: google.cloud.visualinspection.v1beta1.VisualInspection.GetDataset:output_type -> google.cloud.visualinspection.v1beta1.Dataset
	21,  // 117: google.cloud.visualinspection.v1beta1.VisualInspection.ListDatasets:output_type -> google.cloud.visualinspection.v1beta1.ListDatasetsResponse
	108, // 118: google.cloud.visualinspection.v1beta1.VisualInspection.DeleteDataset:output_type -> google.longrunning.Operation
	108, // 119: google.cloud.visualinspection.v1beta1.VisualInspection.ImportData:output_type -> google.longrunning.Operation
	108, // 120: google.cloud.visualinspection.v1beta1.VisualInspection.ExportData:output_type -> google.longrunning.Operation
	96,  // 121: google.cloud.visualinspection.v1beta1.VisualInspection.GetImage:output_type -> google.cloud.visualinspection.v1beta1.Image
	29,  // 122: google.cloud.visualinspection.v1beta1.VisualInspection.ListImages:output_type -> google.cloud.visualinspection.v1beta1.ListImagesResponse
	97,  // 123: google.cloud.visualinspection.v1beta1.VisualInspection.CreateAnnotationSet:output_type -> google.cloud.visualinspection.v1beta1.AnnotationSet
	32,  // 124: google.cloud.visualinspection.v1beta1.VisualInspection.ListAnnotationSets:output_type -> google.cloud.visualinspection.v1beta1.ListAnnotationSetsResponse
	98,  // 125: google.cloud.visualinspection.v1beta1.VisualInspection.CreateAnnotationSpec:output_type -> google.cloud.visualinspection.v1beta1.AnnotationSpec
	36,  // 126: google.cloud.visualinspection.v1beta1.VisualInspection.ListAnnotationSpecs:output_type -> google.cloud.visualinspection.v1beta1.ListAnnotationSpecsResponse
	39,  // 127: google.cloud.visualinspection.v1beta1.VisualInspection.ListAnnotations:output_type -> google.cloud.visualinspection.v1beta1.ListAnnotationsResponse
	100, // 128: google.cloud.visualinspection.v1beta1.VisualInspection.CreateModule:output_type -> google.cloud.visualinspection.v1beta1.Module
	43,  // 129: google.cloud.visualinspection.v1beta1.VisualInspection.ListModules:output_type -> google.cloud.visualinspection.v1beta1.ListModulesResponse
	100, // 130: google.cloud.visualinspection.v1beta1.VisualInspection.GetModule:output_type -> google.cloud.visualinspection.v1beta1.Module
	108, // 131: google.cloud.visualinspection.v1beta1.VisualInspection.DeleteModule:output_type -> google.longrunning.Operation
	100, // 132: google.cloud.visualinspection.v1beta1.VisualInspection.UpdateModule:output_type -> google.cloud.visualinspection.v1beta1.Module
	108, // 133: google.cloud.visualinspection.v1beta1.VisualInspection.CreateModel:output_type -> google.longrunning.Operation
	51,  // 134: google.cloud.visualinspection.v1beta1.VisualInspection.ListModels:output_type -> google.cloud.visualinspection.v1beta1.ListModelsResponse
	101, // 135: google.cloud.visualinspection.v1beta1.VisualInspection.GetModel:output_type -> google.cloud.visualinspection.v1beta1.Model
	108, // 136: google.cloud.visualinspection.v1beta1.VisualInspection.DeleteModel:output_type -> google.longrunning.Operation
	101, // 137: google.cloud.visualinspection.v1beta1.VisualInspection.UpdateModel:output_type -> google.cloud.visualinspection.v1beta1.Model
	57,  // 138: google.cloud.visualinspection.v1beta1.VisualInspection.ListModelEvaluations:output_type -> google.cloud.visualinspection.v1beta1.ListModelEvaluationsResponse
	102, // 139: google.cloud.visualinspection.v1beta1.VisualInspection.GetModelEvaluation:output_type -> google.cloud.visualinspection.v1beta1.ModelEvaluation
	108, // 140: google.cloud.visualinspection.v1beta1.VisualInspection.WritePredictions:output_type -> google.longrunning.Operation
	108, // 141: google.cloud.visualinspection.v1beta1.VisualInspection.CreateSpecialistPool:output_type -> google.longrunning.Operation
	103, // 142: google.cloud.visualinspection.v1beta1.VisualInspection.GetSpecialistPool:output_type -> google.cloud.visualinspection.v1beta1.SpecialistPool
	108, // 143: google.cloud.visualinspection.v1beta1.VisualInspection.UpdateSpecialistPool:output_type -> google.longrunning.Operation
	67,  // 144: google.cloud.visualinspection.v1beta1.VisualInspection.ListSpecialistPools:output_type -> google.cloud.visualinspection.v1beta1.ListSpecialistPoolsResponse
	108, // 145: google.cloud.visualinspection.v1beta1.VisualInspection.DeleteSpecialistPool:output_type -> google.longrunning.Operation
	104, // 146: google.cloud.visualinspection.v1beta1.VisualInspection.CreateLabelingJob:output_type -> google.cloud.visualinspection.v1beta1.LabelingJob
	104, // 147: google.cloud.visualinspection.v1beta1.VisualInspection.GetLabelingJob:output_type -> google.cloud.visualinspection.v1beta1.LabelingJob
	73,  // 148: google.cloud.visualinspection.v1beta1.VisualInspection.ListLabelingJobs:output_type -> google.cloud.visualinspection.v1beta1.ListLabelingJobsResponse
	108, // 149: google.cloud.visualinspection.v1beta1.VisualInspection.DeleteLabelingJob:output_type -> google.longrunning.Operation
	109, // 150: google.cloud.visualinspection.v1beta1.VisualInspection.CancelLabelingJob:output_type -> google.protobuf.Empty
	107, // [107:151] is the sub-list for method output_type
	63,  // [63:107] is the sub-list for method input_type
	63,  // [63:63] is the sub-list for extension type_name
	63,  // [63:63] is the sub-list for extension extendee
	0,   // [0:63] is the sub-list for field type_name
}

func init() { file_google_cloud_visualinspection_v1beta1_service_proto_init() }
func file_google_cloud_visualinspection_v1beta1_service_proto_init() {
	if File_google_cloud_visualinspection_v1beta1_service_proto != nil {
		return
	}
	file_google_cloud_visualinspection_v1beta1_annotation_proto_init()
	file_google_cloud_visualinspection_v1beta1_annotation_set_proto_init()
	file_google_cloud_visualinspection_v1beta1_annotation_spec_proto_init()
	file_google_cloud_visualinspection_v1beta1_common_proto_init()
	file_google_cloud_visualinspection_v1beta1_dataset_proto_init()
	file_google_cloud_visualinspection_v1beta1_geometry_proto_init()
	file_google_cloud_visualinspection_v1beta1_image_proto_init()
	file_google_cloud_visualinspection_v1beta1_io_proto_init()
	file_google_cloud_visualinspection_v1beta1_labeling_proto_init()
	file_google_cloud_visualinspection_v1beta1_model_proto_init()
	file_google_cloud_visualinspection_v1beta1_model_evaluation_proto_init()
	file_google_cloud_visualinspection_v1beta1_module_proto_init()
	file_google_cloud_visualinspection_v1beta1_solution_artifact_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Solution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SolutionOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSolutionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSolutionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSolutionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSolutionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportSolutionOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeploySolutionOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeploySolutionOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSolutionArtifactRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSolutionArtifactOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSolutionArtifactsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSolutionArtifactsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSolutionArtifactRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSolutionArtifactRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSolutionArtifactOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSolutionArtifactRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDatasetOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDatasetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDatasetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDatasetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDatasetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportDataOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportDataOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDatasetOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetImageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListImagesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListImagesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAnnotationSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnnotationSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnnotationSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAnnotationSetOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAnnotationSpecRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnnotationSpecsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnnotationSpecsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAnnotationSpecOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnnotationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnnotationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAnnotationOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteModuleOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateModelOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListModelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListModelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteModelOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListModelEvaluationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListModelEvaluationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetModelEvaluationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WritePredictionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WritePredictionsOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSpecialistPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSpecialistPoolOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSpecialistPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSpecialistPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSpecialistPoolOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSpecialistPoolsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSpecialistPoolsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSpecialistPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSpecialistPoolOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateLabelingJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLabelingJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLabelingJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLabelingJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteLabelingJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteLabelingJobOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelLabelingJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchPredictRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchPredictOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchPredictResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WritePredictionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Solution_TrainingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Solution_SolutionType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Solution_SolutionType_AssemblyInspectionOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Solution_SolutionType_CosmeticInspectionOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Solution_SolutionType_CustomInspectionOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes[84].OneofWrappers = []interface{}{
		(*Solution_SolutionType_AssemblyInspection)(nil),
		(*Solution_SolutionType_CosmeticInspection)(nil),
		(*Solution_SolutionType_CustomInspection)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_visualinspection_v1beta1_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   89,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_visualinspection_v1beta1_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_visualinspection_v1beta1_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_visualinspection_v1beta1_service_proto_msgTypes,
	}.Build()
	File_google_cloud_visualinspection_v1beta1_service_proto = out.File
	file_google_cloud_visualinspection_v1beta1_service_proto_rawDesc = nil
	file_google_cloud_visualinspection_v1beta1_service_proto_goTypes = nil
	file_google_cloud_visualinspection_v1beta1_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VisualInspectionClient is the client API for VisualInspection service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VisualInspectionClient interface {
	// Creates a solution.
	CreateSolution(ctx context.Context, in *CreateSolutionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists solutions.
	ListSolutions(ctx context.Context, in *ListSolutionsRequest, opts ...grpc.CallOption) (*ListSolutionsResponse, error)
	// Gets a solution.
	GetSolution(ctx context.Context, in *GetSolutionRequest, opts ...grpc.CallOption) (*Solution, error)
	// Creates a SolutionArtifact.
	CreateSolutionArtifact(ctx context.Context, in *CreateSolutionArtifactRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists SolutionArtifacts in a Solution.
	ListSolutionArtifacts(ctx context.Context, in *ListSolutionArtifactsRequest, opts ...grpc.CallOption) (*ListSolutionArtifactsResponse, error)
	// Gets a SolutionArtifact.
	GetSolutionArtifact(ctx context.Context, in *GetSolutionArtifactRequest, opts ...grpc.CallOption) (*SolutionArtifact, error)
	// Deletes a SolutionArtifact. Only the subject SolutionArtifact is affected
	// by this operation. The SolutionArtifact's Models remain unchanged.
	DeleteSolutionArtifact(ctx context.Context, in *DeleteSolutionArtifactRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a SolutionArtifact.
	UpdateSolutionArtifact(ctx context.Context, in *UpdateSolutionArtifactRequest, opts ...grpc.CallOption) (*SolutionArtifact, error)
	// Perform batch prediction on a given SolutionArtifact.
	BatchPredict(ctx context.Context, in *BatchPredictRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets a Dataset.
	GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Lists Datasets in a Project.
	ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error)
	// Deletes a Dataset.
	DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Imports data to a Dataset.
	ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports data from a Dataset.
	ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets an Image.
	// ImportData will create images. Therefore CreateImage is omitted.
	GetImage(ctx context.Context, in *GetImageRequest, opts ...grpc.CallOption) (*Image, error)
	// Lists Images in a Dataset.
	ListImages(ctx context.Context, in *ListImagesRequest, opts ...grpc.CallOption) (*ListImagesResponse, error)
	// Creates an AnnotationSet.
	CreateAnnotationSet(ctx context.Context, in *CreateAnnotationSetRequest, opts ...grpc.CallOption) (*AnnotationSet, error)
	// Lists AnnotationSets in a Dataset.
	ListAnnotationSets(ctx context.Context, in *ListAnnotationSetsRequest, opts ...grpc.CallOption) (*ListAnnotationSetsResponse, error)
	// Creates an AnnotationSpec.
	CreateAnnotationSpec(ctx context.Context, in *CreateAnnotationSpecRequest, opts ...grpc.CallOption) (*AnnotationSpec, error)
	// Lists AnnotationSpecs in a dataset.
	ListAnnotationSpecs(ctx context.Context, in *ListAnnotationSpecsRequest, opts ...grpc.CallOption) (*ListAnnotationSpecsResponse, error)
	// Lists Annotations on an Image.
	ListAnnotations(ctx context.Context, in *ListAnnotationsRequest, opts ...grpc.CallOption) (*ListAnnotationsResponse, error)
	// Creates a Module.
	CreateModule(ctx context.Context, in *CreateModuleRequest, opts ...grpc.CallOption) (*Module, error)
	// Lists Modules in a Solution.
	ListModules(ctx context.Context, in *ListModulesRequest, opts ...grpc.CallOption) (*ListModulesResponse, error)
	// Gets a Module.
	GetModule(ctx context.Context, in *GetModuleRequest, opts ...grpc.CallOption) (*Module, error)
	// Deletes a Module. Only the subject Module is affected by this operation.
	// The Module's input and output AnnotationSets and any connected Modules
	// remain unchanged.
	DeleteModule(ctx context.Context, in *DeleteModuleRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a Module.
	UpdateModule(ctx context.Context, in *UpdateModuleRequest, opts ...grpc.CallOption) (*Module, error)
	// Creates a Model.
	CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists Models for a Module.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Gets a Model.
	GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Deletes a Model.
	DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a Model.
	UpdateModel(ctx context.Context, in *UpdateModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Lists ModelEvaluations for a Model. For Beta, we will have only one
	// evaluation produced when the Model is created.
	ListModelEvaluations(ctx context.Context, in *ListModelEvaluationsRequest, opts ...grpc.CallOption) (*ListModelEvaluationsResponse, error)
	// Gets a ModelEvaluation.
	GetModelEvaluation(ctx context.Context, in *GetModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error)
	// Writes a Model's predictions to the parent Module's output
	// AnnotationSets.
	WritePredictions(ctx context.Context, in *WritePredictionsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a SpecialistPool.
	CreateSpecialistPool(ctx context.Context, in *CreateSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets a SpecialistPool.
	GetSpecialistPool(ctx context.Context, in *GetSpecialistPoolRequest, opts ...grpc.CallOption) (*SpecialistPool, error)
	// Updates a SpecialistPool.
	UpdateSpecialistPool(ctx context.Context, in *UpdateSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists SpecialistPools.
	ListSpecialistPools(ctx context.Context, in *ListSpecialistPoolsRequest, opts ...grpc.CallOption) (*ListSpecialistPoolsResponse, error)
	// Deletes a SpecialistPool.
	DeleteSpecialistPool(ctx context.Context, in *DeleteSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a LabelingJob.
	CreateLabelingJob(ctx context.Context, in *CreateLabelingJobRequest, opts ...grpc.CallOption) (*LabelingJob, error)
	// Gets a LabelingJob.
	GetLabelingJob(ctx context.Context, in *GetLabelingJobRequest, opts ...grpc.CallOption) (*LabelingJob, error)
	// Lists LabelingJobs.
	ListLabelingJobs(ctx context.Context, in *ListLabelingJobsRequest, opts ...grpc.CallOption) (*ListLabelingJobsResponse, error)
	// Deletes a LabelingJob.
	DeleteLabelingJob(ctx context.Context, in *DeleteLabelingJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Cancels a LabelingJob. Success of cancellation is not guaranteed.
	CancelLabelingJob(ctx context.Context, in *CancelLabelingJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type visualInspectionClient struct {
	cc grpc.ClientConnInterface
}

func NewVisualInspectionClient(cc grpc.ClientConnInterface) VisualInspectionClient {
	return &visualInspectionClient{cc}
}

func (c *visualInspectionClient) CreateSolution(ctx context.Context, in *CreateSolutionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateSolution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) ListSolutions(ctx context.Context, in *ListSolutionsRequest, opts ...grpc.CallOption) (*ListSolutionsResponse, error) {
	out := new(ListSolutionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/ListSolutions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) GetSolution(ctx context.Context, in *GetSolutionRequest, opts ...grpc.CallOption) (*Solution, error) {
	out := new(Solution)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/GetSolution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) CreateSolutionArtifact(ctx context.Context, in *CreateSolutionArtifactRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateSolutionArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) ListSolutionArtifacts(ctx context.Context, in *ListSolutionArtifactsRequest, opts ...grpc.CallOption) (*ListSolutionArtifactsResponse, error) {
	out := new(ListSolutionArtifactsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/ListSolutionArtifacts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) GetSolutionArtifact(ctx context.Context, in *GetSolutionArtifactRequest, opts ...grpc.CallOption) (*SolutionArtifact, error) {
	out := new(SolutionArtifact)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/GetSolutionArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) DeleteSolutionArtifact(ctx context.Context, in *DeleteSolutionArtifactRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/DeleteSolutionArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) UpdateSolutionArtifact(ctx context.Context, in *UpdateSolutionArtifactRequest, opts ...grpc.CallOption) (*SolutionArtifact, error) {
	out := new(SolutionArtifact)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/UpdateSolutionArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) BatchPredict(ctx context.Context, in *BatchPredictRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/BatchPredict", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/GetDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error) {
	out := new(ListDatasetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/ListDatasets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/DeleteDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/ImportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/ExportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) GetImage(ctx context.Context, in *GetImageRequest, opts ...grpc.CallOption) (*Image, error) {
	out := new(Image)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/GetImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) ListImages(ctx context.Context, in *ListImagesRequest, opts ...grpc.CallOption) (*ListImagesResponse, error) {
	out := new(ListImagesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/ListImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) CreateAnnotationSet(ctx context.Context, in *CreateAnnotationSetRequest, opts ...grpc.CallOption) (*AnnotationSet, error) {
	out := new(AnnotationSet)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateAnnotationSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) ListAnnotationSets(ctx context.Context, in *ListAnnotationSetsRequest, opts ...grpc.CallOption) (*ListAnnotationSetsResponse, error) {
	out := new(ListAnnotationSetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/ListAnnotationSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) CreateAnnotationSpec(ctx context.Context, in *CreateAnnotationSpecRequest, opts ...grpc.CallOption) (*AnnotationSpec, error) {
	out := new(AnnotationSpec)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateAnnotationSpec", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) ListAnnotationSpecs(ctx context.Context, in *ListAnnotationSpecsRequest, opts ...grpc.CallOption) (*ListAnnotationSpecsResponse, error) {
	out := new(ListAnnotationSpecsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/ListAnnotationSpecs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) ListAnnotations(ctx context.Context, in *ListAnnotationsRequest, opts ...grpc.CallOption) (*ListAnnotationsResponse, error) {
	out := new(ListAnnotationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/ListAnnotations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) CreateModule(ctx context.Context, in *CreateModuleRequest, opts ...grpc.CallOption) (*Module, error) {
	out := new(Module)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) ListModules(ctx context.Context, in *ListModulesRequest, opts ...grpc.CallOption) (*ListModulesResponse, error) {
	out := new(ListModulesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/ListModules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) GetModule(ctx context.Context, in *GetModuleRequest, opts ...grpc.CallOption) (*Module, error) {
	out := new(Module)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/GetModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) DeleteModule(ctx context.Context, in *DeleteModuleRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/DeleteModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) UpdateModule(ctx context.Context, in *UpdateModuleRequest, opts ...grpc.CallOption) (*Module, error) {
	out := new(Module)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/UpdateModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/ListModels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/GetModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/DeleteModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) UpdateModel(ctx context.Context, in *UpdateModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/UpdateModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) ListModelEvaluations(ctx context.Context, in *ListModelEvaluationsRequest, opts ...grpc.CallOption) (*ListModelEvaluationsResponse, error) {
	out := new(ListModelEvaluationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/ListModelEvaluations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) GetModelEvaluation(ctx context.Context, in *GetModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error) {
	out := new(ModelEvaluation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/GetModelEvaluation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) WritePredictions(ctx context.Context, in *WritePredictionsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/WritePredictions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) CreateSpecialistPool(ctx context.Context, in *CreateSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateSpecialistPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) GetSpecialistPool(ctx context.Context, in *GetSpecialistPoolRequest, opts ...grpc.CallOption) (*SpecialistPool, error) {
	out := new(SpecialistPool)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/GetSpecialistPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) UpdateSpecialistPool(ctx context.Context, in *UpdateSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/UpdateSpecialistPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) ListSpecialistPools(ctx context.Context, in *ListSpecialistPoolsRequest, opts ...grpc.CallOption) (*ListSpecialistPoolsResponse, error) {
	out := new(ListSpecialistPoolsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/ListSpecialistPools", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) DeleteSpecialistPool(ctx context.Context, in *DeleteSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/DeleteSpecialistPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) CreateLabelingJob(ctx context.Context, in *CreateLabelingJobRequest, opts ...grpc.CallOption) (*LabelingJob, error) {
	out := new(LabelingJob)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateLabelingJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) GetLabelingJob(ctx context.Context, in *GetLabelingJobRequest, opts ...grpc.CallOption) (*LabelingJob, error) {
	out := new(LabelingJob)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/GetLabelingJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) ListLabelingJobs(ctx context.Context, in *ListLabelingJobsRequest, opts ...grpc.CallOption) (*ListLabelingJobsResponse, error) {
	out := new(ListLabelingJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/ListLabelingJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) DeleteLabelingJob(ctx context.Context, in *DeleteLabelingJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/DeleteLabelingJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *visualInspectionClient) CancelLabelingJob(ctx context.Context, in *CancelLabelingJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.visualinspection.v1beta1.VisualInspection/CancelLabelingJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VisualInspectionServer is the server API for VisualInspection service.
type VisualInspectionServer interface {
	// Creates a solution.
	CreateSolution(context.Context, *CreateSolutionRequest) (*longrunning.Operation, error)
	// Lists solutions.
	ListSolutions(context.Context, *ListSolutionsRequest) (*ListSolutionsResponse, error)
	// Gets a solution.
	GetSolution(context.Context, *GetSolutionRequest) (*Solution, error)
	// Creates a SolutionArtifact.
	CreateSolutionArtifact(context.Context, *CreateSolutionArtifactRequest) (*longrunning.Operation, error)
	// Lists SolutionArtifacts in a Solution.
	ListSolutionArtifacts(context.Context, *ListSolutionArtifactsRequest) (*ListSolutionArtifactsResponse, error)
	// Gets a SolutionArtifact.
	GetSolutionArtifact(context.Context, *GetSolutionArtifactRequest) (*SolutionArtifact, error)
	// Deletes a SolutionArtifact. Only the subject SolutionArtifact is affected
	// by this operation. The SolutionArtifact's Models remain unchanged.
	DeleteSolutionArtifact(context.Context, *DeleteSolutionArtifactRequest) (*longrunning.Operation, error)
	// Updates a SolutionArtifact.
	UpdateSolutionArtifact(context.Context, *UpdateSolutionArtifactRequest) (*SolutionArtifact, error)
	// Perform batch prediction on a given SolutionArtifact.
	BatchPredict(context.Context, *BatchPredictRequest) (*longrunning.Operation, error)
	// Gets a Dataset.
	GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error)
	// Lists Datasets in a Project.
	ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error)
	// Deletes a Dataset.
	DeleteDataset(context.Context, *DeleteDatasetRequest) (*longrunning.Operation, error)
	// Imports data to a Dataset.
	ImportData(context.Context, *ImportDataRequest) (*longrunning.Operation, error)
	// Exports data from a Dataset.
	ExportData(context.Context, *ExportDataRequest) (*longrunning.Operation, error)
	// Gets an Image.
	// ImportData will create images. Therefore CreateImage is omitted.
	GetImage(context.Context, *GetImageRequest) (*Image, error)
	// Lists Images in a Dataset.
	ListImages(context.Context, *ListImagesRequest) (*ListImagesResponse, error)
	// Creates an AnnotationSet.
	CreateAnnotationSet(context.Context, *CreateAnnotationSetRequest) (*AnnotationSet, error)
	// Lists AnnotationSets in a Dataset.
	ListAnnotationSets(context.Context, *ListAnnotationSetsRequest) (*ListAnnotationSetsResponse, error)
	// Creates an AnnotationSpec.
	CreateAnnotationSpec(context.Context, *CreateAnnotationSpecRequest) (*AnnotationSpec, error)
	// Lists AnnotationSpecs in a dataset.
	ListAnnotationSpecs(context.Context, *ListAnnotationSpecsRequest) (*ListAnnotationSpecsResponse, error)
	// Lists Annotations on an Image.
	ListAnnotations(context.Context, *ListAnnotationsRequest) (*ListAnnotationsResponse, error)
	// Creates a Module.
	CreateModule(context.Context, *CreateModuleRequest) (*Module, error)
	// Lists Modules in a Solution.
	ListModules(context.Context, *ListModulesRequest) (*ListModulesResponse, error)
	// Gets a Module.
	GetModule(context.Context, *GetModuleRequest) (*Module, error)
	// Deletes a Module. Only the subject Module is affected by this operation.
	// The Module's input and output AnnotationSets and any connected Modules
	// remain unchanged.
	DeleteModule(context.Context, *DeleteModuleRequest) (*longrunning.Operation, error)
	// Updates a Module.
	UpdateModule(context.Context, *UpdateModuleRequest) (*Module, error)
	// Creates a Model.
	CreateModel(context.Context, *CreateModelRequest) (*longrunning.Operation, error)
	// Lists Models for a Module.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Gets a Model.
	GetModel(context.Context, *GetModelRequest) (*Model, error)
	// Deletes a Model.
	DeleteModel(context.Context, *DeleteModelRequest) (*longrunning.Operation, error)
	// Updates a Model.
	UpdateModel(context.Context, *UpdateModelRequest) (*Model, error)
	// Lists ModelEvaluations for a Model. For Beta, we will have only one
	// evaluation produced when the Model is created.
	ListModelEvaluations(context.Context, *ListModelEvaluationsRequest) (*ListModelEvaluationsResponse, error)
	// Gets a ModelEvaluation.
	GetModelEvaluation(context.Context, *GetModelEvaluationRequest) (*ModelEvaluation, error)
	// Writes a Model's predictions to the parent Module's output
	// AnnotationSets.
	WritePredictions(context.Context, *WritePredictionsRequest) (*longrunning.Operation, error)
	// Creates a SpecialistPool.
	CreateSpecialistPool(context.Context, *CreateSpecialistPoolRequest) (*longrunning.Operation, error)
	// Gets a SpecialistPool.
	GetSpecialistPool(context.Context, *GetSpecialistPoolRequest) (*SpecialistPool, error)
	// Updates a SpecialistPool.
	UpdateSpecialistPool(context.Context, *UpdateSpecialistPoolRequest) (*longrunning.Operation, error)
	// Lists SpecialistPools.
	ListSpecialistPools(context.Context, *ListSpecialistPoolsRequest) (*ListSpecialistPoolsResponse, error)
	// Deletes a SpecialistPool.
	DeleteSpecialistPool(context.Context, *DeleteSpecialistPoolRequest) (*longrunning.Operation, error)
	// Creates a LabelingJob.
	CreateLabelingJob(context.Context, *CreateLabelingJobRequest) (*LabelingJob, error)
	// Gets a LabelingJob.
	GetLabelingJob(context.Context, *GetLabelingJobRequest) (*LabelingJob, error)
	// Lists LabelingJobs.
	ListLabelingJobs(context.Context, *ListLabelingJobsRequest) (*ListLabelingJobsResponse, error)
	// Deletes a LabelingJob.
	DeleteLabelingJob(context.Context, *DeleteLabelingJobRequest) (*longrunning.Operation, error)
	// Cancels a LabelingJob. Success of cancellation is not guaranteed.
	CancelLabelingJob(context.Context, *CancelLabelingJobRequest) (*emptypb.Empty, error)
}

// UnimplementedVisualInspectionServer can be embedded to have forward compatible implementations.
type UnimplementedVisualInspectionServer struct {
}

func (*UnimplementedVisualInspectionServer) CreateSolution(context.Context, *CreateSolutionRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSolution not implemented")
}
func (*UnimplementedVisualInspectionServer) ListSolutions(context.Context, *ListSolutionsRequest) (*ListSolutionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSolutions not implemented")
}
func (*UnimplementedVisualInspectionServer) GetSolution(context.Context, *GetSolutionRequest) (*Solution, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSolution not implemented")
}
func (*UnimplementedVisualInspectionServer) CreateSolutionArtifact(context.Context, *CreateSolutionArtifactRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSolutionArtifact not implemented")
}
func (*UnimplementedVisualInspectionServer) ListSolutionArtifacts(context.Context, *ListSolutionArtifactsRequest) (*ListSolutionArtifactsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSolutionArtifacts not implemented")
}
func (*UnimplementedVisualInspectionServer) GetSolutionArtifact(context.Context, *GetSolutionArtifactRequest) (*SolutionArtifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSolutionArtifact not implemented")
}
func (*UnimplementedVisualInspectionServer) DeleteSolutionArtifact(context.Context, *DeleteSolutionArtifactRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSolutionArtifact not implemented")
}
func (*UnimplementedVisualInspectionServer) UpdateSolutionArtifact(context.Context, *UpdateSolutionArtifactRequest) (*SolutionArtifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSolutionArtifact not implemented")
}
func (*UnimplementedVisualInspectionServer) BatchPredict(context.Context, *BatchPredictRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchPredict not implemented")
}
func (*UnimplementedVisualInspectionServer) GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataset not implemented")
}
func (*UnimplementedVisualInspectionServer) ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatasets not implemented")
}
func (*UnimplementedVisualInspectionServer) DeleteDataset(context.Context, *DeleteDatasetRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataset not implemented")
}
func (*UnimplementedVisualInspectionServer) ImportData(context.Context, *ImportDataRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportData not implemented")
}
func (*UnimplementedVisualInspectionServer) ExportData(context.Context, *ExportDataRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportData not implemented")
}
func (*UnimplementedVisualInspectionServer) GetImage(context.Context, *GetImageRequest) (*Image, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImage not implemented")
}
func (*UnimplementedVisualInspectionServer) ListImages(context.Context, *ListImagesRequest) (*ListImagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListImages not implemented")
}
func (*UnimplementedVisualInspectionServer) CreateAnnotationSet(context.Context, *CreateAnnotationSetRequest) (*AnnotationSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAnnotationSet not implemented")
}
func (*UnimplementedVisualInspectionServer) ListAnnotationSets(context.Context, *ListAnnotationSetsRequest) (*ListAnnotationSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAnnotationSets not implemented")
}
func (*UnimplementedVisualInspectionServer) CreateAnnotationSpec(context.Context, *CreateAnnotationSpecRequest) (*AnnotationSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAnnotationSpec not implemented")
}
func (*UnimplementedVisualInspectionServer) ListAnnotationSpecs(context.Context, *ListAnnotationSpecsRequest) (*ListAnnotationSpecsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAnnotationSpecs not implemented")
}
func (*UnimplementedVisualInspectionServer) ListAnnotations(context.Context, *ListAnnotationsRequest) (*ListAnnotationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAnnotations not implemented")
}
func (*UnimplementedVisualInspectionServer) CreateModule(context.Context, *CreateModuleRequest) (*Module, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateModule not implemented")
}
func (*UnimplementedVisualInspectionServer) ListModules(context.Context, *ListModulesRequest) (*ListModulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModules not implemented")
}
func (*UnimplementedVisualInspectionServer) GetModule(context.Context, *GetModuleRequest) (*Module, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModule not implemented")
}
func (*UnimplementedVisualInspectionServer) DeleteModule(context.Context, *DeleteModuleRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteModule not implemented")
}
func (*UnimplementedVisualInspectionServer) UpdateModule(context.Context, *UpdateModuleRequest) (*Module, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateModule not implemented")
}
func (*UnimplementedVisualInspectionServer) CreateModel(context.Context, *CreateModelRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateModel not implemented")
}
func (*UnimplementedVisualInspectionServer) ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModels not implemented")
}
func (*UnimplementedVisualInspectionServer) GetModel(context.Context, *GetModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModel not implemented")
}
func (*UnimplementedVisualInspectionServer) DeleteModel(context.Context, *DeleteModelRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteModel not implemented")
}
func (*UnimplementedVisualInspectionServer) UpdateModel(context.Context, *UpdateModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateModel not implemented")
}
func (*UnimplementedVisualInspectionServer) ListModelEvaluations(context.Context, *ListModelEvaluationsRequest) (*ListModelEvaluationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModelEvaluations not implemented")
}
func (*UnimplementedVisualInspectionServer) GetModelEvaluation(context.Context, *GetModelEvaluationRequest) (*ModelEvaluation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModelEvaluation not implemented")
}
func (*UnimplementedVisualInspectionServer) WritePredictions(context.Context, *WritePredictionsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WritePredictions not implemented")
}
func (*UnimplementedVisualInspectionServer) CreateSpecialistPool(context.Context, *CreateSpecialistPoolRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSpecialistPool not implemented")
}
func (*UnimplementedVisualInspectionServer) GetSpecialistPool(context.Context, *GetSpecialistPoolRequest) (*SpecialistPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSpecialistPool not implemented")
}
func (*UnimplementedVisualInspectionServer) UpdateSpecialistPool(context.Context, *UpdateSpecialistPoolRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSpecialistPool not implemented")
}
func (*UnimplementedVisualInspectionServer) ListSpecialistPools(context.Context, *ListSpecialistPoolsRequest) (*ListSpecialistPoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSpecialistPools not implemented")
}
func (*UnimplementedVisualInspectionServer) DeleteSpecialistPool(context.Context, *DeleteSpecialistPoolRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSpecialistPool not implemented")
}
func (*UnimplementedVisualInspectionServer) CreateLabelingJob(context.Context, *CreateLabelingJobRequest) (*LabelingJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLabelingJob not implemented")
}
func (*UnimplementedVisualInspectionServer) GetLabelingJob(context.Context, *GetLabelingJobRequest) (*LabelingJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLabelingJob not implemented")
}
func (*UnimplementedVisualInspectionServer) ListLabelingJobs(context.Context, *ListLabelingJobsRequest) (*ListLabelingJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLabelingJobs not implemented")
}
func (*UnimplementedVisualInspectionServer) DeleteLabelingJob(context.Context, *DeleteLabelingJobRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteLabelingJob not implemented")
}
func (*UnimplementedVisualInspectionServer) CancelLabelingJob(context.Context, *CancelLabelingJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelLabelingJob not implemented")
}

func RegisterVisualInspectionServer(s *grpc.Server, srv VisualInspectionServer) {
	s.RegisterService(&_VisualInspection_serviceDesc, srv)
}

func _VisualInspection_CreateSolution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSolutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).CreateSolution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateSolution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).CreateSolution(ctx, req.(*CreateSolutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_ListSolutions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSolutionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).ListSolutions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/ListSolutions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).ListSolutions(ctx, req.(*ListSolutionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_GetSolution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSolutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).GetSolution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/GetSolution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).GetSolution(ctx, req.(*GetSolutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_CreateSolutionArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSolutionArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).CreateSolutionArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateSolutionArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).CreateSolutionArtifact(ctx, req.(*CreateSolutionArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_ListSolutionArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSolutionArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).ListSolutionArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/ListSolutionArtifacts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).ListSolutionArtifacts(ctx, req.(*ListSolutionArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_GetSolutionArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSolutionArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).GetSolutionArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/GetSolutionArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).GetSolutionArtifact(ctx, req.(*GetSolutionArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_DeleteSolutionArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSolutionArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).DeleteSolutionArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/DeleteSolutionArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).DeleteSolutionArtifact(ctx, req.(*DeleteSolutionArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_UpdateSolutionArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSolutionArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).UpdateSolutionArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/UpdateSolutionArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).UpdateSolutionArtifact(ctx, req.(*UpdateSolutionArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_BatchPredict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchPredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).BatchPredict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/BatchPredict",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).BatchPredict(ctx, req.(*BatchPredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_GetDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).GetDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/GetDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).GetDataset(ctx, req.(*GetDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_ListDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).ListDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/ListDatasets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).ListDatasets(ctx, req.(*ListDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_DeleteDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).DeleteDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/DeleteDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).DeleteDataset(ctx, req.(*DeleteDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_ImportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).ImportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/ImportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).ImportData(ctx, req.(*ImportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_ExportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).ExportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/ExportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).ExportData(ctx, req.(*ExportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_GetImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).GetImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/GetImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).GetImage(ctx, req.(*GetImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_ListImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).ListImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/ListImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).ListImages(ctx, req.(*ListImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_CreateAnnotationSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnnotationSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).CreateAnnotationSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateAnnotationSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).CreateAnnotationSet(ctx, req.(*CreateAnnotationSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_ListAnnotationSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnnotationSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).ListAnnotationSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/ListAnnotationSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).ListAnnotationSets(ctx, req.(*ListAnnotationSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_CreateAnnotationSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnnotationSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).CreateAnnotationSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateAnnotationSpec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).CreateAnnotationSpec(ctx, req.(*CreateAnnotationSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_ListAnnotationSpecs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnnotationSpecsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).ListAnnotationSpecs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/ListAnnotationSpecs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).ListAnnotationSpecs(ctx, req.(*ListAnnotationSpecsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_ListAnnotations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnnotationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).ListAnnotations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/ListAnnotations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).ListAnnotations(ctx, req.(*ListAnnotationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_CreateModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).CreateModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).CreateModule(ctx, req.(*CreateModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_ListModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).ListModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/ListModules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).ListModules(ctx, req.(*ListModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_GetModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).GetModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/GetModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).GetModule(ctx, req.(*GetModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_DeleteModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).DeleteModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/DeleteModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).DeleteModule(ctx, req.(*DeleteModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_UpdateModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).UpdateModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/UpdateModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).UpdateModule(ctx, req.(*UpdateModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_CreateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).CreateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).CreateModel(ctx, req.(*CreateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/ListModels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_GetModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).GetModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/GetModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).GetModel(ctx, req.(*GetModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_DeleteModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).DeleteModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/DeleteModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).DeleteModel(ctx, req.(*DeleteModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_UpdateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).UpdateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/UpdateModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).UpdateModel(ctx, req.(*UpdateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_ListModelEvaluations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelEvaluationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).ListModelEvaluations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/ListModelEvaluations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).ListModelEvaluations(ctx, req.(*ListModelEvaluationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_GetModelEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).GetModelEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/GetModelEvaluation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).GetModelEvaluation(ctx, req.(*GetModelEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_WritePredictions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WritePredictionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).WritePredictions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/WritePredictions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).WritePredictions(ctx, req.(*WritePredictionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_CreateSpecialistPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSpecialistPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).CreateSpecialistPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateSpecialistPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).CreateSpecialistPool(ctx, req.(*CreateSpecialistPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_GetSpecialistPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSpecialistPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).GetSpecialistPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/GetSpecialistPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).GetSpecialistPool(ctx, req.(*GetSpecialistPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_UpdateSpecialistPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSpecialistPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).UpdateSpecialistPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/UpdateSpecialistPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).UpdateSpecialistPool(ctx, req.(*UpdateSpecialistPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_ListSpecialistPools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSpecialistPoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).ListSpecialistPools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/ListSpecialistPools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).ListSpecialistPools(ctx, req.(*ListSpecialistPoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_DeleteSpecialistPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSpecialistPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).DeleteSpecialistPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/DeleteSpecialistPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).DeleteSpecialistPool(ctx, req.(*DeleteSpecialistPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_CreateLabelingJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLabelingJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).CreateLabelingJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/CreateLabelingJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).CreateLabelingJob(ctx, req.(*CreateLabelingJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_GetLabelingJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLabelingJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).GetLabelingJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/GetLabelingJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).GetLabelingJob(ctx, req.(*GetLabelingJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_ListLabelingJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLabelingJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).ListLabelingJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/ListLabelingJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).ListLabelingJobs(ctx, req.(*ListLabelingJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_DeleteLabelingJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLabelingJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).DeleteLabelingJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/DeleteLabelingJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).DeleteLabelingJob(ctx, req.(*DeleteLabelingJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VisualInspection_CancelLabelingJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelLabelingJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VisualInspectionServer).CancelLabelingJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visualinspection.v1beta1.VisualInspection/CancelLabelingJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VisualInspectionServer).CancelLabelingJob(ctx, req.(*CancelLabelingJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VisualInspection_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.visualinspection.v1beta1.VisualInspection",
	HandlerType: (*VisualInspectionServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSolution",
			Handler:    _VisualInspection_CreateSolution_Handler,
		},
		{
			MethodName: "ListSolutions",
			Handler:    _VisualInspection_ListSolutions_Handler,
		},
		{
			MethodName: "GetSolution",
			Handler:    _VisualInspection_GetSolution_Handler,
		},
		{
			MethodName: "CreateSolutionArtifact",
			Handler:    _VisualInspection_CreateSolutionArtifact_Handler,
		},
		{
			MethodName: "ListSolutionArtifacts",
			Handler:    _VisualInspection_ListSolutionArtifacts_Handler,
		},
		{
			MethodName: "GetSolutionArtifact",
			Handler:    _VisualInspection_GetSolutionArtifact_Handler,
		},
		{
			MethodName: "DeleteSolutionArtifact",
			Handler:    _VisualInspection_DeleteSolutionArtifact_Handler,
		},
		{
			MethodName: "UpdateSolutionArtifact",
			Handler:    _VisualInspection_UpdateSolutionArtifact_Handler,
		},
		{
			MethodName: "BatchPredict",
			Handler:    _VisualInspection_BatchPredict_Handler,
		},
		{
			MethodName: "GetDataset",
			Handler:    _VisualInspection_GetDataset_Handler,
		},
		{
			MethodName: "ListDatasets",
			Handler:    _VisualInspection_ListDatasets_Handler,
		},
		{
			MethodName: "DeleteDataset",
			Handler:    _VisualInspection_DeleteDataset_Handler,
		},
		{
			MethodName: "ImportData",
			Handler:    _VisualInspection_ImportData_Handler,
		},
		{
			MethodName: "ExportData",
			Handler:    _VisualInspection_ExportData_Handler,
		},
		{
			MethodName: "GetImage",
			Handler:    _VisualInspection_GetImage_Handler,
		},
		{
			MethodName: "ListImages",
			Handler:    _VisualInspection_ListImages_Handler,
		},
		{
			MethodName: "CreateAnnotationSet",
			Handler:    _VisualInspection_CreateAnnotationSet_Handler,
		},
		{
			MethodName: "ListAnnotationSets",
			Handler:    _VisualInspection_ListAnnotationSets_Handler,
		},
		{
			MethodName: "CreateAnnotationSpec",
			Handler:    _VisualInspection_CreateAnnotationSpec_Handler,
		},
		{
			MethodName: "ListAnnotationSpecs",
			Handler:    _VisualInspection_ListAnnotationSpecs_Handler,
		},
		{
			MethodName: "ListAnnotations",
			Handler:    _VisualInspection_ListAnnotations_Handler,
		},
		{
			MethodName: "CreateModule",
			Handler:    _VisualInspection_CreateModule_Handler,
		},
		{
			MethodName: "ListModules",
			Handler:    _VisualInspection_ListModules_Handler,
		},
		{
			MethodName: "GetModule",
			Handler:    _VisualInspection_GetModule_Handler,
		},
		{
			MethodName: "DeleteModule",
			Handler:    _VisualInspection_DeleteModule_Handler,
		},
		{
			MethodName: "UpdateModule",
			Handler:    _VisualInspection_UpdateModule_Handler,
		},
		{
			MethodName: "CreateModel",
			Handler:    _VisualInspection_CreateModel_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _VisualInspection_ListModels_Handler,
		},
		{
			MethodName: "GetModel",
			Handler:    _VisualInspection_GetModel_Handler,
		},
		{
			MethodName: "DeleteModel",
			Handler:    _VisualInspection_DeleteModel_Handler,
		},
		{
			MethodName: "UpdateModel",
			Handler:    _VisualInspection_UpdateModel_Handler,
		},
		{
			MethodName: "ListModelEvaluations",
			Handler:    _VisualInspection_ListModelEvaluations_Handler,
		},
		{
			MethodName: "GetModelEvaluation",
			Handler:    _VisualInspection_GetModelEvaluation_Handler,
		},
		{
			MethodName: "WritePredictions",
			Handler:    _VisualInspection_WritePredictions_Handler,
		},
		{
			MethodName: "CreateSpecialistPool",
			Handler:    _VisualInspection_CreateSpecialistPool_Handler,
		},
		{
			MethodName: "GetSpecialistPool",
			Handler:    _VisualInspection_GetSpecialistPool_Handler,
		},
		{
			MethodName: "UpdateSpecialistPool",
			Handler:    _VisualInspection_UpdateSpecialistPool_Handler,
		},
		{
			MethodName: "ListSpecialistPools",
			Handler:    _VisualInspection_ListSpecialistPools_Handler,
		},
		{
			MethodName: "DeleteSpecialistPool",
			Handler:    _VisualInspection_DeleteSpecialistPool_Handler,
		},
		{
			MethodName: "CreateLabelingJob",
			Handler:    _VisualInspection_CreateLabelingJob_Handler,
		},
		{
			MethodName: "GetLabelingJob",
			Handler:    _VisualInspection_GetLabelingJob_Handler,
		},
		{
			MethodName: "ListLabelingJobs",
			Handler:    _VisualInspection_ListLabelingJobs_Handler,
		},
		{
			MethodName: "DeleteLabelingJob",
			Handler:    _VisualInspection_DeleteLabelingJob_Handler,
		},
		{
			MethodName: "CancelLabelingJob",
			Handler:    _VisualInspection_CancelLabelingJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/visualinspection/v1beta1/service.proto",
}
