/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.database.SqlDataSource;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0007"}, d2={"findAppropriateCodeStyleSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "file", "Lcom/intellij/psi/PsiFile;", "name", "", "findCodeStyleSchemeName", "intellij.database.sql.core.impl"})
@JvmName(name="SqlCodeStyleProviderFun")
public final class SqlCodeStyleProviderFun {
    @Nullable
    public static final CodeStyleSettings findAppropriateCodeStyleSettings(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String name2 = SqlCodeStyleProviderFun.findCodeStyleSchemeName(file);
        return SqlCodeStyleProviderFun.findAppropriateCodeStyleSettings(name2);
    }

    @Nullable
    public static final CodeStyleSettings findAppropriateCodeStyleSettings(@Nullable String name2) {
        if (name2 == null) {
            return null;
        }
        CodeStyleSchemes css = CodeStyleSchemes.getInstance();
        CodeStyleScheme codeStyleScheme = css.findSchemeByName(name2);
        if (codeStyleScheme == null) {
            return null;
        }
        CodeStyleScheme scheme = codeStyleScheme;
        return scheme.getCodeStyleSettings();
    }

    private static final String findCodeStyleSchemeName(PsiFile file) {
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        if (Intrinsics.areEqual((Object)fileName, (Object)"preview\u22c8style.sql")) {
            return null;
        }
        DbDataSource dataSource = DbImplUtilCore.getForcedDataSource(file);
        RawDataSource ds = DbImplUtilCore.unwrapDS(dataSource);
        return ds instanceof LocalDataSource ? ((LocalDataSource)ds).getCodeStyleName() : (ds instanceof SqlDataSource ? ((SqlDataSource)ds).getCodeStyleName() : null);
    }
}

