/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileOffsetsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.text.CharArrayUtil;
import java.nio.CharBuffer;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/javascript/service/DocumentOffsetsManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myOffsets", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/editor/Document;", "Lcom/intellij/openapi/fileEditor/impl/FileOffsetsManager$LineOffsets;", "getConvertedOffset", "", "document", "originalOffset", "getOriginalOffset", "convertedOffset", "getLineOffsets", "loadLineOffsets", "createWritableCharBuffer", "Ljava/nio/CharBuffer;", "charSequence", "", "intellij.javascript.impl"})
public final class DocumentOffsetsManager {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<Document, FileOffsetsManager.LineOffsets> myOffsets;

    public DocumentOffsetsManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.myOffsets = concurrentMap;
    }

    public final int getConvertedOffset(@NotNull Document document, int originalOffset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        FileOffsetsManager.LineOffsets offsets = this.getLineOffsets(document);
        if (offsets == null || offsets.myLineOffsetsAreTheSame) {
            return originalOffset;
        }
        return FileOffsetsManager.getCorrespondingOffset((int[])offsets.myOriginalLineOffsets, (int[])offsets.myConvertedLineOffsets, (int)originalOffset);
    }

    public final int getOriginalOffset(@NotNull Document document, int convertedOffset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        FileOffsetsManager.LineOffsets offsets = this.getLineOffsets(document);
        if (offsets == null || offsets.myLineOffsetsAreTheSame) {
            return convertedOffset;
        }
        return FileOffsetsManager.getCorrespondingOffset((int[])offsets.myConvertedLineOffsets, (int[])offsets.myOriginalLineOffsets, (int)convertedOffset);
    }

    private final FileOffsetsManager.LineOffsets getLineOffsets(Document document) {
        FileOffsetsManager.LineOffsets cachedOffsets;
        FileOffsetsManager.LineOffsets lineOffsets = cachedOffsets = (FileOffsetsManager.LineOffsets)this.myOffsets.get(document);
        boolean bl = lineOffsets != null ? lineOffsets.myFileModificationStamp == document.getModificationStamp() : false;
        if (bl) {
            return cachedOffsets;
        }
        FileOffsetsManager.LineOffsets lineOffsets2 = this.loadLineOffsets(document);
        if (lineOffsets2 == null) {
            return null;
        }
        FileOffsetsManager.LineOffsets newOffsets = lineOffsets2;
        return this.myOffsets.compute(document, (arg_0, arg_1) -> DocumentOffsetsManager.getLineOffsets$lambda$1((arg_0, arg_1) -> DocumentOffsetsManager.getLineOffsets$lambda$0(newOffsets, arg_0, arg_1), arg_0, arg_1));
    }

    private final FileOffsetsManager.LineOffsets loadLineOffsets(Document document) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        Pair pair = (Pair)ReadAction.compute(() -> DocumentOffsetsManager.loadLineOffsets$lambda$2(document));
        CharSequence content = (CharSequence)pair.component1();
        long modificationStamp = ((Number)pair.component2()).longValue();
        CharSequence charSequence = JSLanguageServiceUtil.convertLineSeparatorsToFileOriginal(this.project, content, file);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"convertLineSeparatorsToFileOriginal(...)");
        CharSequence convertedContent = charSequence;
        return FileOffsetsManager.loadLineOffsets((CharBuffer)this.createWritableCharBuffer(convertedContent), (long)modificationStamp);
    }

    private final CharBuffer createWritableCharBuffer(CharSequence charSequence) {
        char[] arr = new char[charSequence.length()];
        CharArrayUtil.getChars((CharSequence)charSequence, (char[])arr, (int)0);
        CharBuffer charBuffer = CharBuffer.wrap(arr);
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"wrap(...)");
        return charBuffer;
    }

    private static final FileOffsetsManager.LineOffsets getLineOffsets$lambda$0(FileOffsetsManager.LineOffsets $newOffsets, Document doc, FileOffsetsManager.LineOffsets offsets) {
        FileOffsetsManager.LineOffsets lineOffsets = offsets;
        return (lineOffsets != null ? lineOffsets.myFileModificationStamp == doc.getModificationStamp() : false) ? offsets : ($newOffsets.myFileModificationStamp == doc.getModificationStamp() ? $newOffsets : null);
    }

    private static final FileOffsetsManager.LineOffsets getLineOffsets$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (FileOffsetsManager.LineOffsets)$tmp0.invoke(p0, p1);
    }

    private static final Pair loadLineOffsets$lambda$2(Document $document) {
        return TuplesKt.to((Object)$document.getCharsSequence(), (Object)$document.getModificationStamp());
    }
}

