/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcomponents.descriptor;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlDocumentImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class TagWithNameDescriptor
implements XmlElementDescriptor {
    protected final String myName;
    protected final XmlTag myXmlTag;

    public TagWithNameDescriptor(XmlTag xmlTag) {
        this(xmlTag.getName(), xmlTag);
    }

    public TagWithNameDescriptor(String name, XmlTag xmlTag) {
        this.myName = name;
        this.myXmlTag = xmlTag;
    }

    public String getQualifiedName() {
        return this.myName;
    }

    public String getDefaultName() {
        return this.myName;
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        XmlDocumentImpl xmlDocument = (XmlDocumentImpl)PsiTreeUtil.getParentOfType((PsiElement)context, XmlDocumentImpl.class);
        if (xmlDocument == null) {
            return EMPTY_ARRAY;
        }
        XmlNSDescriptor rootNSDescriptor = xmlDocument.getRootTagNSDescriptor();
        return rootNSDescriptor != null ? rootNSDescriptor.getRootElementsDescriptors((XmlDocument)xmlDocument) : EMPTY_ARRAY;
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        XmlTag parent = contextTag.getParentTag();
        if (parent == null) {
            return null;
        }
        XmlNSDescriptor descriptor = parent.getNSDescriptor(childTag.getNamespace(), true);
        return descriptor == null ? null : descriptor.getElementDescriptor(childTag);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        return XmlAttributeDescriptor.EMPTY;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        return new AnyXmlAttributeDescriptor(attributeName);
    }

    public XmlNSDescriptor getNSDescriptor() {
        return null;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return 1;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getName() {
        return this.myName;
    }

    public void init(PsiElement element) {
    }
}

