/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.html.psi.impl;

import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.recordImpl.CallSignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.lang.LangMode;
import org.jetbrains.vuejs.lang.html.VueFile;
import org.jetbrains.vuejs.lang.html.VueFileElementType;
import org.jetbrains.vuejs.lang.html.lexer.VueLangModeMarkerElementType;
import org.jetbrains.vuejs.lang.html.psi.impl.VueScriptSetupEmbeddedContentImpl;
import org.jetbrains.vuejs.lang.html.stub.impl.VueFileStubImpl;
import org.jetbrains.vuejs.model.VueModelManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/vuejs/lang/html/psi/impl/VueFileImpl;", "Lcom/intellij/psi/impl/source/html/HtmlFileImpl;", "Lorg/jetbrains/vuejs/lang/html/VueFile;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "<init>", "(Lcom/intellij/psi/FileViewProvider;)V", "getStub", "Lorg/jetbrains/vuejs/lang/html/stub/impl/VueFileStubImpl;", "langMode", "Lorg/jetbrains/vuejs/lang/LangMode;", "getLangMode", "()Lorg/jetbrains/vuejs/lang/LangMode;", "getDefaultExportedName", "", "buildModuleType", "Lcom/intellij/lang/javascript/psi/JSType;", "module", "Lcom/intellij/psi/PsiElement;", "intellij.vuejs"})
public final class VueFileImpl
extends HtmlFileImpl
implements VueFile {
    public VueFileImpl(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        super(viewProvider, (IFileElementType)VueFileElementType.Companion.getINSTANCE());
    }

    @Nullable
    public VueFileStubImpl getStub() {
        return (VueFileStubImpl)super.getStub();
    }

    @Override
    @NotNull
    public LangMode getLangMode() {
        VueFileStubImpl stub = this.getStub();
        if (stub != null) {
            return stub.getLangMode();
        }
        PsiElement psiElement = this.getLastChild();
        IElementType astMarker = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
        return astMarker instanceof VueLangModeMarkerElementType ? ((VueLangModeMarkerElementType)astMarker).getLangMode() : LangMode.Companion.getDEFAULT();
    }

    @NotNull
    public String getDefaultExportedName() {
        String string = FileUtil.getNameWithoutExtension((String)this.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        return VueUtilKt.toAsset(string, true);
    }

    @Nullable
    public JSType buildModuleType(@NotNull PsiElement module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (module instanceof VueFile) {
            PropertySignatureImpl defaultProperty = new PropertySignatureImpl("default", null, true, true, module);
            return (JSType)new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)module, (boolean)true), CollectionsKt.listOf((Object)defaultProperty));
        }
        if (!(module instanceof VueScriptSetupEmbeddedContentImpl)) {
            return null;
        }
        return (JSType)CachedValuesManager.getCachedValue((PsiElement)module, () -> VueFileImpl.buildModuleType$lambda$0(module));
    }

    private static final CachedValueProvider.Result buildModuleType$lambda$0(PsiElement $module) {
        JSRecordType jSRecordType = VueModelManager.Companion.findEnclosingContainer($module).getThisType().asRecordType();
        Intrinsics.checkNotNullExpressionValue((Object)jSRecordType, (String)"asRecordType(...)");
        JSRecordType returnType = jSRecordType;
        JSType jSType = returnType.transformTypeHierarchy((JSRecursiveTypeTransformer)TypeScriptTypeRelations.instantiationTransformer((boolean)false));
        Intrinsics.checkNotNullExpressionValue((Object)jSType, (String)"transformTypeHierarchy(...)");
        JSType returnTypeInstantiated = jSType;
        JSTypeSource jSTypeSource = JSTypeSourceFactory.createTypeSource((PsiElement)$module, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jSTypeSource, (String)"createTypeSource(...)");
        JSTypeSource source = jSTypeSource;
        TypeScriptJSFunctionTypeImpl functionType = new TypeScriptJSFunctionTypeImpl(source, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, returnTypeInstantiated);
        PropertySignatureImpl defaultProperty = new PropertySignatureImpl("default", null, true, true, $module);
        Object[] objectArray = new JSRecordType.TypeMember[]{new CallSignatureImpl(true, (JSFunctionType)functionType), defaultProperty};
        JSRecordTypeImpl recordType = new JSRecordTypeImpl(source, CollectionsKt.listOf((Object[])objectArray));
        return CachedValueProvider.Result.createSingleDependency((Object)recordType, (Object)PsiModificationTracker.MODIFICATION_COUNT);
    }
}

