/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.style;

import com.intellij.charts.style.ColorTableModel;
import com.intellij.charts.style.PaletteDialogKt;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/charts/style/ColorTableCopyProvider;", "Lcom/intellij/ide/CopyProvider;", "table", "Ljavax/swing/JTable;", "<init>", "(Ljavax/swing/JTable;)V", "performCopy", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyEnabled", "", "isCopyVisible", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nColorTableCopyProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorTableCopyProvider.kt\ncom/intellij/charts/style/ColorTableCopyProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,41:1\n13493#2,2:42\n*S KotlinDebug\n*F\n+ 1 ColorTableCopyProvider.kt\ncom/intellij/charts/style/ColorTableCopyProvider\n*L\n25#1:42,2\n*E\n"})
public final class ColorTableCopyProvider
implements CopyProvider {
    @NotNull
    private final JTable table;

    public ColorTableCopyProvider(@NotNull JTable table2) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        this.table = table2;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        ColorTableModel model2;
        int[] selectedColumns;
        int[] selectedRows;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                selectedRows = this.table.getSelectedRows();
                selectedColumns = this.table.getSelectedColumns();
                TableModel tableModel = this.table.getModel();
                ColorTableModel colorTableModel = tableModel instanceof ColorTableModel ? (ColorTableModel)tableModel : null;
                if (colorTableModel == null) {
                    return;
                }
                model2 = colorTableModel;
                Intrinsics.checkNotNull((Object)selectedRows);
                if (selectedRows.length == 0) break block9;
                Intrinsics.checkNotNull((Object)selectedColumns);
                if (!(selectedColumns.length == 0)) break block10;
            }
            return;
        }
        boolean saveLight = ArraysKt.contains((int[])selectedColumns, (int)0) || ArraysKt.contains((int[])selectedColumns, (int)1);
        boolean saveDark = ArraysKt.contains((int[])selectedColumns, (int)2) || ArraysKt.contains((int[])selectedColumns, (int)3);
        StringBuilder sb = new StringBuilder();
        int[] $this$forEach$iv = selectedRows;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String string;
            StringBuilder stringBuilder;
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (saveLight && saveDark) {
                Object object = model2.getValueAt(it, 0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                StringBuilder stringBuilder2 = sb.append(PaletteDialogKt.fromColorToHexString((Integer)object)).append(';');
                Object object2 = model2.getValueAt(it, 2);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                stringBuilder = stringBuilder2.append(PaletteDialogKt.fromColorToHexString((Integer)object2)).append('\n');
                continue;
            }
            if (saveLight) {
                Object object = model2.getValueAt(it, 0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                string = PaletteDialogKt.fromColorToHexString((Integer)object);
            } else {
                Object object = model2.getValueAt(it, 2);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                string = PaletteDialogKt.fromColorToHexString((Integer)object);
            }
            stringBuilder = sb.append(string).append('\n');
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb.toString()));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.table.getSelectedRowCount() > 0 && this.table.getSelectedColumnCount() > 0;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

