/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.presentation;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.unsupported.UnsupportedKt;
import org.jetbrains.letsPlot.commons.values.Font;
import org.jetbrains.letsPlot.core.plot.base.render.text.RichText;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;
import org.jetbrains.letsPlot.core.plot.builder.presentation.TextWidthEstimator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/presentation/PlotLabelSpec;", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "markdown", "", "(Lorg/jetbrains/letsPlot/commons/values/Font;Z)V", "getFont", "()Lorg/jetbrains/letsPlot/commons/values/Font;", "getMarkdown", "()Z", "dimensions", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "labelText", "", "height", "", "multilineDimensions", "multilineHeight", "width", "Companion", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotLabelSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotLabelSpec.kt\norg/jetbrains/letsPlot/core/plot/builder/presentation/PlotLabelSpec\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,101:1\n1099#2,3:102\n*S KotlinDebug\n*F\n+ 1 PlotLabelSpec.kt\norg/jetbrains/letsPlot/core/plot/builder/presentation/PlotLabelSpec\n*L\n35#1:102,3\n*E\n"})
public final class PlotLabelSpec
implements LabelSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Font font;
    private final boolean markdown;
    private static final double FONT_SIZE_TO_GLYPH_WIDTH_RATIO = 0.67;
    private static final double FONT_SIZE_TO_GLYPH_WIDTH_RATIO_MONOSPACED = 0.6;
    private static final double FONT_WEIGHT_BOLD_TO_NORMAL_WIDTH_RATIO = 1.075;
    private static final double LABEL_PADDING = 0.0;
    private static final double FONT_WIDTH_SCALE_FACTOR = 0.85026;
    @NotNull
    private static final LabelSpec DUMMY = new LabelSpec(){

        @NotNull
        public Font getFont() {
            UnsupportedKt.UNSUPPORTED("Dummy Label Spec");
            throw new KotlinNothingValueException();
        }

        public boolean getMarkdown() {
            UnsupportedKt.UNSUPPORTED("Dummy Label Spec");
            throw new KotlinNothingValueException();
        }

        @NotNull
        public DoubleVector dimensions(@NotNull String labelText) {
            Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
            UnsupportedKt.UNSUPPORTED("Dummy Label Spec");
            throw new KotlinNothingValueException();
        }

        @NotNull
        public DoubleVector multilineDimensions(@NotNull String labelText) {
            Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
            UnsupportedKt.UNSUPPORTED("Dummy Label Spec");
            throw new KotlinNothingValueException();
        }

        public double width(@NotNull String labelText) {
            Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
            UnsupportedKt.UNSUPPORTED("Dummy Label Spec");
            throw new KotlinNothingValueException();
        }

        public double height() {
            UnsupportedKt.UNSUPPORTED("Dummy Label Spec");
            throw new KotlinNothingValueException();
        }

        public double multilineHeight(@NotNull String labelText) {
            Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
            UnsupportedKt.UNSUPPORTED("Dummy Label Spec");
            throw new KotlinNothingValueException();
        }
    };

    public PlotLabelSpec(@NotNull Font font, boolean markdown) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.font = font;
        this.markdown = markdown;
    }

    public /* synthetic */ PlotLabelSpec(Font font, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(font, bl);
    }

    @Override
    @NotNull
    public Font getFont() {
        return this.font;
    }

    @Override
    public boolean getMarkdown() {
        return this.markdown;
    }

    @Override
    @NotNull
    public DoubleVector dimensions(@NotNull String labelText) {
        Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
        return new DoubleVector(this.width(labelText), this.height());
    }

    @Override
    @NotNull
    public DoubleVector multilineDimensions(@NotNull String labelText) {
        Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
        return new DoubleVector(this.width(labelText), this.multilineHeight(labelText));
    }

    @Override
    public double width(@NotNull String labelText) {
        Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
        return RichText.estimateWidth$default(RichText.INSTANCE, labelText, this.getFont(), 0, 0, this.getMarkdown(), (Function2)new Function2<String, Font, Double>((Object)Companion){

            @NotNull
            public final Double invoke(@NotNull String p0, @NotNull Font p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return org.jetbrains.letsPlot.core.plot.builder.presentation.PlotLabelSpec$Companion.access$widthCalculator((Companion)this.receiver, p0, p1);
            }
        }, 12, null);
    }

    @Override
    public double height() {
        return (double)this.getFont().getSize() + 0.0;
    }

    @Override
    public double multilineHeight(@NotNull String labelText) {
        Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
        CharSequence $this$count$iv = labelText;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        int newLinesCount = count$iv;
        boolean bl = false;
        return this.height() + (double)(this.getFont().getSize() * newLinesCount);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/presentation/PlotLabelSpec$Companion;", "", "()V", "DUMMY", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "getDUMMY", "()Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "FONT_SIZE_TO_GLYPH_WIDTH_RATIO", "", "FONT_SIZE_TO_GLYPH_WIDTH_RATIO_MONOSPACED", "FONT_WEIGHT_BOLD_TO_NORMAL_WIDTH_RATIO", "FONT_WIDTH_SCALE_FACTOR", "LABEL_PADDING", "monospacedWidth", "labelLength", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "text", "", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        private final double widthCalculator(String text2, Font font) {
            double it = font.isMonospased() ? this.monospacedWidth(text2.length(), font) : 0.85026 * TextWidthEstimator.INSTANCE.textWidth(text2, font);
            boolean bl = false;
            return it * font.getFamily().getWidthFactor();
        }

        private final double monospacedWidth(int labelLength, Font font) {
            double ratio = 0.6;
            double width2 = (double)labelLength * (double)font.getSize() * ratio + 0.0;
            return font.isBold() ? width2 * 1.075 : width2;
        }

        @NotNull
        public final LabelSpec getDUMMY() {
            return DUMMY;
        }

        public static final /* synthetic */ double access$widthCalculator(Companion $this, String text2, Font font) {
            return $this.widthCalculator(text2, font);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

