/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssElementDescriptorConstants;
import com.intellij.psi.css.inspections.bugs.CssNoGenericFontNameInspection;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssInsertGenericFontFamilyIntention
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public CssInsertGenericFontFamilyIntention(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            CssInsertGenericFontFamilyIntention.$$$reportNull$$$0(0);
        }
        super((PsiElement)declaration);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            CssInsertGenericFontFamilyIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            CssInsertGenericFontFamilyIntention.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            CssInsertGenericFontFamilyIntention.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            CssInsertGenericFontFamilyIntention.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            CssInsertGenericFontFamilyIntention.$$$reportNull$$$0(5);
        }
        if (startElement instanceof CssDeclaration) {
            CssDeclaration cssDeclaration = (CssDeclaration)startElement;
            String propertyName = CssDescriptorsUtil.getCanonicalPropertyName(cssDeclaration);
            return "font-family".equals(propertyName) && CssNoGenericFontNameInspection.isGenericFontFamilyMissed(cssDeclaration);
        }
        return false;
    }

    private static int findPlaceForGenericFontName(@NotNull CssDeclaration declaration) {
        PsiElement[] terms;
        CssTermList termList;
        if (declaration == null) {
            CssInsertGenericFontFamilyIntention.$$$reportNull$$$0(6);
        }
        if ((termList = declaration.getValue()) != null && (terms = termList.getChildren()).length > 0) {
            return terms[terms.length - 1].getTextRange().getEndOffset();
        }
        return declaration.getTextRange().getEndOffset();
    }

    private static Template createTemplate(Project project, boolean withComma) {
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "");
        template.addTextSegment(withComma ? "," : "");
        ConstantNode expression = new ConstantNode("serif").withLookupStrings(CssElementDescriptorConstants.GENERIC_FONT_NAMES);
        template.addVariable("name", (Expression)expression, (Expression)expression, true);
        return template;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            CssInsertGenericFontFamilyIntention.$$$reportNull$$$0(7);
        }
        if (psiFile == null) {
            CssInsertGenericFontFamilyIntention.$$$reportNull$$$0(8);
        }
        if (startElement == null) {
            CssInsertGenericFontFamilyIntention.$$$reportNull$$$0(9);
        }
        if (endElement == null) {
            CssInsertGenericFontFamilyIntention.$$$reportNull$$$0(10);
        }
        if (editor == null || !(startElement instanceof CssDeclaration)) {
            return;
        }
        CssDeclaration cssDeclaration = (CssDeclaration)startElement;
        CssTermList value = cssDeclaration.getValue();
        if (value == null) {
            return;
        }
        CssTerm[] terms = value.getTerms();
        Template template = CssInsertGenericFontFamilyIntention.createTemplate(project, terms.length > 0);
        PsiFile containingFile = cssDeclaration.getContainingFile();
        if (containingFile != null) {
            int offset = CssInsertGenericFontFamilyIntention.findPlaceForGenericFontName(cssDeclaration);
            editor.getCaretModel().moveToOffset(offset);
            CodeEditUtil.markToReformat((ASTNode)cssDeclaration.getNode(), (boolean)true);
            TemplateManager.getInstance((Project)project).startTemplate(editor, template);
        }
    }

    @NotNull
    public String getText() {
        String string = CssBundle.message("css.overwritten.nongeneric.fontname.fix.message", new Object[0]);
        if (string == null) {
            CssInsertGenericFontFamilyIntention.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/CssInsertGenericFontFamilyIntention";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/CssInsertGenericFontFamilyIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 11: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPlaceForGenericFontName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 11 -> new IllegalStateException(string);
        };
    }
}

