/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.util.ThrowableConsumer;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.TimeDistribution;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8LogIndexesWriter;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import com.jetbrains.nodejs.run.profile.heap.io.LinksWriter;
import com.jetbrains.nodejs.run.profile.heap.io.LongRawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawWriter;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReader;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class V8LogStackDurationWorker
implements Closeable {
    private Long2LongMap myDurationByIdMap;
    @NotNull
    private final IndexFiles<V8LogIndexesWriter.Category> myIndexFiles;
    private ArrayList<Duration> myStack;
    private final LinksWriter<Long> myWriter;
    private long myDurationCnt;
    private long myTick;
    private File myNumDurationFile;
    private File myDurationFile;
    private final File myNumDurationIdFile;
    private final File myDurationIdFile;
    private final Map<Long, TimeDistribution> myDistribution;
    private final Map<Long, TimeDistribution> mySelfDistribution;
    private File myDistributionFile;
    private File mySelfDistributionFile;

    public V8LogStackDurationWorker(@NotNull IndexFiles<V8LogIndexesWriter.Category> indexFiles) throws IOException {
        if (indexFiles == null) {
            V8LogStackDurationWorker.$$$reportNull$$$0(0);
        }
        this.myIndexFiles = indexFiles;
        this.myNumDurationIdFile = indexFiles.generate(V8LogIndexesWriter.Category.numDurationByTick1, "numDuration");
        this.myDurationIdFile = indexFiles.generate(V8LogIndexesWriter.Category.durationByTick1, "duration");
        this.myWriter = new LinksWriter<Long>(this.myNumDurationIdFile, this.myDurationIdFile, new LongRawSerializer());
        this.myStack = new ArrayList();
        this.myDurationByIdMap = new Long2LongOpenHashMap();
        this.myDurationCnt = 0L;
        this.myTick = 0L;
        this.myDistribution = new HashMap<Long, TimeDistribution>();
        this.mySelfDistribution = new HashMap<Long, TimeDistribution>();
    }

    public LinksReaderFactory<Long> getDurationFactory() {
        return new LinksReaderFactory<Long>(new LongRawSerializer(), this.myNumDurationFile, this.myDurationFile);
    }

    public void tick(long nanos, List<Long> bottomUpStringNumbers) throws IOException {
        Duration oldId;
        Long newId;
        int newIdx;
        this.myTick = nanos;
        int stackId = this.myStack.size() - 1;
        for (newIdx = bottomUpStringNumbers.size() - 1; newIdx >= 0 && stackId >= 0 && (newId = bottomUpStringNumbers.get(newIdx)).equals((oldId = this.myStack.get(stackId)).getStringId()); --newIdx, --stackId) {
        }
        boolean selfTimePut = false;
        for (int i = 0; i <= stackId; ++i) {
            Duration duration = this.myStack.get(i);
            int interval = (int)(nanos - duration.getStartTs());
            this.myDurationByIdMap.put(duration.getDurationId(), (long)interval);
            if (!selfTimePut && 1L != duration.getStringId()) {
                V8LogStackDurationWorker.registerInDistribution(this.mySelfDistribution, duration.getStringId(), duration.getStartTs(), interval);
                selfTimePut = true;
            }
            V8LogStackDurationWorker.registerInDistribution(this.myDistribution, duration.getStringId(), duration.getStartTs(), interval);
        }
        List<Duration> tail = this.myStack.subList(stackId + 1, this.myStack.size());
        this.myStack = new ArrayList(bottomUpStringNumbers.size());
        ArrayList<Long> durationIdsList = new ArrayList<Long>();
        for (int i = 0; i <= newIdx; ++i) {
            long durationId;
            ++this.myDurationCnt;
            this.myStack.add(new Duration(bottomUpStringNumbers.get(i), durationId, nanos));
            durationIdsList.add(durationId);
        }
        for (Duration duration : tail) {
            this.myStack.add(duration);
            durationIdsList.add(duration.getDurationId());
        }
        this.myWriter.write(durationIdsList);
    }

    /*
     * WARNING - void declaration
     */
    private static void registerInDistribution(@NotNull Map<Long, TimeDistribution> map, long stringId, long startTs, int n) {
        void interval;
        TimeDistribution distribution;
        if (map == null) {
            V8LogStackDurationWorker.$$$reportNull$$$0(1);
        }
        if ((distribution = map.get(stringId)) == null) {
            distribution = new TimeDistribution();
            map.put(stringId, distribution);
        }
        distribution.register(startTs, (long)interval);
    }

    public void recalculateDurationsWriteDistribution(@NotNull Long maxStringId) throws IOException {
        if (maxStringId == null) {
            V8LogStackDurationWorker.$$$reportNull$$$0(2);
        }
        this.myWriter.close();
        for (Duration duration : this.myStack) {
            this.myDurationByIdMap.put(duration.getDurationId(), (long)((int)(this.myTick - duration.getStartTs())));
        }
        try (CompositeCloseable closeable = new CompositeCloseable();){
            this.myNumDurationFile = this.myIndexFiles.generate(V8LogIndexesWriter.Category.numDurationByTick2, "numDuration2");
            this.myDurationFile = this.myIndexFiles.generate(V8LogIndexesWriter.Category.durationByTick2, "duration2");
            LinksWriter<Long> writer = closeable.register(new LinksWriter<Long>(this.myNumDurationFile, this.myDurationFile, new LongRawSerializer()));
            LinksReader<Long> reader = closeable.register(new LinksReaderFactory<Long>(new LongRawSerializer(), this.myNumDurationIdFile, this.myDurationIdFile).create(true));
            reader.iterateWithThrowable((ThrowableConsumer<List<Long>, IOException>)((ThrowableConsumer)longs -> {
                LongArrayList duration = new LongArrayList();
                Iterator iterator = longs.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    duration.add(this.myDurationByIdMap.get(id));
                }
                writer.write((Collection<Long>)duration);
            }));
        }
        this.myDurationByIdMap = null;
        this.writeDistributions(maxStringId);
    }

    private void writeDistributions(Long maxStringId) throws IOException {
        this.myDistributionFile = this.myIndexFiles.generate(V8LogIndexesWriter.Category.distribution, "Distribution");
        this.mySelfDistributionFile = this.myIndexFiles.generate(V8LogIndexesWriter.Category.selfDistribution, "SelfDistribution");
        try (CompositeCloseable closeable = new CompositeCloseable();){
            V8LogStackDurationWorker.writeDistributionMap(this.myDistribution, this.myDistributionFile, maxStringId, closeable);
            V8LogStackDurationWorker.writeDistributionMap(this.mySelfDistribution, this.mySelfDistributionFile, maxStringId, closeable);
        }
    }

    private static void writeDistributionMap(@NotNull Map<Long, TimeDistribution> map, @NotNull File distributionFile, Long maxStringId, CompositeCloseable closeable) throws IOException {
        if (map == null) {
            V8LogStackDurationWorker.$$$reportNull$$$0(3);
        }
        if (distributionFile == null) {
            V8LogStackDurationWorker.$$$reportNull$$$0(4);
        }
        RawSerializer<TimeDistribution> serializer = TimeDistribution.getSerializer(TimeDistribution.STANDARD);
        SequentialRawWriter<TimeDistribution> writer = closeable.register(new SequentialRawWriter<TimeDistribution>(distributionFile, serializer));
        for (long i = 0L; i < maxStringId; ++i) {
            TimeDistribution distribution = map.get(i);
            distribution = distribution == null ? new TimeDistribution() : distribution;
            writer.write(distribution);
        }
    }

    @Override
    public void close() throws IOException {
        this.myWriter.close();
    }

    public File getDistributionFile() {
        return this.myDistributionFile;
    }

    public File getSelfDistributionFile() {
        return this.mySelfDistributionFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexFiles";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxStringId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8LogStackDurationWorker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerInDistribution";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "recalculateDurationsWriteDistribution";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeDistributionMap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Duration {
        private final long myStringId;
        private final long myDurationId;
        private final long myStartTs;

        Duration(long stringId, long durationId, long startTs) {
            this.myStringId = stringId;
            this.myDurationId = durationId;
            this.myStartTs = startTs;
        }

        public long getStringId() {
            return this.myStringId;
        }

        public long getDurationId() {
            return this.myDurationId;
        }

        public long getStartTs() {
            return this.myStartTs;
        }
    }
}

