//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-quartz-core")]
#[cfg(not(target_os = "watchos"))]
use objc2_quartz_core::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextviewdelegate?language=objc)
    #[cfg(feature = "UIScrollView")]
    pub unsafe trait UITextViewDelegate:
        NSObjectProtocol + UIScrollViewDelegate + MainThreadOnly
    {
        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(textViewShouldBeginEditing:))]
        #[unsafe(method_family = none)]
        fn textViewShouldBeginEditing(&self, text_view: &UITextView) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(textViewShouldEndEditing:))]
        #[unsafe(method_family = none)]
        fn textViewShouldEndEditing(&self, text_view: &UITextView) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(textViewDidBeginEditing:))]
        #[unsafe(method_family = none)]
        fn textViewDidBeginEditing(&self, text_view: &UITextView);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(textViewDidEndEditing:))]
        #[unsafe(method_family = none)]
        fn textViewDidEndEditing(&self, text_view: &UITextView);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[deprecated]
        #[optional]
        #[unsafe(method(textView:shouldChangeTextInRange:replacementText:))]
        #[unsafe(method_family = none)]
        fn textView_shouldChangeTextInRange_replacementText(
            &self,
            text_view: &UITextView,
            range: NSRange,
            text: &NSString,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Asks the delegate if the text at the specified `ranges` should be replaced with `text`.
        ///
        ///
        /// If this method returns YES then the text view will, at its own discretion, choose any one of the specified `ranges` of text and replace it with the specified `replacementText` before deleting the text at the other ranges. If the delegate does not implement this method then the `textView:shouldChangeTextInRange:replacementText:` method will be called and passed the union range instead. If the delegate also does not implement that method then YES is assumed.
        ///
        ///
        /// Parameter `textView`: The text view asking the delegate
        ///
        /// Parameter `ranges`: The ranges of the text that should be deleted before replacing
        ///
        /// Parameter `replacementText`: The replacement text
        ///
        ///
        /// Returns: Returns true if the text at the `ranges` should be replaced.
        #[optional]
        #[unsafe(method(textView:shouldChangeTextInRanges:replacementText:))]
        #[unsafe(method_family = none)]
        fn textView_shouldChangeTextInRanges_replacementText(
            &self,
            text_view: &UITextView,
            ranges: &NSArray<NSValue>,
            text: &NSString,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(textViewDidChange:))]
        #[unsafe(method_family = none)]
        fn textViewDidChange(&self, text_view: &UITextView);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(textViewDidChangeSelection:))]
        #[unsafe(method_family = none)]
        fn textViewDidChangeSelection(&self, text_view: &UITextView);

        #[cfg(all(
            feature = "UIMenu",
            feature = "UIMenuElement",
            feature = "UIResponder",
            feature = "UIView"
        ))]
        /// Asks the delegate for the menu to be shown for the specified text range.
        ///
        ///
        /// Parameter `textView`: The text view requesting the menu.
        ///
        /// Parameter `range`: The text range for which the menu is presented for.
        ///
        /// Parameter `suggestedActions`: The actions and commands that the system suggests.
        ///
        ///
        /// Returns: Return a UIMenu describing the desired menu hierarchy. Return
        /// `nil`to present the default system menu.
        #[deprecated]
        #[optional]
        #[unsafe(method(textView:editMenuForTextInRange:suggestedActions:))]
        #[unsafe(method_family = none)]
        fn textView_editMenuForTextInRange_suggestedActions(
            &self,
            text_view: &UITextView,
            range: NSRange,
            suggested_actions: &NSArray<UIMenuElement>,
        ) -> Option<Retained<UIMenu>>;

        #[cfg(all(
            feature = "UIMenu",
            feature = "UIMenuElement",
            feature = "UIResponder",
            feature = "UIView"
        ))]
        /// Asks the delegate for the menu to be shown for the specified text ranges.
        ///
        ///
        /// If the delegate does not implement this method then the `textView:editMenuForTextInRange:suggestedActions:` method will be called and passed the union range instead. If the delegate also does not implement that method then `nil` is assumed.
        ///
        ///
        /// Parameter `textView`: The text view requesting the menu.
        ///
        /// Parameter `ranges`: The text ranges for which the menu is presented for.
        ///
        /// Parameter `suggestedActions`: The actions and commands that the system suggests.
        ///
        ///
        /// Returns: Return a UIMenu describing the desired menu hierarchy. Return
        /// `nil`to present the default system menu.
        #[optional]
        #[unsafe(method(textView:editMenuForTextInRanges:suggestedActions:))]
        #[unsafe(method_family = none)]
        fn textView_editMenuForTextInRanges_suggestedActions(
            &self,
            text_view: &UITextView,
            ranges: &NSArray<NSValue>,
            suggested_actions: &NSArray<UIMenuElement>,
        ) -> Option<Retained<UIMenu>>;

        #[cfg(all(
            feature = "UIEditMenuInteraction",
            feature = "UIResponder",
            feature = "UIView"
        ))]
        /// Called when the text view is about to present the edit menu.
        ///
        ///
        /// Parameter `textView`: The text view displaying the menu.
        ///
        /// Parameter `animator`: Appearance animator. Add animations to this object to run them alongside the appearance transition.
        #[optional]
        #[unsafe(method(textView:willPresentEditMenuWithAnimator:))]
        #[unsafe(method_family = none)]
        fn textView_willPresentEditMenuWithAnimator(
            &self,
            text_view: &UITextView,
            animator: &ProtocolObject<dyn UIEditMenuInteractionAnimating>,
        );

        #[cfg(all(
            feature = "UIEditMenuInteraction",
            feature = "UIResponder",
            feature = "UIView"
        ))]
        /// Called when the text view is about to dismiss the edit menu.
        ///
        ///
        /// Parameter `textView`: The text view displaying the menu.
        ///
        /// Parameter `animator`: Dismissal animator. Add animations to this object to run them alongside the dismissal transition.
        #[optional]
        #[unsafe(method(textView:willDismissEditMenuWithAnimator:))]
        #[unsafe(method_family = none)]
        fn textView_willDismissEditMenuWithAnimator(
            &self,
            text_view: &UITextView,
            animator: &ProtocolObject<dyn UIEditMenuInteractionAnimating>,
        );

        #[cfg(all(
            feature = "UIAction",
            feature = "UIMenuElement",
            feature = "UIResponder",
            feature = "UITextItem",
            feature = "UIView"
        ))]
        /// Asks the delegate for the action to be performed when interacting with a text item. If a nil action is provided, the text view
        /// will request a menu to be presented on primary action if possible.
        ///
        ///
        /// Parameter `textView`: The text view requesting the primary action.
        ///
        /// Parameter `textItem`: The text item for performing said action.
        ///
        /// Parameter `defaultAction`: The default action for the text item. Return this to perform the default action.
        ///
        ///
        /// Returns: Return a UIAction to be performed when the text item is interacted with. Return
        /// `nil`to prevent the action from being performed.
        #[optional]
        #[unsafe(method(textView:primaryActionForTextItem:defaultAction:))]
        #[unsafe(method_family = none)]
        fn textView_primaryActionForTextItem_defaultAction(
            &self,
            text_view: &UITextView,
            text_item: &UITextItem,
            default_action: &UIAction,
        ) -> Option<Retained<UIAction>>;

        #[cfg(all(
            feature = "UIMenu",
            feature = "UIMenuElement",
            feature = "UIResponder",
            feature = "UITextItem",
            feature = "UIView"
        ))]
        /// Asks the delegate for the menu configuration to be performed when interacting with a text item.
        ///
        ///
        /// Parameter `textView`: The text view requesting the menu.
        ///
        /// Parameter `textItem`: The text item for performing said action.
        ///
        /// Parameter `defaultMenu`: The default menu for the specified text item.
        ///
        ///
        /// Returns: Return a menu configuration to be presented when the text item is interacted with. Return
        /// `nil`to prevent the menu from being presented.
        #[optional]
        #[unsafe(method(textView:menuConfigurationForTextItem:defaultMenu:))]
        #[unsafe(method_family = none)]
        fn textView_menuConfigurationForTextItem_defaultMenu(
            &self,
            text_view: &UITextView,
            text_item: &UITextItem,
            default_menu: &UIMenu,
        ) -> Option<Retained<UITextItemMenuConfiguration>>;

        #[cfg(all(
            feature = "UIContextMenuInteraction",
            feature = "UIResponder",
            feature = "UITextItem",
            feature = "UIView"
        ))]
        /// Informs the delegate that a text item menu is about to be presented with the specified animator.
        ///
        ///
        /// Parameter `textView`: The text view showing the menu.
        ///
        /// Parameter `textItem`: The text item for performing said action.
        ///
        /// Parameter `animator`: Appearance animator. Add animations to this object to run them alongside the appearance transition.
        #[optional]
        #[unsafe(method(textView:textItemMenuWillDisplayForTextItem:animator:))]
        #[unsafe(method_family = none)]
        fn textView_textItemMenuWillDisplayForTextItem_animator(
            &self,
            text_view: &UITextView,
            text_item: &UITextItem,
            animator: &ProtocolObject<dyn UIContextMenuInteractionAnimating>,
        );

        #[cfg(all(
            feature = "UIContextMenuInteraction",
            feature = "UIResponder",
            feature = "UITextItem",
            feature = "UIView"
        ))]
        /// Informs the delegate that a text item menu is about to be dismissed with the specified animator.
        ///
        ///
        /// Parameter `textView`: The text view showing the menu.
        ///
        /// Parameter `textItem`: The text item for performing said action.
        ///
        /// Parameter `animator`: Dismissal animator. Add animations to this object to run them alongside the dismissal transition.
        #[optional]
        #[unsafe(method(textView:textItemMenuWillEndForTextItem:animator:))]
        #[unsafe(method_family = none)]
        fn textView_textItemMenuWillEndForTextItem_animator(
            &self,
            text_view: &UITextView,
            text_item: &UITextItem,
            animator: &ProtocolObject<dyn UIContextMenuInteractionAnimating>,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Informs the delegate that Writing Tools will begin manipulating the text view
        ///
        ///
        /// Parameter `textView`: The text view interacting with Writing Tools
        #[optional]
        #[unsafe(method(textViewWritingToolsWillBegin:))]
        #[unsafe(method_family = none)]
        fn textViewWritingToolsWillBegin(&self, text_view: &UITextView);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Informs the delegate that Writing Tools has finished manipulating the text view
        ///
        ///
        /// Parameter `textView`: The text view interacting with Writing Tools
        #[optional]
        #[unsafe(method(textViewWritingToolsDidEnd:))]
        #[unsafe(method_family = none)]
        fn textViewWritingToolsDidEnd(&self, text_view: &UITextView);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Allows the delegate to specify ranges of text to be ignored by Writing Tools
        ///
        ///
        /// Parameter `textView`: The text view interacting with Writing Tools
        ///
        /// Parameter `enclosingRange`:
        ///
        /// Returns: Return an array of ranges in the attributed substring of the textView storage with the enclosing range representing portions of text to be ignored by Writing Tools when evaluating the text for proofreading, summarization, rewrites, and so forth.
        #[optional]
        #[unsafe(method(textView:writingToolsIgnoredRangesInEnclosingRange:))]
        #[unsafe(method_family = none)]
        fn textView_writingToolsIgnoredRangesInEnclosingRange(
            &self,
            text_view: &UITextView,
            enclosing_range: NSRange,
        ) -> Retained<NSArray<NSValue>>;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UITextItemInteraction",
            feature = "UIView"
        ))]
        #[deprecated = "Replaced by primaryActionForTextItem: and menuConfigurationForTextItem: for additional customization options."]
        #[optional]
        #[unsafe(method(textView:shouldInteractWithURL:inRange:interaction:))]
        #[unsafe(method_family = none)]
        fn textView_shouldInteractWithURL_inRange_interaction(
            &self,
            text_view: &UITextView,
            url: &NSURL,
            character_range: NSRange,
            interaction: UITextItemInteraction,
        ) -> bool;

        #[cfg(all(
            feature = "NSTextAttachment",
            feature = "UIResponder",
            feature = "UITextItemInteraction",
            feature = "UIView"
        ))]
        #[deprecated = "Replaced by primaryActionForTextItem: and menuConfigurationForTextItem: for additional customization options."]
        #[optional]
        #[unsafe(method(textView:shouldInteractWithTextAttachment:inRange:interaction:))]
        #[unsafe(method_family = none)]
        fn textView_shouldInteractWithTextAttachment_inRange_interaction(
            &self,
            text_view: &UITextView,
            text_attachment: &NSTextAttachment,
            character_range: NSRange,
            interaction: UITextItemInteraction,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[deprecated]
        #[optional]
        #[unsafe(method(textView:shouldInteractWithURL:inRange:))]
        #[unsafe(method_family = none)]
        fn textView_shouldInteractWithURL_inRange(
            &self,
            text_view: &UITextView,
            url: &NSURL,
            character_range: NSRange,
        ) -> bool;

        #[cfg(all(
            feature = "NSTextAttachment",
            feature = "UIResponder",
            feature = "UIView"
        ))]
        #[deprecated]
        #[optional]
        #[unsafe(method(textView:shouldInteractWithTextAttachment:inRange:))]
        #[unsafe(method_family = none)]
        fn textView_shouldInteractWithTextAttachment_inRange(
            &self,
            text_view: &UITextView,
            text_attachment: &NSTextAttachment,
            character_range: NSRange,
        ) -> bool;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UITextFormattingViewController",
            feature = "UIView",
            feature = "UIViewController"
        ))]
        /// Informs the delegate that text formatting controller is about to be presented.
        ///
        ///
        /// Parameter `viewController`: The text formatting controller that is being presented.
        #[optional]
        #[unsafe(method(textView:willBeginFormattingWithViewController:))]
        #[unsafe(method_family = none)]
        fn textView_willBeginFormattingWithViewController(
            &self,
            text_view: &UITextView,
            view_controller: &UITextFormattingViewController,
        );

        #[cfg(all(
            feature = "UIResponder",
            feature = "UITextFormattingViewController",
            feature = "UIView",
            feature = "UIViewController"
        ))]
        /// Informs the delegate that text formatting controller has been presented.
        ///
        ///
        /// Parameter `viewController`: The text formatting controller that is being presented.
        #[optional]
        #[unsafe(method(textView:didBeginFormattingWithViewController:))]
        #[unsafe(method_family = none)]
        fn textView_didBeginFormattingWithViewController(
            &self,
            text_view: &UITextView,
            view_controller: &UITextFormattingViewController,
        );

        #[cfg(all(
            feature = "UIResponder",
            feature = "UITextFormattingViewController",
            feature = "UIView",
            feature = "UIViewController"
        ))]
        /// Informs the delegate that text formatting controller is about to be dismissed.
        ///
        ///
        /// Parameter `viewController`: The text formatting controller that is being presented.
        #[optional]
        #[unsafe(method(textView:willEndFormattingWithViewController:))]
        #[unsafe(method_family = none)]
        fn textView_willEndFormattingWithViewController(
            &self,
            text_view: &UITextView,
            view_controller: &UITextFormattingViewController,
        );

        #[cfg(all(
            feature = "UIResponder",
            feature = "UITextFormattingViewController",
            feature = "UIView",
            feature = "UIViewController"
        ))]
        /// Informs the delegate that text formatting controller has been dismissed.
        ///
        ///
        /// Parameter `viewController`: The text formatting controller that is being presented.
        #[optional]
        #[unsafe(method(textView:didEndFormattingWithViewController:))]
        #[unsafe(method_family = none)]
        fn textView_didEndFormattingWithViewController(
            &self,
            text_view: &UITextView,
            view_controller: &UITextFormattingViewController,
        );

        #[cfg(all(
            feature = "UIInputSuggestion",
            feature = "UIResponder",
            feature = "UIView"
        ))]
        /// Tells the delegate when the keyboard delivers an input suggestion.
        ///
        /// - Parameters:
        /// - textView: The text view that is currently the first responder.
        /// - inputSuggestion: The input suggestion that the user or system selected.
        #[optional]
        #[unsafe(method(textView:insertInputSuggestion:))]
        #[unsafe(method_family = none)]
        fn textView_insertInputSuggestion(
            &self,
            text_view: &UITextView,
            input_suggestion: &UIInputSuggestion,
        );
    }
);

/// The type of border around the text view.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextviewborderstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITextViewBorderStyle(pub NSInteger);
impl UITextViewBorderStyle {
    /// The text view does not display a border.
    #[doc(alias = "UITextViewBorderStyleNone")]
    pub const None: Self = Self(0);
    /// Displays a rounded-style border for the text view.
    #[doc(alias = "UITextViewBorderStyleRoundedRect")]
    pub const RoundedRect: Self = Self(1);
}

unsafe impl Encode for UITextViewBorderStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITextViewBorderStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextview?language=objc)
    #[unsafe(super(UIScrollView, UIView, UIResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
    pub struct UITextView;
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView",
    feature = "objc2-quartz-core"
))]
#[cfg(not(target_os = "watchos"))]
extern_conformance!(
    unsafe impl CALayerDelegate for UITextView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
extern_conformance!(
    unsafe impl NSCoding for UITextView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for UITextView {}
);

#[cfg(all(
    feature = "UIAppearance",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIAppearance for UITextView {}
);

#[cfg(all(
    feature = "UIAppearance",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIAppearanceContainer for UITextView {}
);

#[cfg(all(
    feature = "UIContentSizeCategoryAdjusting",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIContentSizeCategoryAdjusting for UITextView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
extern_conformance!(
    unsafe impl UICoordinateSpace for UITextView {}
);

#[cfg(all(
    feature = "UIDynamicBehavior",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIDynamicItem for UITextView {}
);

#[cfg(all(
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusEnvironment for UITextView {}
);

#[cfg(all(
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusItem for UITextView {}
);

#[cfg(all(
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusItemContainer for UITextView {}
);

#[cfg(all(
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusItemScrollableContainer for UITextView {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UITextInput",
    feature = "UITextInputTraits",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIKeyInput for UITextView {}
);

#[cfg(all(
    feature = "UILetterformAwareAdjusting",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UILetterformAwareAdjusting for UITextView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIResponderStandardEditActions for UITextView {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UITextInput",
    feature = "UITextInputTraits",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITextInput for UITextView {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UITextInputTraits",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITextInputTraits for UITextView {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UITraitCollection",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITraitEnvironment for UITextView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
impl UITextView {
    extern_methods!(
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(&self) -> Option<Retained<ProtocolObject<dyn UITextViewDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn UITextViewDelegate>>);

        #[unsafe(method(text))]
        #[unsafe(method_family = none)]
        pub fn text(&self) -> Retained<NSString>;

        /// Setter for [`text`][Self::text].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setText:))]
        #[unsafe(method_family = none)]
        pub fn setText(&self, text: Option<&NSString>);

        #[cfg(feature = "UIFont")]
        #[unsafe(method(font))]
        #[unsafe(method_family = none)]
        pub fn font(&self) -> Option<Retained<UIFont>>;

        #[cfg(feature = "UIFont")]
        /// Setter for [`font`][Self::font].
        #[unsafe(method(setFont:))]
        #[unsafe(method_family = none)]
        pub fn setFont(&self, font: Option<&UIFont>);

        #[cfg(feature = "UIColor")]
        #[unsafe(method(textColor))]
        #[unsafe(method_family = none)]
        pub fn textColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`textColor`][Self::textColor].
        #[unsafe(method(setTextColor:))]
        #[unsafe(method_family = none)]
        pub fn setTextColor(&self, text_color: Option<&UIColor>);

        #[cfg(feature = "NSText")]
        #[unsafe(method(textAlignment))]
        #[unsafe(method_family = none)]
        pub fn textAlignment(&self) -> NSTextAlignment;

        #[cfg(feature = "NSText")]
        /// Setter for [`textAlignment`][Self::textAlignment].
        #[unsafe(method(setTextAlignment:))]
        #[unsafe(method_family = none)]
        pub fn setTextAlignment(&self, text_alignment: NSTextAlignment);

        /// A union of all the `selectedRanges`.
        #[deprecated]
        #[unsafe(method(selectedRange))]
        #[unsafe(method_family = none)]
        pub fn selectedRange(&self) -> NSRange;

        /// Setter for [`selectedRange`][Self::selectedRange].
        #[deprecated]
        #[unsafe(method(setSelectedRange:))]
        #[unsafe(method_family = none)]
        pub fn setSelectedRange(&self, selected_range: NSRange);

        /// The `NSRange`s of the selection. In most cases, there will only be a single selected range. For cases where bidirectional text is selected, there may be multiple discontiguous ranges. These selected ranges will always be in the normal form, which means they are sorted in ascending order and there are no overlaps. The selected ranges will always be converted to its normal form when they are set. There will always be at least one selected range in this array. So if this array is set to an empty array then the selection will be cleared and a single selected range will be left behind where the length will be 0 and the location will be the location at the end of the selection.
        #[unsafe(method(selectedRanges))]
        #[unsafe(method_family = none)]
        pub fn selectedRanges(&self) -> Retained<NSArray<NSValue>>;

        /// Setter for [`selectedRanges`][Self::selectedRanges].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSelectedRanges:))]
        #[unsafe(method_family = none)]
        pub fn setSelectedRanges(&self, selected_ranges: &NSArray<NSValue>);

        #[unsafe(method(isEditable))]
        #[unsafe(method_family = none)]
        pub fn isEditable(&self) -> bool;

        /// Setter for [`isEditable`][Self::isEditable].
        #[unsafe(method(setEditable:))]
        #[unsafe(method_family = none)]
        pub fn setEditable(&self, editable: bool);

        #[unsafe(method(isSelectable))]
        #[unsafe(method_family = none)]
        pub fn isSelectable(&self) -> bool;

        /// Setter for [`isSelectable`][Self::isSelectable].
        #[unsafe(method(setSelectable:))]
        #[unsafe(method_family = none)]
        pub fn setSelectable(&self, selectable: bool);

        #[cfg(feature = "UIDataDetectors")]
        #[unsafe(method(dataDetectorTypes))]
        #[unsafe(method_family = none)]
        pub fn dataDetectorTypes(&self) -> UIDataDetectorTypes;

        #[cfg(feature = "UIDataDetectors")]
        /// Setter for [`dataDetectorTypes`][Self::dataDetectorTypes].
        #[unsafe(method(setDataDetectorTypes:))]
        #[unsafe(method_family = none)]
        pub fn setDataDetectorTypes(&self, data_detector_types: UIDataDetectorTypes);

        #[unsafe(method(allowsEditingTextAttributes))]
        #[unsafe(method_family = none)]
        pub fn allowsEditingTextAttributes(&self) -> bool;

        /// Setter for [`allowsEditingTextAttributes`][Self::allowsEditingTextAttributes].
        #[unsafe(method(setAllowsEditingTextAttributes:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsEditingTextAttributes(&self, allows_editing_text_attributes: bool);

        #[unsafe(method(attributedText))]
        #[unsafe(method_family = none)]
        pub fn attributedText(&self) -> Retained<NSAttributedString>;

        /// Setter for [`attributedText`][Self::attributedText].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAttributedText:))]
        #[unsafe(method_family = none)]
        pub fn setAttributedText(&self, attributed_text: Option<&NSAttributedString>);

        #[unsafe(method(typingAttributes))]
        #[unsafe(method_family = none)]
        pub fn typingAttributes(&self) -> Retained<NSDictionary<NSAttributedStringKey, AnyObject>>;

        /// Setter for [`typingAttributes`][Self::typingAttributes].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `typing_attributes` generic should be of the correct type.
        #[unsafe(method(setTypingAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTypingAttributes(
            &self,
            typing_attributes: &NSDictionary<NSAttributedStringKey, AnyObject>,
        );

        #[unsafe(method(scrollRangeToVisible:))]
        #[unsafe(method_family = none)]
        pub fn scrollRangeToVisible(&self, range: NSRange);

        #[unsafe(method(inputView))]
        #[unsafe(method_family = none)]
        pub fn inputView(&self) -> Option<Retained<UIView>>;

        /// Setter for [`inputView`][Self::inputView].
        #[unsafe(method(setInputView:))]
        #[unsafe(method_family = none)]
        pub fn setInputView(&self, input_view: Option<&UIView>);

        #[unsafe(method(inputAccessoryView))]
        #[unsafe(method_family = none)]
        pub fn inputAccessoryView(&self) -> Option<Retained<UIView>>;

        /// Setter for [`inputAccessoryView`][Self::inputAccessoryView].
        #[unsafe(method(setInputAccessoryView:))]
        #[unsafe(method_family = none)]
        pub fn setInputAccessoryView(&self, input_accessory_view: Option<&UIView>);

        #[unsafe(method(clearsOnInsertion))]
        #[unsafe(method_family = none)]
        pub fn clearsOnInsertion(&self) -> bool;

        /// Setter for [`clearsOnInsertion`][Self::clearsOnInsertion].
        #[unsafe(method(setClearsOnInsertion:))]
        #[unsafe(method_family = none)]
        pub fn setClearsOnInsertion(&self, clears_on_insertion: bool);

        #[cfg(all(feature = "NSTextContainer", feature = "objc2-core-foundation"))]
        #[unsafe(method(initWithFrame:textContainer:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame_textContainer(
            this: Allocated<Self>,
            frame: CGRect,
            text_container: Option<&NSTextContainer>,
        ) -> Retained<Self>;

        #[unsafe(method(textViewUsingTextLayoutManager:))]
        #[unsafe(method_family = none)]
        pub fn textViewUsingTextLayoutManager(
            using_text_layout_manager: bool,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSTextContainer")]
        #[unsafe(method(textContainer))]
        #[unsafe(method_family = none)]
        pub fn textContainer(&self) -> Retained<NSTextContainer>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(textContainerInset))]
        #[unsafe(method_family = none)]
        pub fn textContainerInset(&self) -> UIEdgeInsets;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`textContainerInset`][Self::textContainerInset].
        #[unsafe(method(setTextContainerInset:))]
        #[unsafe(method_family = none)]
        pub fn setTextContainerInset(&self, text_container_inset: UIEdgeInsets);

        #[cfg(feature = "NSTextLayoutManager")]
        #[unsafe(method(textLayoutManager))]
        #[unsafe(method_family = none)]
        pub fn textLayoutManager(&self) -> Option<Retained<NSTextLayoutManager>>;

        #[cfg(feature = "NSLayoutManager")]
        #[unsafe(method(layoutManager))]
        #[unsafe(method_family = none)]
        pub fn layoutManager(&self) -> Retained<NSLayoutManager>;

        #[cfg(feature = "NSTextStorage")]
        #[unsafe(method(textStorage))]
        #[unsafe(method_family = none)]
        pub fn textStorage(&self) -> Retained<NSTextStorage>;

        #[unsafe(method(linkTextAttributes))]
        #[unsafe(method_family = none)]
        pub fn linkTextAttributes(
            &self,
        ) -> Retained<NSDictionary<NSAttributedStringKey, AnyObject>>;

        /// Setter for [`linkTextAttributes`][Self::linkTextAttributes].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `link_text_attributes` generic should be of the correct type.
        #[unsafe(method(setLinkTextAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLinkTextAttributes(
            &self,
            link_text_attributes: Option<&NSDictionary<NSAttributedStringKey, AnyObject>>,
        );

        #[unsafe(method(usesStandardTextScaling))]
        #[unsafe(method_family = none)]
        pub fn usesStandardTextScaling(&self) -> bool;

        /// Setter for [`usesStandardTextScaling`][Self::usesStandardTextScaling].
        #[unsafe(method(setUsesStandardTextScaling:))]
        #[unsafe(method_family = none)]
        pub fn setUsesStandardTextScaling(&self, uses_standard_text_scaling: bool);

        #[cfg(feature = "UIFindInteraction")]
        /// If `findInteractionEnabled` is set to true, returns this text view's built-in find interaction. Otherwise, nil.
        #[unsafe(method(findInteraction))]
        #[unsafe(method_family = none)]
        pub fn findInteraction(&self) -> Option<Retained<UIFindInteraction>>;

        /// Enables this text view's built-in find interaction.
        #[unsafe(method(isFindInteractionEnabled))]
        #[unsafe(method_family = none)]
        pub fn isFindInteractionEnabled(&self) -> bool;

        /// Setter for [`isFindInteractionEnabled`][Self::isFindInteractionEnabled].
        #[unsafe(method(setFindInteractionEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setFindInteractionEnabled(&self, find_interaction_enabled: bool);

        /// The border style for the text field.
        #[unsafe(method(borderStyle))]
        #[unsafe(method_family = none)]
        pub fn borderStyle(&self) -> UITextViewBorderStyle;

        /// Setter for [`borderStyle`][Self::borderStyle].
        #[unsafe(method(setBorderStyle:))]
        #[unsafe(method_family = none)]
        pub fn setBorderStyle(&self, border_style: UITextViewBorderStyle);

        #[unsafe(method(textHighlightAttributes))]
        #[unsafe(method_family = none)]
        pub fn textHighlightAttributes(
            &self,
        ) -> Retained<NSDictionary<NSAttributedStringKey, AnyObject>>;

        /// Setter for [`textHighlightAttributes`][Self::textHighlightAttributes].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `text_highlight_attributes` generic should be of the correct type.
        #[unsafe(method(setTextHighlightAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTextHighlightAttributes(
            &self,
            text_highlight_attributes: Option<&NSDictionary<NSAttributedStringKey, AnyObject>>,
        );

        #[cfg(all(feature = "NSTextRange", feature = "objc2-core-foundation"))]
        #[unsafe(method(drawTextHighlightBackgroundForTextRange:origin:))]
        #[unsafe(method_family = none)]
        pub fn drawTextHighlightBackgroundForTextRange_origin(
            &self,
            text_range: &NSTextRange,
            origin: CGPoint,
        );

        /// Convenience for tracking whether Writing Tools is active
        ///
        ///
        /// Returns: Returns
        /// `YES`while Writing Tools is interacting with the receiver (after
        /// `-textViewWritingToolsWillBegin:`completes until
        /// `-textViewWritingToolsDidEnd:`completes)
        #[unsafe(method(isWritingToolsActive))]
        #[unsafe(method_family = none)]
        pub fn isWritingToolsActive(&self) -> bool;

        #[cfg(feature = "UITextInputTraits")]
        #[unsafe(method(writingToolsBehavior))]
        #[unsafe(method_family = none)]
        pub fn writingToolsBehavior(&self) -> UIWritingToolsBehavior;

        #[cfg(feature = "UITextInputTraits")]
        /// Setter for [`writingToolsBehavior`][Self::writingToolsBehavior].
        #[unsafe(method(setWritingToolsBehavior:))]
        #[unsafe(method_family = none)]
        pub fn setWritingToolsBehavior(&self, writing_tools_behavior: UIWritingToolsBehavior);

        #[cfg(feature = "UITextInputTraits")]
        #[unsafe(method(allowedWritingToolsResultOptions))]
        #[unsafe(method_family = none)]
        pub fn allowedWritingToolsResultOptions(&self) -> UIWritingToolsResultOptions;

        #[cfg(feature = "UITextInputTraits")]
        /// Setter for [`allowedWritingToolsResultOptions`][Self::allowedWritingToolsResultOptions].
        #[unsafe(method(setAllowedWritingToolsResultOptions:))]
        #[unsafe(method_family = none)]
        pub fn setAllowedWritingToolsResultOptions(
            &self,
            allowed_writing_tools_result_options: UIWritingToolsResultOptions,
        );

        #[unsafe(method(subclassForWritingToolsCoordinator))]
        #[unsafe(method_family = none)]
        pub fn subclassForWritingToolsCoordinator(&self) -> &'static AnyClass;

        #[cfg(feature = "UIWritingToolsCoordinator")]
        #[unsafe(method(writingToolsCoordinator))]
        #[unsafe(method_family = none)]
        pub fn writingToolsCoordinator(&self) -> Retained<UIWritingToolsCoordinator>;

        #[cfg(feature = "UITextFormattingViewControllerConfiguration")]
        /// For text views that have flag `allowsEditingTextAttributes` set,
        /// this configuration will be used for `UITextFormattingViewController`
        /// when its presentation is requested.
        ///
        /// It has a non-nil default value.
        #[unsafe(method(textFormattingConfiguration))]
        #[unsafe(method_family = none)]
        pub fn textFormattingConfiguration(
            &self,
        ) -> Option<Retained<UITextFormattingViewControllerConfiguration>>;

        #[cfg(feature = "UITextFormattingViewControllerConfiguration")]
        /// Setter for [`textFormattingConfiguration`][Self::textFormattingConfiguration].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTextFormattingConfiguration:))]
        #[unsafe(method_family = none)]
        pub fn setTextFormattingConfiguration(
            &self,
            text_formatting_configuration: Option<&UITextFormattingViewControllerConfiguration>,
        );
    );
}

/// Methods declared on superclass `UIView`.
#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
impl UITextView {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame: CGRect) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
impl UITextView {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
impl UITextView {
    extern_methods!();
}

#[cfg(all(
    feature = "UIFindInteraction",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFindInteractionDelegate for UITextView {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UITextDragging",
    feature = "UITextInput",
    feature = "UITextInputTraits",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITextDraggable for UITextView {}
);

#[cfg(all(
    feature = "UIPasteConfigurationSupporting",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UITextDropping",
    feature = "UITextInput",
    feature = "UITextInputTraits",
    feature = "UITextPasteConfigurationSupporting",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITextDroppable for UITextView {}
);

#[cfg(all(
    feature = "UIPasteConfigurationSupporting",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UITextPasteConfigurationSupporting",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITextPasteConfigurationSupporting for UITextView {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UITextSearching",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITextSearching for UITextView {}
);

/// UIInteractionStateRestorable.
#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
impl UITextView {
    extern_methods!(
        #[unsafe(method(interactionState))]
        #[unsafe(method_family = none)]
        pub fn interactionState(&self) -> Retained<AnyObject>;

        /// Setter for [`interactionState`][Self::interactionState].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `interaction_state` should be of the correct type.
        #[unsafe(method(setInteractionState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInteractionState(&self, interaction_state: &AnyObject);
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextviewtextdidbegineditingnotification?language=objc)
    pub static UITextViewTextDidBeginEditingNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextviewtextdidchangenotification?language=objc)
    pub static UITextViewTextDidChangeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextviewtextdidendeditingnotification?language=objc)
    pub static UITextViewTextDidEndEditingNotification: &'static NSNotificationName;
}
