/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.model.AppendedSpans;
import org.fxmisc.richtext.model.PrependedSpans;
import org.fxmisc.richtext.model.SingletonSpans;
import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.fxmisc.richtext.model.SubSpans;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.richtext.model.UpdatedSpans;

public interface StyleSpans<S>
extends Iterable<StyleSpan<S>>,
TwoDimensional {
    public static <S> StyleSpans<S> singleton(S style, int length) {
        return StyleSpans.singleton(new StyleSpan<S>(style, length));
    }

    public static <S> StyleSpans<S> singleton(StyleSpan<S> span) {
        return new SingletonSpans<S>(span);
    }

    public int length();

    public int getSpanCount();

    public StyleSpan<S> getStyleSpan(int var1);

    public IndexRange getStyleRange(int var1);

    public boolean equals(Object var1);

    @Override
    default public Iterator<StyleSpan<S>> iterator() {
        return new Iterator<StyleSpan<S>>(){
            private int nextToReturn = 0;
            private final int spanCount = StyleSpans.this.getSpanCount();

            @Override
            public boolean hasNext() {
                return this.nextToReturn < this.spanCount;
            }

            @Override
            public StyleSpan<S> next() {
                return StyleSpans.this.getStyleSpan(this.nextToReturn++);
            }
        };
    }

    default public StyleSpans<S> append(S style, int length) {
        return this.append(new StyleSpan<S>(style, length));
    }

    default public StyleSpans<S> append(StyleSpan<S> span) {
        if (span.getLength() == 0) {
            return this;
        }
        if (this.length() == 0) {
            return StyleSpans.singleton(span);
        }
        int lastIdx = this.getSpanCount() - 1;
        StyleSpan<S> myLastSpan = this.getStyleSpan(lastIdx);
        if (Objects.equals(myLastSpan.getStyle(), span.getStyle())) {
            StyleSpan<S> newLastSpan = new StyleSpan<S>(span.getStyle(), myLastSpan.getLength() + span.getLength());
            return new UpdatedSpans<S>(this, lastIdx, newLastSpan);
        }
        return new AppendedSpans<S>(this, span);
    }

    default public StyleSpans<S> prepend(S style, int length) {
        return this.prepend(new StyleSpan<S>(style, length));
    }

    default public StyleSpans<S> prepend(StyleSpan<S> span) {
        if (span.getLength() == 0) {
            return this;
        }
        if (this.length() == 0) {
            return StyleSpans.singleton(span);
        }
        StyleSpan<S> myFirstSpan = this.getStyleSpan(0);
        if (Objects.equals(span.getStyle(), myFirstSpan.getStyle())) {
            StyleSpan<S> newFirstSpan = new StyleSpan<S>(span.getStyle(), span.getLength() + myFirstSpan.getLength());
            return new UpdatedSpans<S>(this, 0, newFirstSpan);
        }
        return new PrependedSpans<S>(this, span);
    }

    default public StyleSpans<S> subView(int from, int to) {
        TwoDimensional.Position start = this.offsetToPosition(from, TwoDimensional.Bias.Forward);
        TwoDimensional.Position end = to > from ? start.offsetBy(to - from, TwoDimensional.Bias.Backward) : start;
        return this.subView(start, end);
    }

    default public StyleSpans<S> subView(TwoDimensional.Position from, TwoDimensional.Position to) {
        return new SubSpans(this, from, to);
    }

    default public StyleSpans<S> concat(StyleSpans<S> that) {
        StyleSpansBuilder<S> builder;
        if (that.length() == 0) {
            return this;
        }
        if (this.length() == 0) {
            return that;
        }
        int n1 = this.getSpanCount();
        int n2 = that.getSpanCount();
        StyleSpan<S> myLast = this.getStyleSpan(n1 - 1);
        StyleSpan<S> theirFirst = that.getStyleSpan(0);
        if (Objects.equals(myLast.getStyle(), theirFirst.getStyle())) {
            int i;
            builder = new StyleSpansBuilder(n1 + n2 - 1);
            for (i = 0; i < n1 - 1; ++i) {
                builder.add(this.getStyleSpan(i));
            }
            builder.add(myLast.getStyle(), myLast.getLength() + theirFirst.getLength());
            for (i = 1; i < n2; ++i) {
                builder.add(that.getStyleSpan(i));
            }
        } else {
            builder = new StyleSpansBuilder<S>(n1 + n2);
            builder.addAll(this, n1);
            builder.addAll(that, n2);
        }
        return builder.create();
    }

    default public StyleSpans<S> mapStyles(UnaryOperator<S> mapper) {
        StyleSpansBuilder builder = new StyleSpansBuilder(this.getSpanCount());
        for (StyleSpan<S> span : this) {
            builder.add(mapper.apply(span.getStyle()), span.getLength());
        }
        return builder.create();
    }

    default public StyleSpans<S> overlay(StyleSpans<S> that, BiFunction<? super S, ? super S, ? extends S> f) {
        return StyleSpansBuilder.overlay(this, that, f);
    }

    default public Stream<S> styleStream() {
        return this.stream().map(StyleSpan::getStyle);
    }

    default public Stream<StyleSpan<S>> stream() {
        Spliterator spliterator = new Spliterator<StyleSpan<S>>(){
            private final Iterator<StyleSpan<S>> iterator;
            {
                this.iterator = StyleSpans.this.iterator();
            }

            @Override
            public boolean tryAdvance(Consumer<? super StyleSpan<S>> action) {
                if (this.iterator.hasNext()) {
                    action.accept(this.iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<StyleSpan<S>> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return StyleSpans.this.getSpanCount();
            }

            @Override
            public int characteristics() {
                return 1088;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }
}

