/*
 * Decompiled with CFR 0.152.
 */
package com.tobiasdiez.easybind;

import com.tobiasdiez.easybind.EasyObservableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;

class FlattenedList<E>
extends ObservableListBase<E>
implements EasyObservableList<E> {
    private final ObservableList<ObservableList<? extends E>> sourceLists;

    FlattenedList(ObservableList<ObservableList<? extends E>> sourceLists) {
        if (sourceLists == null) {
            throw new NullPointerException("sourceLists = null");
        }
        this.sourceLists = sourceLists;
        HashSet<ObservableList<E>> sourcesSet = new HashSet<ObservableList<E>>(sourceLists);
        sourcesSet.forEach(source -> source.addListener(this::onSourceChanged));
        sourceLists.addListener(this::onSourcesListChanged);
    }

    private void onSourcesListChanged(ListChangeListener.Change<? extends ObservableList<? extends E>> change) {
        this.beginChange();
        while (change.next()) {
            int fromIdx = 0;
            for (int i = 0; i < change.getFrom(); ++i) {
                fromIdx += ((ObservableList)this.sourceLists.get(i)).size();
            }
            int toIdx = fromIdx;
            for (int i = change.getFrom(); i < change.getTo(); ++i) {
                toIdx += ((ObservableList)this.sourceLists.get(i)).size();
            }
            int rangeSize = toIdx - fromIdx;
            if (change.wasPermutated()) {
                int[] permutation = new int[rangeSize];
                int fIdx = fromIdx;
                for (int parentIdx = change.getFrom(); parentIdx < change.getTo(); ++parentIdx) {
                    int i = 0;
                    while (i < ((ObservableList)this.sourceLists.get(i)).size()) {
                        permutation[fIdx] = change.getPermutation(parentIdx) + i;
                        ++i;
                        ++fIdx;
                    }
                }
                this.nextPermutation(fromIdx, toIdx, permutation);
                continue;
            }
            if (change.wasUpdated()) {
                for (int i = fromIdx; i < toIdx; ++i) {
                    this.nextUpdate(i);
                }
                continue;
            }
            if (change.wasAdded()) {
                this.nextAdd(fromIdx, toIdx);
                continue;
            }
            ArrayList itemsToRemove = new ArrayList(rangeSize);
            change.getRemoved().forEach(itemsToRemove::addAll);
            this.nextRemove(fromIdx, itemsToRemove);
        }
        this.endChange();
    }

    private void onSourceChanged(ListChangeListener.Change<? extends E> change) {
        ObservableList source = change.getList();
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        int calcOffset = 0;
        for (ObservableList currList : this.sourceLists) {
            if (currList == source) {
                offsets.add(calcOffset);
            }
            calcOffset += currList.size();
        }
        this.beginChange();
        while (change.next()) {
            Iterator iterator;
            if (change.wasPermutated()) {
                int indexOffset;
                int rangeSize = change.getTo() - change.getFrom();
                int[] permutation = new int[rangeSize * offsets.size()];
                for (int offsetIdx = 0; offsetIdx < offsets.size(); ++offsetIdx) {
                    indexOffset = (Integer)offsets.get(offsetIdx);
                    for (int i = 0; i < rangeSize; ++i) {
                        permutation[i + offsetIdx * rangeSize] = change.getPermutation(i + change.getFrom()) + indexOffset;
                    }
                }
                Iterator offsetIdx = offsets.iterator();
                while (offsetIdx.hasNext()) {
                    indexOffset = (Integer)offsetIdx.next();
                    this.nextPermutation(change.getFrom() + indexOffset, change.getTo() + indexOffset, permutation);
                }
                continue;
            }
            if (change.wasUpdated()) {
                iterator = offsets.iterator();
                while (iterator.hasNext()) {
                    int indexOffset = (Integer)iterator.next();
                    for (int i = change.getFrom(); i < change.getTo(); ++i) {
                        this.nextUpdate(i + indexOffset);
                    }
                }
                continue;
            }
            if (change.wasAdded()) {
                iterator = offsets.iterator();
                while (iterator.hasNext()) {
                    int indexOffset = (Integer)iterator.next();
                    this.nextAdd(change.getFrom() + indexOffset, change.getTo() + indexOffset);
                }
                continue;
            }
            iterator = offsets.iterator();
            while (iterator.hasNext()) {
                int indexOffset = (Integer)iterator.next();
                this.nextRemove(change.getFrom() + indexOffset, change.getRemoved());
            }
        }
        this.endChange();
    }

    public E get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("List index must be >= 0. Was " + index);
        }
        for (ObservableList source : this.sourceLists) {
            if (index < source.size()) {
                return (E)source.get(index);
            }
            index -= source.size();
        }
        throw new IndexOutOfBoundsException("Index too large.");
    }

    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<ObservableList<? extends E>> sourceIterator;
            Iterator<? extends E> currentIterator;
            {
                this.sourceIterator = FlattenedList.this.sourceLists.iterator();
                this.currentIterator = null;
            }

            @Override
            public boolean hasNext() {
                while (this.currentIterator == null || !this.currentIterator.hasNext()) {
                    if (this.sourceIterator.hasNext()) {
                        this.currentIterator = this.sourceIterator.next().iterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public E next() {
                while (this.currentIterator == null || !this.currentIterator.hasNext()) {
                    if (this.sourceIterator.hasNext()) {
                        this.currentIterator = this.sourceIterator.next().iterator();
                        continue;
                    }
                    throw new NoSuchElementException();
                }
                return this.currentIterator.next();
            }
        };
    }

    public int size() {
        return this.sourceLists.stream().mapToInt(List::size).sum();
    }
}

