/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core.java;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.zip.GZIPInputStream;
import kong.unirest.core.Config;
import kong.unirest.core.Headers;
import kong.unirest.core.HttpRequestSummary;
import kong.unirest.core.RawResponseBase;
import kong.unirest.core.UnirestException;

class JavaResponse
extends RawResponseBase {
    private final HttpResponse<InputStream> response;

    public JavaResponse(HttpResponse<InputStream> response, Config config, HttpRequestSummary summary) {
        super(config, summary);
        this.response = response;
    }

    @Override
    public int getStatus() {
        return this.response.statusCode();
    }

    @Override
    public String getStatusText() {
        return "";
    }

    @Override
    public Headers getHeaders() {
        Headers h = new Headers();
        this.response.headers().map().entrySet().forEach(e -> ((List)e.getValue()).forEach(v -> h.add((String)e.getKey(), (String)v)));
        return h;
    }

    @Override
    public InputStream getContent() {
        try {
            InputStream body = this.response.body();
            if (JavaResponse.isGzipped(this.getEncoding()) && !(body instanceof GZIPInputStream)) {
                body = new GZIPInputStream(body);
            }
            return body;
        }
        catch (EOFException e) {
            return new ByteArrayInputStream(new byte[0]);
        }
        catch (Exception e) {
            throw new UnirestException(e);
        }
    }

    @Override
    public byte[] getContentAsBytes() {
        if (!this.hasContent()) {
            return new byte[0];
        }
        try {
            InputStream is = this.getContent();
            return JavaResponse.getBytes(is);
        }
        catch (IOException e2) {
            throw new UnirestException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(InputStream is) throws IOException {
        try {
            byte[] buf;
            int size = 1024;
            if (is instanceof ByteArrayInputStream) {
                size = is.available();
                buf = new byte[size];
                int len = is.read(buf, 0, size);
            } else {
                int len;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                buf = new byte[size];
                while ((len = is.read(buf, 0, size)) != -1) {
                    bos.write(buf, 0, len);
                }
                buf = bos.toByteArray();
            }
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            is.close();
        }
    }

    private static boolean isGzipped(String value) {
        return "gzip".equalsIgnoreCase(value.toLowerCase().trim());
    }

    @Override
    public String getContentAsString() {
        return this.getContentAsString(null);
    }

    @Override
    public String getContentAsString(String charset) {
        if (!this.hasContent()) {
            return "";
        }
        try {
            String charSet = this.getCharset(charset);
            return new String(this.getContentAsBytes(), charSet);
        }
        catch (IOException e) {
            throw new UnirestException(e);
        }
    }

    private String getCharset(String charset) {
        if (charset == null || charset.trim().isEmpty()) {
            return this.getCharSet();
        }
        return charset;
    }

    @Override
    public InputStreamReader getContentReader() {
        return new InputStreamReader(this.getContent());
    }

    @Override
    public boolean hasContent() {
        return this.response.body() != null;
    }

    @Override
    public String getContentType() {
        return this.response.headers().firstValue("Content-Type").orElse("");
    }

    @Override
    public String getEncoding() {
        if (this.hasContent()) {
            String s = this.response.headers().firstValue("Content-Encoding").orElse("");
            return s;
        }
        return "";
    }
}

