/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.Token;

final class LineNumberToken
implements Token {
    LineNumberToken() {
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singleton(LogEntryValue.LINE);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        int line = logEntry.getLineNumber();
        if (line >= 0) {
            builder.append(line);
        } else {
            builder.append("?");
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        int line = logEntry.getLineNumber();
        if (line >= 0) {
            statement.setInt(index, line);
        } else {
            statement.setNull(index, 4);
        }
    }
}

