/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.format.MarkdownTable;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.format.TableManipulator;
import com.vladsch.flexmark.util.format.TrackedOffset;
import com.vladsch.flexmark.util.format.TrackedOffsetList;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.LineAppendable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableNodeFormatter
implements NodeFormatter {
    private final TableFormatOptions options;
    private final boolean parserTrimCellWhiteSpace;
    private MarkdownTable myTable;

    public TableNodeFormatter(DataHolder options) {
        this.options = new TableFormatOptions(options);
        this.parserTrimCellWhiteSpace = (Boolean)TablesExtension.TRIM_CELL_WHITESPACE.get(options);
    }

    @Nullable
    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(TableBlock.class, this::render), new NodeFormattingHandler(TableHead.class, this::render), new NodeFormattingHandler(TableSeparator.class, this::render), new NodeFormattingHandler(TableBody.class, this::render), new NodeFormattingHandler(TableRow.class, this::render), new NodeFormattingHandler(TableCell.class, this::render), new NodeFormattingHandler(TableCaption.class, this::render), new NodeFormattingHandler(Text.class, this::render)));
    }

    private void render(TableBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable = new MarkdownTable((CharSequence)node.getChars(), this.options);
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: 
            case TRANSLATED_SPANS: 
            case TRANSLATED: {
                markdown.blankLine();
                context.renderChildren((Node)node);
                markdown.tailBlankLine();
                break;
            }
            default: {
                context.renderChildren((Node)node);
                TrackedOffsetList trackedOffsets = context.getTrackedOffsets();
                TrackedOffsetList tableTrackedOffsets = trackedOffsets.getTrackedOffsets(node.getStartOffset(), node.getEndOffset());
                if (!trackedOffsets.isEmpty()) {
                    for (TrackedOffset trackedOffset : tableTrackedOffsets) {
                        assert (trackedOffset.getOffset() >= node.getStartOffset() && trackedOffset.getOffset() <= node.getEndOffset());
                        this.myTable.addTrackedOffset(trackedOffset);
                    }
                }
                if (this.options.tableManipulator != TableManipulator.NULL) {
                    this.myTable.normalize();
                    this.options.tableManipulator.apply(this.myTable, (Node)node);
                }
                if (this.myTable.getMaxColumns() <= 0) break;
                markdown.blankLine();
                BasedSequence prefix = markdown.getPrefix();
                this.myTable.setFormatTableIndentPrefix((CharSequence)prefix);
                MarkdownWriter formattedTable = new MarkdownWriter(markdown.getOptions());
                this.myTable.appendTable((LineAppendable)formattedTable);
                List tableOffsets = this.myTable.getTrackedOffsets();
                int startOffset = markdown.offsetWithPending();
                if (!tableTrackedOffsets.isEmpty()) {
                    assert (tableTrackedOffsets.size() == tableOffsets.size());
                    for (TrackedOffset trackedOffset : tableTrackedOffsets) {
                        assert (trackedOffset.getOffset() >= node.getStartOffset() && trackedOffset.getOffset() <= node.getEndOffset());
                        if (!trackedOffset.isResolved()) continue;
                        trackedOffset.setIndex(trackedOffset.getIndex() + startOffset);
                    }
                }
                ((MarkdownWriter)((MarkdownWriter)((MarkdownWriter)markdown.pushPrefix()).setPrefix((CharSequence)"", false)).pushOptions()).removeOptions(LineAppendable.F_WHITESPACE_REMOVAL).append((LineAppendable)formattedTable).popOptions().popPrefix(false);
                markdown.tailBlankLine();
                if (this.myTable.getMaxColumns() <= 0 || tableTrackedOffsets.isEmpty() || !this.options.dumpIntellijOffsets) break;
                ((MarkdownWriter)markdown.append((CharSequence)"\nTracked Offsets")).line();
                String sep = "  ";
                int i = 0;
                for (TrackedOffset trackedOffset : tableOffsets) {
                    ((MarkdownWriter)markdown.append((CharSequence)sep)).append((CharSequence)String.format(Locale.US, "%d:[%d,%d] was:[%d,%d]", ++i, trackedOffset.getIndex(), trackedOffset.getIndex() + 1, trackedOffset.getOffset(), trackedOffset.getOffset() + 1));
                    sep = " ";
                }
                markdown.append((CharSequence)"\n");
            }
        }
        this.myTable = null;
    }

    private void render(TableHead node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setSeparator(false);
        this.myTable.setHeader(true);
        context.renderChildren((Node)node);
    }

    private void render(TableSeparator node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setSeparator(true);
        context.renderChildren((Node)node);
    }

    private void render(TableBody node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setSeparator(false);
        this.myTable.setHeader(false);
        context.renderChildren((Node)node);
    }

    private void render(TableRow node, NodeFormatterContext context, MarkdownWriter markdown) {
        context.renderChildren((Node)node);
        if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
            if (!this.myTable.isSeparator()) {
                this.myTable.nextRow();
            }
        } else {
            markdown.line();
        }
    }

    private void render(TableCaption node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
            this.myTable.setCaptionWithMarkers((Node)node, (CharSequence)node.getOpeningMarker(), (CharSequence)node.getText(), (CharSequence)node.getClosingMarker());
        } else {
            String dummyCaption = node.hasChildren() ? "dummy" : "";
            String formattedCaption = MarkdownTable.formattedCaption((BasedSequence)BasedSequence.of((CharSequence)dummyCaption).subSequence(0, dummyCaption.length()), (TableFormatOptions)this.options);
            if (formattedCaption != null) {
                ((MarkdownWriter)markdown.line()).append((CharSequence)node.getOpeningMarker());
                context.renderChildren((Node)node);
                ((MarkdownWriter)markdown.append((CharSequence)node.getClosingMarker())).line();
            }
        }
    }

    private void render(TableCell node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
            BasedSequence text = node.getText();
            if (this.options.trimCellWhitespace) {
                text = text.isBlank() && !text.isEmpty() ? text.subSequence(0, 1) : (BasedSequence)text.trim();
            }
            this.myTable.addCell(new com.vladsch.flexmark.util.format.TableCell((Node)node, (CharSequence)node.getOpeningMarker(), (CharSequence)text, (CharSequence)node.getClosingMarker(), 1, node.getSpan(), node.getAlignment() == null ? CellAlignment.NONE : node.getAlignment().cellAlignment()));
        } else {
            if (node.getPrevious() == null) {
                if (this.options.leadTrailPipes && node.getOpeningMarker().isEmpty()) {
                    markdown.append('|');
                } else {
                    markdown.append((CharSequence)node.getOpeningMarker());
                }
            } else {
                markdown.append((CharSequence)node.getOpeningMarker());
            }
            if (!this.myTable.isSeparator() && this.options.spaceAroundPipes && (!node.getText().startsWith((CharSequence)" ") || this.parserTrimCellWhiteSpace)) {
                markdown.append(' ');
            }
            String[] childText = new String[]{""};
            context.translatingSpan((context1, writer) -> {
                context1.renderChildren((Node)node);
                childText[0] = writer.toString(-1, -1);
            });
            if (!this.myTable.isSeparator() && this.options.spaceAroundPipes && (!childText[0].endsWith(" ") || this.parserTrimCellWhiteSpace)) {
                markdown.append(' ');
            }
            if (node.getNext() == null) {
                if (this.options.leadTrailPipes && node.getClosingMarker().isEmpty()) {
                    markdown.append('|');
                } else {
                    markdown.append((CharSequence)node.getClosingMarker());
                }
            } else {
                markdown.append((CharSequence)node.getClosingMarker());
            }
        }
    }

    private void render(Text node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (this.myTable != null && this.myTable.isSeparator()) {
            Node parent = node.getAncestorOfType(new Class[]{Paragraph.class});
            if (parent instanceof Paragraph && ((Paragraph)parent).hasTableSeparator()) {
                ((MarkdownWriter)((MarkdownWriter)((MarkdownWriter)markdown.pushPrefix()).addPrefix((CharSequence)" ")).append((CharSequence)node.getChars())).popPrefix();
            } else {
                markdown.append((CharSequence)node.getChars());
            }
        } else {
            markdown.append((CharSequence)node.getChars());
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        @NotNull
        public NodeFormatter create(@NotNull DataHolder options) {
            return new TableNodeFormatter(options);
        }
    }
}

