/*
 * Decompiled with CFR 0.152.
 */
package com.adarshr.gradle.testlogger.theme;

import com.adarshr.gradle.testlogger.TestDescriptorWrapper;
import com.adarshr.gradle.testlogger.TestLoggerExtension;
import com.adarshr.gradle.testlogger.TestResultWrapper;
import com.adarshr.gradle.testlogger.theme.AbstractTheme;
import com.adarshr.gradle.testlogger.theme.ThemeType;
import com.adarshr.gradle.testlogger.util.RendererUtils;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.tasks.testing.TestResult;

public class PlainTheme
extends AbstractTheme {
    private ThemeType type;
    protected static final Map RESULT_TYPE_MAPPING;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    @Generated
    protected PlainTheme(TestLoggerExtension extension) {
        super(extension);
        ThemeType themeType;
        this.type = themeType = ThemeType.PLAIN;
    }

    @Override
    protected String suiteTextInternal(TestDescriptorWrapper descriptor) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{StringGroovyMethods.multiply((CharSequence)"  ", (Number)descriptor.getDepth()), descriptor.getDisplayName(), System.lineSeparator()}, new String[]{"", "", "", ""}));
    }

    @Override
    protected String testTextInternal(TestDescriptorWrapper descriptor, TestResultWrapper result) {
        return this.testTextInternal(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{StringGroovyMethods.multiply((CharSequence)"  ", (Number)descriptor.getDepth()), descriptor.getDisplayName(), DefaultGroovyMethods.getAt((Map)RESULT_TYPE_MAPPING, (Object)result.getResultType())}, new String[]{"", "Test ", " ", ""})), descriptor, result);
    }

    protected String testTextInternal(String start, TestDescriptorWrapper descriptor, TestResultWrapper result) {
        StringBuilder line = new StringBuilder(start);
        if (result.isTooSlow()) {
            StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{result.getDuration()}, new String[]{" (", ")"}));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)result.getResultType(), (Object)TestResult.ResultType.FAILURE)) {
            StringGroovyMethods.leftShift((StringBuilder)line, (Object)this.exceptionText(descriptor, result));
        }
        return ShortTypeHandling.castToString((Object)line);
    }

    @Override
    protected String exceptionText(TestDescriptorWrapper descriptor, TestResultWrapper result, int indent) {
        return super.exceptionText(descriptor, result, this.getType().isParallel() ? indent : indent * descriptor.getDepth());
    }

    @Override
    public String summaryText(TestDescriptorWrapper descriptor, TestResultWrapper result) {
        Boolean bl = this.extension.getShowSummary();
        if (!(bl == null ? false : bl)) {
            return "";
        }
        StringBuilder line = new StringBuilder();
        StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{result.getResultType()}, new String[]{"", ": "}));
        StringGroovyMethods.leftShift((StringBuilder)line, (Object)new GStringImpl(new Object[]{result.getTestCount(), result.getDuration()}, new String[]{"Executed ", " tests in ", ""}));
        List breakdown = PlainTheme.getBreakdown(result);
        if (DefaultTypeTransformation.booleanUnbox((Object)breakdown)) {
            StringGroovyMethods.leftShift((StringBuilder)StringGroovyMethods.leftShift((StringBuilder)StringGroovyMethods.leftShift((StringBuilder)line, (Object)" ("), (Object)DefaultGroovyMethods.join((Iterable)breakdown, (String)", ")), (Object)")");
        }
        return ShortTypeHandling.castToString((Object)StringGroovyMethods.leftShift((StringBuilder)line, (Object)System.lineSeparator()));
    }

    private static List getBreakdown(TestResultWrapper result) {
        List breakdown = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (result.getFailedTestCount() != 0L) {
            DefaultGroovyMethods.leftShift((List)breakdown, (Object)new GStringImpl(new Object[]{result.getFailedTestCount()}, new String[]{"", " failed"}));
        }
        if (result.getSkippedTestCount() != 0L) {
            DefaultGroovyMethods.leftShift((List)breakdown, (Object)new GStringImpl(new Object[]{result.getSkippedTestCount()}, new String[]{"", " skipped"}));
        }
        return breakdown;
    }

    @Override
    protected String suiteStandardStreamTextInternal(TestDescriptorWrapper descriptor, String lines) {
        return this.standardStreamTextInternal(lines, descriptor.getDepth() * 2 + 2);
    }

    @Override
    protected String testStandardStreamTextInternal(TestDescriptorWrapper descriptor, String lines) {
        return this.standardStreamTextInternal(lines, descriptor.getDepth() * 2 + 2);
    }

    protected String standardStreamTextInternal(String lines, int indent) {
        Boolean bl = this.extension.getShowStandardStreams();
        if (!(bl == null ? false : bl) || !DefaultTypeTransformation.booleanUnbox((Object)lines)) {
            return "";
        }
        lines = RendererUtils.escape(lines);
        Reference indentation = new Reference((Object)StringGroovyMethods.multiply((CharSequence)" ", (Number)indent));
        StringBuilder line = new StringBuilder(System.lineSeparator());
        public final class _standardStreamTextInternal_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference indentation;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _standardStreamTextInternal_closure1(Object _outerInstance, Object _thisObject, Reference indentation) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.indentation = reference = indentation;
            }

            public GString doCall(Object it) {
                return new GStringImpl(new Object[]{this.indentation.get(), it}, new String[]{"", "", ""});
            }

            @Generated
            public Object getIndentation() {
                return this.indentation.get();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public GString doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _standardStreamTextInternal_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        StringGroovyMethods.leftShift((StringBuilder)line, (Object)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)lines.split(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{System.lineSeparator()}, new String[]{"", ""}))), Object[].class)), (Closure)new _standardStreamTextInternal_closure1(this, this, indentation)), (String)System.lineSeparator()));
        return ShortTypeHandling.castToString((Object)StringGroovyMethods.leftShift((StringBuilder)line, (Object)System.lineSeparator()));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PlainTheme.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Map map;
        RESULT_TYPE_MAPPING = map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{TestResult.ResultType.SUCCESS, "PASSED", TestResult.ResultType.FAILURE, "FAILED", TestResult.ResultType.SKIPPED, "SKIPPED"});
    }

    @Override
    @Generated
    public ThemeType getType() {
        return this.type;
    }

    @Generated
    public void setType(ThemeType themeType) {
        this.type = themeType;
    }
}

