/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Constructed;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.asn1.ASN1TaggedObject;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.VectorOverArrayList;

public class ASN1Set
implements ASN1Constructed,
ASN1TaggedObject {
    public static final int BER = 0;
    public static final int DER_SET = 1;
    public static final int DER_SET_OF = 2;
    private ArrayList<ASN1Object> a = new ArrayList();
    private int b = 0;
    private ASN1Header c = null;
    private int d = 2;
    private ASN1Object[] e = null;

    public ASN1Set() {
    }

    public ASN1Set(ASN1Object aSN1Object) {
        this.addElement(aSN1Object);
    }

    public ASN1Set(Vector<? extends ASN1Object> vector) {
        this((List<? extends ASN1Object>)vector);
    }

    public ASN1Set(List<? extends ASN1Object> list) {
        this.a = list == null ? null : new ArrayList<ASN1Object>(list);
        this.b = 0;
        int n = this.a.size();
        for (int i = 0; i < n; ++i) {
            this.b += this.a.get(i).length();
        }
    }

    public ASN1Set(Enumeration<ASN1Object> enumeration) {
        while (enumeration.hasMoreElements()) {
            this.addElement(enumeration.nextElement());
        }
    }

    public ASN1Set(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    @Override
    public ASN1Header getHeader() {
        if (this.c == null) {
            this.c = new ASN1Header(17, 0, 1, this.b);
        }
        return this.c;
    }

    private ASN1Object[] a() {
        if (this.e == null) {
            this.e = ASN1Set.a(this.a, this.d);
        }
        return this.e;
    }

    @Override
    public Vector<ASN1Object> elements() {
        return this.a == null ? null : new VectorOverArrayList<ASN1Object>(this.a);
    }

    @Override
    public ArrayList<ASN1Object> elementsAsList() {
        return this.a;
    }

    @Override
    public int size() {
        return this.a.size();
    }

    @Override
    public ASN1Object elementAt(int n) {
        return this.a.get(n);
    }

    public ASN1Object firstElement() {
        return this.a.get(0);
    }

    public ASN1Object lastElement() {
        return this.a.get(this.a.size() - 1);
    }

    public void addElement(ASN1Object aSN1Object) {
        this.a.add(aSN1Object);
        this.b += aSN1Object.length();
        this.c = null;
        this.e = null;
    }

    public void setEncodingType(int n) {
        this.d = n;
        this.e = null;
    }

    public int getEncodingType() {
        return this.d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET {");
        int n = this.a.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.a.get(i).toString());
            if (i == this.a.size() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1SetInputStream aSN1SetInputStream = new ASN1SetInputStream(inputStream);
        this.a = new ArrayList();
        this.b = 0;
        while (aSN1SetInputStream.hasMoreData()) {
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(aSN1SetInputStream);
            this.a.add(aSN1Object);
            this.b += aSN1Object.length();
        }
        aSN1SetInputStream.terminate();
        this.c = null;
        this.e = null;
    }

    @Override
    public int length() {
        return this.getHeader().totalLength();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.getHeader().output(outputStream);
        if (this.d == 0) {
            int n = this.a.size();
            for (int i = 0; i < n; ++i) {
                this.a.get(i).output(outputStream);
            }
        } else {
            ASN1Object[] aSN1ObjectArray = this.a();
            int n = aSN1ObjectArray.length;
            for (int i = 0; i < n; ++i) {
                aSN1ObjectArray[i].output(outputStream);
            }
        }
    }

    static <S extends ASN1Object> ASN1Object[] a(ArrayList<S> arrayList, int n) {
        ASN1Object[] aSN1ObjectArray = new ASN1Object[arrayList.size()];
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            aSN1ObjectArray[i] = n == 2 ? new oracle.security.crypto.asn1.a((ASN1Object)arrayList.get(i)) : (ASN1Object)arrayList.get(i);
        }
        if (n != 0) {
            Arrays.sort(aSN1ObjectArray, new a(n));
        }
        return aSN1ObjectArray;
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    private static class a
    implements Comparator<ASN1Object> {
        int a;

        public a(int n) {
            this.a = n;
        }

        public int a(ASN1Object aSN1Object, ASN1Object aSN1Object2) {
            int n;
            if (this.a == 1) {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Object;
                ASN1TaggedObject aSN1TaggedObject2 = (ASN1TaggedObject)aSN1Object2;
                return aSN1TaggedObject.getHeader().getTag() - aSN1TaggedObject2.getHeader().getTag();
            }
            byte[] byArray = ((oracle.security.crypto.asn1.a)aSN1Object).a();
            byte[] byArray2 = ((oracle.security.crypto.asn1.a)aSN1Object2).a();
            int n2 = Math.min(byArray.length, byArray2.length);
            for (n = 0; n < n2 && byArray[n] == byArray2[n]; ++n) {
            }
            if (n == n2) {
                return byArray.length - byArray2.length;
            }
            return (byArray[n] & 0xFF) - (byArray2[n] & 0xFF);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((ASN1Object)object, (ASN1Object)object2);
        }
    }
}

