/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import java.util.List;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.definitions.CorePackageDefinitions;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

public final class ListEnvironmentHandler
implements EnvironmentHandler,
CommandHandler {
    @Override
    public void handleEnvironment(DOMBuilder builder, Element parentElement, EnvironmentToken token) throws SnuggleParseException {
        String listElementName = null;
        BuiltinEnvironment environment = token.getEnvironment();
        if (environment == CorePackageDefinitions.ENV_ITEMIZE) {
            listElementName = "ul";
        } else if (environment == CorePackageDefinitions.ENV_ENUMERATE) {
            listElementName = "ol";
        } else {
            throw new SnuggleLogicException("No logic to handle list environment " + environment.getTeXName());
        }
        Element listElement = builder.appendXHTMLElement(parentElement, listElementName);
        this.handleListContent(builder, parentElement, listElement, token.getContent().getContents());
    }

    private void handleListContent(DOMBuilder builder, Element parentElement, Element listElement, List<FlowToken> content) throws SnuggleParseException {
        for (FlowToken token : content) {
            if (token.isCommand(CorePackageDefinitions.CMD_LIST_ITEM)) {
                this.handleListItem(builder, listElement, (CommandToken)token);
                continue;
            }
            if (token.getType() == TokenType.ERROR) {
                builder.handleToken(parentElement, token);
                continue;
            }
            throw new SnuggleLogicException("List environments can only contain list items - this should have been handled earlier");
        }
    }

    private void handleListItem(DOMBuilder builder, Element listElement, CommandToken itemToken) throws SnuggleParseException {
        Element listItemElement = builder.appendXHTMLElement(listElement, "li");
        builder.handleTokens(listItemElement, itemToken.getArguments()[0], true);
    }

    @Override
    public void handleCommand(DOMBuilder builder, Element parentElement, CommandToken itemToken) throws SnuggleParseException {
        if (itemToken.isCommand(CorePackageDefinitions.CMD_LIST_ITEM)) {
            throw new SnuggleLogicException("List item outside environment - this should not have occurred");
        }
        if (itemToken.isCommand(CorePackageDefinitions.CMD_ITEM)) {
            builder.appendOrThrowError(parentElement, itemToken, CoreErrorCode.TDEL00, new Object[0]);
        }
    }
}

