/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.internal.SessionContext;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.internal.WorkingDocument;

public final class SnuggleInputReader
implements WorkingDocument.SourceContext {
    private final SessionContext sessionContext;
    private final SnuggleInput input;
    private int[] newlineIndices = null;
    private int inputLength;
    private WorkingDocument resultingDocument = null;

    public SnuggleInputReader(SessionContext sessionContext, SnuggleInput input) {
        this.sessionContext = sessionContext;
        this.input = input;
    }

    public SnuggleInput getInput() {
        return this.input;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public WorkingDocument createWorkingDocument() throws IOException, SnuggleParseException {
        StringBuilder inputData = this.readInputData();
        this.inputLength = inputData.length();
        this.newlineIndices = this.calculateNewlineIndicesAndCheckCodePoints(inputData);
        this.resultingDocument = new WorkingDocument(inputData, this);
        return this.resultingDocument;
    }

    public int[] getLineAndColumn(int index) {
        int line;
        if (this.newlineIndices == null) {
            throw new IllegalStateException("Input has not yet been read");
        }
        if (index < 0 || index > this.inputLength) {
            throw new IndexOutOfBoundsException();
        }
        for (line = 0; line < this.newlineIndices.length && this.newlineIndices[line] < index; ++line) {
        }
        int column = index - this.newlineIndices[line - 1];
        return new int[]{line, column};
    }

    private StringBuilder readInputData() throws IOException {
        switch (this.input.getType()) {
            case STRING: {
                return new StringBuilder(this.input.getString());
            }
            case FILE: {
                return this.readCharacterStream(this.createReader(new FileInputStream(this.input.getFile()), this.input.getEncoding()));
            }
            case INPUT_STREAM: {
                return this.readCharacterStream(this.createReader(this.input.getInputStream(), this.input.getEncoding()));
            }
            case READER: {
                return this.readCharacterStream(this.input.getReader());
            }
        }
        throw new SnuggleLogicException("Unexpected switch case: " + (Object)((Object)this.input.getType()));
    }

    private Reader createReader(InputStream inputStream, String encoding) throws UnsupportedEncodingException {
        return encoding != null ? new InputStreamReader(inputStream, encoding) : new InputStreamReader(inputStream);
    }

    private StringBuilder readCharacterStream(Reader reader) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder result = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            result.append(line).append("\n");
        }
        bufferedReader.close();
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private int[] calculateNewlineIndicesAndCheckCodePoints(StringBuilder inputData) throws SnuggleParseException {
        newlineIndicesBuilder = new ArrayList<Integer>();
        newlineIndicesBuilder.add(-1);
        lastChar = 0;
        length = inputData.length();
        for (i = 0; i < length; ++i) {
            block9: {
                block7: {
                    block8: {
                        thisChar = inputData.charAt(i);
                        if (thisChar == 10) {
                            newlineIndicesBuilder.add(i);
                        }
                        if (!Character.isHighSurrogate((char)lastChar)) break block7;
                        if (!Character.isLowSurrogate((char)thisChar)) break block8;
                        codePoint = Character.toCodePoint((char)lastChar, (char)thisChar);
                        ** GOTO lbl23
                    }
                    this.recordSurrogateError(inputData, i - 1, (char)lastChar);
                    break block9;
                }
                if (Character.isLowSurrogate((char)thisChar)) {
                    this.recordSurrogateError(inputData, i, (char)thisChar);
                } else {
                    codePoint = thisChar;
lbl23:
                    // 2 sources

                    if (Character.isISOControl(codePoint) && codePoint != 13 && codePoint != 10 && codePoint != 9) {
                        this.sessionContext.registerError(new InputError(CoreErrorCode.TTEG02, null, new Object[]{Integer.toHexString(codePoint), i}));
                        inputData.setCharAt(i, ' ');
                    }
                }
            }
            lastChar = thisChar;
        }
        if (Character.isHighSurrogate((char)lastChar)) {
            this.recordSurrogateError(inputData, inputData.length() - 1, (char)lastChar);
        }
        calculatedNewlineIndices = new int[newlineIndicesBuilder.size()];
        for (i = 0; i < calculatedNewlineIndices.length; ++i) {
            calculatedNewlineIndices[i] = (Integer)newlineIndicesBuilder.get(i);
        }
        return calculatedNewlineIndices;
    }

    private void recordSurrogateError(StringBuilder inputData, int index, char codePoint) throws SnuggleParseException {
        this.sessionContext.registerError(new InputError(CoreErrorCode.TTEG05, null, Integer.toHexString(codePoint), index));
        inputData.setCharAt(index, ' ');
    }
}

