/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.ComputedStyle;
import uk.ac.ed.ph.snuggletex.definitions.CorePackageDefinitions;
import uk.ac.ed.ph.snuggletex.internal.SessionContext;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.BraceContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.RootToken;

public final class StyleRebuilder {
    private final SessionContext sessionContext;

    public StyleRebuilder(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void rebuildStyles(RootToken rootToken) {
        this.visitSiblings(rootToken.getContents(), rootToken.getComputedStyle());
    }

    private void visitSiblings(List<FlowToken> content, ComputedStyle inScopeStyle) {
        ComputedStyle currentStyle = inScopeStyle;
        for (int i = 0; i < content.size(); ++i) {
            FlowToken token = content.get(i);
            if (token.hasInterpretationType(InterpretationType.STYLE_SENTINEL)) {
                this.visitToken(token, inScopeStyle);
                continue;
            }
            if (!token.getComputedStyle().isEquivalentTo(currentStyle)) {
                FlowToken followingToken;
                int endIndex;
                ArrayList<FlowToken> tokenGroup = new ArrayList<FlowToken>();
                tokenGroup.add(token);
                for (endIndex = i + 1; endIndex < content.size() && !(followingToken = content.get(endIndex)).hasInterpretationType(InterpretationType.STYLE_SENTINEL) && token.getComputedStyle().isEquivalentTo(followingToken.getComputedStyle()); ++endIndex) {
                    tokenGroup.add(followingToken);
                }
                EnvironmentToken replacement = this.createStyleEnvironmentToken(token, tokenGroup);
                content.set(i, replacement);
                content.subList(i + 1, endIndex).clear();
                token = replacement;
            }
            currentStyle = token.getComputedStyle();
            this.visitToken(token, currentStyle);
        }
        if (content instanceof ArrayList) {
            ((ArrayList)content).trimToSize();
        }
    }

    private void visitToken(FlowToken token, ComputedStyle currentStyle) {
        switch (token.getType()) {
            case COMMAND: {
                this.visitCommand((CommandToken)token, currentStyle);
                break;
            }
            case ENVIRONMENT: {
                this.visitEnvironment((EnvironmentToken)token, currentStyle);
                break;
            }
            case BRACE_CONTAINER: {
                this.visitSiblings(((BraceContainerToken)token).getContents(), currentStyle);
                break;
            }
            case TEXT_MODE_TEXT: 
            case VERBATIM_MODE_TEXT: 
            case LR_MODE_NEW_PARAGRAPH: 
            case MATH_NUMBER: 
            case MATH_CHARACTER: 
            case ERROR: 
            case TAB_CHARACTER: 
            case NEW_PARAGRAPH: {
                break;
            }
            default: {
                throw new SnuggleLogicException("Unhandled/unexpected TokenType " + (Object)((Object)token.getType()));
            }
        }
    }

    private EnvironmentToken createStyleEnvironmentToken(FlowToken source, List<FlowToken> tokenGroup) {
        ArgumentContainerToken contentToken = ArgumentContainerToken.createFromContiguousTokens(source, source.getLatexMode(), tokenGroup, source.getComputedStyle());
        return this.createStyleEnvironmentToken(source, contentToken);
    }

    private EnvironmentToken createStyleEnvironmentToken(FlowToken source, ArgumentContainerToken contentToken) {
        EnvironmentToken result = new EnvironmentToken(source.getSlice(), source.getLatexMode(), CorePackageDefinitions.ENV_STYLE, contentToken);
        result.setComputedStyle(contentToken.getComputedStyle());
        return result;
    }

    private void visitCommand(CommandToken commandToken, ComputedStyle currentStyle) {
        ArgumentContainerToken[] arguments;
        ArgumentContainerToken optArgument = commandToken.getOptionalArgument();
        if (optArgument != null) {
            this.visitArgumentContainer(commandToken, optArgument, currentStyle);
        }
        if ((arguments = commandToken.getArguments()) != null) {
            for (ArgumentContainerToken argument : arguments) {
                this.visitArgumentContainer(commandToken, argument, currentStyle);
            }
        }
    }

    private void visitEnvironment(EnvironmentToken environmentToken, ComputedStyle currentStyle) {
        ArgumentContainerToken[] arguments;
        ArgumentContainerToken optArgument = environmentToken.getOptionalArgument();
        if (optArgument != null) {
            this.visitArgumentContainer(environmentToken, optArgument, currentStyle);
        }
        if ((arguments = environmentToken.getArguments()) != null) {
            for (ArgumentContainerToken argument : arguments) {
                this.visitArgumentContainer(environmentToken, argument, currentStyle);
            }
        }
        this.visitArgumentContainer(environmentToken, environmentToken.getContent(), currentStyle);
    }

    private void visitArgumentContainer(FlowToken owner, ArgumentContainerToken token, ComputedStyle currentStyle) {
        List<FlowToken> contents = token.getContents();
        if (owner.hasInterpretationType(InterpretationType.STYLE_SENTINEL)) {
            this.visitSiblings(contents, currentStyle);
        } else {
            this.visitSiblings(contents, token.getComputedStyle());
        }
    }
}

