/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.reactfx.util.Timer;
import org.reactfx.util.TriFunction;

class ScheduledExecutorServiceTimer
implements Timer {
    private final long timeout;
    private final TimeUnit unit;
    private final Runnable action;
    private final TriFunction<Long, TimeUnit, Runnable, ScheduledFuture<?>> scheduler;
    private final Executor eventThreadExecutor;
    private ScheduledFuture<?> pendingTimer = null;
    private long seq = 0L;

    public static Timer create(Duration timeout, Runnable action, ScheduledExecutorService scheduler, Executor eventThreadExecutor) {
        return new ScheduledExecutorServiceTimer(timeout, action, (delay, unit, cmd) -> scheduler.schedule((Runnable)cmd, (long)delay, (TimeUnit)((Object)unit)), eventThreadExecutor);
    }

    public static Timer createPeriodic(Duration timeout, Runnable action, ScheduledExecutorService scheduler, Executor eventThreadExecutor) {
        return new ScheduledExecutorServiceTimer(timeout, action, (delay, unit, cmd) -> scheduler.scheduleAtFixedRate((Runnable)cmd, (long)delay, (long)delay, (TimeUnit)((Object)unit)), eventThreadExecutor);
    }

    private ScheduledExecutorServiceTimer(Duration timeout, Runnable action, TriFunction<Long, TimeUnit, Runnable, ScheduledFuture<?>> scheduler, Executor eventThreadExecutor) {
        this.timeout = timeout.toNanos();
        this.unit = TimeUnit.NANOSECONDS;
        this.action = action;
        this.scheduler = scheduler;
        this.eventThreadExecutor = eventThreadExecutor;
    }

    @Override
    public final void restart() {
        this.stop();
        long expected = this.seq;
        this.pendingTimer = this.scheduler.apply(this.timeout, this.unit, () -> this.eventThreadExecutor.execute(() -> {
            if (this.seq == expected) {
                this.action.run();
            }
        }));
    }

    @Override
    public final void stop() {
        if (this.pendingTimer != null) {
            this.pendingTimer.cancel(false);
        }
        ++this.seq;
    }
}

