/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.reactfx.util.AccuMap;
import org.reactfx.util.AccumulationFacility;
import org.reactfx.util.HashAccuMap;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;

class IteratorBasedAccuMap<K, V, A>
implements AccuMap<K, V, A> {
    private K currentKey = null;
    private A currentAccumulatedValue = null;
    private Iterator<K> it;
    private V value;

    IteratorBasedAccuMap(Iterator<K> keys, V value) {
        this.it = keys;
        this.value = value;
    }

    @Override
    public boolean isEmpty() {
        return this.currentKey == null && !this.it.hasNext();
    }

    @Override
    public Tuple2<K, A> peek(AccumulationFacility<V, A> af) {
        if (this.currentKey == null) {
            this.currentKey = this.it.next();
            this.currentAccumulatedValue = af.initialAccumulator(this.value);
        }
        return Tuples.t(this.currentKey, this.currentAccumulatedValue);
    }

    @Override
    public AccuMap<K, V, A> dropPeeked() {
        this.checkPeeked();
        this.currentKey = null;
        this.currentAccumulatedValue = null;
        return this;
    }

    @Override
    public AccuMap<K, V, A> updatePeeked(A newAccumulatedValue) {
        this.checkPeeked();
        this.currentAccumulatedValue = newAccumulatedValue;
        return this;
    }

    @Override
    public AccuMap<K, V, A> addAll(Iterator<K> keys, V value, AccumulationFacility<V, A> af) {
        if (this.isEmpty()) {
            this.it = keys;
            this.value = value;
            return this;
        }
        if (!keys.hasNext()) {
            return this;
        }
        HashAccuMap<K, Object, A> res = new HashAccuMap<K, Object, A>();
        if (this.currentKey != null) {
            res.put(this.currentKey, this.currentAccumulatedValue);
        }
        return res.addAll(this.it, this.value, af).addAll(keys, value, af);
    }

    private final void checkPeeked() {
        if (this.currentKey == null) {
            throw new NoSuchElementException("No peeked value present. Use peek() first.");
        }
    }
}

