/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.BenchmarkResultMetaData;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.runner.Action;
import org.openjdk.jmh.runner.ActionMode;
import org.openjdk.jmh.runner.ActionPlan;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.BenchmarkHandler;
import org.openjdk.jmh.runner.IterationResultAcceptor;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.util.Multimap;
import org.openjdk.jmh.util.TreeMultimap;
import org.openjdk.jmh.util.Utils;

abstract class BaseRunner {
    private long projectedTotalTime;
    private long projectedRunningTime;
    private long actualRunningTime;
    private long benchmarkStart;
    protected final Options options;
    protected final OutputFormat out;

    public BaseRunner(Options options, OutputFormat handler) {
        if (options == null) {
            throw new IllegalArgumentException("Options is null.");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Handler is null.");
        }
        this.options = options;
        this.out = handler;
    }

    protected void runBenchmarksForked(ActionPlan actionPlan, IterationResultAcceptor acceptor) {
        for (Action action : actionPlan.getActions()) {
            BenchmarkParams params = action.getParams();
            ActionMode mode = action.getMode();
            this.doSingle(params, mode, acceptor);
        }
    }

    protected Multimap<BenchmarkParams, BenchmarkResult> runBenchmarksEmbedded(ActionPlan actionPlan) {
        TreeMultimap<BenchmarkParams, BenchmarkResult> results = new TreeMultimap<BenchmarkParams, BenchmarkResult>();
        for (Action action : actionPlan.getActions()) {
            BenchmarkParams params = action.getParams();
            ActionMode mode = action.getMode();
            long startTime = System.currentTimeMillis();
            this.out.startBenchmark(params);
            this.out.println("");
            this.etaBeforeBenchmark();
            this.out.println("# Fork: N/A, test runs in the host VM");
            this.out.println("# *** WARNING: Non-forked runs may silently omit JVM options, mess up profilers, disable compiler hints, etc. ***");
            this.out.println("# *** WARNING: Use non-forked runs only for debugging purposes, not for actual performance runs. ***");
            final ArrayList<IterationResult> res = new ArrayList<IterationResult>();
            final ArrayList mds = new ArrayList();
            IterationResultAcceptor acceptor = new IterationResultAcceptor(){

                @Override
                public void accept(IterationResult iterationData) {
                    res.add(iterationData);
                }

                @Override
                public void acceptMeta(BenchmarkResultMetaData md) {
                    mds.add(md);
                }
            };
            this.doSingle(params, mode, acceptor);
            if (!res.isEmpty()) {
                BenchmarkResultMetaData md = (BenchmarkResultMetaData)mds.get(0);
                if (md != null) {
                    md.adjustStart(startTime);
                }
                BenchmarkResult br = new BenchmarkResult(params, res, md);
                results.put(params, br);
                this.out.endBenchmark(br);
            }
            this.etaAfterBenchmark(params);
        }
        return results;
    }

    private void doSingle(BenchmarkParams params, ActionMode mode, IterationResultAcceptor acceptor) {
        block7: {
            try {
                switch (mode) {
                    case WARMUP: {
                        this.runBenchmark(params, null);
                        this.out.println("");
                        break;
                    }
                    case WARMUP_MEASUREMENT: 
                    case MEASUREMENT: {
                        this.runBenchmark(params, acceptor);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown mode: " + (Object)((Object)mode));
                    }
                }
            }
            catch (BenchmarkException be) {
                this.out.println("<failure>");
                this.out.println("");
                for (Throwable cause : be.getSuppressed()) {
                    this.out.println(Utils.throwableToString(cause));
                }
                this.out.println("");
                if (!this.options.shouldFailOnError().orElse(false).booleanValue()) break block7;
                throw be;
            }
        }
    }

    protected void etaAfterBenchmark(BenchmarkParams params) {
        long current = System.nanoTime();
        this.projectedRunningTime += this.estimateTimeSingleFork(params);
        this.actualRunningTime += current - this.benchmarkStart;
        this.benchmarkStart = current;
    }

    protected void etaBeforeBenchmarks(Collection<ActionPlan> plans) {
        this.projectedTotalTime = 0L;
        for (ActionPlan plan : plans) {
            for (Action act : plan.getActions()) {
                BenchmarkParams params = act.getParams();
                this.projectedTotalTime += (long)(Math.max(1, params.getForks()) + params.getWarmupForks()) * this.estimateTimeSingleFork(params);
            }
        }
    }

    private long estimateTimeSingleFork(BenchmarkParams params) {
        IterationParams wp = params.getWarmup();
        IterationParams mp = params.getMeasurement();
        long estimatedTime = params.getMode() == Mode.SingleShotTime ? (long)(wp.getCount() + mp.getCount()) * TimeUnit.MILLISECONDS.toNanos(1L) : (long)wp.getCount() * wp.getTime().convertTo(TimeUnit.NANOSECONDS) + (long)mp.getCount() * mp.getTime().convertTo(TimeUnit.NANOSECONDS);
        return estimatedTime;
    }

    protected void etaBeforeBenchmark() {
        double partsDone;
        if (this.benchmarkStart == 0L) {
            this.benchmarkStart = System.nanoTime();
        }
        long totalETA = (partsDone = 1.0 * (double)this.projectedRunningTime / (double)this.projectedTotalTime) != 0.0 ? (long)((double)this.actualRunningTime * (1.0 / partsDone - 1.0)) : this.projectedTotalTime;
        this.out.println(String.format("# Run progress: %.2f%% complete, ETA %s", partsDone * 100.0, this.formatDuration(totalETA)));
    }

    protected void etaAfterBenchmarks() {
        this.out.println(String.format("# Run complete. Total time: %s", this.formatDuration(this.actualRunningTime)));
        this.out.println("");
    }

    private String formatDuration(long nanos) {
        long days = TimeUnit.NANOSECONDS.toDays(nanos);
        long hrs = TimeUnit.NANOSECONDS.toHours(nanos -= days * TimeUnit.DAYS.toNanos(1L));
        long mins = TimeUnit.NANOSECONDS.toMinutes(nanos -= hrs * TimeUnit.HOURS.toNanos(1L));
        long secs = TimeUnit.NANOSECONDS.toSeconds(nanos -= mins * TimeUnit.MINUTES.toNanos(1L));
        return String.format("%s%02d:%02d:%02d", days > 0L ? days + " days, " : "", hrs, mins, secs);
    }

    void runBenchmark(BenchmarkParams benchParams, IterationResultAcceptor acceptor) {
        BenchmarkHandler handler = null;
        try {
            handler = new BenchmarkHandler(this.out, this.options, benchParams);
            this.runBenchmark(benchParams, handler, acceptor);
        }
        catch (BenchmarkException be) {
            throw be;
        }
        catch (Throwable ex) {
            throw new BenchmarkException(ex);
        }
        finally {
            if (handler != null) {
                handler.shutdown();
            }
        }
    }

    protected void runBenchmark(BenchmarkParams benchParams, BenchmarkHandler handler, IterationResultAcceptor acceptor) {
        long warmupTime = System.currentTimeMillis();
        long allWarmup = 0L;
        long allMeasurement = 0L;
        IterationParams wp = benchParams.getWarmup();
        for (int i = 1; i <= wp.getCount(); ++i) {
            if (this.runSystemGC()) {
                this.out.verbosePrintln("System.gc() executed");
            }
            this.out.iteration(benchParams, wp, i);
            boolean isFirstIteration = i == 1;
            boolean isLastIteration = benchParams.getMeasurement().getCount() == 0;
            IterationResult ir = handler.runIteration(benchParams, wp, isFirstIteration, isLastIteration);
            this.out.iterationResult(benchParams, wp, i, ir);
            allWarmup += ir.getMetadata().getAllOps();
        }
        long measurementTime = System.currentTimeMillis();
        IterationParams mp = benchParams.getMeasurement();
        for (int i = 1; i <= mp.getCount(); ++i) {
            if (this.runSystemGC()) {
                this.out.verbosePrintln("System.gc() executed");
            }
            this.out.iteration(benchParams, mp, i);
            boolean isFirstIteration = benchParams.getWarmup().getCount() == 0 && i == 1;
            boolean isLastIteration = i == mp.getCount();
            IterationResult ir = handler.runIteration(benchParams, mp, isFirstIteration, isLastIteration);
            this.out.iterationResult(benchParams, mp, i, ir);
            allMeasurement += ir.getMetadata().getAllOps();
            if (acceptor == null) continue;
            acceptor.accept(ir);
        }
        long stopTime = System.currentTimeMillis();
        BenchmarkResultMetaData md = new BenchmarkResultMetaData(warmupTime, measurementTime, stopTime, allWarmup, allMeasurement);
        if (acceptor != null) {
            acceptor.acceptMeta(md);
        }
    }

    public boolean runSystemGC() {
        if (this.options.shouldDoGC().orElse(false).booleanValue()) {
            ArrayList<GarbageCollectorMXBean> enabledBeans = new ArrayList<GarbageCollectorMXBean>();
            long beforeGcCount = 0L;
            for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                long count = bean.getCollectionCount();
                if (count == -1L) continue;
                enabledBeans.add(bean);
            }
            for (GarbageCollectorMXBean bean : enabledBeans) {
                beforeGcCount += bean.getCollectionCount();
            }
            System.runFinalization();
            System.gc();
            System.runFinalization();
            System.gc();
            int MAX_WAIT_MSEC = 20000;
            if (enabledBeans.isEmpty()) {
                this.out.println("WARNING: MXBeans can not report GC info. System.gc() invoked, pessimistically waiting 20000 msecs");
                try {
                    TimeUnit.MILLISECONDS.sleep(20000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
            boolean gcHappened = false;
            long start = System.nanoTime();
            while (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) < 20000L) {
                try {
                    TimeUnit.MILLISECONDS.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                long afterGcCount = 0L;
                for (GarbageCollectorMXBean bean : enabledBeans) {
                    afterGcCount += bean.getCollectionCount();
                }
                if (!gcHappened) {
                    if (afterGcCount - beforeGcCount < 2L) continue;
                    gcHappened = true;
                    continue;
                }
                if (afterGcCount == beforeGcCount) {
                    return true;
                }
                beforeGcCount = afterGcCount;
            }
            if (gcHappened) {
                this.out.println("WARNING: System.gc() was invoked but unable to wait while GC stopped, is GC too asynchronous?");
            } else {
                this.out.println("WARNING: System.gc() was invoked but couldn't detect a GC occurring, is System.gc() disabled?");
            }
            return false;
        }
        return false;
    }
}

