/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.GlassPane;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.CacheHint;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class DrawerStackPane
extends StackPane {
    private static final Logger LOG = Logger.getLogger(DrawerStackPane.class.getName());
    private static final int MAXIMIZE = -1;
    private GlassPane glassPane;
    private VBox drawer;
    private double startY;
    private HBox headerBox;
    private Timeline timeline;
    private final BooleanProperty fadeInOut = new SimpleBooleanProperty((Object)this, "fadeInOut", true);
    private final BooleanProperty autoHide = new SimpleBooleanProperty((Object)this, "autoHide", true);
    private final StringProperty preferencesKey = new SimpleStringProperty((Object)this, "preferencesKey", "drawer.stackpane");
    private final DoubleProperty maxDrawerHeight = new SimpleDoubleProperty((Object)this, "maxDrawerHeight", 1.0);
    private final DoubleProperty minDrawerHeight = new SimpleDoubleProperty((Object)this, "minDrawerHeight", 0.1);
    private final ListProperty<Node> toolbarItems = new SimpleListProperty((Object)this, "toolbarItems", FXCollections.observableArrayList());
    private final ObjectProperty<Runnable> onDrawerClose = new SimpleObjectProperty((Object)this, "onDrawerClose");
    private final BooleanProperty showDrawerTitle = new SimpleBooleanProperty((Object)this, "showDrawerTitle", false);
    private final StringProperty drawerTitle = new SimpleStringProperty((Object)this, "drawerTitle", "Untitled");
    private final ObjectProperty<Node> drawerContent = new SimpleObjectProperty((Object)this, "drawerContent");
    private final ObjectProperty<Node> drawerTitleExtra = new SimpleObjectProperty((Object)this, "drawerTitleExtra");
    private final BooleanProperty showDrawer = new SimpleBooleanProperty((Object)this, "showDrawer", false);
    private final DoubleProperty preferredDrawerWidth = new SimpleDoubleProperty((Object)this, "preferredDrawerWidth", -1.0);
    private final DoubleProperty topPadding = new SimpleDoubleProperty((Object)this, "topPadding", 20.0);
    private final DoubleProperty sidePadding = new SimpleDoubleProperty((Object)this, "sidePadding", 100.0);
    private final BooleanProperty animateDrawer = new SimpleBooleanProperty((Object)this, "animateDrawer", true);
    private final DoubleProperty drawerHeight = new SimpleDoubleProperty((Object)this, "drawerHeight");
    private final ObjectProperty<Duration> animationDuration = new SimpleObjectProperty((Object)this, "animationDuration", (Object)Duration.millis((double)250.0));

    public DrawerStackPane(Node ... nodes) {
        super(nodes);
        this.init();
    }

    public DrawerStackPane() {
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)"drawer-stackpane");
        this.drawer = this.createContainer();
        this.drawer.getStyleClass().add((Object)"drawer");
        this.drawer.setVisible(false);
        this.drawer.setMinHeight(0.0);
        this.drawer.setPrefHeight(0.0);
        this.drawer.setManaged(false);
        this.glassPane = new GlassPane();
        this.glassPane.fadeInOutDurationProperty().bind(this.animationDurationProperty());
        this.glassPane.fadeInOutProperty().bind((ObservableValue)this.animateDrawerProperty());
        this.glassPane.setOnMouseClicked(evt -> {
            if (this.isAutoHide() && evt.getButton().equals((Object)MouseButton.PRIMARY) && !evt.isConsumed()) {
                this.setShowDrawer(false);
            }
        });
        this.glassPane.hideProperty().bind((ObservableValue)this.showDrawer.not());
        this.getChildren().addAll((Object[])new Node[]{this.glassPane, this.drawer});
        this.drawerContentProperty().addListener((observable, oldContent, newContent) -> {
            if (oldContent != null) {
                this.drawer.getChildren().remove(oldContent);
            }
            if (newContent != null) {
                this.drawer.getChildren().add(newContent);
                VBox.setVgrow((Node)newContent, (Priority)Priority.ALWAYS);
            }
        });
        this.headerBox.setOnMousePressed(evt -> {
            this.startY = evt.getScreenY();
        });
        this.headerBox.setOnMouseReleased(evt -> {
            if (this.startY != -1.0 && evt.getY() > this.drawer.getHeight()) {
                this.setShowDrawer(false);
                this.startY = 0.0;
            } else {
                this.saveDrawerHeightToUserPreferences();
            }
        });
        this.headerBox.setOnMouseDragged(evt -> {
            if (this.startY != -1.0) {
                double deltaY = this.startY - evt.getScreenY();
                double height = this.getDrawerHeight();
                if ((height += deltaY / this.getHeight()) > this.getMinDrawerHeight() && height <= this.getMaxDrawerHeight()) {
                    height = Math.max(this.getMinDrawerHeight(), Math.min(this.getMaxDrawerHeight(), height));
                    this.setDrawerHeight(height);
                    this.startY = evt.getScreenY();
                }
            }
        });
        this.headerBox.setOnMouseClicked(evt -> {
            if (evt.getButton().equals((Object)MouseButton.PRIMARY) && evt.getClickCount() == 2) {
                if (this.getDrawerHeight() < 1.0) {
                    this.setDrawerHeight(1.0);
                    this.saveDrawerHeightToUserPreferences();
                } else {
                    this.setShowDrawer(false);
                }
            }
        });
        this.setDrawerHeight(this.loadDrawerHeightFromUserPreferences());
        this.showDrawerProperty().addListener(it -> {
            this.stopCurrentlyRunningTimeline();
            if (this.isShowDrawer()) {
                this.showDrawer();
            } else {
                this.hideDrawer();
            }
        });
        InvalidationListener layoutListener = it -> this.requestLayout();
        this.drawerHeightProperty().addListener(layoutListener);
        this.preferredDrawerWidthProperty().addListener(layoutListener);
        this.topPaddingProperty().addListener(layoutListener);
        this.sidePaddingProperty().addListener(layoutListener);
        this.minDrawerHeight.addListener(it -> {
            if (this.getMinDrawerHeight() < 0.0) {
                throw new IllegalArgumentException("minimum drawer height can not be smaller than 0 but was " + this.getMinDrawerHeight());
            }
        });
        this.maxDrawerHeight.addListener(it -> {
            if (this.getMaxDrawerHeight() > 1.0) {
                throw new IllegalArgumentException("maximum drawer height can not be greater than 1 but was " + this.getMaxDrawerHeight());
            }
        });
        this.sidePadding.addListener(it -> {
            if (this.getSidePadding() < 0.0) {
                throw new IllegalArgumentException("side padding must be larger or equal to 0 but was " + this.getSidePadding());
            }
        });
        this.topPadding.addListener(it -> {
            if (this.getTopPadding() < 0.0) {
                throw new IllegalArgumentException("top padding must be larger or equal to 0 but was " + this.getTopPadding());
            }
        });
        this.addEventFilter(KeyEvent.KEY_PRESSED, evt -> {
            if (this.isShowDrawer() && evt.getCode().equals((Object)KeyCode.ESCAPE)) {
                this.setShowDrawer(false);
                evt.consume();
            }
        });
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(DrawerStackPane.class.getResource("drawer-stackpane.css")).toExternalForm();
    }

    public final BooleanProperty fadeInOutProperty() {
        return this.fadeInOut;
    }

    public final boolean isFadeInOut() {
        return this.fadeInOut.get();
    }

    public final void setFadeInOut(boolean fadeInOut) {
        this.fadeInOut.set(fadeInOut);
    }

    public boolean isAutoHide() {
        return this.autoHide.get();
    }

    public BooleanProperty autoHideProperty() {
        return this.autoHide;
    }

    public void setAutoHide(boolean autoHide) {
        this.autoHide.set(autoHide);
    }

    public final StringProperty preferencesKeyProperty() {
        return this.preferencesKey;
    }

    public final void setPreferencesKey(String key) {
        this.preferencesKey.set((Object)key);
    }

    public final String getPreferencesKey() {
        return (String)this.preferencesKey.get();
    }

    public double getMaxDrawerHeight() {
        return this.maxDrawerHeight.get();
    }

    public DoubleProperty maxDrawerHeightProperty() {
        return this.maxDrawerHeight;
    }

    public void setMaxDrawerHeight(double maxDrawerHeight) {
        this.maxDrawerHeight.set(maxDrawerHeight);
    }

    public double getMinDrawerHeight() {
        return this.minDrawerHeight.get();
    }

    public DoubleProperty minDrawerHeightProperty() {
        return this.minDrawerHeight;
    }

    public void setMinDrawerHeight(double minDrawerHeight) {
        this.minDrawerHeight.set(minDrawerHeight);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        double availableHeight = this.getHeight() - this.getTopPadding();
        double maxDrawerWidth = this.getWidth() - 2.0 * this.getSidePadding();
        double drawerWidth = this.getPreferredDrawerWidth() == -1.0 ? maxDrawerWidth : Math.min(this.getPreferredDrawerWidth(), maxDrawerWidth);
        double drawerHeight = this.getDrawerHeight();
        double x = (this.getWidth() - drawerWidth) / 2.0;
        double y = this.getHeight() - drawerHeight * availableHeight;
        this.drawer.resizeRelocate(x, y, drawerWidth, availableHeight * drawerHeight);
    }

    private VBox createContainer() {
        StackPane dragHandle = this.createDragHandle();
        Label titleLabel = this.createTitleLabel();
        ToolBar toolBar = this.createToolBar();
        titleLabel.setMouseTransparent(true);
        StackPane.setAlignment((Node)dragHandle, (Pos)Pos.CENTER);
        this.headerBox = new HBox(new Node[]{titleLabel, toolBar});
        this.headerBox.getStyleClass().add((Object)"header");
        this.headerBox.setAlignment(Pos.CENTER_LEFT);
        this.headerBox.setFillHeight(false);
        this.headerBox.setCursor(Cursor.N_RESIZE);
        this.headerBox.alignmentProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> this.isShowDrawerTitle() ? Pos.CENTER_LEFT : Pos.CENTER_RIGHT, (Observable[])new Observable[]{this.showDrawerTitleProperty()}));
        this.drawerTitleExtraProperty().addListener((obs, oldExtra, newExtra) -> this.addExtra(this.headerBox, (Node)oldExtra, (Node)newExtra));
        this.addExtra(this.headerBox, null, this.getDrawerTitleExtra());
        StackPane topContainer = new StackPane(new Node[]{this.headerBox, dragHandle});
        topContainer.getStyleClass().add((Object)"top");
        VBox box = new VBox(new Node[]{topContainer});
        box.setFillWidth(true);
        return box;
    }

    public final ObservableList<Node> getToolbarItems() {
        return (ObservableList)this.toolbarItems.get();
    }

    public final ListProperty<Node> toolbarItemsProperty() {
        return this.toolbarItems;
    }

    public final void setToolbarItems(ObservableList<Node> items) {
        this.toolbarItems.set(items);
    }

    private ToolBar createToolBar() {
        ToolBar toolBar = new ToolBar();
        Bindings.bindContent((List)toolBar.getItems(), this.toolbarItemsProperty());
        Button closeButton = new Button("Close");
        closeButton.setOnAction(evt -> this.setShowDrawer(false));
        closeButton.getStyleClass().add((Object)"close-button");
        this.getToolbarItems().add((Object)closeButton);
        return toolBar;
    }

    private Label createTitleLabel() {
        Label titleLabel = new Label();
        titleLabel.getStyleClass().add((Object)"title-label");
        titleLabel.textProperty().bind((ObservableValue)this.drawerTitleProperty());
        titleLabel.setMaxWidth(Double.MAX_VALUE);
        titleLabel.setAlignment(Pos.CENTER_LEFT);
        titleLabel.visibleProperty().bind((ObservableValue)this.showDrawerTitleProperty());
        titleLabel.managedProperty().bind((ObservableValue)this.showDrawerTitleProperty());
        HBox.setHgrow((Node)titleLabel, (Priority)Priority.ALWAYS);
        return titleLabel;
    }

    private StackPane createDragHandle() {
        Separator line1 = new Separator();
        Separator line2 = new Separator();
        Separator line3 = new Separator();
        VBox handle = new VBox(new Node[]{line1, line2, line3});
        handle.setAlignment(Pos.CENTER);
        handle.getStyleClass().add((Object)"handle");
        handle.setMouseTransparent(true);
        StackPane dragHandle = new StackPane();
        dragHandle.setMouseTransparent(true);
        dragHandle.setMaxWidth(Double.MAX_VALUE);
        dragHandle.getStyleClass().add((Object)"drag-handle");
        dragHandle.getChildren().add((Object)handle);
        return dragHandle;
    }

    private void addExtra(HBox headerBox, Node oldExtra, Node newExtra) {
        if (oldExtra != null) {
            headerBox.getChildren().remove((Object)oldExtra);
        }
        if (newExtra != null) {
            headerBox.getChildren().add((Object)newExtra);
        }
    }

    public final Runnable getOnDrawerClose() {
        return (Runnable)this.onDrawerClose.get();
    }

    public final ObjectProperty<Runnable> onDrawerCloseProperty() {
        return this.onDrawerClose;
    }

    public final void setOnDrawerClose(Runnable onDrawerClose) {
        this.onDrawerClose.set((Object)onDrawerClose);
    }

    public final boolean isShowDrawerTitle() {
        return this.showDrawerTitle.get();
    }

    public final BooleanProperty showDrawerTitleProperty() {
        return this.showDrawerTitle;
    }

    public final void setShowDrawerTitle(boolean showDrawerTitle) {
        this.showDrawerTitle.set(showDrawerTitle);
    }

    public final String getDrawerTitle() {
        return (String)this.drawerTitle.get();
    }

    public final StringProperty drawerTitleProperty() {
        return this.drawerTitle;
    }

    public void setDrawerTitle(String drawerTitle) {
        this.drawerTitle.set((Object)drawerTitle);
    }

    public final Node getDrawerContent() {
        return (Node)this.drawerContent.get();
    }

    public final ObjectProperty<Node> drawerContentProperty() {
        return this.drawerContent;
    }

    public final void setDrawerContent(Node drawerContent) {
        this.drawerContent.set((Object)drawerContent);
    }

    public final Node getDrawerTitleExtra() {
        return (Node)this.drawerTitleExtra.get();
    }

    public final ObjectProperty<Node> drawerTitleExtraProperty() {
        return this.drawerTitleExtra;
    }

    public final void setDrawerTitleExtra(Node drawerTitleExtra) {
        this.drawerTitleExtra.set((Object)drawerTitleExtra);
    }

    private String createPreferenceKey() {
        return this.getPreferencesKey() + ".drawer.height";
    }

    public boolean isShowDrawer() {
        return this.showDrawer.get();
    }

    public final BooleanProperty showDrawerProperty() {
        return this.showDrawer;
    }

    public final void setShowDrawer(boolean showDrawer) {
        this.showDrawer.set(showDrawer);
    }

    public final double getPreferredDrawerWidth() {
        return this.preferredDrawerWidth.get();
    }

    public final DoubleProperty preferredDrawerWidthProperty() {
        return this.preferredDrawerWidth;
    }

    public final void setPreferredDrawerWidth(double preferredDrawerWidth) {
        this.preferredDrawerWidth.set(preferredDrawerWidth);
    }

    public final double getTopPadding() {
        return this.topPadding.get();
    }

    public final DoubleProperty topPaddingProperty() {
        return this.topPadding;
    }

    public final void setTopPadding(double topPadding) {
        this.topPadding.set(topPadding);
    }

    public final double getSidePadding() {
        return this.sidePadding.get();
    }

    public final DoubleProperty sidePaddingProperty() {
        return this.sidePadding;
    }

    public final void setSidePadding(double sidePadding) {
        this.sidePadding.set(sidePadding);
    }

    public final boolean isAnimateDrawer() {
        return this.animateDrawer.get();
    }

    public final BooleanProperty animateDrawerProperty() {
        return this.animateDrawer;
    }

    public final void setAnimateDrawer(boolean animateDrawer) {
        this.animateDrawer.set(animateDrawer);
    }

    public final double getDrawerHeight() {
        return Math.min(1.0, Math.max(0.0, this.drawerHeight.get()));
    }

    public final DoubleProperty drawerHeightProperty() {
        return this.drawerHeight;
    }

    public final void setDrawerHeight(double drawerHeight) {
        this.drawerHeight.set(drawerHeight);
    }

    public final Duration getAnimationDuration() {
        return (Duration)this.animationDuration.get();
    }

    public final ObjectProperty<Duration> animationDurationProperty() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(Duration animationDuration) {
        this.animationDuration.set((Object)animationDuration);
    }

    private void showDrawer() {
        this.glassPane.toFront();
        this.drawer.setCache(true);
        this.drawer.setCacheHint(CacheHint.SPEED);
        this.drawer.toFront();
        this.drawer.setVisible(true);
        if (this.isAnimateDrawer() && this.getAnimationDuration() != null && this.getAnimationDuration().greaterThan(Duration.ZERO)) {
            this.setDrawerHeight(0.0);
            KeyValue keyValue = new KeyValue((WritableValue)this.drawerHeightProperty(), (Object)this.loadDrawerHeightFromUserPreferences(), Interpolator.EASE_BOTH);
            KeyFrame keyFrame = new KeyFrame(this.getAnimationDuration(), new KeyValue[]{keyValue});
            this.timeline = new Timeline(new KeyFrame[]{keyFrame});
            this.timeline.setOnFinished(evt -> this.drawer.setCache(false));
            this.timeline.play();
        } else {
            this.setDrawerHeight(this.loadDrawerHeightFromUserPreferences());
        }
    }

    private void stopCurrentlyRunningTimeline() {
        if (this.timeline != null && this.timeline.getStatus().equals((Object)Animation.Status.RUNNING)) {
            this.timeline.stop();
        }
    }

    private double loadDrawerHeightFromUserPreferences() {
        try {
            double height = Preferences.userNodeForPackage(DrawerStackPane.class).getDouble(this.createPreferenceKey(), 0.7);
            return Math.min(1.0, Math.max(0.1, height));
        }
        catch (SecurityException ex) {
            LOG.log(Level.SEVERE, "problem encountered when trying to load drawer height from user preferences", ex);
            return 0.9;
        }
    }

    private void saveDrawerHeightToUserPreferences() {
        if (this.getPreferencesKey() != null) {
            try {
                Preferences.userNodeForPackage(DrawerStackPane.class).putDouble(this.createPreferenceKey(), this.getDrawerHeight());
            }
            catch (SecurityException ex) {
                LOG.log(Level.SEVERE, "problem encountered when trying to save drawer height in user preferences", ex);
            }
        }
    }

    private void hideDrawer() {
        if (this.isAnimateDrawer()) {
            KeyValue keyValue = new KeyValue((WritableValue)this.drawerHeightProperty(), (Object)0, Interpolator.EASE_BOTH);
            KeyFrame keyFrame = new KeyFrame(this.getAnimationDuration(), new KeyValue[]{keyValue});
            this.timeline = new Timeline(new KeyFrame[]{keyFrame});
            this.timeline.setOnFinished(evt -> this.postHiding());
            this.timeline.play();
        } else {
            this.setDrawerHeight(0.0);
            this.postHiding();
        }
    }

    private void postHiding() {
        this.drawer.setVisible(false);
        Runnable onClose = this.getOnDrawerClose();
        if (onClose != null) {
            onClose.run();
        }
    }
}

