/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.skins.MaskedViewSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class MaskedView
extends Control {
    private static final int DEFAULT_FADING_SIZE = 120;
    private final SimpleObjectProperty<Node> content = new SimpleObjectProperty((Object)this, "content");
    private DoubleProperty fadingSize;

    public MaskedView() {
        this.getStyleClass().add((Object)"masked-view");
        this.setFocusTraversable(false);
    }

    public MaskedView(Node content) {
        this();
        this.setContent(content);
    }

    protected Skin<?> createDefaultSkin() {
        return new MaskedViewSkin(this);
    }

    public final Node getContent() {
        return (Node)this.content.get();
    }

    public final SimpleObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public final void setContent(Node content) {
        this.content.set((Object)content);
    }

    public final double getFadingSize() {
        return this.fadingSize == null ? 120.0 : this.fadingSize.get();
    }

    public final DoubleProperty fadingSizeProperty() {
        if (this.fadingSize == null) {
            this.fadingSize = new StyleableDoubleProperty(120.0){

                public Object getBean() {
                    return MaskedView.this;
                }

                public String getName() {
                    return "fadingSize";
                }

                public CssMetaData<? extends Styleable, Number> getCssMetaData() {
                    return StyleableProperties.FADING_SIZE;
                }
            };
        }
        return this.fadingSize;
    }

    public final void setFadingSize(double fadingSize) {
        this.fadingSizeProperty().set(fadingSize);
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MaskedView.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<MaskedView, Number> FADING_SIZE = new CssMetaData<MaskedView, Number>("-fx-fading-size", SizeConverter.getInstance(), (Number)120){

            public StyleableProperty<Number> getStyleableProperty(MaskedView control) {
                return (StyleableProperty)control.fadingSizeProperty();
            }

            public boolean isSettable(MaskedView control) {
                return control.fadingSize == null || !control.fadingSize.isBound();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<MaskedView, Number>> styleables = new ArrayList<CssMetaData<MaskedView, Number>>(Control.getClassCssMetaData());
            styleables.add(FADING_SIZE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

