/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.binding;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.beans.binding.ObjectBinding;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;

public class AggregatedListBinding<T, S, R>
extends ObjectBinding<R> {
    private final Function<T, ObservableList<S>> itemToListFunction;
    private final ObservableList<T> source;
    private final Function<Stream<S>, R> aggregationFunction;
    private final ListChangeListener<Object> nestedListChangeListener = change -> {
        while (change.next()) {
            if (!change.wasAdded() && !change.wasRemoved()) continue;
            this.invalidate();
            break;
        }
    };
    private final WeakListChangeListener<Object> weakNestedListChangeListener = new WeakListChangeListener(this.nestedListChangeListener);
    private final ListChangeListener<T> sourceListChangeListener = change -> {
        while (change.next()) {
            if (change.wasRemoved()) {
                change.getRemoved().forEach(this::convertToListAndSafeRemoveListener);
            }
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(this::convertToListAndSafeAddListener);
            }
            this.invalidate();
        }
    };
    private final WeakListChangeListener<T> weakSourceListChangeListener = new WeakListChangeListener(this.sourceListChangeListener);

    public AggregatedListBinding(ObservableList<T> source, Function<T, ObservableList<S>> itemToListFunction, Function<Stream<S>, R> aggregationFunction) {
        this.source = Objects.requireNonNull(source, "Source list cannot be null");
        this.itemToListFunction = Objects.requireNonNull(itemToListFunction, "Item-to-list function cannot be null");
        this.aggregationFunction = Objects.requireNonNull(aggregationFunction, "Aggregation function cannot be null");
        this.source.stream().map(itemToListFunction).forEach(this::safeAddListener);
        this.source.addListener(this.weakSourceListChangeListener);
    }

    private void convertToListAndSafeAddListener(T item) {
        ObservableList<S> list = this.itemToListFunction.apply(item);
        this.safeAddListener(list);
    }

    private void safeAddListener(ObservableList<S> list) {
        if (list != null) {
            list.addListener(this.weakNestedListChangeListener);
        }
    }

    private void convertToListAndSafeRemoveListener(T item) {
        ObservableList<S> list = this.itemToListFunction.apply(item);
        this.safeRemoveListener(list);
    }

    private void safeRemoveListener(ObservableList<S> list) {
        if (list != null) {
            list.removeListener(this.weakNestedListChangeListener);
        }
    }

    protected R computeValue() {
        return this.aggregationFunction.apply(this.source.stream().map(this.itemToListFunction).filter(Objects::nonNull).flatMap(Collection::stream));
    }

    public void dispose() {
        this.source.stream().map(this.itemToListFunction).forEach(this::safeRemoveListener);
        this.source.removeListener(this.weakSourceListChangeListener);
    }
}

