/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.infocenter;

import com.dlsc.gemsfx.infocenter.InfoCenterEvent;
import com.dlsc.gemsfx.infocenter.Notification;
import com.dlsc.gemsfx.infocenter.NotificationAction;
import com.dlsc.gemsfx.infocenter.NotificationGroup;
import com.dlsc.gemsfx.util.ResourceBundleManager;
import java.text.MessageFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Objects;
import java.util.Optional;
import javafx.animation.FadeTransition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.kordamp.ikonli.javafx.FontIcon;

public class NotificationView<T, S extends Notification<T>>
extends StackPane {
    private static final PseudoClass PSEUDO_CLASS_EXPANDED = PseudoClass.getPseudoClass((String)"expanded");
    private static final DateTimeFormatter SHORT_TIME_FORMATTER = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);
    private final S notification;
    private final ContentPane contentPane;
    private final StackPane stackNotification1;
    private final StackPane stackNotification2;
    private final ObjectProperty<Node> graphic = new SimpleObjectProperty((Object)this, "graphic");
    private final BooleanProperty stackingEnabled = new SimpleBooleanProperty((Object)this, "stackingEnabled", true);
    private final ObjectProperty<Node> content = new SimpleObjectProperty((Object)this, "content");
    private final BooleanProperty showContent = new SimpleBooleanProperty((Object)this, "showContent");
    private static final StringConverter<ZonedDateTime> DEFAULT_TIME_CONVERTER = new StringConverter<ZonedDateTime>(){

        public String toString(ZonedDateTime dateTime) {
            if (dateTime != null) {
                java.time.Duration between = java.time.Duration.between(dateTime, ZonedDateTime.now());
                if (between.toDays() == 0L) {
                    if (between.toHours() > 2L) {
                        return DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).format(dateTime.toLocalTime());
                    }
                    if (between.toHours() > 0L) {
                        return MessageFormat.format("{0}{1}", between.toHours(), ResourceBundleManager.getString(ResourceBundleManager.Type.NOTIFICATION_VIEW, "time.hours.ago"));
                    }
                    if (between.toMinutes() > 0L) {
                        return MessageFormat.format("{0}{1}", between.toMinutes(), ResourceBundleManager.getString(ResourceBundleManager.Type.NOTIFICATION_VIEW, "time.minutes.ago"));
                    }
                    return ResourceBundleManager.getString(ResourceBundleManager.Type.NOTIFICATION_VIEW, "time.now");
                }
                if (between.toDays() == 1L) {
                    return MessageFormat.format("{0}, {1}", ResourceBundleManager.getString(ResourceBundleManager.Type.NOTIFICATION_VIEW, "time.yesterday"), SHORT_TIME_FORMATTER.format(dateTime.toLocalTime()));
                }
                if (between.toDays() < 7L) {
                    return MessageFormat.format("{0} {1}", between.toDays(), ResourceBundleManager.getString(ResourceBundleManager.Type.NOTIFICATION_VIEW, "time.days.ago"));
                }
                return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).format(dateTime);
            }
            return "";
        }

        public ZonedDateTime fromString(String string) {
            return null;
        }
    };
    private ObjectProperty<StringConverter<ZonedDateTime>> timeConverter;

    public NotificationView(S notification) {
        this.notification = (Notification)Objects.requireNonNull(notification);
        this.getStyleClass().add((Object)"notification-view");
        this.setPickOnBounds(false);
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        this.stackNotification1 = new StackPane();
        this.stackNotification1.getStyleClass().addAll((Object[])new String[]{"content", "stack-notification1"});
        this.stackNotification1.visibleProperty().bind((ObservableValue)this.stackingEnabled.and((ObservableBooleanValue)((Notification)this.getNotification()).expandedProperty().not().and((ObservableBooleanValue)Bindings.size(((Notification)notification).getGroup().getNotifications()).greaterThan(1))));
        this.stackNotification1.managedProperty().bind((ObservableValue)this.stackNotification1.visibleProperty());
        this.stackNotification2 = new StackPane();
        this.stackNotification2.getStyleClass().addAll((Object[])new String[]{"content", "stack-notification2"});
        this.stackNotification2.visibleProperty().bind((ObservableValue)this.stackingEnabled.and((ObservableBooleanValue)((Notification)this.getNotification()).expandedProperty().not().and((ObservableBooleanValue)Bindings.size(((Notification)notification).getGroup().getNotifications()).greaterThan(2))));
        this.stackNotification2.managedProperty().bind((ObservableValue)this.stackNotification2.visibleProperty());
        this.contentPane = new ContentPane();
        FontIcon defaultIcon = new FontIcon();
        defaultIcon.getStyleClass().add((Object)"default-icon");
        this.setGraphic((Node)defaultIcon);
        this.getChildren().addAll((Object[])new Node[]{this.stackNotification2, this.stackNotification1, this.contentPane});
        this.showContentProperty().addListener(it -> Optional.ofNullable(this.getParent()).ifPresent(Parent::requestLayout));
        MapChangeListener ml = change -> {
            if (change.wasAdded() && change.getKey().equals("stacking-enabled")) {
                this.stackingEnabled.set(change.getValueAdded().equals("true"));
                this.getProperties().remove((Object)"stacking-enabled");
            }
        };
        this.getProperties().addListener(ml);
        InvalidationListener updateStyleClassListener = it -> this.updateStyleClass();
        ((Notification)notification).getGroup().expandedProperty().addListener(updateStyleClassListener);
        ((Notification)notification).getGroup().getNotifications().addListener(updateStyleClassListener);
        this.updateStyleClass();
    }

    protected double computePrefHeight(double width) {
        double h = this.contentPane.prefHeight(width - this.getInsets().getLeft() - this.getInsets().getRight());
        if (this.stackNotification1.isVisible()) {
            h += 5.0;
        }
        if (this.stackNotification2.isVisible()) {
            h += 5.0;
        }
        return h;
    }

    protected void layoutChildren() {
        double width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        double ph = this.contentPane.prefHeight(width);
        this.contentPane.resizeRelocate(this.getInsets().getLeft(), this.getInsets().getTop(), width, ph);
        if (this.stackNotification1.isVisible()) {
            this.stackNotification1.resizeRelocate(this.getInsets().getLeft() + 10.0, this.getInsets().getTop() + 5.0, width - 20.0, ph);
        }
        if (this.stackNotification2.isVisible()) {
            this.stackNotification2.resizeRelocate(this.getInsets().getLeft() + 20.0, this.getInsets().getTop() + 10.0, width - 40.0, ph);
        }
    }

    private void updateStyleClass() {
        this.getStyleClass().removeAll((Object[])new String[]{"small-stack", "big-stack"});
        if (!((Notification)this.notification).getGroup().isExpanded()) {
            int size = ((Notification)this.notification).getGroup().getNotifications().size();
            if (size > 1) {
                this.getStyleClass().add((Object)"big-stack");
            } else if (size > 0) {
                this.getStyleClass().add((Object)"small-stack");
            }
        }
    }

    public final S getNotification() {
        return this.notification;
    }

    public final Node getGraphic() {
        return (Node)this.graphic.get();
    }

    public final ObjectProperty<Node> graphicProperty() {
        return this.graphic;
    }

    public final void setGraphic(Node graphic) {
        this.graphic.set((Object)graphic);
    }

    public final Node getContent() {
        return (Node)this.content.get();
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public final void setContent(Node content) {
        this.content.set((Object)content);
    }

    public final boolean isShowContent() {
        return this.showContent.get();
    }

    public final BooleanProperty showContentProperty() {
        return this.showContent;
    }

    public final void setShowContent(boolean showContent) {
        this.showContent.set(showContent);
    }

    public final StringConverter<ZonedDateTime> getTimeConverter() {
        return this.timeConverter == null ? DEFAULT_TIME_CONVERTER : (StringConverter)this.timeConverter.get();
    }

    public final ObjectProperty<StringConverter<ZonedDateTime>> timeConverterProperty() {
        if (this.timeConverter == null) {
            this.timeConverter = new SimpleObjectProperty<StringConverter<ZonedDateTime>>((Object)this, "timeConverter", DEFAULT_TIME_CONVERTER){

                protected void invalidated() {
                    NotificationView.this.updateDateAndTimeLabel();
                }
            };
        }
        return this.timeConverter;
    }

    public final void setTimeConverter(StringConverter<ZonedDateTime> timeConverter) {
        this.timeConverterProperty().set(timeConverter);
    }

    public void updateDateAndTimeLabel() {
        this.contentPane.updateDateAndTimeLabel();
    }

    public class ContentPane
    extends BorderPane {
        private final StackPane closeIconWrapper;
        private final Label timeLabel;
        private final InvalidationListener updateStackClassListener = it -> this.updateStackStyle();
        private final WeakInvalidationListener weakUpdateStackClassListener = new WeakInvalidationListener(this.updateStackClassListener);
        private FadeTransition fadeTransition;

        public ContentPane() {
            this.getStyleClass().add((Object)"content");
            this.setMinHeight(Double.NEGATIVE_INFINITY);
            this.setPickOnBounds(false);
            this.leftProperty().bind(NotificationView.this.graphicProperty());
            Label titleLabel = new Label();
            titleLabel.textProperty().bind((ObservableValue)((Notification)NotificationView.this.notification).titleProperty());
            titleLabel.setWrapText(true);
            titleLabel.setMaxWidth(Double.MAX_VALUE);
            titleLabel.getStyleClass().add((Object)"title-label");
            HBox.setHgrow((Node)titleLabel, (Priority)Priority.ALWAYS);
            BooleanBinding showArrowBinding = Bindings.createBooleanBinding(() -> {
                if (NotificationView.this.getContent() == null || !this.isHover()) {
                    return false;
                }
                if (((Notification)NotificationView.this.notification).getGroup().getNotifications().size() == 1) {
                    return true;
                }
                return ((Notification)NotificationView.this.notification).getGroup().isExpanded();
            }, (Observable[])new Observable[]{this.hoverProperty(), ((Notification)NotificationView.this.notification).getGroup().expandedProperty(), ((Notification)NotificationView.this.notification).getGroup().getNotifications(), NotificationView.this.contentProperty()});
            this.timeLabel = new Label();
            this.timeLabel.setMinWidth(Double.NEGATIVE_INFINITY);
            this.timeLabel.getStyleClass().add((Object)"time-label");
            this.timeLabel.tooltipProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Tooltip(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).format(((Notification)NotificationView.this.notification).getDateTime())), (Observable[])new Observable[]{((Notification)NotificationView.this.notification).dateTimeProperty()}));
            this.timeLabel.visibleProperty().bind((ObservableValue)showArrowBinding.not());
            FontIcon arrowIcon = new FontIcon();
            arrowIcon.getStyleClass().add((Object)"arrow");
            StackPane arrowPane = new StackPane(new Node[]{arrowIcon});
            arrowPane.getStyleClass().add((Object)"arrow-pane");
            arrowPane.setOnMouseClicked(evt -> {
                evt.consume();
                if (NotificationView.this.getContent() != null) {
                    NotificationView.this.setShowContent(!NotificationView.this.isShowContent());
                }
            });
            arrowPane.visibleProperty().bind((ObservableValue)showArrowBinding);
            StackPane upperRightPane = new StackPane(new Node[]{this.timeLabel, arrowPane});
            upperRightPane.getStyleClass().add((Object)"upper-right-pane");
            upperRightPane.setAlignment(Pos.TOP_RIGHT);
            HBox titleTimeBox = new HBox(new Node[]{titleLabel, upperRightPane});
            titleTimeBox.getStyleClass().add((Object)"title-time-box");
            Label descriptionLabel = new Label();
            descriptionLabel.textProperty().bind((ObservableValue)((Notification)NotificationView.this.notification).summaryProperty());
            descriptionLabel.getStyleClass().add((Object)"description-label");
            descriptionLabel.setWrapText(true);
            HBox actionsBox = new HBox();
            actionsBox.getStyleClass().add((Object)"actions-box");
            actionsBox.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)actionsBox.getChildren()).and((ObservableBooleanValue)((Notification)NotificationView.this.notification).expandedProperty()));
            actionsBox.managedProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)actionsBox.getChildren()).and((ObservableBooleanValue)((Notification)NotificationView.this.notification).expandedProperty()));
            ((Notification)NotificationView.this.notification).getActions().addListener(it -> this.updateActions(actionsBox));
            this.updateActions(actionsBox);
            VBox center = new VBox(new Node[]{titleTimeBox, descriptionLabel, actionsBox});
            center.setFillWidth(true);
            center.setAlignment(Pos.CENTER_LEFT);
            center.getStyleClass().add((Object)"text-container");
            center.setMinHeight(Double.NEGATIVE_INFINITY);
            this.setCenter((Node)center);
            NotificationView.this.contentProperty().addListener(it -> this.updateCenterNode(center));
            NotificationView.this.showContentProperty().addListener(it -> this.updateCenterNode(center));
            Label clearAllLabel = new Label(ResourceBundleManager.getString(ResourceBundleManager.Type.NOTIFICATION_VIEW, "group.clear.all"));
            clearAllLabel.getStyleClass().add((Object)"clear-all");
            clearAllLabel.setMouseTransparent(true);
            FontIcon closeIcon = new FontIcon();
            closeIcon.setMouseTransparent(true);
            this.closeIconWrapper = new StackPane(new Node[]{closeIcon, clearAllLabel});
            this.closeIconWrapper.setPickOnBounds(false);
            this.closeIconWrapper.setOpacity(0.0);
            this.closeIconWrapper.getStyleClass().add((Object)"close-icon-wrapper");
            this.closeIconWrapper.setOnMouseEntered(evt -> this.requestLayout());
            this.closeIconWrapper.setOnMouseExited(evt -> this.requestLayout());
            this.closeIconWrapper.setOnMouseClicked(evt -> {
                evt.consume();
                NotificationGroup group = ((Notification)NotificationView.this.notification).getGroup();
                if (group.isExpanded()) {
                    ((Notification)NotificationView.this.notification).remove();
                } else {
                    group.getNotifications().clear();
                }
            });
            StackPane.setAlignment((Node)this.closeIconWrapper, (Pos)Pos.TOP_LEFT);
            NotificationView.this.graphicProperty().addListener(it -> this.closeIconWrapper.toFront());
            ((Notification)NotificationView.this.notification).getGroup().expandedProperty().addListener((InvalidationListener)this.weakUpdateStackClassListener);
            NotificationView.this.stackingEnabled.addListener((InvalidationListener)this.weakUpdateStackClassListener);
            this.updateStackStyle();
            this.hoverProperty().addListener((obs, oldHover, newHover) -> {
                if (this.fadeTransition != null) {
                    this.fadeTransition.stop();
                }
                this.fadeTransition = new FadeTransition(Duration.millis((double)100.0), (Node)this.closeIconWrapper);
                this.fadeTransition.setToValue(newHover != false ? 1.0 : 0.0);
                this.fadeTransition.play();
            });
            this.getChildren().add((Object)this.closeIconWrapper);
            this.updateDateAndTimeLabel();
        }

        private void updateCenterNode(VBox center) {
            Node content = NotificationView.this.getContent();
            boolean contentIsExpanded = NotificationView.this.isShowContent() && content != null;
            NotificationView.this.pseudoClassStateChanged(PSEUDO_CLASS_EXPANDED, contentIsExpanded);
            if (contentIsExpanded) {
                if (!center.getChildren().contains((Object)content)) {
                    VBox.setMargin((Node)content, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
                    center.getChildren().add(2, (Object)content);
                }
            } else if (content != null) {
                center.getChildren().remove((Object)content);
            }
        }

        private void updateStackStyle() {
            this.closeIconWrapper.getStyleClass().remove((Object)"stack");
            if (NotificationView.this.stackingEnabled.get() && !((Notification)NotificationView.this.notification).getGroup().isExpanded() && ((Notification)NotificationView.this.notification).getGroup().getNotifications().size() > 1) {
                this.closeIconWrapper.getStyleClass().add((Object)"stack");
            }
        }

        protected void layoutChildren() {
            super.layoutChildren();
            this.closeIconWrapper.resizeRelocate(0.0, 0.0, this.closeIconWrapper.prefWidth(-1.0), this.closeIconWrapper.prefHeight(-1.0));
        }

        private void updateActions(HBox actionsBox) {
            actionsBox.getChildren().clear();
            ObservableList<NotificationAction> actions = ((Notification)NotificationView.this.notification).getActions();
            if (!actions.isEmpty()) {
                actions.forEach(action -> {
                    Button button = new Button();
                    button.textProperty().bind((ObservableValue)action.textProperty());
                    HBox.setHgrow((Node)button, (Priority)Priority.ALWAYS);
                    button.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
                    button.setPrefWidth(1.0);
                    button.setOnAction(evt -> {
                        this.fireEvent(new InfoCenterEvent(InfoCenterEvent.HIDE, (Notification<?>)NotificationView.this.getNotification()));
                        Notification.OnClickBehaviour call = (Notification.OnClickBehaviour)((Object)((Object)((Object)action.getOnAction().call(NotificationView.this.notification))));
                        switch (call) {
                            case NONE: {
                                break;
                            }
                            case REMOVE: {
                                ((Notification)NotificationView.this.notification).remove();
                                break;
                            }
                            case HIDE: {
                                this.fireEvent(new InfoCenterEvent(InfoCenterEvent.HIDE));
                                break;
                            }
                            case HIDE_AND_REMOVE: {
                                this.fireEvent(new InfoCenterEvent(InfoCenterEvent.HIDE));
                                ((Notification)NotificationView.this.notification).remove();
                            }
                        }
                    });
                    actionsBox.getChildren().add((Object)button);
                });
            }
        }

        private void updateDateAndTimeLabel() {
            this.timeLabel.setText(NotificationView.this.getTimeConverter().toString((Object)((Notification)NotificationView.this.notification).getDateTime()));
        }
    }
}

