/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.util.Utils;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Skinnable;
import javafx.scene.layout.Region;
import javafx.stage.WindowEvent;

public abstract class CustomComboBoxSkinBase<T extends ComboBoxBase>
extends SkinBase<T> {
    private boolean popupNeedsReconfiguring = true;
    private PopupControl popup;

    public CustomComboBoxSkinBase(T control) {
        super(control);
        control.showingProperty().addListener(it -> {
            if (control.isShowing()) {
                this.show();
            } else if (this.popup != null) {
                this.hide();
            }
        });
        control.focusedProperty().addListener(it -> {
            if (!control.isFocused()) {
                this.hide();
            }
        });
    }

    private PopupControl getPopup() {
        if (this.popup == null) {
            this.createPopup();
        }
        return this.popup;
    }

    protected abstract Node getPopupContent();

    private void positionAndShowPopup() {
        ComboBoxBase skinnable = (ComboBoxBase)this.getSkinnable();
        if (skinnable.getScene() == null) {
            return;
        }
        this.getPopup();
        this.popup.getScene().setNodeOrientation(((ComboBoxBase)this.getSkinnable()).getEffectiveNodeOrientation());
        Node popupContent = this.getPopupContent();
        this.sizePopup();
        Point2D p = this.getPrefPopupPosition();
        this.popupNeedsReconfiguring = true;
        this.reconfigurePopup();
        this.popup.show(skinnable.getScene().getWindow(), this.snapPositionX(p.getX()), this.snapPositionY(p.getY()));
        popupContent.requestFocus();
        this.sizePopup();
    }

    private Point2D getPrefPopupPosition() {
        return Utils.pointRelativeTo((Node)this.getSkinnable(), this.getPopupContent(), HPos.CENTER, VPos.BOTTOM, 0.0, 0.0, true);
    }

    private void sizePopup() {
        Node popupContent = this.getPopupContent();
        if (popupContent instanceof Region) {
            Region r = (Region)popupContent;
            double prefHeight = this.snapSizeY(r.prefHeight(0.0));
            double minHeight = this.snapSizeY(r.minHeight(0.0));
            double maxHeight = this.snapSizeY(r.maxHeight(0.0));
            double h = this.snapSizeY(Math.min(Math.max(prefHeight, minHeight), Math.max(minHeight, maxHeight)));
            double prefWidth = this.snapSizeX(r.prefWidth(h));
            double minWidth = this.snapSizeX(r.minWidth(h));
            double maxWidth = this.snapSizeX(r.maxWidth(h));
            double w = this.snapSizeX(Math.min(Math.max(prefWidth, minWidth), Math.max(minWidth, maxWidth)));
            popupContent.resize(w, h);
        } else {
            popupContent.autosize();
        }
    }

    private void createPopup() {
        this.popup = new PopupControl(){
            {
                this.setSkin((Skin)new Skin<Skinnable>(){

                    public Skinnable getSkinnable() {
                        return CustomComboBoxSkinBase.this.popup;
                    }

                    public Node getNode() {
                        return CustomComboBoxSkinBase.this.getPopupContent();
                    }

                    public void dispose() {
                    }
                });
            }

            public Styleable getStyleableParent() {
                return CustomComboBoxSkinBase.this.getSkinnable();
            }
        };
        this.popup.setConsumeAutoHidingEvents(false);
        this.popup.setAutoHide(true);
        this.popup.setAutoFix(true);
        this.popup.setHideOnEscape(true);
        this.popup.addEventHandler(WindowEvent.WINDOW_HIDDEN, t -> {
            ((ComboBoxBase)this.getSkinnable()).notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_NODE);
            ((ComboBoxBase)this.getSkinnable()).hide();
        });
        this.popup.setOnAutoHide(this::popupOnAutoHide);
        InvalidationListener layoutPosListener = o -> {
            this.popupNeedsReconfiguring = true;
            this.reconfigurePopup();
        };
        ((ComboBoxBase)this.getSkinnable()).layoutXProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).layoutYProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).widthProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).heightProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).sceneProperty().addListener(o -> {
            if (((ObservableValue)o).getValue() == null) {
                this.hide();
            } else if (((ComboBoxBase)this.getSkinnable()).isShowing()) {
                this.show();
            }
        });
    }

    void reconfigurePopup() {
        if (this.popup == null) {
            return;
        }
        boolean isShowing = this.popup.isShowing();
        if (!isShowing) {
            return;
        }
        if (!this.popupNeedsReconfiguring) {
            return;
        }
        this.popupNeedsReconfiguring = false;
        Point2D p = this.getPrefPopupPosition();
        Node popupContent = this.getPopupContent();
        double minWidth = popupContent.prefWidth(-1.0);
        double minHeight = popupContent.prefHeight(-1.0);
        if (p.getX() > -1.0) {
            this.popup.setAnchorX(p.getX());
        }
        if (p.getY() > -1.0) {
            this.popup.setAnchorY(p.getY());
        }
        if (minWidth > -1.0) {
            this.popup.setMinWidth(minWidth);
        }
        if (minHeight > -1.0) {
            this.popup.setMinHeight(minHeight);
        }
        Bounds b = popupContent.getLayoutBounds();
        double currentWidth = b.getWidth();
        double currentHeight = b.getHeight();
        double newWidth = Math.max(currentWidth, minWidth);
        double newHeight = Math.max(currentHeight, minHeight);
        if (newWidth != currentWidth || newHeight != currentHeight) {
            popupContent.resize(newWidth, newHeight);
            if (popupContent instanceof Region) {
                ((Region)popupContent).setMinSize(newWidth, newHeight);
                ((Region)popupContent).setPrefSize(newWidth, newHeight);
            }
        }
    }

    protected void popupOnAutoHide(Event event) {
    }

    public void show() {
        ComboBoxBase control = (ComboBoxBase)this.getSkinnable();
        if (control == null) {
            throw new IllegalStateException("ComboBox is null");
        }
        control.requestFocus();
        Node content = this.getPopupContent();
        if (content == null) {
            throw new IllegalStateException("Popup node is null");
        }
        this.positionAndShowPopup();
    }

    public void hide() {
        if (this.popup != null && this.popup.isShowing()) {
            this.popup.hide();
        }
    }
}

