/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.CustomComboBox;
import com.dlsc.gemsfx.DurationPicker;
import com.dlsc.gemsfx.Spacer;
import com.dlsc.gemsfx.skins.DurationUnitField;
import com.dlsc.gemsfx.skins.ToggleVisibilityComboBoxSkin;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.Callback;
import javafx.util.Pair;
import org.kordamp.ikonli.javafx.FontIcon;

public class DurationPickerSkin
extends ToggleVisibilityComboBoxSkin<DurationPicker> {
    private final HBox box;
    private final Spacer spacer;
    private final Button editButton;
    private final HBox innerBox = new HBox();
    private final List<DurationUnitField> durationUnitFields = new ArrayList<DurationUnitField>();
    private Node popupContent;

    public DurationPickerSkin(DurationPicker picker) {
        super(picker);
        this.editButton = new Button();
        this.editButton.getStyleClass().add((Object)"edit-button");
        this.editButton.addEventHandler(MouseEvent.MOUSE_ENTERED, this::mouseEntered);
        this.editButton.addEventHandler(MouseEvent.MOUSE_EXITED, this::mouseExited);
        this.editButton.addEventHandler(MouseEvent.MOUSE_RELEASED, this::mouseReleased);
        this.editButton.setMaxHeight(Double.MAX_VALUE);
        this.editButton.setMaxWidth(Double.MAX_VALUE);
        this.editButton.setGraphic((Node)new FontIcon());
        this.editButton.setFocusTraversable(false);
        this.editButton.visibleProperty().bind((ObservableValue)picker.showPopupTriggerButtonProperty());
        this.editButton.managedProperty().bind((ObservableValue)picker.showPopupTriggerButtonProperty());
        InvalidationListener updateListener = it -> this.buildView();
        picker.fieldsProperty().addListener(updateListener);
        this.innerBox.getStyleClass().add((Object)"fields-box");
        this.innerBox.setAlignment(Pos.CENTER_LEFT);
        this.spacer = new Spacer();
        this.box = new HBox();
        this.box.getStyleClass().add((Object)"box");
        this.updateBox();
        this.getChildren().add((Object)this.box);
        this.registerChangeListener((ObservableValue)picker.buttonDisplayProperty(), it -> this.updateBox());
        picker.separatorFactoryProperty().addListener(it -> this.buildView());
        this.buildView();
    }

    private void updateBox() {
        CustomComboBox.ButtonDisplay value = ((DurationPicker)this.getSkinnable()).getButtonDisplay();
        switch (value) {
            case LEFT: {
                this.box.getChildren().setAll((Object[])new Node[]{this.editButton, this.spacer, this.innerBox});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.NEVER);
                break;
            }
            case RIGHT: {
                this.box.getChildren().setAll((Object[])new Node[]{this.innerBox, this.spacer, this.editButton});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.NEVER);
                break;
            }
            case BUTTON_ONLY: {
                this.box.getChildren().setAll((Object[])new Node[]{this.editButton});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.ALWAYS);
                break;
            }
            case FIELD_ONLY: {
                this.box.getChildren().setAll((Object[])new Node[]{this.innerBox});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.NEVER);
            }
        }
    }

    @Override
    protected Node getPopupContent() {
        if (this.popupContent == null) {
            DurationPicker skinnable = (DurationPicker)this.getSkinnable();
            com.dlsc.pickerfx.DurationPicker durationPicker = new com.dlsc.pickerfx.DurationPicker(){

                public String getUserAgentStylesheet() {
                    return Objects.requireNonNull(DurationPicker.class.getResource("duration-picker.css")).toExternalForm();
                }
            };
            durationPicker.valueProperty().bindBidirectional(skinnable.durationProperty());
            durationPicker.maximumDurationProperty().bind(skinnable.maximumDurationProperty());
            durationPicker.minimumDurationProperty().bind(skinnable.minimumDurationProperty());
            durationPicker.fieldsProperty().bind(skinnable.fieldsProperty());
            this.popupContent = new HBox(new Node[]{durationPicker});
            this.popupContent.getStyleClass().add((Object)"popup");
        }
        return this.popupContent;
    }

    private void buildView() {
        int i;
        this.innerBox.getChildren().clear();
        this.durationUnitFields.clear();
        ObservableList<ChronoUnit> fields = ((DurationPicker)this.getSkinnable()).getFields();
        for (i = 0; i < fields.size(); ++i) {
            ChronoUnit chronoUnit = (ChronoUnit)fields.get(i);
            DurationUnitField unitField = this.createField(chronoUnit);
            this.durationUnitFields.add(unitField);
            this.innerBox.getChildren().add((Object)unitField);
            if (i >= fields.size() - 1) continue;
            Callback<Pair<ChronoUnit, ChronoUnit>, Node> separatorFactory = ((DurationPicker)this.getSkinnable()).getSeparatorFactory();
            Node separatorNode = (Node)separatorFactory.call((Object)new Pair((Object)chronoUnit, (Object)((ChronoUnit)fields.get(i + 1))));
            this.innerBox.getChildren().add((Object)separatorNode);
        }
        for (i = 0; i < this.durationUnitFields.size(); ++i) {
            DurationUnitField field = this.durationUnitFields.get(i);
            DurationUnitField previousField = null;
            DurationUnitField nextField = null;
            if (i > 0) {
                previousField = this.durationUnitFields.get(i - 1);
            }
            if (i < this.durationUnitFields.size() - 1) {
                nextField = this.durationUnitFields.get(i + 1);
            }
            if (previousField != null) {
                field.setPreviousField(previousField);
            }
            if (nextField == null) continue;
            field.setNextField(nextField);
        }
    }

    private DurationUnitField createField(ChronoUnit unit) {
        DurationUnitField field = new DurationUnitField((DurationPicker)this.getSkinnable(), unit);
        switch (unit) {
            default: {
                break;
            }
            case HOURS: {
                field.setMaximumValue(23L);
                break;
            }
            case MINUTES: 
            case SECONDS: {
                field.setMaximumValue(59L);
                break;
            }
            case MILLIS: {
                field.setMaximumValue(999L);
            }
        }
        field.setValue(0L);
        field.durationProperty().bind(((DurationPicker)this.getSkinnable()).durationProperty());
        field.labelTypeProperty().bind(((DurationPicker)this.getSkinnable()).labelTypeProperty());
        field.fillDigitsProperty().bind((ObservableValue)((DurationPicker)this.getSkinnable()).fillDigitsProperty());
        field.valueProperty().addListener(it -> {
            if (!field.isUpdating()) {
                ((DurationPicker)this.getSkinnable()).getProperties().put((Object)"NEW_DURATION", (Object)this.createDuration());
            }
        });
        return field;
    }

    private Duration createDuration() {
        Duration duration = Duration.ZERO;
        for (DurationUnitField field : this.durationUnitFields) {
            ChronoUnit chronoUnit = field.getChronoUnit();
            Long value = field.getValue();
            if (value == null) continue;
            duration = duration.plus((long)value, chronoUnit);
        }
        return duration;
    }
}

